// third_party/blink/public/mojom/plugins/plugin_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  FilePath as mojoBase_mojom_FilePath,
  FilePathSpec as mojoBase_mojom_FilePathSpec
} from '../../../../../mojo/public/mojom/base/file_path.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PluginRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PluginRegistry', scope);
  }
}

/** @interface */
export class PluginRegistryInterface {
  
  /**
   * @param { !boolean } refresh
   * @return {!Promise<{
        plugins: !Array<!PluginInfo>,
   *  }>}
   */

  getPlugins(refresh) {}
}

/**
 * @implements { PluginRegistryInterface }
 */
export class PluginRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PluginRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PluginRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PluginRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } refresh
   * @return {!Promise<{
        plugins: !Array<!PluginInfo>,
   *  }>}
   */

  getPlugins(
      refresh) {
    return this.proxy.sendMessage(
        0,
        PluginRegistry_GetPlugins_ParamsSpec.$,
        PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        [
          refresh
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PluginRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PluginRegistryReceiver {
  /**
   * @param {!PluginRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PluginRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PluginRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PluginRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PluginRegistry_GetPlugins_ParamsSpec.$,
        PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        impl.getPlugins.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PluginRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PluginRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PluginRegistryRemote}
   */
  static getRemote() {
    let remote = new PluginRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PluginRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PluginRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PluginRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PluginRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPlugins =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PluginRegistry_GetPlugins_ParamsSpec.$,
        PluginRegistry_GetPlugins_ResponseParamsSpec.$,
        this.getPlugins.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PluginMimeTypeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PluginInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PluginRegistry_GetPlugins_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PluginRegistry_GetPlugins_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PluginMimeTypeSpec.$,
    'PluginMimeType',
    [
      mojo.internal.StructField(
        'mimeType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileExtensions', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PluginMimeType {
  constructor() {
    /** @type { !string } */
    this.mimeType;
    /** @type { !mojoBase_mojom_String16 } */
    this.description;
    /** @type { !Array<!string> } */
    this.fileExtensions;
  }
}



mojo.internal.Struct(
    PluginInfoSpec.$,
    'PluginInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filename', 16,
        0,
        mojoBase_mojom_FilePathSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'backgroundColor', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeTypes', 32,
        0,
        mojo.internal.Array(PluginMimeTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mayUseExternalHandler', 28,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class PluginInfo {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.name;
    /** @type { !mojoBase_mojom_String16 } */
    this.description;
    /** @type { !mojoBase_mojom_FilePath } */
    this.filename;
    /** @type { !number } */
    this.backgroundColor;
    /** @type { !Array<!PluginMimeType> } */
    this.mimeTypes;
    /** @type { !boolean } */
    this.mayUseExternalHandler;
  }
}



mojo.internal.Struct(
    PluginRegistry_GetPlugins_ParamsSpec.$,
    'PluginRegistry_GetPlugins_Params',
    [
      mojo.internal.StructField(
        'refresh', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PluginRegistry_GetPlugins_Params {
  constructor() {
    /** @type { !boolean } */
    this.refresh;
  }
}



mojo.internal.Struct(
    PluginRegistry_GetPlugins_ResponseParamsSpec.$,
    'PluginRegistry_GetPlugins_ResponseParams',
    [
      mojo.internal.StructField(
        'plugins', 0,
        0,
        mojo.internal.Array(PluginInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PluginRegistry_GetPlugins_ResponseParams {
  constructor() {
    /** @type { !Array<!PluginInfo> } */
    this.plugins;
  }
}

