// third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/plugins/plugin_registry.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
PluginMimeType::PluginMimeType()
    : mime_type(),
      description(),
      file_extensions() {}

PluginMimeType::PluginMimeType(
    const ::blink::String& mime_type_in,
    const ::blink::String& description_in,
    ::blink::Vector<::blink::String> file_extensions_in)
    : mime_type(std::move(mime_type_in)),
      description(std::move(description_in)),
      file_extensions(std::move(file_extensions_in)) {}

PluginMimeType::~PluginMimeType() = default;

void PluginMimeType::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_type"), this->mime_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_extensions"), this->file_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginMimeType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PluginInfo::PluginInfo()
    : name(),
      description(),
      filename(),
      background_color(),
      mime_types(),
      may_use_external_handler() {}

PluginInfo::PluginInfo(
    const ::blink::String& name_in,
    const ::blink::String& description_in,
    const ::base::FilePath& filename_in,
    uint32_t background_color_in,
    ::blink::Vector<PluginMimeTypePtr> mime_types_in,
    bool may_use_external_handler_in)
    : name(std::move(name_in)),
      description(std::move(description_in)),
      filename(std::move(filename_in)),
      background_color(std::move(background_color_in)),
      mime_types(std::move(mime_types_in)),
      may_use_external_handler(std::move(may_use_external_handler_in)) {}

PluginInfo::~PluginInfo() = default;

void PluginInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filename"), this->filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mime_types"), this->mime_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<PluginMimeTypePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "may_use_external_handler"), this->may_use_external_handler,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PluginInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PluginRegistry::IPCStableHashFunction PluginRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PluginRegistry>(message.name())) {
    case messages::PluginRegistry::kGetPlugins: {
      return &PluginRegistry::GetPlugins_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PluginRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PluginRegistry>(message.name())) {
      case messages::PluginRegistry::kGetPlugins:
            return "Receive blink::mojom::PluginRegistry::GetPlugins";
    }
  } else {
    switch (static_cast<messages::PluginRegistry>(message.name())) {
      case messages::PluginRegistry::kGetPlugins:
            return "Receive reply blink::mojom::PluginRegistry::GetPlugins";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PluginRegistry::GetPlugins_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7a61644b;  // IPCStableHash for blink::mojom::PluginRegistry::GetPlugins
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool PluginRegistry::GetPlugins(bool refresh, ::blink::Vector<PluginInfoPtr>* out_plugins) {
  NOTREACHED();
}
class PluginRegistry_GetPlugins_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  PluginRegistry_GetPlugins_HandleSyncResponse(
      bool* result, ::blink::Vector<PluginInfoPtr>* out_plugins)
      : result_(result), out_plugins_(out_plugins) {
    DCHECK(!*result_);
  }

  PluginRegistry_GetPlugins_HandleSyncResponse(const PluginRegistry_GetPlugins_HandleSyncResponse&) = delete;
  PluginRegistry_GetPlugins_HandleSyncResponse& operator=(const PluginRegistry_GetPlugins_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<PluginInfoPtr>* out_plugins_;};

class PluginRegistry_GetPlugins_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PluginRegistry_GetPlugins_ForwardToCallback(
      PluginRegistry::GetPluginsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PluginRegistry_GetPlugins_ForwardToCallback(const PluginRegistry_GetPlugins_ForwardToCallback&) = delete;
  PluginRegistry_GetPlugins_ForwardToCallback& operator=(const PluginRegistry_GetPlugins_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PluginRegistry::GetPluginsCallback callback_;
};

PluginRegistryProxy::PluginRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool PluginRegistryProxy::GetPlugins(
    bool param_refresh, ::blink::Vector<PluginInfoPtr>* out_param_plugins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::PluginRegistry::GetPlugins (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("refresh"), param_refresh,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "PluginRegistry::GetPlugins");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginRegistry::kGetPlugins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_Params_Data> params(
          message);
  params.Allocate();

  params->refresh = param_refresh;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginRegistry_GetPlugins_HandleSyncResponse(
          &result, out_param_plugins));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "PluginRegistry::GetPlugins", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugins"), out_param_plugins,
                        "<value of type ::blink::Vector<PluginInfoPtr>>");
   });
#endif
  return result;
}

void PluginRegistryProxy::GetPlugins(
    bool in_refresh, GetPluginsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PluginRegistry::GetPlugins", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("refresh"), in_refresh,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginRegistry::kGetPlugins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_Params_Data> params(
          message);
  params.Allocate();

  params->refresh = in_refresh;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PluginRegistry_GetPlugins_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PluginRegistry_GetPlugins_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PluginRegistry::GetPluginsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PluginRegistry_GetPlugins_ProxyToResponder> proxy(
        new PluginRegistry_GetPlugins_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PluginRegistry_GetPlugins_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PluginRegistry_GetPlugins_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PluginRegistry_GetPlugins_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PluginRegistry::GetPluginsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<PluginInfoPtr> in_plugins);
};

bool PluginRegistry_GetPlugins_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PluginRegistry_GetPlugins_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PluginRegistry_GetPlugins_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PluginRegistry.0
  bool success = true;
  ::blink::Vector<PluginInfoPtr> p_plugins{};
  PluginRegistry_GetPlugins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlugins(&p_plugins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginRegistry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_plugins));
  }
  return true;
}

void PluginRegistry_GetPlugins_ProxyToResponder::Run(
    ::blink::Vector<PluginInfoPtr> in_plugins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PluginRegistry::GetPlugins", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("plugins"), in_plugins,
                        "<value of type ::blink::Vector<PluginInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PluginRegistry::kGetPlugins), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PluginRegistry_GetPlugins_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->plugins)::BaseType>
      plugins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& plugins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::PluginInfoDataView>>(
    in_plugins,
    plugins_fragment,
    &plugins_validate_params);

  params->plugins.Set(
      plugins_fragment.is_null() ? nullptr : plugins_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->plugins.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null plugins in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PluginRegistry::Name_);
  message.set_method_name("GetPlugins");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool PluginRegistry_GetPlugins_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PluginRegistry_GetPlugins_ResponseParams_Data* params =
      reinterpret_cast<internal::PluginRegistry_GetPlugins_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for PluginRegistry.0
  bool success = true;
  ::blink::Vector<PluginInfoPtr> p_plugins{};
  PluginRegistry_GetPlugins_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlugins(&p_plugins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PluginRegistry::Name_, 0, true);
    return false;
  }
  *out_plugins_ = std::move(p_plugins);
  *result_ = true;
  return true;
}

// static
bool PluginRegistryStubDispatch::Accept(
    PluginRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PluginRegistry>(message->header()->name)) {
    case messages::PluginRegistry::kGetPlugins: {
      break;
    }
  }
  return false;
}

// static
bool PluginRegistryStubDispatch::AcceptWithResponder(
    PluginRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PluginRegistry>(message->header()->name)) {
    case messages::PluginRegistry::kGetPlugins: {
      internal::PluginRegistry_GetPlugins_Params_Data* params =
          reinterpret_cast<
              internal::PluginRegistry_GetPlugins_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PluginRegistry.0
      bool success = true;
      bool p_refresh{};
      PluginRegistry_GetPlugins_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_refresh = input_data_view.refresh();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PluginRegistry::Name_, 0, false);
        return false;
      }
      auto callback =
          PluginRegistry_GetPlugins_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlugins(        
        std::move(p_refresh), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPluginRegistryValidationInfo[] = {
    { &internal::PluginRegistry_GetPlugins_Params_Data::Validate,
     &internal::PluginRegistry_GetPlugins_ResponseParams_Data::Validate},
};

bool PluginRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PluginRegistry::Name_,
    kPluginRegistryValidationInfo);
}

bool PluginRegistryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PluginRegistry::Name_,
    kPluginRegistryValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PluginMimeType::DataView, ::blink::mojom::blink::PluginMimeTypePtr>::Read(
    ::blink::mojom::blink::PluginMimeType::DataView input,
    ::blink::mojom::blink::PluginMimeTypePtr* output) {
  bool success = true;
  ::blink::mojom::blink::PluginMimeTypePtr result(::blink::mojom::blink::PluginMimeType::New());
  
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadFileExtensions(&result->file_extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PluginInfo::DataView, ::blink::mojom::blink::PluginInfoPtr>::Read(
    ::blink::mojom::blink::PluginInfo::DataView input,
    ::blink::mojom::blink::PluginInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PluginInfoPtr result(::blink::mojom::blink::PluginInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadFilename(&result->filename))
        success = false;
      if (success)
        result->background_color = input.background_color();
      if (success && !input.ReadMimeTypes(&result->mime_types))
        success = false;
      if (success)
        result->may_use_external_handler = input.may_use_external_handler();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PluginRegistryInterceptorForTesting::GetPlugins(bool refresh, GetPluginsCallback callback) {
  GetForwardingInterface()->GetPlugins(
    std::move(refresh)
    , std::move(callback));
}
PluginRegistryAsyncWaiter::PluginRegistryAsyncWaiter(
    PluginRegistry* proxy) : proxy_(proxy) {}

PluginRegistryAsyncWaiter::~PluginRegistryAsyncWaiter() = default;


void PluginRegistryAsyncWaiter::GetPlugins(
    bool refresh, ::blink::Vector<PluginInfoPtr>* out_plugins) {
  base::RunLoop loop;
  proxy_->GetPlugins(
      std::move(refresh),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<PluginInfoPtr>* out_plugins
,
             ::blink::Vector<PluginInfoPtr> plugins) {*out_plugins = std::move(plugins);
            loop->Quit();
          },
          &loop,
          out_plugins));
  loop.Run();
}

::blink::Vector<PluginInfoPtr> PluginRegistryAsyncWaiter::GetPlugins(
    bool refresh) {
  ::blink::Vector<PluginInfoPtr> async_wait_result;
  GetPlugins(std::move(refresh),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif