// third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PICTURE_IN_PICTURE_WINDOW_OPTIONS_PICTURE_IN_PICTURE_WINDOW_OPTIONS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PICTURE_IN_PICTURE_WINDOW_OPTIONS_PICTURE_IN_PICTURE_WINDOW_OPTIONS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {





class PLATFORM_EXPORT PictureInPictureWindowOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PictureInPictureWindowOptions, T>::value>;
  using DataView = PictureInPictureWindowOptionsDataView;
  using Data_ = internal::PictureInPictureWindowOptions_Data;

  template <typename... Args>
  static PictureInPictureWindowOptionsPtr New(Args&&... args) {
    return PictureInPictureWindowOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PictureInPictureWindowOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PictureInPictureWindowOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PictureInPictureWindowOptions>::Convert(*this);
  }


  PictureInPictureWindowOptions();

  PictureInPictureWindowOptions(
      uint64_t width,
      uint64_t height,
      bool disallow_return_to_opener,
      bool prefer_initial_window_placement);


  ~PictureInPictureWindowOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PictureInPictureWindowOptionsPtr>
  PictureInPictureWindowOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PictureInPictureWindowOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PictureInPictureWindowOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PictureInPictureWindowOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PictureInPictureWindowOptions_UnserializedMessageContext<
            UserType, PictureInPictureWindowOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PictureInPictureWindowOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PictureInPictureWindowOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PictureInPictureWindowOptions_UnserializedMessageContext<
            UserType, PictureInPictureWindowOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PictureInPictureWindowOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t width;
  
  uint64_t height;
  
  bool disallow_return_to_opener;
  
  bool prefer_initial_window_placement;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
PictureInPictureWindowOptionsPtr PictureInPictureWindowOptions::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(disallow_return_to_opener),
      mojo::Clone(prefer_initial_window_placement)
  );
}

template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>*>
bool PictureInPictureWindowOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->disallow_return_to_opener, other_struct.disallow_return_to_opener))
    return false;
  if (!mojo::Equals(this->prefer_initial_window_placement, other_struct.prefer_initial_window_placement))
    return false;
  return true;
}

template <typename T, PictureInPictureWindowOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.disallow_return_to_opener < rhs.disallow_return_to_opener)
    return true;
  if (rhs.disallow_return_to_opener < lhs.disallow_return_to_opener)
    return false;
  if (lhs.prefer_initial_window_placement < rhs.prefer_initial_window_placement)
    return true;
  if (rhs.prefer_initial_window_placement < lhs.prefer_initial_window_placement)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::PictureInPictureWindowOptions::DataView,
                                         ::blink::mojom::blink::PictureInPictureWindowOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PictureInPictureWindowOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PictureInPictureWindowOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::PictureInPictureWindowOptions::width) width(
      const ::blink::mojom::blink::PictureInPictureWindowOptionsPtr& input) {
    return input->width;
  }

  static decltype(::blink::mojom::blink::PictureInPictureWindowOptions::height) height(
      const ::blink::mojom::blink::PictureInPictureWindowOptionsPtr& input) {
    return input->height;
  }

  static decltype(::blink::mojom::blink::PictureInPictureWindowOptions::disallow_return_to_opener) disallow_return_to_opener(
      const ::blink::mojom::blink::PictureInPictureWindowOptionsPtr& input) {
    return input->disallow_return_to_opener;
  }

  static decltype(::blink::mojom::blink::PictureInPictureWindowOptions::prefer_initial_window_placement) prefer_initial_window_placement(
      const ::blink::mojom::blink::PictureInPictureWindowOptionsPtr& input) {
    return input->prefer_initial_window_placement;
  }

  static bool Read(::blink::mojom::blink::PictureInPictureWindowOptions::DataView input, ::blink::mojom::blink::PictureInPictureWindowOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PICTURE_IN_PICTURE_WINDOW_OPTIONS_PICTURE_IN_PICTURE_WINDOW_OPTIONS_MOJOM_BLINK_H_