// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-params-data.h"
#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-import-headers.h"
#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-test-utils.h"


namespace blink::mojom {
PeerConnectionInfo::PeerConnectionInfo()
    : lid(),
      rtc_configuration(),
      url() {}

PeerConnectionInfo::PeerConnectionInfo(
    int32_t lid_in,
    const std::string& rtc_configuration_in,
    const std::optional<std::string>& url_in)
    : lid(std::move(lid_in)),
      rtc_configuration(std::move(rtc_configuration_in)),
      url(std::move(url_in)) {}

PeerConnectionInfo::~PeerConnectionInfo() = default;

void PeerConnectionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lid"), this->lid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtc_configuration"), this->rtc_configuration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PeerConnectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PeerConnectionManager::IPCStableHashFunction PeerConnectionManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PeerConnectionManager>(message.name())) {
    case messages::PeerConnectionManager::kOnSuspend: {
      return &PeerConnectionManager::OnSuspend_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kOnThermalStateChange: {
      return &PeerConnectionManager::OnThermalStateChange_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kStartEventLog: {
      return &PeerConnectionManager::StartEventLog_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kStopEventLog: {
      return &PeerConnectionManager::StopEventLog_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kStartDataChannelLog: {
      return &PeerConnectionManager::StartDataChannelLog_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kStopDataChannelLog: {
      return &PeerConnectionManager::StopDataChannelLog_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kGetStandardStats: {
      return &PeerConnectionManager::GetStandardStats_Sym::IPCStableHash;
    }
    case messages::PeerConnectionManager::kGetCurrentState: {
      return &PeerConnectionManager::GetCurrentState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PeerConnectionManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PeerConnectionManager>(message.name())) {
      case messages::PeerConnectionManager::kOnSuspend:
            return "Receive blink::mojom::PeerConnectionManager::OnSuspend";
      case messages::PeerConnectionManager::kOnThermalStateChange:
            return "Receive blink::mojom::PeerConnectionManager::OnThermalStateChange";
      case messages::PeerConnectionManager::kStartEventLog:
            return "Receive blink::mojom::PeerConnectionManager::StartEventLog";
      case messages::PeerConnectionManager::kStopEventLog:
            return "Receive blink::mojom::PeerConnectionManager::StopEventLog";
      case messages::PeerConnectionManager::kStartDataChannelLog:
            return "Receive blink::mojom::PeerConnectionManager::StartDataChannelLog";
      case messages::PeerConnectionManager::kStopDataChannelLog:
            return "Receive blink::mojom::PeerConnectionManager::StopDataChannelLog";
      case messages::PeerConnectionManager::kGetStandardStats:
            return "Receive blink::mojom::PeerConnectionManager::GetStandardStats";
      case messages::PeerConnectionManager::kGetCurrentState:
            return "Receive blink::mojom::PeerConnectionManager::GetCurrentState";
    }
  } else {
    switch (static_cast<messages::PeerConnectionManager>(message.name())) {
      case messages::PeerConnectionManager::kOnSuspend:
            return "Receive reply blink::mojom::PeerConnectionManager::OnSuspend";
      case messages::PeerConnectionManager::kOnThermalStateChange:
            return "Receive reply blink::mojom::PeerConnectionManager::OnThermalStateChange";
      case messages::PeerConnectionManager::kStartEventLog:
            return "Receive reply blink::mojom::PeerConnectionManager::StartEventLog";
      case messages::PeerConnectionManager::kStopEventLog:
            return "Receive reply blink::mojom::PeerConnectionManager::StopEventLog";
      case messages::PeerConnectionManager::kStartDataChannelLog:
            return "Receive reply blink::mojom::PeerConnectionManager::StartDataChannelLog";
      case messages::PeerConnectionManager::kStopDataChannelLog:
            return "Receive reply blink::mojom::PeerConnectionManager::StopDataChannelLog";
      case messages::PeerConnectionManager::kGetStandardStats:
            return "Receive reply blink::mojom::PeerConnectionManager::GetStandardStats";
      case messages::PeerConnectionManager::kGetCurrentState:
            return "Receive reply blink::mojom::PeerConnectionManager::GetCurrentState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PeerConnectionManager::OnSuspend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeee9d682;  // IPCStableHash for blink::mojom::PeerConnectionManager::OnSuspend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::OnThermalStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84896ff6;  // IPCStableHash for blink::mojom::PeerConnectionManager::OnThermalStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::StartEventLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55b91d71;  // IPCStableHash for blink::mojom::PeerConnectionManager::StartEventLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::StopEventLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x81a83730;  // IPCStableHash for blink::mojom::PeerConnectionManager::StopEventLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::StartDataChannelLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5608cbe6;  // IPCStableHash for blink::mojom::PeerConnectionManager::StartDataChannelLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::StopDataChannelLog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc59573ee;  // IPCStableHash for blink::mojom::PeerConnectionManager::StopDataChannelLog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::GetStandardStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d9eeb6f;  // IPCStableHash for blink::mojom::PeerConnectionManager::GetStandardStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionManager::GetCurrentState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9006d0b9;  // IPCStableHash for blink::mojom::PeerConnectionManager::GetCurrentState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PeerConnectionManagerProxy::PeerConnectionManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeerConnectionManagerProxy::OnSuspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PeerConnectionManager::OnSuspend");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kOnSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_OnSuspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("OnSuspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::OnThermalStateChange(
    DeviceThermalState in_thermal_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionManager::OnThermalStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thermal_state"), in_thermal_state,
                        "<value of type DeviceThermalState>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kOnThermalStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_OnThermalStateChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::DeviceThermalState>(
    in_thermal_state,
    &params->thermal_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("OnThermalStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::StartEventLog(
    int32_t in_peer_connection_local_id, int32_t in_output_period_ms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionManager::StartEventLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output_period_ms"), in_output_period_ms,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kStartEventLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StartEventLog_Params_Data> params(
          message);
  params.Allocate();

  params->peer_connection_local_id = in_peer_connection_local_id;

  params->output_period_ms = in_output_period_ms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StartEventLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::StopEventLog(
    int32_t in_peer_connection_local_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionManager::StopEventLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kStopEventLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StopEventLog_Params_Data> params(
          message);
  params.Allocate();

  params->peer_connection_local_id = in_peer_connection_local_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StopEventLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::StartDataChannelLog(
    int32_t in_peer_connection_local_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionManager::StartDataChannelLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kStartDataChannelLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StartDataChannelLog_Params_Data> params(
          message);
  params.Allocate();

  params->peer_connection_local_id = in_peer_connection_local_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StartDataChannelLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::StopDataChannelLog(
    int32_t in_peer_connection_local_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionManager::StopDataChannelLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("peer_connection_local_id"), in_peer_connection_local_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kStopDataChannelLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_StopDataChannelLog_Params_Data> params(
          message);
  params.Allocate();

  params->peer_connection_local_id = in_peer_connection_local_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("StopDataChannelLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::GetStandardStats(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PeerConnectionManager::GetStandardStats");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kGetStandardStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_GetStandardStats_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("GetStandardStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionManagerProxy::GetCurrentState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::PeerConnectionManager::GetCurrentState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionManager::kGetCurrentState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionManager_GetCurrentState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionManager::Name_);
  message.set_method_name("GetCurrentState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PeerConnectionManagerStubDispatch::Accept(
    PeerConnectionManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PeerConnectionManager>(message->header()->name)) {
    case messages::PeerConnectionManager::kOnSuspend: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_OnSuspend_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_OnSuspend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.0
      bool success = true;
      PeerConnectionManager_OnSuspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSuspend(        );
      return true;
    }
    case messages::PeerConnectionManager::kOnThermalStateChange: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_OnThermalStateChange_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_OnThermalStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.1
      bool success = true;
      DeviceThermalState p_thermal_state{};
      PeerConnectionManager_OnThermalStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadThermalState(&p_thermal_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnThermalStateChange(        
        std::move(p_thermal_state));
      return true;
    }
    case messages::PeerConnectionManager::kStartEventLog: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StartEventLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StartEventLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.2
      bool success = true;
      int32_t p_peer_connection_local_id{};
      int32_t p_output_period_ms{};
      PeerConnectionManager_StartEventLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (success)
        p_output_period_ms = input_data_view.output_period_ms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartEventLog(        
        std::move(p_peer_connection_local_id), 
        std::move(p_output_period_ms));
      return true;
    }
    case messages::PeerConnectionManager::kStopEventLog: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StopEventLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StopEventLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.3
      bool success = true;
      int32_t p_peer_connection_local_id{};
      PeerConnectionManager_StopEventLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopEventLog(        
        std::move(p_peer_connection_local_id));
      return true;
    }
    case messages::PeerConnectionManager::kStartDataChannelLog: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StartDataChannelLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StartDataChannelLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.4
      bool success = true;
      int32_t p_peer_connection_local_id{};
      PeerConnectionManager_StartDataChannelLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDataChannelLog(        
        std::move(p_peer_connection_local_id));
      return true;
    }
    case messages::PeerConnectionManager::kStopDataChannelLog: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_StopDataChannelLog_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_StopDataChannelLog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.5
      bool success = true;
      int32_t p_peer_connection_local_id{};
      PeerConnectionManager_StopDataChannelLog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_peer_connection_local_id = input_data_view.peer_connection_local_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopDataChannelLog(        
        std::move(p_peer_connection_local_id));
      return true;
    }
    case messages::PeerConnectionManager::kGetStandardStats: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_GetStandardStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_GetStandardStats_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.6
      bool success = true;
      PeerConnectionManager_GetStandardStats_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStandardStats(        );
      return true;
    }
    case messages::PeerConnectionManager::kGetCurrentState: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionManager_GetCurrentState_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionManager_GetCurrentState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionManager.7
      bool success = true;
      PeerConnectionManager_GetCurrentState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionManager::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCurrentState(        );
      return true;
    }
  }
  return false;
}

// static
bool PeerConnectionManagerStubDispatch::AcceptWithResponder(
    PeerConnectionManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PeerConnectionManager>(message->header()->name)) {
    case messages::PeerConnectionManager::kOnSuspend: {
      break;
    }
    case messages::PeerConnectionManager::kOnThermalStateChange: {
      break;
    }
    case messages::PeerConnectionManager::kStartEventLog: {
      break;
    }
    case messages::PeerConnectionManager::kStopEventLog: {
      break;
    }
    case messages::PeerConnectionManager::kStartDataChannelLog: {
      break;
    }
    case messages::PeerConnectionManager::kStopDataChannelLog: {
      break;
    }
    case messages::PeerConnectionManager::kGetStandardStats: {
      break;
    }
    case messages::PeerConnectionManager::kGetCurrentState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPeerConnectionManagerValidationInfo[] = {
    { &internal::PeerConnectionManager_OnSuspend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_OnThermalStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_StartEventLog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_StopEventLog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_StartDataChannelLog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_StopDataChannelLog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_GetStandardStats_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionManager_GetCurrentState_Params_Data::Validate,
     nullptr /* no response */},
};

bool PeerConnectionManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PeerConnectionManager::Name_,
    kPeerConnectionManagerValidationInfo);
}

// The declaration includes the definition on other builds.

PeerConnectionTrackerHost::IPCStableHashFunction PeerConnectionTrackerHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PeerConnectionTrackerHost>(message.name())) {
    case messages::PeerConnectionTrackerHost::kAddPeerConnection: {
      return &PeerConnectionTrackerHost::AddPeerConnection_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kRemovePeerConnection: {
      return &PeerConnectionTrackerHost::RemovePeerConnection_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kUpdatePeerConnection: {
      return &PeerConnectionTrackerHost::UpdatePeerConnection_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet: {
      return &PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMedia: {
      return &PeerConnectionTrackerHost::GetUserMedia_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaSuccess: {
      return &PeerConnectionTrackerHost::GetUserMediaSuccess_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaFailure: {
      return &PeerConnectionTrackerHost::GetUserMediaFailure_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMedia: {
      return &PeerConnectionTrackerHost::GetDisplayMedia_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess: {
      return &PeerConnectionTrackerHost::GetDisplayMediaSuccess_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure: {
      return &PeerConnectionTrackerHost::GetDisplayMediaFailure_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite: {
      return &PeerConnectionTrackerHost::WebRtcEventLogWrite_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite: {
      return &PeerConnectionTrackerHost::WebRtcDataChannelLogWrite_Sym::IPCStableHash;
    }
    case messages::PeerConnectionTrackerHost::kAddStandardStats: {
      return &PeerConnectionTrackerHost::AddStandardStats_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PeerConnectionTrackerHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PeerConnectionTrackerHost>(message.name())) {
      case messages::PeerConnectionTrackerHost::kAddPeerConnection:
            return "Receive blink::mojom::PeerConnectionTrackerHost::AddPeerConnection";
      case messages::PeerConnectionTrackerHost::kRemovePeerConnection:
            return "Receive blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection";
      case messages::PeerConnectionTrackerHost::kUpdatePeerConnection:
            return "Receive blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection";
      case messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet:
            return "Receive blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet";
      case messages::PeerConnectionTrackerHost::kGetUserMedia:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetUserMedia";
      case messages::PeerConnectionTrackerHost::kGetUserMediaSuccess:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetUserMediaSuccess";
      case messages::PeerConnectionTrackerHost::kGetUserMediaFailure:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetUserMediaFailure";
      case messages::PeerConnectionTrackerHost::kGetDisplayMedia:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetDisplayMedia";
      case messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaSuccess";
      case messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure:
            return "Receive blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaFailure";
      case messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite:
            return "Receive blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite";
      case messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite:
            return "Receive blink::mojom::PeerConnectionTrackerHost::WebRtcDataChannelLogWrite";
      case messages::PeerConnectionTrackerHost::kAddStandardStats:
            return "Receive blink::mojom::PeerConnectionTrackerHost::AddStandardStats";
    }
  } else {
    switch (static_cast<messages::PeerConnectionTrackerHost>(message.name())) {
      case messages::PeerConnectionTrackerHost::kAddPeerConnection:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::AddPeerConnection";
      case messages::PeerConnectionTrackerHost::kRemovePeerConnection:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection";
      case messages::PeerConnectionTrackerHost::kUpdatePeerConnection:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection";
      case messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet";
      case messages::PeerConnectionTrackerHost::kGetUserMedia:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetUserMedia";
      case messages::PeerConnectionTrackerHost::kGetUserMediaSuccess:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetUserMediaSuccess";
      case messages::PeerConnectionTrackerHost::kGetUserMediaFailure:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetUserMediaFailure";
      case messages::PeerConnectionTrackerHost::kGetDisplayMedia:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetDisplayMedia";
      case messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaSuccess";
      case messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaFailure";
      case messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite";
      case messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::WebRtcDataChannelLogWrite";
      case messages::PeerConnectionTrackerHost::kAddStandardStats:
            return "Receive reply blink::mojom::PeerConnectionTrackerHost::AddStandardStats";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PeerConnectionTrackerHost::AddPeerConnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b6c78a0;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::AddPeerConnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::RemovePeerConnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed4da495;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::UpdatePeerConnection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0780d25;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8884de5;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetUserMedia_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91bbedfd;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetUserMedia
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetUserMediaSuccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43f5ddc3;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetUserMediaSuccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetUserMediaFailure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7c12762;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetUserMediaFailure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetDisplayMedia_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43f5a8b7;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetDisplayMedia
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetDisplayMediaSuccess_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe01f84e8;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaSuccess
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::GetDisplayMediaFailure_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5f2c0182;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaFailure
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::WebRtcEventLogWrite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25ccc51f;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::WebRtcDataChannelLogWrite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x94713758;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::WebRtcDataChannelLogWrite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PeerConnectionTrackerHost::AddStandardStats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe38fd000;  // IPCStableHash for blink::mojom::PeerConnectionTrackerHost::AddStandardStats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PeerConnectionTrackerHostProxy::PeerConnectionTrackerHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PeerConnectionTrackerHostProxy::AddPeerConnection(
    PeerConnectionInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::AddPeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PeerConnectionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kAddPeerConnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PeerConnectionInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in PeerConnectionTrackerHost.AddPeerConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("AddPeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::RemovePeerConnection(
    int32_t in_lid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::RemovePeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kRemovePeerConnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("RemovePeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::UpdatePeerConnection(
    int32_t in_lid, const std::string& in_type, const std::string& in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::UpdatePeerConnection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kUpdatePeerConnection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->type)::BaseType> type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_type,
    type_fragment);

  params->type.Set(
      type_fragment.is_null() ? nullptr : type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null type in PeerConnectionTrackerHost.UpdatePeerConnection request");
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in PeerConnectionTrackerHost.UpdatePeerConnection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("UpdatePeerConnection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::OnPeerConnectionSessionIdSet(
    int32_t in_lid, const std::string& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::OnPeerConnectionSessionIdSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in PeerConnectionTrackerHost.OnPeerConnectionSessionIdSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("OnPeerConnectionSessionIdSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetUserMedia(
    int32_t in_request_id, bool in_audio, bool in_video, const std::string& in_audio_constraints, const std::string& in_video_constraints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetUserMedia", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio"), in_audio,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video"), in_video,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_constraints"), in_audio_constraints,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_constraints"), in_video_constraints,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetUserMedia), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  params->audio = in_audio;

  params->video = in_video;
  mojo::internal::MessageFragment<
      typename decltype(params->audio_constraints)::BaseType> audio_constraints_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_audio_constraints,
    audio_constraints_fragment);

  params->audio_constraints.Set(
      audio_constraints_fragment.is_null() ? nullptr : audio_constraints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_constraints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_constraints in PeerConnectionTrackerHost.GetUserMedia request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_constraints)::BaseType> video_constraints_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_video_constraints,
    video_constraints_fragment);

  params->video_constraints.Set(
      video_constraints_fragment.is_null() ? nullptr : video_constraints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_constraints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_constraints in PeerConnectionTrackerHost.GetUserMedia request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetUserMedia");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetUserMediaSuccess(
    int32_t in_request_id, const std::string& in_stream_id, const std::string& in_audio_track_info, const std::string& in_video_track_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetUserMediaSuccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_track_info"), in_audio_track_info,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_track_info"), in_video_track_info,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetUserMediaSuccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_id)::BaseType> stream_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_stream_id,
    stream_id_fragment);

  params->stream_id.Set(
      stream_id_fragment.is_null() ? nullptr : stream_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stream_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stream_id in PeerConnectionTrackerHost.GetUserMediaSuccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_track_info)::BaseType> audio_track_info_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_audio_track_info,
    audio_track_info_fragment);

  params->audio_track_info.Set(
      audio_track_info_fragment.is_null() ? nullptr : audio_track_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_track_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_track_info in PeerConnectionTrackerHost.GetUserMediaSuccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_track_info)::BaseType> video_track_info_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_video_track_info,
    video_track_info_fragment);

  params->video_track_info.Set(
      video_track_info_fragment.is_null() ? nullptr : video_track_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_track_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_track_info in PeerConnectionTrackerHost.GetUserMediaSuccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetUserMediaSuccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetUserMediaFailure(
    int32_t in_request_id, const std::string& in_error, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetUserMediaFailure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetUserMediaFailure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in PeerConnectionTrackerHost.GetUserMediaFailure request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in PeerConnectionTrackerHost.GetUserMediaFailure request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetUserMediaFailure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetDisplayMedia(
    int32_t in_request_id, bool in_audio, bool in_video, const std::string& in_audio_constraints, const std::string& in_video_constraints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetDisplayMedia", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio"), in_audio,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video"), in_video,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_constraints"), in_audio_constraints,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_constraints"), in_video_constraints,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetDisplayMedia), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetDisplayMedia_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

  params->audio = in_audio;

  params->video = in_video;
  mojo::internal::MessageFragment<
      typename decltype(params->audio_constraints)::BaseType> audio_constraints_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_audio_constraints,
    audio_constraints_fragment);

  params->audio_constraints.Set(
      audio_constraints_fragment.is_null() ? nullptr : audio_constraints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_constraints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_constraints in PeerConnectionTrackerHost.GetDisplayMedia request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_constraints)::BaseType> video_constraints_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_video_constraints,
    video_constraints_fragment);

  params->video_constraints.Set(
      video_constraints_fragment.is_null() ? nullptr : video_constraints_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_constraints.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_constraints in PeerConnectionTrackerHost.GetDisplayMedia request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetDisplayMedia");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetDisplayMediaSuccess(
    int32_t in_request_id, const std::string& in_stream_id, const std::string& in_audio_track_info, const std::string& in_video_track_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaSuccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_id"), in_stream_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_track_info"), in_audio_track_info,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_track_info"), in_video_track_info,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_id)::BaseType> stream_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_stream_id,
    stream_id_fragment);

  params->stream_id.Set(
      stream_id_fragment.is_null() ? nullptr : stream_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stream_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stream_id in PeerConnectionTrackerHost.GetDisplayMediaSuccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_track_info)::BaseType> audio_track_info_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_audio_track_info,
    audio_track_info_fragment);

  params->audio_track_info.Set(
      audio_track_info_fragment.is_null() ? nullptr : audio_track_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_track_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_track_info in PeerConnectionTrackerHost.GetDisplayMediaSuccess request");
  mojo::internal::MessageFragment<
      typename decltype(params->video_track_info)::BaseType> video_track_info_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_video_track_info,
    video_track_info_fragment);

  params->video_track_info.Set(
      video_track_info_fragment.is_null() ? nullptr : video_track_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_track_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_track_info in PeerConnectionTrackerHost.GetDisplayMediaSuccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetDisplayMediaSuccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::GetDisplayMediaFailure(
    int32_t in_request_id, const std::string& in_error, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::GetDisplayMediaFailure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in PeerConnectionTrackerHost.GetDisplayMediaFailure request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in PeerConnectionTrackerHost.GetDisplayMediaFailure request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("GetDisplayMediaFailure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::WebRtcEventLogWrite(
    int32_t in_lid, const std::vector<uint8_t>& in_output) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::WebRtcEventLogWrite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output"), in_output,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->output)::BaseType>
      output_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& output_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_output,
    output_fragment,
    &output_validate_params);

  params->output.Set(
      output_fragment.is_null() ? nullptr : output_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output in PeerConnectionTrackerHost.WebRtcEventLogWrite request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("WebRtcEventLogWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::WebRtcDataChannelLogWrite(
    int32_t in_lid, const std::vector<uint8_t>& in_output) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::WebRtcDataChannelLogWrite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("output"), in_output,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->output)::BaseType>
      output_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& output_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_output,
    output_fragment,
    &output_validate_params);

  params->output.Set(
      output_fragment.is_null() ? nullptr : output_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->output.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null output in PeerConnectionTrackerHost.WebRtcDataChannelLogWrite request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("WebRtcDataChannelLogWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PeerConnectionTrackerHostProxy::AddStandardStats(
    int32_t in_lid, ::base::Value::List in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PeerConnectionTrackerHost::AddStandardStats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lid"), in_lid,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ::base::Value::List>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PeerConnectionTrackerHost::kAddStandardStats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data> params(
          message);
  params.Allocate();

  params->lid = in_lid;
  mojo::internal::MessageFragment<
      typename decltype(params->value)::BaseType> value_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
    in_value,
    value_fragment);

  params->value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->value.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null value in PeerConnectionTrackerHost.AddStandardStats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PeerConnectionTrackerHost::Name_);
  message.set_method_name("AddStandardStats");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PeerConnectionTrackerHostStubDispatch::Accept(
    PeerConnectionTrackerHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PeerConnectionTrackerHost>(message->header()->name)) {
    case messages::PeerConnectionTrackerHost::kAddPeerConnection: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.0
      bool success = true;
      PeerConnectionInfoPtr p_info{};
      PeerConnectionTrackerHost_AddPeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddPeerConnection(        
        std::move(p_info));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kRemovePeerConnection: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.1
      bool success = true;
      int32_t p_lid{};
      PeerConnectionTrackerHost_RemovePeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemovePeerConnection(        
        std::move(p_lid));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kUpdatePeerConnection: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.2
      bool success = true;
      int32_t p_lid{};
      std::string p_type{};
      std::string p_value{};
      PeerConnectionTrackerHost_UpdatePeerConnection_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdatePeerConnection(        
        std::move(p_lid), 
        std::move(p_type), 
        std::move(p_value));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.3
      bool success = true;
      int32_t p_lid{};
      std::string p_session_id{};
      PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPeerConnectionSessionIdSet(        
        std::move(p_lid), 
        std::move(p_session_id));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMedia: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.4
      bool success = true;
      int32_t p_request_id{};
      bool p_audio{};
      bool p_video{};
      std::string p_audio_constraints{};
      std::string p_video_constraints{};
      PeerConnectionTrackerHost_GetUserMedia_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_audio = input_data_view.audio();
      if (success)
        p_video = input_data_view.video();
      if (success && !input_data_view.ReadAudioConstraints(&p_audio_constraints))
        success = false;
      if (success && !input_data_view.ReadVideoConstraints(&p_video_constraints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserMedia(        
        std::move(p_request_id), 
        std::move(p_audio), 
        std::move(p_video), 
        std::move(p_audio_constraints), 
        std::move(p_video_constraints));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaSuccess: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.5
      bool success = true;
      int32_t p_request_id{};
      std::string p_stream_id{};
      std::string p_audio_track_info{};
      std::string p_video_track_info{};
      PeerConnectionTrackerHost_GetUserMediaSuccess_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadStreamId(&p_stream_id))
        success = false;
      if (success && !input_data_view.ReadAudioTrackInfo(&p_audio_track_info))
        success = false;
      if (success && !input_data_view.ReadVideoTrackInfo(&p_video_track_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserMediaSuccess(        
        std::move(p_request_id), 
        std::move(p_stream_id), 
        std::move(p_audio_track_info), 
        std::move(p_video_track_info));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaFailure: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.6
      bool success = true;
      int32_t p_request_id{};
      std::string p_error{};
      std::string p_error_message{};
      PeerConnectionTrackerHost_GetUserMediaFailure_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUserMediaFailure(        
        std::move(p_request_id), 
        std::move(p_error), 
        std::move(p_error_message));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMedia: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetDisplayMedia_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetDisplayMedia_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.7
      bool success = true;
      int32_t p_request_id{};
      bool p_audio{};
      bool p_video{};
      std::string p_audio_constraints{};
      std::string p_video_constraints{};
      PeerConnectionTrackerHost_GetDisplayMedia_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_audio = input_data_view.audio();
      if (success)
        p_video = input_data_view.video();
      if (success && !input_data_view.ReadAudioConstraints(&p_audio_constraints))
        success = false;
      if (success && !input_data_view.ReadVideoConstraints(&p_video_constraints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDisplayMedia(        
        std::move(p_request_id), 
        std::move(p_audio), 
        std::move(p_video), 
        std::move(p_audio_constraints), 
        std::move(p_video_constraints));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.8
      bool success = true;
      int32_t p_request_id{};
      std::string p_stream_id{};
      std::string p_audio_track_info{};
      std::string p_video_track_info{};
      PeerConnectionTrackerHost_GetDisplayMediaSuccess_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadStreamId(&p_stream_id))
        success = false;
      if (success && !input_data_view.ReadAudioTrackInfo(&p_audio_track_info))
        success = false;
      if (success && !input_data_view.ReadVideoTrackInfo(&p_video_track_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDisplayMediaSuccess(        
        std::move(p_request_id), 
        std::move(p_stream_id), 
        std::move(p_audio_track_info), 
        std::move(p_video_track_info));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.9
      bool success = true;
      int32_t p_request_id{};
      std::string p_error{};
      std::string p_error_message{};
      PeerConnectionTrackerHost_GetDisplayMediaFailure_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDisplayMediaFailure(        
        std::move(p_request_id), 
        std::move(p_error), 
        std::move(p_error_message));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.10
      bool success = true;
      int32_t p_lid{};
      std::vector<uint8_t> p_output{};
      PeerConnectionTrackerHost_WebRtcEventLogWrite_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadOutput(&p_output))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebRtcEventLogWrite(        
        std::move(p_lid), 
        std::move(p_output));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.11
      bool success = true;
      int32_t p_lid{};
      std::vector<uint8_t> p_output{};
      PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadOutput(&p_output))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WebRtcDataChannelLogWrite(        
        std::move(p_lid), 
        std::move(p_output));
      return true;
    }
    case messages::PeerConnectionTrackerHost::kAddStandardStats: {
      DCHECK(message->is_serialized());
      internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data* params =
          reinterpret_cast<internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PeerConnectionTrackerHost.12
      bool success = true;
      int32_t p_lid{};
      ::base::Value::List p_value{};
      PeerConnectionTrackerHost_AddStandardStats_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_lid = input_data_view.lid();
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PeerConnectionTrackerHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddStandardStats(        
        std::move(p_lid), 
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool PeerConnectionTrackerHostStubDispatch::AcceptWithResponder(
    PeerConnectionTrackerHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PeerConnectionTrackerHost>(message->header()->name)) {
    case messages::PeerConnectionTrackerHost::kAddPeerConnection: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kRemovePeerConnection: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kUpdatePeerConnection: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kOnPeerConnectionSessionIdSet: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMedia: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaSuccess: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetUserMediaFailure: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMedia: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaSuccess: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kGetDisplayMediaFailure: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcEventLogWrite: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kWebRtcDataChannelLogWrite: {
      break;
    }
    case messages::PeerConnectionTrackerHost::kAddStandardStats: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPeerConnectionTrackerHostValidationInfo[] = {
    { &internal::PeerConnectionTrackerHost_AddPeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_RemovePeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_UpdatePeerConnection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_OnPeerConnectionSessionIdSet_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetUserMedia_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetUserMediaSuccess_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetUserMediaFailure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetDisplayMedia_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetDisplayMediaSuccess_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_GetDisplayMediaFailure_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_WebRtcEventLogWrite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_WebRtcDataChannelLogWrite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PeerConnectionTrackerHost_AddStandardStats_Params_Data::Validate,
     nullptr /* no response */},
};

bool PeerConnectionTrackerHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::PeerConnectionTrackerHost::Name_,
    kPeerConnectionTrackerHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::PeerConnectionInfo::DataView, ::blink::mojom::PeerConnectionInfoPtr>::Read(
    ::blink::mojom::PeerConnectionInfo::DataView input,
    ::blink::mojom::PeerConnectionInfoPtr* output) {
  bool success = true;
  ::blink::mojom::PeerConnectionInfoPtr result(::blink::mojom::PeerConnectionInfo::New());
  
      if (success)
        result->lid = input.lid();
      if (success && !input.ReadRtcConfiguration(&result->rtc_configuration))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void PeerConnectionManagerInterceptorForTesting::OnSuspend() {
  GetForwardingInterface()->OnSuspend();
}
void PeerConnectionManagerInterceptorForTesting::OnThermalStateChange(DeviceThermalState thermal_state) {
  GetForwardingInterface()->OnThermalStateChange(
    std::move(thermal_state)
    );
}
void PeerConnectionManagerInterceptorForTesting::StartEventLog(int32_t peer_connection_local_id, int32_t output_period_ms) {
  GetForwardingInterface()->StartEventLog(
    std::move(peer_connection_local_id)
    , 
    std::move(output_period_ms)
    );
}
void PeerConnectionManagerInterceptorForTesting::StopEventLog(int32_t peer_connection_local_id) {
  GetForwardingInterface()->StopEventLog(
    std::move(peer_connection_local_id)
    );
}
void PeerConnectionManagerInterceptorForTesting::StartDataChannelLog(int32_t peer_connection_local_id) {
  GetForwardingInterface()->StartDataChannelLog(
    std::move(peer_connection_local_id)
    );
}
void PeerConnectionManagerInterceptorForTesting::StopDataChannelLog(int32_t peer_connection_local_id) {
  GetForwardingInterface()->StopDataChannelLog(
    std::move(peer_connection_local_id)
    );
}
void PeerConnectionManagerInterceptorForTesting::GetStandardStats() {
  GetForwardingInterface()->GetStandardStats();
}
void PeerConnectionManagerInterceptorForTesting::GetCurrentState() {
  GetForwardingInterface()->GetCurrentState();
}
PeerConnectionManagerAsyncWaiter::PeerConnectionManagerAsyncWaiter(
    PeerConnectionManager* proxy) : proxy_(proxy) {}

PeerConnectionManagerAsyncWaiter::~PeerConnectionManagerAsyncWaiter() = default;





void PeerConnectionTrackerHostInterceptorForTesting::AddPeerConnection(PeerConnectionInfoPtr info) {
  GetForwardingInterface()->AddPeerConnection(
    std::move(info)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::RemovePeerConnection(int32_t lid) {
  GetForwardingInterface()->RemovePeerConnection(
    std::move(lid)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::UpdatePeerConnection(int32_t lid, const std::string& type, const std::string& value) {
  GetForwardingInterface()->UpdatePeerConnection(
    std::move(lid)
    , 
    std::move(type)
    , 
    std::move(value)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::OnPeerConnectionSessionIdSet(int32_t lid, const std::string& session_id) {
  GetForwardingInterface()->OnPeerConnectionSessionIdSet(
    std::move(lid)
    , 
    std::move(session_id)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetUserMedia(int32_t request_id, bool audio, bool video, const std::string& audio_constraints, const std::string& video_constraints) {
  GetForwardingInterface()->GetUserMedia(
    std::move(request_id)
    , 
    std::move(audio)
    , 
    std::move(video)
    , 
    std::move(audio_constraints)
    , 
    std::move(video_constraints)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetUserMediaSuccess(int32_t request_id, const std::string& stream_id, const std::string& audio_track_info, const std::string& video_track_info) {
  GetForwardingInterface()->GetUserMediaSuccess(
    std::move(request_id)
    , 
    std::move(stream_id)
    , 
    std::move(audio_track_info)
    , 
    std::move(video_track_info)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetUserMediaFailure(int32_t request_id, const std::string& error, const std::string& error_message) {
  GetForwardingInterface()->GetUserMediaFailure(
    std::move(request_id)
    , 
    std::move(error)
    , 
    std::move(error_message)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetDisplayMedia(int32_t request_id, bool audio, bool video, const std::string& audio_constraints, const std::string& video_constraints) {
  GetForwardingInterface()->GetDisplayMedia(
    std::move(request_id)
    , 
    std::move(audio)
    , 
    std::move(video)
    , 
    std::move(audio_constraints)
    , 
    std::move(video_constraints)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetDisplayMediaSuccess(int32_t request_id, const std::string& stream_id, const std::string& audio_track_info, const std::string& video_track_info) {
  GetForwardingInterface()->GetDisplayMediaSuccess(
    std::move(request_id)
    , 
    std::move(stream_id)
    , 
    std::move(audio_track_info)
    , 
    std::move(video_track_info)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::GetDisplayMediaFailure(int32_t request_id, const std::string& error, const std::string& error_message) {
  GetForwardingInterface()->GetDisplayMediaFailure(
    std::move(request_id)
    , 
    std::move(error)
    , 
    std::move(error_message)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::WebRtcEventLogWrite(int32_t lid, const std::vector<uint8_t>& output) {
  GetForwardingInterface()->WebRtcEventLogWrite(
    std::move(lid)
    , 
    std::move(output)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::WebRtcDataChannelLogWrite(int32_t lid, const std::vector<uint8_t>& output) {
  GetForwardingInterface()->WebRtcDataChannelLogWrite(
    std::move(lid)
    , 
    std::move(output)
    );
}
void PeerConnectionTrackerHostInterceptorForTesting::AddStandardStats(int32_t lid, ::base::Value::List value) {
  GetForwardingInterface()->AddStandardStats(
    std::move(lid)
    , 
    std::move(value)
    );
}
PeerConnectionTrackerHostAsyncWaiter::PeerConnectionTrackerHostAsyncWaiter(
    PeerConnectionTrackerHost* proxy) : proxy_(proxy) {}

PeerConnectionTrackerHostAsyncWaiter::~PeerConnectionTrackerHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif