// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('payments.mojom');
  var authenticator$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/webauthn/authenticator.mojom', '../webauthn/authenticator.mojom.js');
  }


  var PaymentCredentialStorageStatus = {};
  PaymentCredentialStorageStatus.SUCCESS = 0;
  PaymentCredentialStorageStatus.FAILED_TO_STORE_CREDENTIAL = 1;
  PaymentCredentialStorageStatus.MIN_VALUE = 0;
  PaymentCredentialStorageStatus.MAX_VALUE = 1;

  PaymentCredentialStorageStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  PaymentCredentialStorageStatus.toKnownEnumValue = function(value) {
    return value;
  };

  PaymentCredentialStorageStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var SecurePaymentConfirmationAvailabilityEnum = {};
  SecurePaymentConfirmationAvailabilityEnum.kAvailable = 0;
  SecurePaymentConfirmationAvailabilityEnum.kUnavailableUnknownReason = 1;
  SecurePaymentConfirmationAvailabilityEnum.kUnavailableFeatureNotEnabled = 2;
  SecurePaymentConfirmationAvailabilityEnum.kUnavailableNoPermissionPolicy = 3;
  SecurePaymentConfirmationAvailabilityEnum.kUnavailableNoUserVerifyingPlatformAuthenticator = 4;
  SecurePaymentConfirmationAvailabilityEnum.MIN_VALUE = 0;
  SecurePaymentConfirmationAvailabilityEnum.MAX_VALUE = 4;

  SecurePaymentConfirmationAvailabilityEnum.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  SecurePaymentConfirmationAvailabilityEnum.toKnownEnumValue = function(value) {
    return value;
  };

  SecurePaymentConfirmationAvailabilityEnum.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.prototype.initDefaults_ = function() {
  };
  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.encodedSize = codec.kStructHeaderSize + 0;

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.prototype.initDefaults_ = function() {
    this.availability = 0;
  };
  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.availability
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SecurePaymentConfirmationAvailabilityEnum);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.availability =
        decoder.decodeStruct(new codec.Enum(SecurePaymentConfirmationAvailabilityEnum));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.availability);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SecurePaymentConfirmationService_StorePaymentCredential_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_StorePaymentCredential_Params.prototype.initDefaults_ = function() {
    this.credentialId = null;
    this.rpId = null;
    this.userId = null;
  };
  SecurePaymentConfirmationService_StorePaymentCredential_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_StorePaymentCredential_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_StorePaymentCredential_Params.credentialId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_StorePaymentCredential_Params.rpId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_StorePaymentCredential_Params.userId
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_StorePaymentCredential_Params.encodedSize = codec.kStructHeaderSize + 24;

  SecurePaymentConfirmationService_StorePaymentCredential_Params.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_StorePaymentCredential_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.credentialId =
        decoder.decodeArrayPointer(codec.Uint8);
    val.rpId =
        decoder.decodeStruct(codec.String);
    val.userId =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SecurePaymentConfirmationService_StorePaymentCredential_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_StorePaymentCredential_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.credentialId);
    encoder.encodeStruct(codec.String, val.rpId);
    encoder.encodeArrayPointer(codec.Uint8, val.userId);
  };
  function SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PaymentCredentialStorageStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(PaymentCredentialStorageStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SecurePaymentConfirmationService_MakePaymentCredential_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_MakePaymentCredential_Params.prototype.initDefaults_ = function() {
    this.options = null;
  };
  SecurePaymentConfirmationService_MakePaymentCredential_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_MakePaymentCredential_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_MakePaymentCredential_Params.options
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, authenticator$.PublicKeyCredentialCreationOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_MakePaymentCredential_Params.encodedSize = codec.kStructHeaderSize + 8;

  SecurePaymentConfirmationService_MakePaymentCredential_Params.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_MakePaymentCredential_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.options =
        decoder.decodeStructPointer(authenticator$.PublicKeyCredentialCreationOptions);
    return val;
  };

  SecurePaymentConfirmationService_MakePaymentCredential_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_MakePaymentCredential_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(authenticator$.PublicKeyCredentialCreationOptions, val.options);
  };
  function SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.prototype.initDefaults_ = function() {
    this.status = 0;
    this.credential = null;
    this.domExceptionDetails = null;
  };
  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, authenticator$.AuthenticatorStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.credential
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, authenticator$.MakeCredentialAuthenticatorResponse, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.domExceptionDetails
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, authenticator$.WebAuthnDOMExceptionDetails, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(authenticator$.AuthenticatorStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.credential =
        decoder.decodeStructPointer(authenticator$.MakeCredentialAuthenticatorResponse);
    val.domExceptionDetails =
        decoder.decodeStructPointer(authenticator$.WebAuthnDOMExceptionDetails);
    return val;
  };

  SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(authenticator$.MakeCredentialAuthenticatorResponse, val.credential);
    encoder.encodeStructPointer(authenticator$.WebAuthnDOMExceptionDetails, val.domExceptionDetails);
  };
  var kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name = 0;
  var kSecurePaymentConfirmationService_StorePaymentCredential_Name = 1;
  var kSecurePaymentConfirmationService_MakePaymentCredential_Name = 2;

  function SecurePaymentConfirmationServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SecurePaymentConfirmationService,
                                                   handleOrPtrInfo);
  }

  function SecurePaymentConfirmationServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SecurePaymentConfirmationService, associatedInterfacePtrInfo);
  }

  SecurePaymentConfirmationServiceAssociatedPtr.prototype =
      Object.create(SecurePaymentConfirmationServicePtr.prototype);
  SecurePaymentConfirmationServiceAssociatedPtr.prototype.constructor =
      SecurePaymentConfirmationServiceAssociatedPtr;

  function SecurePaymentConfirmationServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SecurePaymentConfirmationServicePtr.prototype.securePaymentConfirmationAvailability = function() {
    return SecurePaymentConfirmationServiceProxy.prototype.securePaymentConfirmationAvailability
        .apply(this.ptr.getProxy(), arguments);
  };

  SecurePaymentConfirmationServiceProxy.prototype.securePaymentConfirmationAvailability = function() {
    var params_ = new SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name,
          codec.align(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SecurePaymentConfirmationServicePtr.prototype.storePaymentCredential = function() {
    return SecurePaymentConfirmationServiceProxy.prototype.storePaymentCredential
        .apply(this.ptr.getProxy(), arguments);
  };

  SecurePaymentConfirmationServiceProxy.prototype.storePaymentCredential = function(credentialId, rpId, userId) {
    var params_ = new SecurePaymentConfirmationService_StorePaymentCredential_Params();
    params_.credentialId = credentialId;
    params_.rpId = rpId;
    params_.userId = userId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSecurePaymentConfirmationService_StorePaymentCredential_Name,
          codec.align(SecurePaymentConfirmationService_StorePaymentCredential_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SecurePaymentConfirmationService_StorePaymentCredential_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SecurePaymentConfirmationServicePtr.prototype.makePaymentCredential = function() {
    return SecurePaymentConfirmationServiceProxy.prototype.makePaymentCredential
        .apply(this.ptr.getProxy(), arguments);
  };

  SecurePaymentConfirmationServiceProxy.prototype.makePaymentCredential = function(options) {
    var params_ = new SecurePaymentConfirmationService_MakePaymentCredential_Params();
    params_.options = options;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSecurePaymentConfirmationService_MakePaymentCredential_Name,
          codec.align(SecurePaymentConfirmationService_MakePaymentCredential_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SecurePaymentConfirmationService_MakePaymentCredential_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function SecurePaymentConfirmationServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  SecurePaymentConfirmationServiceStub.prototype.securePaymentConfirmationAvailability = function() {
    return this.delegate_ && this.delegate_.securePaymentConfirmationAvailability && this.delegate_.securePaymentConfirmationAvailability();
  }
  SecurePaymentConfirmationServiceStub.prototype.storePaymentCredential = function(credentialId, rpId, userId) {
    return this.delegate_ && this.delegate_.storePaymentCredential && this.delegate_.storePaymentCredential(credentialId, rpId, userId);
  }
  SecurePaymentConfirmationServiceStub.prototype.makePaymentCredential = function(options) {
    return this.delegate_ && this.delegate_.makePaymentCredential && this.delegate_.makePaymentCredential(options);
  }

  SecurePaymentConfirmationServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  SecurePaymentConfirmationServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name:
      var params = reader.decodeStruct(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params);
      this.securePaymentConfirmationAvailability().then(function(response) {
        var responseParams =
            new SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams();
        responseParams.availability = response.availability;
        var builder = new codec.MessageV1Builder(
            kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name,
            codec.align(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSecurePaymentConfirmationService_StorePaymentCredential_Name:
      var params = reader.decodeStruct(SecurePaymentConfirmationService_StorePaymentCredential_Params);
      this.storePaymentCredential(params.credentialId, params.rpId, params.userId).then(function(response) {
        var responseParams =
            new SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams();
        responseParams.status = response.status;
        var builder = new codec.MessageV1Builder(
            kSecurePaymentConfirmationService_StorePaymentCredential_Name,
            codec.align(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kSecurePaymentConfirmationService_MakePaymentCredential_Name:
      var params = reader.decodeStruct(SecurePaymentConfirmationService_MakePaymentCredential_Params);
      this.makePaymentCredential(params.options).then(function(response) {
        var responseParams =
            new SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams();
        responseParams.status = response.status;
        responseParams.credential = response.credential;
        responseParams.domExceptionDetails = response.domExceptionDetails;
        var builder = new codec.MessageV1Builder(
            kSecurePaymentConfirmationService_MakePaymentCredential_Name,
            codec.align(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSecurePaymentConfirmationServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name:
        if (message.expectsResponse())
          paramsClass = SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Params;
      break;
      case kSecurePaymentConfirmationService_StorePaymentCredential_Name:
        if (message.expectsResponse())
          paramsClass = SecurePaymentConfirmationService_StorePaymentCredential_Params;
      break;
      case kSecurePaymentConfirmationService_MakePaymentCredential_Name:
        if (message.expectsResponse())
          paramsClass = SecurePaymentConfirmationService_MakePaymentCredential_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSecurePaymentConfirmationServiceResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_Name:
        if (message.isResponse())
          paramsClass = SecurePaymentConfirmationService_SecurePaymentConfirmationAvailability_ResponseParams;
        break;
      case kSecurePaymentConfirmationService_StorePaymentCredential_Name:
        if (message.isResponse())
          paramsClass = SecurePaymentConfirmationService_StorePaymentCredential_ResponseParams;
        break;
      case kSecurePaymentConfirmationService_MakePaymentCredential_Name:
        if (message.isResponse())
          paramsClass = SecurePaymentConfirmationService_MakePaymentCredential_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SecurePaymentConfirmationService = {
    name: 'payments.mojom.SecurePaymentConfirmationService',
    kVersion: 0,
    ptrClass: SecurePaymentConfirmationServicePtr,
    proxyClass: SecurePaymentConfirmationServiceProxy,
    stubClass: SecurePaymentConfirmationServiceStub,
    validateRequest: validateSecurePaymentConfirmationServiceRequest,
    validateResponse: validateSecurePaymentConfirmationServiceResponse,
  };
  SecurePaymentConfirmationServiceStub.prototype.validator = validateSecurePaymentConfirmationServiceRequest;
  SecurePaymentConfirmationServiceProxy.prototype.validator = validateSecurePaymentConfirmationServiceResponse;
  exports.PaymentCredentialStorageStatus = PaymentCredentialStorageStatus;
  exports.SecurePaymentConfirmationAvailabilityEnum = SecurePaymentConfirmationAvailabilityEnum;
  exports.SecurePaymentConfirmationService = SecurePaymentConfirmationService;
  exports.SecurePaymentConfirmationServicePtr = SecurePaymentConfirmationServicePtr;
  exports.SecurePaymentConfirmationServiceAssociatedPtr = SecurePaymentConfirmationServiceAssociatedPtr;
})();