// third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/payments/secure_payment_confirmation_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace payments::mojom::blink {

class SecurePaymentConfirmationServiceProxy;

template <typename ImplRefTraits>
class SecurePaymentConfirmationServiceStub;

class SecurePaymentConfirmationServiceRequestValidator;
class SecurePaymentConfirmationServiceResponseValidator;


class PLATFORM_EXPORT SecurePaymentConfirmationService
    : public SecurePaymentConfirmationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "payments.mojom.SecurePaymentConfirmationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SecurePaymentConfirmationServiceInterfaceBase;
  using Proxy_ = SecurePaymentConfirmationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SecurePaymentConfirmationServiceStub<ImplRefTraits>;

  using RequestValidator_ = SecurePaymentConfirmationServiceRequestValidator;
  using ResponseValidator_ = SecurePaymentConfirmationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSecurePaymentConfirmationAvailabilityMinVersion = 0,
    kStorePaymentCredentialMinVersion = 0,
    kMakePaymentCredentialMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SecurePaymentConfirmationAvailability_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StorePaymentCredential_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakePaymentCredential_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SecurePaymentConfirmationService() = default;

  using SecurePaymentConfirmationAvailabilityCallback = base::OnceCallback<void(SecurePaymentConfirmationAvailabilityEnum)>;
  using SecurePaymentConfirmationAvailabilityMojoCallback = base::OnceCallback<void(SecurePaymentConfirmationAvailabilityEnum)>;

  virtual void SecurePaymentConfirmationAvailability(SecurePaymentConfirmationAvailabilityCallback callback) = 0;

  using StorePaymentCredentialCallback = base::OnceCallback<void(PaymentCredentialStorageStatus)>;
  using StorePaymentCredentialMojoCallback = base::OnceCallback<void(PaymentCredentialStorageStatus)>;

  virtual void StorePaymentCredential(const ::blink::Vector<uint8_t>& credential_id, const ::blink::String& rp_id, const ::blink::Vector<uint8_t>& user_id, StorePaymentCredentialCallback callback) = 0;

  using MakePaymentCredentialCallback = base::OnceCallback<void(::blink::mojom::blink::AuthenticatorStatus, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr)>;
  using MakePaymentCredentialMojoCallback = base::OnceCallback<void(::blink::mojom::blink::AuthenticatorStatus, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr)>;

  virtual void MakePaymentCredential(::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr options, MakePaymentCredentialCallback callback) = 0;
};



class PLATFORM_EXPORT SecurePaymentConfirmationServiceProxy
    : public SecurePaymentConfirmationService {
 public:
  using InterfaceType = SecurePaymentConfirmationService;

  explicit SecurePaymentConfirmationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SecurePaymentConfirmationAvailability(SecurePaymentConfirmationAvailabilityCallback callback) final;
  
  void StorePaymentCredential(const ::blink::Vector<uint8_t>& credential_id, const ::blink::String& rp_id, const ::blink::Vector<uint8_t>& user_id, StorePaymentCredentialCallback callback) final;
  
  void MakePaymentCredential(::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr options, MakePaymentCredentialCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SecurePaymentConfirmationServiceStubDispatch {
 public:
  static bool Accept(SecurePaymentConfirmationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SecurePaymentConfirmationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SecurePaymentConfirmationService>>
class SecurePaymentConfirmationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SecurePaymentConfirmationServiceStub() = default;
  ~SecurePaymentConfirmationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SecurePaymentConfirmationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SecurePaymentConfirmationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SecurePaymentConfirmationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SecurePaymentConfirmationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // payments::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_SECURE_PAYMENT_CONFIRMATION_SERVICE_MOJOM_BLINK_H_