// third_party/blink/public/mojom/page/display_cutout.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/display_cutout.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/page/display_cutout.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/display_cutout.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/display_cutout.mojom-import-headers.h"
#include "third_party/blink/public/mojom/page/display_cutout.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

DisplayCutoutHost::IPCStableHashFunction DisplayCutoutHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DisplayCutoutHost>(message.name())) {
    case messages::DisplayCutoutHost::kNotifyViewportFitChanged: {
      return &DisplayCutoutHost::NotifyViewportFitChanged_Sym::IPCStableHash;
    }
    case messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged: {
      return &DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DisplayCutoutHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DisplayCutoutHost>(message.name())) {
      case messages::DisplayCutoutHost::kNotifyViewportFitChanged:
            return "Receive blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged";
      case messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged:
            return "Receive blink::mojom::DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged";
    }
  } else {
    switch (static_cast<messages::DisplayCutoutHost>(message.name())) {
      case messages::DisplayCutoutHost::kNotifyViewportFitChanged:
            return "Receive reply blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged";
      case messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged:
            return "Receive reply blink::mojom::DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DisplayCutoutHost::NotifyViewportFitChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3206929c;  // IPCStableHash for blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x940351e1;  // IPCStableHash for blink::mojom::DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DisplayCutoutHostProxy::DisplayCutoutHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayCutoutHostProxy::NotifyViewportFitChanged(
    ViewportFit in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DisplayCutoutHost::NotifyViewportFitChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type ViewportFit>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayCutoutHost::kNotifyViewportFitChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ViewportFit>(
    in_value,
    &params->value);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayCutoutHost::Name_);
  message.set_method_name("NotifyViewportFitChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DisplayCutoutHostProxy::NotifyComplexSafeAreaConstraintChanged(
    bool in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DisplayCutoutHost::NotifyComplexSafeAreaConstraintChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params_Data> params(
          message);
  params.Allocate();

  params->value = in_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayCutoutHost::Name_);
  message.set_method_name("NotifyComplexSafeAreaConstraintChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DisplayCutoutHostStubDispatch::Accept(
    DisplayCutoutHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DisplayCutoutHost>(message->header()->name)) {
    case messages::DisplayCutoutHost::kNotifyViewportFitChanged: {
      DCHECK(message->is_serialized());
      internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data* params =
          reinterpret_cast<internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayCutoutHost.0
      bool success = true;
      ViewportFit p_value{};
      DisplayCutoutHost_NotifyViewportFitChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayCutoutHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyViewportFitChanged(        
        std::move(p_value));
      return true;
    }
    case messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged: {
      DCHECK(message->is_serialized());
      internal::DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params_Data* params =
          reinterpret_cast<internal::DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayCutoutHost.1
      bool success = true;
      bool p_value{};
      DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_value = input_data_view.value();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayCutoutHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyComplexSafeAreaConstraintChanged(        
        std::move(p_value));
      return true;
    }
  }
  return false;
}

// static
bool DisplayCutoutHostStubDispatch::AcceptWithResponder(
    DisplayCutoutHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DisplayCutoutHost>(message->header()->name)) {
    case messages::DisplayCutoutHost::kNotifyViewportFitChanged: {
      break;
    }
    case messages::DisplayCutoutHost::kNotifyComplexSafeAreaConstraintChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDisplayCutoutHostValidationInfo[] = {
    { &internal::DisplayCutoutHost_NotifyViewportFitChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayCutoutHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::DisplayCutoutHost::Name_,
    kDisplayCutoutHostValidationInfo);
}

// The declaration includes the definition on other builds.

DisplayCutoutClient::IPCStableHashFunction DisplayCutoutClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DisplayCutoutClient>(message.name())) {
    case messages::DisplayCutoutClient::kSetSafeArea: {
      return &DisplayCutoutClient::SetSafeArea_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DisplayCutoutClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DisplayCutoutClient>(message.name())) {
      case messages::DisplayCutoutClient::kSetSafeArea:
            return "Receive blink::mojom::DisplayCutoutClient::SetSafeArea";
    }
  } else {
    switch (static_cast<messages::DisplayCutoutClient>(message.name())) {
      case messages::DisplayCutoutClient::kSetSafeArea:
            return "Receive reply blink::mojom::DisplayCutoutClient::SetSafeArea";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DisplayCutoutClient::SetSafeArea_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c27ce5a;  // IPCStableHash for blink::mojom::DisplayCutoutClient::SetSafeArea
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DisplayCutoutClientProxy::DisplayCutoutClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DisplayCutoutClientProxy::SetSafeArea(
    const ::gfx::Insets& in_safe_area) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DisplayCutoutClient::SetSafeArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safe_area"), in_safe_area,
                        "<value of type const ::gfx::Insets&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DisplayCutoutClient::kSetSafeArea), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DisplayCutoutClient_SetSafeArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->safe_area)::BaseType> safe_area_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::InsetsDataView>(
    in_safe_area,
    safe_area_fragment);

  params->safe_area.Set(
      safe_area_fragment.is_null() ? nullptr : safe_area_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->safe_area.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null safe_area in DisplayCutoutClient.SetSafeArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DisplayCutoutClient::Name_);
  message.set_method_name("SetSafeArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DisplayCutoutClientStubDispatch::Accept(
    DisplayCutoutClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DisplayCutoutClient>(message->header()->name)) {
    case messages::DisplayCutoutClient::kSetSafeArea: {
      DCHECK(message->is_serialized());
      internal::DisplayCutoutClient_SetSafeArea_Params_Data* params =
          reinterpret_cast<internal::DisplayCutoutClient_SetSafeArea_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DisplayCutoutClient.0
      bool success = true;
      ::gfx::Insets p_safe_area{};
      DisplayCutoutClient_SetSafeArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSafeArea(&p_safe_area))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DisplayCutoutClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSafeArea(        
        std::move(p_safe_area));
      return true;
    }
  }
  return false;
}

// static
bool DisplayCutoutClientStubDispatch::AcceptWithResponder(
    DisplayCutoutClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DisplayCutoutClient>(message->header()->name)) {
    case messages::DisplayCutoutClient::kSetSafeArea: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDisplayCutoutClientValidationInfo[] = {
    { &internal::DisplayCutoutClient_SetSafeArea_Params_Data::Validate,
     nullptr /* no response */},
};

bool DisplayCutoutClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::DisplayCutoutClient::Name_,
    kDisplayCutoutClientValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void DisplayCutoutHostInterceptorForTesting::NotifyViewportFitChanged(ViewportFit value) {
  GetForwardingInterface()->NotifyViewportFitChanged(
    std::move(value)
    );
}
void DisplayCutoutHostInterceptorForTesting::NotifyComplexSafeAreaConstraintChanged(bool value) {
  GetForwardingInterface()->NotifyComplexSafeAreaConstraintChanged(
    std::move(value)
    );
}
DisplayCutoutHostAsyncWaiter::DisplayCutoutHostAsyncWaiter(
    DisplayCutoutHost* proxy) : proxy_(proxy) {}

DisplayCutoutHostAsyncWaiter::~DisplayCutoutHostAsyncWaiter() = default;





void DisplayCutoutClientInterceptorForTesting::SetSafeArea(const ::gfx::Insets& safe_area) {
  GetForwardingInterface()->SetSafeArea(
    std::move(safe_area)
    );
}
DisplayCutoutClientAsyncWaiter::DisplayCutoutClientAsyncWaiter(
    DisplayCutoutClient* proxy) : proxy_(proxy) {}

DisplayCutoutClientAsyncWaiter::~DisplayCutoutClientAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif