// third_party/blink/public/mojom/opengraph/metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/opengraph/metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function OpenGraphMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OpenGraphMetadata.prototype.initDefaults_ = function() {
    this.image = null;
  };
  OpenGraphMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OpenGraphMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OpenGraphMetadata.image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OpenGraphMetadata.encodedSize = codec.kStructHeaderSize + 8;

  OpenGraphMetadata.decode = function(decoder) {
    var packed;
    var val = new OpenGraphMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  OpenGraphMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OpenGraphMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.image);
  };
  exports.OpenGraphMetadata = OpenGraphMetadata;
})();