// third_party/blink/public/mojom/on_device_translation/translator.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ModelStreamingResponderRemote as blink_mojom_ModelStreamingResponderRemote,
  ModelStreamingResponderPendingReceiver as blink_mojom_ModelStreamingResponderPendingReceiver
} from '../ai/model_streaming_responder.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TranslatorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.Translator', scope);
  }
}

/** @interface */
export class TranslatorInterface {
  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  translate(input, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  translateStreaming(input, pendingResponder) {}
}

/**
 * @implements { TranslatorInterface }
 */
export class TranslatorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TranslatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TranslatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TranslatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  translate(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        Translator_Translate_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !blink_mojom_ModelStreamingResponderRemote } pendingResponder
   */

  translateStreaming(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        1,
        Translator_TranslateStreaming_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Translator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TranslatorReceiver {
  /**
   * @param {!TranslatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TranslatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TranslatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Translator_Translate_ParamsSpec.$,
        null,
        impl.translate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Translator_TranslateStreaming_ParamsSpec.$,
        null,
        impl.translateStreaming.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Translator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Translator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TranslatorRemote}
   */
  static getRemote() {
    let remote = new TranslatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Translator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TranslatorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TranslatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TranslatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Translator_Translate_ParamsSpec.$,
        null,
        this.translate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translateStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Translator_TranslateStreaming_ParamsSpec.$,
        null,
        this.translateStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Translator_Translate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Translator_TranslateStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    Translator_Translate_ParamsSpec.$,
    'Translator_Translate_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Translator_Translate_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}



mojo.internal.Struct(
    Translator_TranslateStreaming_ParamsSpec.$,
    'Translator_TranslateStreaming_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ModelStreamingResponderRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Translator_TranslateStreaming_Params {
  constructor() {
    /** @type { !string } */
    this.input;
    /** @type { !blink_mojom_ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
}

