// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/ai/model_download_progress_observer.mojom-shared.h"
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::CanCreateTranslatorResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CanCreateTranslatorResult> {};

template <>
struct hash<::blink::mojom::CreateTranslatorError>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CreateTranslatorError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CanCreateTranslatorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CanCreateTranslatorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CanCreateTranslatorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CreateTranslatorError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CreateTranslatorError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CreateTranslatorError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TranslatorLanguageCodeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TranslatorLanguageCodeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TranslatorLanguageCode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::code(input)) in_code = Traits::code(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code)::BaseType> code_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_code,
      code_fragment);

    fragment->code.Set(
        code_fragment.is_null() ? nullptr : code_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->code.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null code in TranslatorLanguageCode struct");
  }

  static bool Deserialize(::blink::mojom::internal::TranslatorLanguageCode_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TranslatorLanguageCodeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TranslatorCreateOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TranslatorCreateOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TranslatorCreateOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::source_lang(input)) in_source_lang = Traits::source_lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_lang)::BaseType> source_lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
      in_source_lang,
      source_lang_fragment);

    fragment->source_lang.Set(
        source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_lang.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_lang in TranslatorCreateOptions struct");

    decltype(Traits::target_lang(input)) in_target_lang = Traits::target_lang(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_lang)::BaseType> target_lang_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
      in_target_lang,
      target_lang_fragment);

    fragment->target_lang.Set(
        target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_lang.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_lang in TranslatorCreateOptions struct");

    decltype(Traits::observer_remote(input)) in_observer_remote = Traits::observer_remote(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ModelDownloadProgressObserverInterfaceBase>>(
      in_observer_remote,
      &fragment->observer_remote,
      &fragment.message());
  }

  static bool Deserialize(::blink::mojom::internal::TranslatorCreateOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TranslatorCreateOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CreateTranslatorResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::CreateTranslatorResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::CreateTranslatorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::CreateTranslatorResultDataView::Tag::kTranslator: {
    decltype(Traits::translator(input))
    in_translator = Traits::translator(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::TranslatorInterfaceBase>>(
  in_translator,
  &fragment->data.f_translator,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_translator)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null translator in CreateTranslatorResult union");
    break;
  }
  case ::blink::mojom::CreateTranslatorResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::blink::mojom::CreateTranslatorError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::CreateTranslatorResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CreateTranslatorResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void TranslatorLanguageCodeDataView::GetCodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->code.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void TranslatorCreateOptionsDataView::GetSourceLangDataView(
    TranslatorLanguageCodeDataView* output) {
  auto pointer = data_->source_lang.Get();
  *output = TranslatorLanguageCodeDataView(pointer, message_);
}
inline void TranslatorCreateOptionsDataView::GetTargetLangDataView(
    TranslatorLanguageCodeDataView* output) {
  auto pointer = data_->target_lang.Get();
  *output = TranslatorLanguageCodeDataView(pointer, message_);
}




}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CanCreateTranslatorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CanCreateTranslatorResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CreateTranslatorError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CreateTranslatorError value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_SHARED_H_