// third_party/blink/public/mojom/mime/mime_registry.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MIME_MIME_REGISTRY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MIME_MIME_REGISTRY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mime/mime_registry.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mime/mime_registry.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mime/mime_registry.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class MimeRegistryProxy;

template <typename ImplRefTraits>
class MimeRegistryStub;

class MimeRegistryRequestValidator;
class MimeRegistryResponseValidator;


class BLINK_COMMON_EXPORT MimeRegistry
    : public MimeRegistryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.MimeRegistry";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MimeRegistryInterfaceBase;
  using Proxy_ = MimeRegistryProxy;

  template <typename ImplRefTraits>
  using Stub_ = MimeRegistryStub<ImplRefTraits>;

  using RequestValidator_ = MimeRegistryRequestValidator;
  using ResponseValidator_ = MimeRegistryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMimeTypeFromExtensionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetMimeTypeFromExtension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MimeRegistry() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetMimeTypeFromExtension(const std::string& extension, std::string* out_mime_type);
  using GetMimeTypeFromExtensionCallback = base::OnceCallback<void(const std::string&)>;
  using GetMimeTypeFromExtensionMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetMimeTypeFromExtension(const std::string& extension, GetMimeTypeFromExtensionCallback callback) = 0;
};



class BLINK_COMMON_EXPORT MimeRegistryProxy
    : public MimeRegistry {
 public:
  using InterfaceType = MimeRegistry;

  explicit MimeRegistryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetMimeTypeFromExtension(const std::string& extension, std::string* out_mime_type) final;
  
  void GetMimeTypeFromExtension(const std::string& extension, GetMimeTypeFromExtensionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT MimeRegistryStubDispatch {
 public:
  static bool Accept(MimeRegistry* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MimeRegistry* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MimeRegistry>>
class MimeRegistryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MimeRegistryStub() = default;
  ~MimeRegistryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeRegistryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MimeRegistryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT MimeRegistryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT MimeRegistryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MIME_MIME_REGISTRY_MOJOM_H_