// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ExportedSharedImage as gpu_mojom_ExportedSharedImage,
  ExportedSharedImageSpec as gpu_mojom_ExportedSharedImageSpec
} from '../../../../../gpu/ipc/common/exported_shared_image.mojom.m.js';

import {
  SyncToken as gpu_mojom_SyncToken,
  SyncTokenSpec as gpu_mojom_SyncTokenSpec
} from '../../../../../gpu/ipc/common/sync_token.mojom.m.js';

import {
  BitmapN32 as skia_mojom_BitmapN32,
  BitmapN32Spec as skia_mojom_BitmapN32Spec
} from '../../../../../skia/public/mojom/bitmap.mojom.m.js';

import {
  AlphaType as skia_mojom_AlphaType,
  AlphaTypeSpec as skia_mojom_AlphaTypeSpec
} from '../../../../../skia/public/mojom/image_info.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ImageReleaseCallbackPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ImageReleaseCallback', scope);
  }
}

/** @interface */
export class ImageReleaseCallbackInterface {
  
  /**
   * @param { !gpu_mojom_SyncToken } token
   */

  release(token) {}
}

/**
 * @implements { ImageReleaseCallbackInterface }
 */
export class ImageReleaseCallbackRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ImageReleaseCallbackPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ImageReleaseCallbackPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ImageReleaseCallbackPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gpu_mojom_SyncToken } token
   */

  release(
      token) {
    this.proxy.sendMessage(
        0,
        ImageReleaseCallback_Release_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ImageReleaseCallback
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ImageReleaseCallbackReceiver {
  /**
   * @param {!ImageReleaseCallbackInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ImageReleaseCallbackRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ImageReleaseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageReleaseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ImageReleaseCallback_Release_ParamsSpec.$,
        null,
        impl.release.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ImageReleaseCallback {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ImageReleaseCallback";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ImageReleaseCallbackRemote}
   */
  static getRemote() {
    let remote = new ImageReleaseCallbackRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ImageReleaseCallback
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ImageReleaseCallbackCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ImageReleaseCallbackRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ImageReleaseCallbackRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.release =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ImageReleaseCallback_Release_ParamsSpec.$,
        null,
        this.release.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AcceleratedStaticBitmapImageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ImageReleaseCallback_Release_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SerializedStaticBitmapImageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AcceleratedStaticBitmapImageSpec.$,
    'AcceleratedStaticBitmapImage',
    [
      mojo.internal.StructField(
        'sharedImage', 0,
        0,
        gpu_mojom_ExportedSharedImageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'syncToken', 8,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alphaType', 16,
        0,
        skia_mojom_AlphaTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'releaseCallback', 20,
        0,
        mojo.internal.InterfaceProxy(ImageReleaseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class AcceleratedStaticBitmapImage {
  constructor() {
    /** @type { !gpu_mojom_ExportedSharedImage } */
    this.sharedImage;
    /** @type { !gpu_mojom_SyncToken } */
    this.syncToken;
    /** @type { !skia_mojom_AlphaType } */
    this.alphaType;
    /** @type { !ImageReleaseCallbackRemote } */
    this.releaseCallback;
  }
}



mojo.internal.Struct(
    ImageReleaseCallback_Release_ParamsSpec.$,
    'ImageReleaseCallback_Release_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        gpu_mojom_SyncTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ImageReleaseCallback_Release_Params {
  constructor() {
    /** @type { !gpu_mojom_SyncToken } */
    this.token;
  }
}

mojo.internal.Union(
    SerializedStaticBitmapImageSpec.$, 'SerializedStaticBitmapImage',
    {
      'bitmap': {
        'ordinal': 0,
        'type': skia_mojom_BitmapN32Spec.$,
      },
      'acceleratedImage': {
        'ordinal': 1,
        'type': AcceleratedStaticBitmapImageSpec.$,
      },
    });

/**
 * @typedef { {
 *   bitmap: (!skia_mojom_BitmapN32|undefined),
 *   acceleratedImage: (!AcceleratedStaticBitmapImage|undefined),
 * } }
 */
export const SerializedStaticBitmapImage = {};
