// third_party/blink/public/mojom/mediastream/media_stream.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/display_media_information.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaStreamType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaStreamRequestResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaStreamStateChange, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PreferredDisplaySurface, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::CapturedSurfaceControlResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ZoomLevelAction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::WindowAudioPreference, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SearchOnlyByDeviceIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchOnlyByDeviceIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchOnlyByDeviceId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SearchBySessionIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SearchBySessionIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SearchBySessionId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session_id_map(input)) in_session_id_map = Traits::session_id_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_id_map)::BaseType>
          session_id_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& session_id_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::UnguessableTokenDataView>, send_validation>(
        in_session_id_map,
        session_id_map_fragment,
        &session_id_map_validate_params);

      fragment->session_id_map.Set(
          session_id_map_fragment.is_null() ? nullptr : session_id_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_id_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_id_map in SearchBySessionId struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MediaStreamDeviceDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaStreamDeviceDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaStreamDevice_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in MediaStreamDevice struct");

      fragment->display_id = Traits::display_id(input);

      
      mojo::internal::Serialize<::media::mojom::VideoFacingMode>(
        Traits::video_facing(input),
        &fragment->video_facing);

      decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_id)::BaseType> group_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_id,
        group_id_fragment);

      fragment->group_id.Set(
          group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

      decltype(Traits::matched_output_device_id(input)) in_matched_output_device_id = Traits::matched_output_device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->matched_output_device_id)::BaseType> matched_output_device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_matched_output_device_id,
        matched_output_device_id_fragment);

      fragment->matched_output_device_id.Set(
          matched_output_device_id_fragment.is_null() ? nullptr : matched_output_device_id_fragment.data());

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in MediaStreamDevice struct");

      decltype(Traits::input(input)) in_input = Traits::input(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input)::BaseType> input_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::AudioParametersDataView, send_validation>(
        in_input,
        input_fragment);

      fragment->input.Set(
          input_fragment.is_null() ? nullptr : input_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input in MediaStreamDevice struct");

      decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_id)::BaseType> session_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_session_id,
        session_id_fragment);

      fragment->session_id.Set(
          session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

      decltype(Traits::display_media_info(input)) in_display_media_info = Traits::display_media_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_media_info)::BaseType> display_media_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media::mojom::DisplayMediaInformationDataView, send_validation>(
        in_display_media_info,
        display_media_info_fragment);

      fragment->display_media_info.Set(
          display_media_info_fragment.is_null() ? nullptr : display_media_info_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::TrackControlsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TrackControlsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TrackControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
        Traits::stream_type(input),
        &fragment->stream_type);

      decltype(Traits::device_ids(input)) in_device_ids = Traits::device_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_ids)::BaseType>
          device_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& device_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_device_ids,
        device_ids_fragment,
        &device_ids_validate_params);

      fragment->device_ids.Set(
          device_ids_fragment.is_null() ? nullptr : device_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_ids in TrackControls struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::StreamControlsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamControlsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamControls_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::audio(input)) in_audio = Traits::audio(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio)::BaseType> audio_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::TrackControlsDataView, send_validation>(
        in_audio,
        audio_fragment);

      fragment->audio.Set(
          audio_fragment.is_null() ? nullptr : audio_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->audio.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio in StreamControls struct");

      decltype(Traits::video(input)) in_video = Traits::video(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video)::BaseType> video_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::TrackControlsDataView, send_validation>(
        in_video,
        video_fragment);

      fragment->video.Set(
          video_fragment.is_null() ? nullptr : video_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video in StreamControls struct");

      fragment->hotword_enabled = Traits::hotword_enabled(input);

      fragment->disable_local_echo = Traits::disable_local_echo(input);

      fragment->suppress_local_audio_playback = Traits::suppress_local_audio_playback(input);

      fragment->restrict_own_audio = Traits::restrict_own_audio(input);

      fragment->exclude_system_audio = Traits::exclude_system_audio(input);

      
      mojo::internal::Serialize<::blink::mojom::WindowAudioPreference>(
        Traits::window_audio_preference(input),
        &fragment->window_audio_preference);

      fragment->exclude_self_browser_surface = Traits::exclude_self_browser_surface(input);

      fragment->request_pan_tilt_zoom_permission = Traits::request_pan_tilt_zoom_permission(input);

      fragment->request_all_screens = Traits::request_all_screens(input);

      
      mojo::internal::Serialize<::blink::mojom::PreferredDisplaySurface>(
        Traits::preferred_display_surface(input),
        &fragment->preferred_display_surface);

      fragment->dynamic_surface_switching_requested = Traits::dynamic_surface_switching_requested(input);

      fragment->exclude_monitor_type_surfaces = Traits::exclude_monitor_type_surfaces(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::GetOpenDeviceResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GetOpenDeviceResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GetOpenDeviceResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in GetOpenDeviceResponse struct");

      decltype(Traits::device(input)) in_device = Traits::device(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device)::BaseType> device_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView, send_validation>(
        in_device,
        device_fragment);

      fragment->device.Set(
          device_fragment.is_null() ? nullptr : device_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device in GetOpenDeviceResponse struct");

      fragment->pan_tilt_zoom_allowed = Traits::pan_tilt_zoom_allowed(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::CapturedWheelActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CapturedWheelActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CapturedWheelAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->relative_x = Traits::relative_x(input);

      fragment->relative_y = Traits::relative_y(input);

      fragment->wheel_delta_x = Traits::wheel_delta_x(input);

      fragment->wheel_delta_y = Traits::wheel_delta_y(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::StreamDevicesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevices_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::audio_device(input)) in_audio_device = Traits::audio_device(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_device)::BaseType> audio_device_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView, send_validation>(
        in_audio_device,
        audio_device_fragment);

      fragment->audio_device.Set(
          audio_device_fragment.is_null() ? nullptr : audio_device_fragment.data());

      decltype(Traits::video_device(input)) in_video_device = Traits::video_device(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_device)::BaseType> video_device_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView, send_validation>(
        in_video_device,
        video_device_fragment);

      fragment->video_device.Set(
          video_device_fragment.is_null() ? nullptr : video_device_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::StreamDevicesSetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StreamDevicesSetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StreamDevicesSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::stream_devices(input)) in_stream_devices = Traits::stream_devices(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->stream_devices)::BaseType>
          stream_devices_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& stream_devices_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StreamDevicesDataView>, send_validation>(
        in_stream_devices,
        stream_devices_fragment,
        &stream_devices_validate_params);

      fragment->stream_devices.Set(
          stream_devices_fragment.is_null() ? nullptr : stream_devices_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->stream_devices.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stream_devices in StreamDevicesSet struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::StreamSelectionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::StreamSelectionInfoDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::StreamSelectionInfo_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchOnlyByDeviceId: {
    decltype(Traits::search_only_by_device_id(input))
    in_search_only_by_device_id = Traits::search_only_by_device_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_search_only_by_device_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::SearchOnlyByDeviceIdDataView, send_validation>(
  in_search_only_by_device_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null search_only_by_device_id in StreamSelectionInfo union");
    fragment->data.f_search_only_by_device_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::StreamSelectionInfoDataView::Tag::kSearchBySessionId: {
    decltype(Traits::search_by_session_id(input))
    in_search_by_session_id = Traits::search_by_session_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_search_by_session_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::SearchBySessionIdDataView, send_validation>(
  in_search_by_session_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null search_by_session_id in StreamSelectionInfo union");
    fragment->data.f_search_by_session_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_STREAM_MOJOM_SEND_VALIDATION_H_