// third_party/blink/public/mojom/mediastream/media_devices.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-import-headers.h"
#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-test-utils.h"


namespace blink::mojom {
MediaDeviceInfo::MediaDeviceInfo()
    : device_id(),
      label(),
      group_id(),
      control_support(),
      facing_mode(),
      availability() {}

MediaDeviceInfo::MediaDeviceInfo(
    const std::string& device_id_in,
    const std::string& label_in,
    const std::string& group_id_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    FacingMode facing_mode_in,
    std::optional<::media::mojom::CameraAvailability> availability_in)
    : device_id(std::move(device_id_in)),
      label(std::move(label_in)),
      group_id(std::move(group_id_in)),
      control_support(std::move(control_support_in)),
      facing_mode(std::move(facing_mode_in)),
      availability(std::move(availability_in)) {}

MediaDeviceInfo::~MediaDeviceInfo() = default;

void MediaDeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_support"), this->control_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureControlSupport&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "facing_mode"), this->facing_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "availability"), this->availability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::media::mojom::CameraAvailability>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoInputDeviceCapabilities::VideoInputDeviceCapabilities()
    : device_id(),
      group_id(),
      control_support(),
      formats(),
      facing_mode(),
      availability() {}

VideoInputDeviceCapabilities::VideoInputDeviceCapabilities(
    const std::string& device_id_in,
    const std::string& group_id_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    std::vector<::media::VideoCaptureFormat> formats_in,
    FacingMode facing_mode_in,
    std::optional<::media::mojom::CameraAvailability> availability_in)
    : device_id(std::move(device_id_in)),
      group_id(std::move(group_id_in)),
      control_support(std::move(control_support_in)),
      formats(std::move(formats_in)),
      facing_mode(std::move(facing_mode_in)),
      availability(std::move(availability_in)) {}

VideoInputDeviceCapabilities::~VideoInputDeviceCapabilities() = default;

void VideoInputDeviceCapabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_support"), this->control_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureControlSupport&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "formats"), this->formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::VideoCaptureFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "facing_mode"), this->facing_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "availability"), this->availability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::media::mojom::CameraAvailability>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoInputDeviceCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectAudioOutputResult::SelectAudioOutputResult()
    : status(),
      device_info() {}

SelectAudioOutputResult::SelectAudioOutputResult(
    AudioOutputStatus status_in,
    const ::blink::WebMediaDeviceInfo& device_info_in)
    : status(std::move(status_in)),
      device_info(std::move(device_info_in)) {}

SelectAudioOutputResult::~SelectAudioOutputResult() = default;

void SelectAudioOutputResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AudioOutputStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_info"), this->device_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::WebMediaDeviceInfo&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectAudioOutputResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioInputDeviceCapabilities::AudioInputDeviceCapabilities()
    : device_id(),
      group_id(),
      parameters(),
      is_valid(),
      channels(),
      sample_rate(),
      latency() {}

AudioInputDeviceCapabilities::AudioInputDeviceCapabilities(
    const std::string& device_id_in,
    const std::string& group_id_in,
    const ::media::AudioParameters& parameters_in,
    bool is_valid_in,
    int32_t channels_in,
    int32_t sample_rate_in,
    ::base::TimeDelta latency_in)
    : device_id(std::move(device_id_in)),
      group_id(std::move(group_id_in)),
      parameters(std::move(parameters_in)),
      is_valid(std::move(is_valid_in)),
      channels(std::move(channels_in)),
      sample_rate(std::move(sample_rate_in)),
      latency(std::move(latency_in)) {}

AudioInputDeviceCapabilities::~AudioInputDeviceCapabilities() = default;

void AudioInputDeviceCapabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parameters"), this->parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioParameters&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_valid"), this->is_valid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channels"), this->channels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latency"), this->latency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioInputDeviceCapabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MediaDevicesDispatcherHost::IPCStableHashFunction MediaDevicesDispatcherHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaDevicesDispatcherHost>(message.name())) {
    case messages::MediaDevicesDispatcherHost::kEnumerateDevices: {
      return &MediaDevicesDispatcherHost::EnumerateDevices_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities: {
      return &MediaDevicesDispatcherHost::GetVideoInputCapabilities_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats: {
      return &MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats: {
      return &MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities: {
      return &MediaDevicesDispatcherHost::GetAudioInputCapabilities_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener: {
      return &MediaDevicesDispatcherHost::AddMediaDevicesListener_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig: {
      return &MediaDevicesDispatcherHost::SetCaptureHandleConfig_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity: {
      return &MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId: {
      return &MediaDevicesDispatcherHost::ProduceSubCaptureTargetId_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kSetPreferredSinkId: {
      return &MediaDevicesDispatcherHost::SetPreferredSinkId_Sym::IPCStableHash;
    }
    case messages::MediaDevicesDispatcherHost::kSelectAudioOutput: {
      return &MediaDevicesDispatcherHost::SelectAudioOutput_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaDevicesDispatcherHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaDevicesDispatcherHost>(message.name())) {
      case messages::MediaDevicesDispatcherHost::kEnumerateDevices:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices";
      case messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities";
      case messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats";
      case messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats";
      case messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities";
      case messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener";
      case messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig";
      case messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity";
      case messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::ProduceSubCaptureTargetId";
      case messages::MediaDevicesDispatcherHost::kSetPreferredSinkId:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::SetPreferredSinkId";
      case messages::MediaDevicesDispatcherHost::kSelectAudioOutput:
            return "Receive blink::mojom::MediaDevicesDispatcherHost::SelectAudioOutput";
    }
  } else {
    switch (static_cast<messages::MediaDevicesDispatcherHost>(message.name())) {
      case messages::MediaDevicesDispatcherHost::kEnumerateDevices:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices";
      case messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities";
      case messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats";
      case messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats";
      case messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities";
      case messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener";
      case messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig";
      case messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity";
      case messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::ProduceSubCaptureTargetId";
      case messages::MediaDevicesDispatcherHost::kSetPreferredSinkId:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::SetPreferredSinkId";
      case messages::MediaDevicesDispatcherHost::kSelectAudioOutput:
            return "Receive reply blink::mojom::MediaDevicesDispatcherHost::SelectAudioOutput";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaDevicesDispatcherHost::EnumerateDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf5f8054b;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::GetVideoInputCapabilities_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ab1d9d0;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1d1240f;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa05dfe21;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::GetAudioInputCapabilities_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd58f8cc5;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::AddMediaDevicesListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb384657;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::SetCaptureHandleConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x57156c03;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe699a625;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::ProduceSubCaptureTargetId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe36538f9;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::ProduceSubCaptureTargetId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::SetPreferredSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44d32780;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::SetPreferredSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaDevicesDispatcherHost::SelectAudioOutput_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x663abbd3;  // IPCStableHash for blink::mojom::MediaDevicesDispatcherHost::SelectAudioOutput
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback(
      MediaDevicesDispatcherHost::EnumerateDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback(const MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::EnumerateDevicesCallback callback_;
};

class MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback(
      MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback(const MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback callback_;
};

class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback(const MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback callback_;
};

class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback(const MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback callback_;
};

class MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback(
      MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback(const MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback callback_;
};

class MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback(
      MediaDevicesDispatcherHost::ProduceSubCaptureTargetIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback(const MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::ProduceSubCaptureTargetIdCallback callback_;
};

class MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback(
      MediaDevicesDispatcherHost::SetPreferredSinkIdCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback(const MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::SetPreferredSinkIdCallback callback_;
};

class MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback(
      MediaDevicesDispatcherHost::SelectAudioOutputCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback(const MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback&) = delete;
  MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback& operator=(const MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaDevicesDispatcherHost::SelectAudioOutputCallback callback_;
};

MediaDevicesDispatcherHostProxy::MediaDevicesDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaDevicesDispatcherHostProxy::EnumerateDevices(
    bool in_request_audio_input, bool in_request_video_input, bool in_request_audio_output, bool in_request_video_input_capabilities, bool in_request_audio_input_capabilities, EnumerateDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_input"), in_request_audio_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_video_input"), in_request_video_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_output"), in_request_audio_output,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_video_input_capabilities"), in_request_video_input_capabilities,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_audio_input_capabilities"), in_request_audio_input_capabilities,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kEnumerateDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data> params(
          message);
  params.Allocate();

  params->request_audio_input = in_request_audio_input;

  params->request_video_input = in_request_video_input;

  params->request_audio_output = in_request_audio_output;

  params->request_video_input_capabilities = in_request_video_input_capabilities;

  params->request_audio_input_capabilities = in_request_audio_input_capabilities;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("EnumerateDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::GetVideoInputCapabilities(
    GetVideoInputCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetVideoInputCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::GetAllVideoInputDeviceFormats(
    const std::string& in_device_id, GetAllVideoInputDeviceFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in MediaDevicesDispatcherHost.GetAllVideoInputDeviceFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAllVideoInputDeviceFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::GetAvailableVideoInputDeviceFormats(
    const std::string& in_device_id, GetAvailableVideoInputDeviceFormatsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in MediaDevicesDispatcherHost.GetAvailableVideoInputDeviceFormats request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAvailableVideoInputDeviceFormats");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::GetAudioInputCapabilities(
    GetAudioInputCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAudioInputCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::AddMediaDevicesListener(
    bool in_subscribe_audio_input, bool in_subscribe_video_input, bool in_subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::AddMediaDevicesListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_audio_input"), in_subscribe_audio_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_video_input"), in_subscribe_video_input,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscribe_audio_output"), in_subscribe_audio_output,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<MediaDevicesListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data> params(
          message);
  params.Allocate();

  params->subscribe_audio_input = in_subscribe_audio_input;

  params->subscribe_video_input = in_subscribe_video_input;

  params->subscribe_audio_output = in_subscribe_audio_output;

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MediaDevicesListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in MediaDevicesDispatcherHost.AddMediaDevicesListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("AddMediaDevicesListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaDevicesDispatcherHostProxy::SetCaptureHandleConfig(
    ::blink::mojom::CaptureHandleConfigPtr in_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::SetCaptureHandleConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config"), in_config,
                        "<value of type ::blink::mojom::CaptureHandleConfigPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->config)::BaseType> config_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CaptureHandleConfigDataView>(
    in_config,
    config_fragment);

  params->config.Set(
      config_fragment.is_null() ? nullptr : config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config in MediaDevicesDispatcherHost.SetCaptureHandleConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SetCaptureHandleConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaDevicesDispatcherHostProxy::CloseFocusWindowOfOpportunity(
    const std::string& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::CloseFocusWindowOfOpportunity", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaDevicesDispatcherHost.CloseFocusWindowOfOpportunity request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("CloseFocusWindowOfOpportunity");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaDevicesDispatcherHostProxy::ProduceSubCaptureTargetId(
    ::media::mojom::SubCaptureTargetType in_type, ProduceSubCaptureTargetIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::ProduceSubCaptureTargetId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media::mojom::SubCaptureTargetType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::SubCaptureTargetType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("ProduceSubCaptureTargetId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::SetPreferredSinkId(
    const std::string& in_sink_id, SetPreferredSinkIdCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::SetPreferredSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sink_id"), in_sink_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kSetPreferredSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SetPreferredSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sink_id)::BaseType> sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_sink_id,
    sink_id_fragment);

  params->sink_id.Set(
      sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sink_id in MediaDevicesDispatcherHost.SetPreferredSinkId request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SetPreferredSinkId");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaDevicesDispatcherHostProxy::SelectAudioOutput(
    const std::string& in_device_id, SelectAudioOutputCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesDispatcherHost::SelectAudioOutput", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kSelectAudioOutput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SelectAudioOutput_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in MediaDevicesDispatcherHost.SelectAudioOutput request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SelectAudioOutput");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::EnumerateDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::EnumerateDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::vector<::blink::WebMediaDeviceInfo>>& in_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities);
};

bool MediaDevicesDispatcherHost_EnumerateDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.0
  bool success = true;
  std::vector<std::vector<::blink::WebMediaDeviceInfo>> p_enumeration{};
  std::vector<VideoInputDeviceCapabilitiesPtr> p_video_input_device_capabilities{};
  std::vector<AudioInputDeviceCapabilitiesPtr> p_audio_input_device_capabilities{};
  MediaDevicesDispatcherHost_EnumerateDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEnumeration(&p_enumeration))
    success = false;
  if (success && !input_data_view.ReadVideoInputDeviceCapabilities(&p_video_input_device_capabilities))
    success = false;
  if (success && !input_data_view.ReadAudioInputDeviceCapabilities(&p_audio_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enumeration), 
std::move(p_video_input_device_capabilities), 
std::move(p_audio_input_device_capabilities));
  }
  return true;
}

void MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::Run(
    const std::vector<std::vector<::blink::WebMediaDeviceInfo>>& in_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::EnumerateDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enumeration"), in_enumeration,
                        "<value of type const std::vector<std::vector<::blink::WebMediaDeviceInfo>>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_input_device_capabilities"), in_video_input_device_capabilities,
                        "<value of type std::vector<VideoInputDeviceCapabilitiesPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_input_device_capabilities"), in_audio_input_device_capabilities,
                        "<value of type std::vector<AudioInputDeviceCapabilitiesPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kEnumerateDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->enumeration)::BaseType>
      enumeration_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& enumeration_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::blink::mojom::MediaDeviceInfoDataView>>>(
    in_enumeration,
    enumeration_fragment,
    &enumeration_validate_params);

  params->enumeration.Set(
      enumeration_fragment.is_null() ? nullptr : enumeration_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->enumeration.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null enumeration in ");
  mojo::internal::MessageFragment<
      typename decltype(params->video_input_device_capabilities)::BaseType>
      video_input_device_capabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& video_input_device_capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::VideoInputDeviceCapabilitiesDataView>>(
    in_video_input_device_capabilities,
    video_input_device_capabilities_fragment,
    &video_input_device_capabilities_validate_params);

  params->video_input_device_capabilities.Set(
      video_input_device_capabilities_fragment.is_null() ? nullptr : video_input_device_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_input_device_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_input_device_capabilities in ");
  mojo::internal::MessageFragment<
      typename decltype(params->audio_input_device_capabilities)::BaseType>
      audio_input_device_capabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& audio_input_device_capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AudioInputDeviceCapabilitiesDataView>>(
    in_audio_input_device_capabilities,
    audio_input_device_capabilities_fragment,
    &audio_input_device_capabilities_validate_params);

  params->audio_input_device_capabilities.Set(
      audio_input_device_capabilities_fragment.is_null() ? nullptr : audio_input_device_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_input_device_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_input_device_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("EnumerateDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::GetVideoInputCapabilitiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities);
};

bool MediaDevicesDispatcherHost_GetVideoInputCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.1
  bool success = true;
  std::vector<VideoInputDeviceCapabilitiesPtr> p_video_input_device_capabilities{};
  MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadVideoInputDeviceCapabilities(&p_video_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_video_input_device_capabilities));
  }
  return true;
}

void MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::Run(
    std::vector<VideoInputDeviceCapabilitiesPtr> in_video_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::GetVideoInputCapabilities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("video_input_device_capabilities"), in_video_input_device_capabilities,
                        "<value of type std::vector<VideoInputDeviceCapabilitiesPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->video_input_device_capabilities)::BaseType>
      video_input_device_capabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& video_input_device_capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::VideoInputDeviceCapabilitiesDataView>>(
    in_video_input_device_capabilities,
    video_input_device_capabilities_fragment,
    &video_input_device_capabilities_validate_params);

  params->video_input_device_capabilities.Set(
      video_input_device_capabilities_fragment.is_null() ? nullptr : video_input_device_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->video_input_device_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null video_input_device_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetVideoInputCapabilities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats);
};

bool MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.2
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats{};
  MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormats(&p_formats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_formats));
  }
  return true;
}

void MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::GetAllVideoInputDeviceFormats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats"), in_formats,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats)::BaseType>
      formats_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
    in_formats,
    formats_fragment,
    &formats_validate_params);

  params->formats.Set(
      formats_fragment.is_null() ? nullptr : formats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->formats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null formats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAllVideoInputDeviceFormats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormatsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::media::VideoCaptureFormat>& in_formats);
};

bool MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.3
  bool success = true;
  std::vector<::media::VideoCaptureFormat> p_formats{};
  MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFormats(&p_formats))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_formats));
  }
  return true;
}

void MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::Run(
    const std::vector<::media::VideoCaptureFormat>& in_formats) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::GetAvailableVideoInputDeviceFormats", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("formats"), in_formats,
                        "<value of type const std::vector<::media::VideoCaptureFormat>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->formats)::BaseType>
      formats_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& formats_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
    in_formats,
    formats_fragment,
    &formats_validate_params);

  params->formats.Set(
      formats_fragment.is_null() ? nullptr : formats_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->formats.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null formats in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAvailableVideoInputDeviceFormats");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::GetAudioInputCapabilitiesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities);
};

bool MediaDevicesDispatcherHost_GetAudioInputCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.4
  bool success = true;
  std::vector<AudioInputDeviceCapabilitiesPtr> p_audio_input_device_capabilities{};
  MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAudioInputDeviceCapabilities(&p_audio_input_device_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_audio_input_device_capabilities));
  }
  return true;
}

void MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::Run(
    std::vector<AudioInputDeviceCapabilitiesPtr> in_audio_input_device_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::GetAudioInputCapabilities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_input_device_capabilities"), in_audio_input_device_capabilities,
                        "<value of type std::vector<AudioInputDeviceCapabilitiesPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->audio_input_device_capabilities)::BaseType>
      audio_input_device_capabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& audio_input_device_capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AudioInputDeviceCapabilitiesDataView>>(
    in_audio_input_device_capabilities,
    audio_input_device_capabilities_fragment,
    &audio_input_device_capabilities_validate_params);

  params->audio_input_device_capabilities.Set(
      audio_input_device_capabilities_fragment.is_null() ? nullptr : audio_input_device_capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_input_device_capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_input_device_capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("GetAudioInputCapabilities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::ProduceSubCaptureTargetIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::ProduceSubCaptureTargetIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_id);
};

bool MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.8
  bool success = true;
  std::string p_id{};
  MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadId(&p_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_id));
  }
  return true;
}

void MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder::Run(
    const std::string& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::ProduceSubCaptureTargetId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("ProduceSubCaptureTargetId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::SetPreferredSinkIdCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::SetPreferredSinkIdCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::OutputDeviceStatus in_status);
};

bool MediaDevicesDispatcherHost_SetPreferredSinkId_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.9
  bool success = true;
  ::media::OutputDeviceStatus p_status{};
  MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder::Run(
    ::media::OutputDeviceStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::SetPreferredSinkId", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::media::OutputDeviceStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kSetPreferredSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::OutputDeviceStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SetPreferredSinkId");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaDevicesDispatcherHost::SelectAudioOutputCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder> proxy(
        new MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaDevicesDispatcherHost::SelectAudioOutputCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SelectAudioOutputResultPtr in_result);
};

bool MediaDevicesDispatcherHost_SelectAudioOutput_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaDevicesDispatcherHost.10
  bool success = true;
  SelectAudioOutputResultPtr p_result{};
  MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaDevicesDispatcherHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder::Run(
    SelectAudioOutputResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaDevicesDispatcherHost::SelectAudioOutput", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SelectAudioOutputResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesDispatcherHost::kSelectAudioOutput), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SelectAudioOutputResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesDispatcherHost::Name_);
  message.set_method_name("SelectAudioOutput");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaDevicesDispatcherHostStubDispatch::Accept(
    MediaDevicesDispatcherHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaDevicesDispatcherHost>(message->header()->name)) {
    case messages::MediaDevicesDispatcherHost::kEnumerateDevices: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener: {
      DCHECK(message->is_serialized());
      internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.5
      bool success = true;
      bool p_subscribe_audio_input{};
      bool p_subscribe_video_input{};
      bool p_subscribe_audio_output{};
      ::mojo::PendingRemote<MediaDevicesListener> p_listener{};
      MediaDevicesDispatcherHost_AddMediaDevicesListener_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_subscribe_audio_input = input_data_view.subscribe_audio_input();
      if (success)
        p_subscribe_video_input = input_data_view.subscribe_video_input();
      if (success)
        p_subscribe_audio_output = input_data_view.subscribe_audio_output();
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddMediaDevicesListener(        
        std::move(p_subscribe_audio_input), 
        std::move(p_subscribe_video_input), 
        std::move(p_subscribe_audio_output), 
        std::move(p_listener));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig: {
      DCHECK(message->is_serialized());
      internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.6
      bool success = true;
      ::blink::mojom::CaptureHandleConfigPtr p_config{};
      MediaDevicesDispatcherHost_SetCaptureHandleConfig_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfig(&p_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCaptureHandleConfig(        
        std::move(p_config));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity: {
      DCHECK(message->is_serialized());
      internal::MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.7
      bool success = true;
      std::string p_label{};
      MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseFocusWindowOfOpportunity(        
        std::move(p_label));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kSetPreferredSinkId: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kSelectAudioOutput: {
      break;
    }
  }
  return false;
}

// static
bool MediaDevicesDispatcherHostStubDispatch::AcceptWithResponder(
    MediaDevicesDispatcherHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaDevicesDispatcherHost>(message->header()->name)) {
    case messages::MediaDevicesDispatcherHost::kEnumerateDevices: {
      internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.0
      bool success = true;
      bool p_request_audio_input{};
      bool p_request_video_input{};
      bool p_request_audio_output{};
      bool p_request_video_input_capabilities{};
      bool p_request_audio_input_capabilities{};
      MediaDevicesDispatcherHost_EnumerateDevices_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_audio_input = input_data_view.request_audio_input();
      if (success)
        p_request_video_input = input_data_view.request_video_input();
      if (success)
        p_request_audio_output = input_data_view.request_audio_output();
      if (success)
        p_request_video_input_capabilities = input_data_view.request_video_input_capabilities();
      if (success)
        p_request_audio_input_capabilities = input_data_view.request_audio_input_capabilities();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_EnumerateDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnumerateDevices(        
        std::move(p_request_audio_input), 
        std::move(p_request_video_input), 
        std::move(p_request_audio_output), 
        std::move(p_request_video_input_capabilities), 
        std::move(p_request_audio_input_capabilities), std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kGetVideoInputCapabilities: {
      internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.1
      bool success = true;
      MediaDevicesDispatcherHost_GetVideoInputCapabilities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 1, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_GetVideoInputCapabilities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetVideoInputCapabilities(std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kGetAllVideoInputDeviceFormats: {
      internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.2
      bool success = true;
      std::string p_device_id{};
      MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 2, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllVideoInputDeviceFormats(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kGetAvailableVideoInputDeviceFormats: {
      internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.3
      bool success = true;
      std::string p_device_id{};
      MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 3, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAvailableVideoInputDeviceFormats(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kGetAudioInputCapabilities: {
      internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.4
      bool success = true;
      MediaDevicesDispatcherHost_GetAudioInputCapabilities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 4, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_GetAudioInputCapabilities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAudioInputCapabilities(std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kAddMediaDevicesListener: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kSetCaptureHandleConfig: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kCloseFocusWindowOfOpportunity: {
      break;
    }
    case messages::MediaDevicesDispatcherHost::kProduceSubCaptureTargetId: {
      internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.8
      bool success = true;
      ::media::mojom::SubCaptureTargetType p_type{};
      MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 8, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProduceSubCaptureTargetId(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kSetPreferredSinkId: {
      internal::MediaDevicesDispatcherHost_SetPreferredSinkId_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_SetPreferredSinkId_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.9
      bool success = true;
      std::string p_sink_id{};
      MediaDevicesDispatcherHost_SetPreferredSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSinkId(&p_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 9, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_SetPreferredSinkId_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPreferredSinkId(        
        std::move(p_sink_id), std::move(callback));
      return true;
    }
    case messages::MediaDevicesDispatcherHost::kSelectAudioOutput: {
      internal::MediaDevicesDispatcherHost_SelectAudioOutput_Params_Data* params =
          reinterpret_cast<
              internal::MediaDevicesDispatcherHost_SelectAudioOutput_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaDevicesDispatcherHost.10
      bool success = true;
      std::string p_device_id{};
      MediaDevicesDispatcherHost_SelectAudioOutput_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesDispatcherHost::Name_, 10, false);
        return false;
      }
      auto callback =
          MediaDevicesDispatcherHost_SelectAudioOutput_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectAudioOutput(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaDevicesDispatcherHostValidationInfo[] = {
    { &internal::MediaDevicesDispatcherHost_EnumerateDevices_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_EnumerateDevices_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetVideoInputCapabilities_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAllVideoInputDeviceFormats_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAvailableVideoInputDeviceFormats_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_GetAudioInputCapabilities_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_AddMediaDevicesListener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaDevicesDispatcherHost_SetCaptureHandleConfig_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaDevicesDispatcherHost_CloseFocusWindowOfOpportunity_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_ProduceSubCaptureTargetId_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_SetPreferredSinkId_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_SetPreferredSinkId_ResponseParams_Data::Validate},
    { &internal::MediaDevicesDispatcherHost_SelectAudioOutput_Params_Data::Validate,
     &internal::MediaDevicesDispatcherHost_SelectAudioOutput_ResponseParams_Data::Validate},
};

bool MediaDevicesDispatcherHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::MediaDevicesDispatcherHost::Name_,
    kMediaDevicesDispatcherHostValidationInfo);
}

bool MediaDevicesDispatcherHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::MediaDevicesDispatcherHost::Name_,
    kMediaDevicesDispatcherHostValidationInfo);
}
// The declaration includes the definition on other builds.

MediaDevicesListener::IPCStableHashFunction MediaDevicesListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaDevicesListener>(message.name())) {
    case messages::MediaDevicesListener::kOnDevicesChanged: {
      return &MediaDevicesListener::OnDevicesChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaDevicesListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaDevicesListener>(message.name())) {
      case messages::MediaDevicesListener::kOnDevicesChanged:
            return "Receive blink::mojom::MediaDevicesListener::OnDevicesChanged";
    }
  } else {
    switch (static_cast<messages::MediaDevicesListener>(message.name())) {
      case messages::MediaDevicesListener::kOnDevicesChanged:
            return "Receive reply blink::mojom::MediaDevicesListener::OnDevicesChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaDevicesListener::OnDevicesChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc55aead1;  // IPCStableHash for blink::mojom::MediaDevicesListener::OnDevicesChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaDevicesListenerProxy::MediaDevicesListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaDevicesListenerProxy::OnDevicesChanged(
    MediaDeviceType in_type, const std::vector<::blink::WebMediaDeviceInfo>& in_device_infos) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaDevicesListener::OnDevicesChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaDeviceType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_infos"), in_device_infos,
                        "<value of type const std::vector<::blink::WebMediaDeviceInfo>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaDevicesListener::kOnDevicesChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaDevicesListener_OnDevicesChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::MediaDeviceType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->device_infos)::BaseType>
      device_infos_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& device_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MediaDeviceInfoDataView>>(
    in_device_infos,
    device_infos_fragment,
    &device_infos_validate_params);

  params->device_infos.Set(
      device_infos_fragment.is_null() ? nullptr : device_infos_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_infos.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_infos in MediaDevicesListener.OnDevicesChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaDevicesListener::Name_);
  message.set_method_name("OnDevicesChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaDevicesListenerStubDispatch::Accept(
    MediaDevicesListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaDevicesListener>(message->header()->name)) {
    case messages::MediaDevicesListener::kOnDevicesChanged: {
      DCHECK(message->is_serialized());
      internal::MediaDevicesListener_OnDevicesChanged_Params_Data* params =
          reinterpret_cast<internal::MediaDevicesListener_OnDevicesChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaDevicesListener.0
      bool success = true;
      MediaDeviceType p_type{};
      std::vector<::blink::WebMediaDeviceInfo> p_device_infos{};
      MediaDevicesListener_OnDevicesChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadDeviceInfos(&p_device_infos))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaDevicesListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDevicesChanged(        
        std::move(p_type), 
        std::move(p_device_infos));
      return true;
    }
  }
  return false;
}

// static
bool MediaDevicesListenerStubDispatch::AcceptWithResponder(
    MediaDevicesListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaDevicesListener>(message->header()->name)) {
    case messages::MediaDevicesListener::kOnDevicesChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaDevicesListenerValidationInfo[] = {
    { &internal::MediaDevicesListener_OnDevicesChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaDevicesListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::MediaDevicesListener::Name_,
    kMediaDevicesListenerValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::MediaDeviceInfo::DataView, ::blink::mojom::MediaDeviceInfoPtr>::Read(
    ::blink::mojom::MediaDeviceInfo::DataView input,
    ::blink::mojom::MediaDeviceInfoPtr* output) {
  bool success = true;
  ::blink::mojom::MediaDeviceInfoPtr result(::blink::mojom::MediaDeviceInfo::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadControlSupport(&result->control_support))
        success = false;
      if (success && !input.ReadFacingMode(&result->facing_mode))
        success = false;
      if (success && !input.ReadAvailability(&result->availability)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::VideoInputDeviceCapabilities::DataView, ::blink::mojom::VideoInputDeviceCapabilitiesPtr>::Read(
    ::blink::mojom::VideoInputDeviceCapabilities::DataView input,
    ::blink::mojom::VideoInputDeviceCapabilitiesPtr* output) {
  bool success = true;
  ::blink::mojom::VideoInputDeviceCapabilitiesPtr result(::blink::mojom::VideoInputDeviceCapabilities::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadControlSupport(&result->control_support))
        success = false;
      if (success && !input.ReadFormats(&result->formats))
        success = false;
      if (success && !input.ReadFacingMode(&result->facing_mode))
        success = false;
      if (success && !input.ReadAvailability(&result->availability)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SelectAudioOutputResult::DataView, ::blink::mojom::SelectAudioOutputResultPtr>::Read(
    ::blink::mojom::SelectAudioOutputResult::DataView input,
    ::blink::mojom::SelectAudioOutputResultPtr* output) {
  bool success = true;
  ::blink::mojom::SelectAudioOutputResultPtr result(::blink::mojom::SelectAudioOutputResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadDeviceInfo(&result->device_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::AudioInputDeviceCapabilities::DataView, ::blink::mojom::AudioInputDeviceCapabilitiesPtr>::Read(
    ::blink::mojom::AudioInputDeviceCapabilities::DataView input,
    ::blink::mojom::AudioInputDeviceCapabilitiesPtr* output) {
  bool success = true;
  ::blink::mojom::AudioInputDeviceCapabilitiesPtr result(::blink::mojom::AudioInputDeviceCapabilities::New());
  
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadParameters(&result->parameters))
        success = false;
      if (success)
        result->is_valid = input.is_valid();
      if (success)
        result->channels = input.channels();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success && !input.ReadLatency(&result->latency))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void MediaDevicesDispatcherHostInterceptorForTesting::EnumerateDevices(bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, EnumerateDevicesCallback callback) {
  GetForwardingInterface()->EnumerateDevices(
    std::move(request_audio_input)
    , 
    std::move(request_video_input)
    , 
    std::move(request_audio_output)
    , 
    std::move(request_video_input_capabilities)
    , 
    std::move(request_audio_input_capabilities)
    , std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::GetVideoInputCapabilities(GetVideoInputCapabilitiesCallback callback) {
  GetForwardingInterface()->GetVideoInputCapabilities(std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::GetAllVideoInputDeviceFormats(const std::string& device_id, GetAllVideoInputDeviceFormatsCallback callback) {
  GetForwardingInterface()->GetAllVideoInputDeviceFormats(
    std::move(device_id)
    , std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::GetAvailableVideoInputDeviceFormats(const std::string& device_id, GetAvailableVideoInputDeviceFormatsCallback callback) {
  GetForwardingInterface()->GetAvailableVideoInputDeviceFormats(
    std::move(device_id)
    , std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::GetAudioInputCapabilities(GetAudioInputCapabilitiesCallback callback) {
  GetForwardingInterface()->GetAudioInputCapabilities(std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::AddMediaDevicesListener(bool subscribe_audio_input, bool subscribe_video_input, bool subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> listener) {
  GetForwardingInterface()->AddMediaDevicesListener(
    std::move(subscribe_audio_input)
    , 
    std::move(subscribe_video_input)
    , 
    std::move(subscribe_audio_output)
    , 
    std::move(listener)
    );
}
void MediaDevicesDispatcherHostInterceptorForTesting::SetCaptureHandleConfig(::blink::mojom::CaptureHandleConfigPtr config) {
  GetForwardingInterface()->SetCaptureHandleConfig(
    std::move(config)
    );
}
void MediaDevicesDispatcherHostInterceptorForTesting::CloseFocusWindowOfOpportunity(const std::string& label) {
  GetForwardingInterface()->CloseFocusWindowOfOpportunity(
    std::move(label)
    );
}
void MediaDevicesDispatcherHostInterceptorForTesting::ProduceSubCaptureTargetId(::media::mojom::SubCaptureTargetType type, ProduceSubCaptureTargetIdCallback callback) {
  GetForwardingInterface()->ProduceSubCaptureTargetId(
    std::move(type)
    , std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::SetPreferredSinkId(const std::string& sink_id, SetPreferredSinkIdCallback callback) {
  GetForwardingInterface()->SetPreferredSinkId(
    std::move(sink_id)
    , std::move(callback));
}
void MediaDevicesDispatcherHostInterceptorForTesting::SelectAudioOutput(const std::string& device_id, SelectAudioOutputCallback callback) {
  GetForwardingInterface()->SelectAudioOutput(
    std::move(device_id)
    , std::move(callback));
}
MediaDevicesDispatcherHostAsyncWaiter::MediaDevicesDispatcherHostAsyncWaiter(
    MediaDevicesDispatcherHost* proxy) : proxy_(proxy) {}

MediaDevicesDispatcherHostAsyncWaiter::~MediaDevicesDispatcherHostAsyncWaiter() = default;


void MediaDevicesDispatcherHostAsyncWaiter::EnumerateDevices(
    bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, std::vector<std::vector<::blink::WebMediaDeviceInfo>>* out_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities) {
  base::RunLoop loop;
  proxy_->EnumerateDevices(
      std::move(request_audio_input),
      std::move(request_video_input),
      std::move(request_audio_output),
      std::move(request_video_input_capabilities),
      std::move(request_audio_input_capabilities),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::vector<::blink::WebMediaDeviceInfo>>* out_enumeration
,
             std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities
,
             std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities
,
             const std::vector<std::vector<::blink::WebMediaDeviceInfo>>& enumeration,
             std::vector<VideoInputDeviceCapabilitiesPtr> video_input_device_capabilities,
             std::vector<AudioInputDeviceCapabilitiesPtr> audio_input_device_capabilities) {*out_enumeration = std::move(enumeration);*out_video_input_device_capabilities = std::move(video_input_device_capabilities);*out_audio_input_device_capabilities = std::move(audio_input_device_capabilities);
            loop->Quit();
          },
          &loop,
          out_enumeration,
          out_video_input_device_capabilities,
          out_audio_input_device_capabilities));
  loop.Run();
}



void MediaDevicesDispatcherHostAsyncWaiter::GetVideoInputCapabilities(
    std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities) {
  base::RunLoop loop;
  proxy_->GetVideoInputCapabilities(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities
,
             std::vector<VideoInputDeviceCapabilitiesPtr> video_input_device_capabilities) {*out_video_input_device_capabilities = std::move(video_input_device_capabilities);
            loop->Quit();
          },
          &loop,
          out_video_input_device_capabilities));
  loop.Run();
}

std::vector<VideoInputDeviceCapabilitiesPtr> MediaDevicesDispatcherHostAsyncWaiter::GetVideoInputCapabilities(
    ) {
  std::vector<VideoInputDeviceCapabilitiesPtr> async_wait_result;
  GetVideoInputCapabilities(&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::GetAllVideoInputDeviceFormats(
    const std::string& device_id, std::vector<::media::VideoCaptureFormat>* out_formats) {
  base::RunLoop loop;
  proxy_->GetAllVideoInputDeviceFormats(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureFormat>* out_formats
,
             const std::vector<::media::VideoCaptureFormat>& formats) {*out_formats = std::move(formats);
            loop->Quit();
          },
          &loop,
          out_formats));
  loop.Run();
}

std::vector<::media::VideoCaptureFormat> MediaDevicesDispatcherHostAsyncWaiter::GetAllVideoInputDeviceFormats(
    const std::string& device_id) {
  std::vector<::media::VideoCaptureFormat> async_wait_result;
  GetAllVideoInputDeviceFormats(std::move(device_id),&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::GetAvailableVideoInputDeviceFormats(
    const std::string& device_id, std::vector<::media::VideoCaptureFormat>* out_formats) {
  base::RunLoop loop;
  proxy_->GetAvailableVideoInputDeviceFormats(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::VideoCaptureFormat>* out_formats
,
             const std::vector<::media::VideoCaptureFormat>& formats) {*out_formats = std::move(formats);
            loop->Quit();
          },
          &loop,
          out_formats));
  loop.Run();
}

std::vector<::media::VideoCaptureFormat> MediaDevicesDispatcherHostAsyncWaiter::GetAvailableVideoInputDeviceFormats(
    const std::string& device_id) {
  std::vector<::media::VideoCaptureFormat> async_wait_result;
  GetAvailableVideoInputDeviceFormats(std::move(device_id),&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::GetAudioInputCapabilities(
    std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities) {
  base::RunLoop loop;
  proxy_->GetAudioInputCapabilities(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities
,
             std::vector<AudioInputDeviceCapabilitiesPtr> audio_input_device_capabilities) {*out_audio_input_device_capabilities = std::move(audio_input_device_capabilities);
            loop->Quit();
          },
          &loop,
          out_audio_input_device_capabilities));
  loop.Run();
}

std::vector<AudioInputDeviceCapabilitiesPtr> MediaDevicesDispatcherHostAsyncWaiter::GetAudioInputCapabilities(
    ) {
  std::vector<AudioInputDeviceCapabilitiesPtr> async_wait_result;
  GetAudioInputCapabilities(&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::ProduceSubCaptureTargetId(
    ::media::mojom::SubCaptureTargetType type, std::string* out_id) {
  base::RunLoop loop;
  proxy_->ProduceSubCaptureTargetId(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_id
,
             const std::string& id) {*out_id = std::move(id);
            loop->Quit();
          },
          &loop,
          out_id));
  loop.Run();
}

std::string MediaDevicesDispatcherHostAsyncWaiter::ProduceSubCaptureTargetId(
    ::media::mojom::SubCaptureTargetType type) {
  std::string async_wait_result;
  ProduceSubCaptureTargetId(std::move(type),&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::SetPreferredSinkId(
    const std::string& sink_id, ::media::OutputDeviceStatus* out_status) {
  base::RunLoop loop;
  proxy_->SetPreferredSinkId(
      std::move(sink_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::OutputDeviceStatus* out_status
,
             ::media::OutputDeviceStatus status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::media::OutputDeviceStatus MediaDevicesDispatcherHostAsyncWaiter::SetPreferredSinkId(
    const std::string& sink_id) {
  ::media::OutputDeviceStatus async_wait_result;
  SetPreferredSinkId(std::move(sink_id),&async_wait_result);
  return async_wait_result;
}

void MediaDevicesDispatcherHostAsyncWaiter::SelectAudioOutput(
    const std::string& device_id, SelectAudioOutputResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SelectAudioOutput(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             SelectAudioOutputResultPtr* out_result
,
             SelectAudioOutputResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SelectAudioOutputResultPtr MediaDevicesDispatcherHostAsyncWaiter::SelectAudioOutput(
    const std::string& device_id) {
  SelectAudioOutputResultPtr async_wait_result;
  SelectAudioOutput(std::move(device_id),&async_wait_result);
  return async_wait_result;
}




void MediaDevicesListenerInterceptorForTesting::OnDevicesChanged(MediaDeviceType type, const std::vector<::blink::WebMediaDeviceInfo>& device_infos) {
  GetForwardingInterface()->OnDevicesChanged(
    std::move(type)
    , 
    std::move(device_infos)
    );
}
MediaDevicesListenerAsyncWaiter::MediaDevicesListenerAsyncWaiter(
    MediaDevicesListener* proxy) : proxy_(proxy) {}

MediaDevicesListenerAsyncWaiter::~MediaDevicesListenerAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif