// third_party/blink/public/mojom/mediastream/aec_dump.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediastream/aec_dump.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediastream/aec_dump.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediastream/aec_dump.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediastream/aec_dump.mojom-import-headers.h"
#include "third_party/blink/public/mojom/mediastream/aec_dump.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

AecDumpAgent::IPCStableHashFunction AecDumpAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AecDumpAgent>(message.name())) {
    case messages::AecDumpAgent::kStart: {
      return &AecDumpAgent::Start_Sym::IPCStableHash;
    }
    case messages::AecDumpAgent::kStop: {
      return &AecDumpAgent::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AecDumpAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AecDumpAgent>(message.name())) {
      case messages::AecDumpAgent::kStart:
            return "Receive blink::mojom::AecDumpAgent::Start";
      case messages::AecDumpAgent::kStop:
            return "Receive blink::mojom::AecDumpAgent::Stop";
    }
  } else {
    switch (static_cast<messages::AecDumpAgent>(message.name())) {
      case messages::AecDumpAgent::kStart:
            return "Receive reply blink::mojom::AecDumpAgent::Start";
      case messages::AecDumpAgent::kStop:
            return "Receive reply blink::mojom::AecDumpAgent::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AecDumpAgent::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0295fd96;  // IPCStableHash for blink::mojom::AecDumpAgent::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AecDumpAgent::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6999216;  // IPCStableHash for blink::mojom::AecDumpAgent::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AecDumpAgentProxy::AecDumpAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AecDumpAgentProxy::Start(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AecDumpAgent::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AecDumpAgent::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AecDumpAgent_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in AecDumpAgent.Start request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AecDumpAgent::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AecDumpAgentProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AecDumpAgent::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AecDumpAgent::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AecDumpAgent_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AecDumpAgent::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AecDumpAgentStubDispatch::Accept(
    AecDumpAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AecDumpAgent>(message->header()->name)) {
    case messages::AecDumpAgent::kStart: {
      DCHECK(message->is_serialized());
      internal::AecDumpAgent_Start_Params_Data* params =
          reinterpret_cast<internal::AecDumpAgent_Start_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AecDumpAgent.0
      bool success = true;
      ::base::File p_file{};
      AecDumpAgent_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AecDumpAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_file));
      return true;
    }
    case messages::AecDumpAgent::kStop: {
      DCHECK(message->is_serialized());
      internal::AecDumpAgent_Stop_Params_Data* params =
          reinterpret_cast<internal::AecDumpAgent_Stop_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AecDumpAgent.1
      bool success = true;
      AecDumpAgent_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AecDumpAgent::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
  }
  return false;
}

// static
bool AecDumpAgentStubDispatch::AcceptWithResponder(
    AecDumpAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AecDumpAgent>(message->header()->name)) {
    case messages::AecDumpAgent::kStart: {
      break;
    }
    case messages::AecDumpAgent::kStop: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAecDumpAgentValidationInfo[] = {
    { &internal::AecDumpAgent_Start_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AecDumpAgent_Stop_Params_Data::Validate,
     nullptr /* no response */},
};

bool AecDumpAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AecDumpAgent::Name_,
    kAecDumpAgentValidationInfo);
}

// The declaration includes the definition on other builds.

AecDumpManager::IPCStableHashFunction AecDumpManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AecDumpManager>(message.name())) {
    case messages::AecDumpManager::kAdd: {
      return &AecDumpManager::Add_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AecDumpManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AecDumpManager>(message.name())) {
      case messages::AecDumpManager::kAdd:
            return "Receive blink::mojom::AecDumpManager::Add";
    }
  } else {
    switch (static_cast<messages::AecDumpManager>(message.name())) {
      case messages::AecDumpManager::kAdd:
            return "Receive reply blink::mojom::AecDumpManager::Add";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AecDumpManager::Add_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf267a482;  // IPCStableHash for blink::mojom::AecDumpManager::Add
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AecDumpManagerProxy::AecDumpManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AecDumpManagerProxy::Add(
    ::mojo::PendingRemote<AecDumpAgent> in_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AecDumpManager::Add", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingRemote<AecDumpAgent>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AecDumpManager::kAdd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AecDumpManager_Add_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AecDumpAgentInterfaceBase>>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent in AecDumpManager.Add request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AecDumpManager::Name_);
  message.set_method_name("Add");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AecDumpManagerStubDispatch::Accept(
    AecDumpManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AecDumpManager>(message->header()->name)) {
    case messages::AecDumpManager::kAdd: {
      DCHECK(message->is_serialized());
      internal::AecDumpManager_Add_Params_Data* params =
          reinterpret_cast<internal::AecDumpManager_Add_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AecDumpManager.0
      bool success = true;
      ::mojo::PendingRemote<AecDumpAgent> p_agent{};
      AecDumpManager_Add_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AecDumpManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Add(        
        std::move(p_agent));
      return true;
    }
  }
  return false;
}

// static
bool AecDumpManagerStubDispatch::AcceptWithResponder(
    AecDumpManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AecDumpManager>(message->header()->name)) {
    case messages::AecDumpManager::kAdd: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAecDumpManagerValidationInfo[] = {
    { &internal::AecDumpManager_Add_Params_Data::Validate,
     nullptr /* no response */},
};

bool AecDumpManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::AecDumpManager::Name_,
    kAecDumpManagerValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void AecDumpAgentInterceptorForTesting::Start(::base::File file) {
  GetForwardingInterface()->Start(
    std::move(file)
    );
}
void AecDumpAgentInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
AecDumpAgentAsyncWaiter::AecDumpAgentAsyncWaiter(
    AecDumpAgent* proxy) : proxy_(proxy) {}

AecDumpAgentAsyncWaiter::~AecDumpAgentAsyncWaiter() = default;





void AecDumpManagerInterceptorForTesting::Add(::mojo::PendingRemote<AecDumpAgent> agent) {
  GetForwardingInterface()->Add(
    std::move(agent)
    );
}
AecDumpManagerAsyncWaiter::AecDumpManagerAsyncWaiter(
    AecDumpManager* proxy) : proxy_(proxy) {}

AecDumpManagerAsyncWaiter::~AecDumpManagerAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif