// third_party/blink/public/mojom/mediasession/media_session.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"


namespace blink::mojom {
class MediaSessionSeekToDetailsDataView;

class MediaSessionEnterPictureInPictureDetailsDataView;

class SpecMediaMetadataDataView;

class MediaSessionActionDetailsDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MediaSessionSeekToDetailsDataView> {
  using Data = ::blink::mojom::internal::MediaSessionSeekToDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MediaSessionEnterPictureInPictureDetailsDataView> {
  using Data = ::blink::mojom::internal::MediaSessionEnterPictureInPictureDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SpecMediaMetadataDataView> {
  using Data = ::blink::mojom::internal::SpecMediaMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::MediaSessionActionDetailsDataView> {
  using Data = ::blink::mojom::internal::MediaSessionActionDetails_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class MediaSessionPlaybackState : int32_t {
  
  NONE = 0,
  
  PAUSED = 1,
  
  PLAYING = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaSessionPlaybackState value);
inline bool IsKnownEnumValue(MediaSessionPlaybackState value) {
  return internal::MediaSessionPlaybackState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MediaSessionEnterPictureInPictureReason : int32_t {
  
  kOther = 0,
  
  kUserAction = 1,
  
  kContentOccluded = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaSessionEnterPictureInPictureReason value);
inline bool IsKnownEnumValue(MediaSessionEnterPictureInPictureReason value) {
  return internal::MediaSessionEnterPictureInPictureReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaSessionClientInterfaceBase {};

using MediaSessionClientPtrDataView =
    mojo::InterfacePtrDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionClientInterfaceBase>;
using MediaSessionClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionClientInterfaceBase>;
class MediaSessionServiceInterfaceBase {};

using MediaSessionServicePtrDataView =
    mojo::InterfacePtrDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceRequestDataView =
    mojo::InterfaceRequestDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaSessionServiceInterfaceBase>;
using MediaSessionServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaSessionServiceInterfaceBase>;


class MediaSessionSeekToDetailsDataView {
 public:
  MediaSessionSeekToDetailsDataView() = default;

  MediaSessionSeekToDetailsDataView(
      internal::MediaSessionSeekToDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool fast_seek() const {
    return data_->fast_seek;
  }
 private:
  internal::MediaSessionSeekToDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionEnterPictureInPictureDetailsDataView {
 public:
  MediaSessionEnterPictureInPictureDetailsDataView() = default;

  MediaSessionEnterPictureInPictureDetailsDataView(
      internal::MediaSessionEnterPictureInPictureDetails_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::blink::mojom::MediaSessionEnterPictureInPictureReason>(
        data_value, output);
  }
  MediaSessionEnterPictureInPictureReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::MediaSessionEnterPictureInPictureReason>(data_->reason));
  }
 private:
  internal::MediaSessionEnterPictureInPictureDetails_Data* data_ = nullptr;
};


class SpecMediaMetadataDataView {
 public:
  SpecMediaMetadataDataView() = default;

  SpecMediaMetadataDataView(
      internal::SpecMediaMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetArtistDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtist(UserType* output) {
    
    auto* pointer = data_->artist.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetAlbumDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlbum(UserType* output) {
    
    auto* pointer = data_->album.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetArtworkDataView(
      mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArtwork(UserType* output) {
    
    auto* pointer = data_->artwork.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>>(
        pointer, output, message_);
  }
  inline void GetChapterInfoDataView(
      mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChapterInfo(UserType* output) {
    
    auto* pointer = data_->chapterInfo.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SpecMediaMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaSessionActionDetailsDataView {
 public:
  using Tag = internal::MediaSessionActionDetails_Data::MediaSessionActionDetails_Tag;

  MediaSessionActionDetailsDataView() = default;

  MediaSessionActionDetailsDataView(
      internal::MediaSessionActionDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_seek_to() const { return data_->tag == Tag::kSeekTo; }
  inline void GetSeekToDataView(
      MediaSessionSeekToDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSeekTo(UserType* output) const {
    
    CHECK(is_seek_to());
    return mojo::internal::Deserialize<::blink::mojom::MediaSessionSeekToDetailsDataView>(
        data_->data.f_seek_to.Get(), output, message_);
  }
  bool is_enter_picture_in_picture() const { return data_->tag == Tag::kEnterPictureInPicture; }
  inline void GetEnterPictureInPictureDataView(
      MediaSessionEnterPictureInPictureDetailsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadEnterPictureInPicture(UserType* output) const {
    
    CHECK(is_enter_picture_in_picture());
    return mojo::internal::Deserialize<::blink::mojom::MediaSessionEnterPictureInPictureDetailsDataView>(
        data_->data.f_enter_picture_in_picture.Get(), output, message_);
  }

 private:
  internal::MediaSessionActionDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_DATA_VIEW_H_