// third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/media/renderer_audio_input_stream_factory.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data_pipe.mojom-forward.h"
#include "media/mojo/mojom/audio_input_stream.mojom-forward.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "media/mojo/mojom/audio_processing.mojom-forward.h"
#include "media/mojo/mojom/media_types.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class RendererAudioInputStreamFactoryProxy;

template <typename ImplRefTraits>
class RendererAudioInputStreamFactoryStub;

class RendererAudioInputStreamFactoryRequestValidator;


class BLINK_COMMON_EXPORT RendererAudioInputStreamFactory
    : public RendererAudioInputStreamFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RendererAudioInputStreamFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererAudioInputStreamFactoryInterfaceBase;
  using Proxy_ = RendererAudioInputStreamFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAudioInputStreamFactoryStub<ImplRefTraits>;

  using RequestValidator_ = RendererAudioInputStreamFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateStreamMinVersion = 0,
    kAssociateInputAndOutputForAecMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AssociateInputAndOutputForAec_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererAudioInputStreamFactory() = default;

  virtual void CreateStream(::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> client, const ::base::UnguessableToken& session_id, const ::media::AudioParameters& params, bool automatic_gain_control, uint32_t shared_memory_count, ::media::mojom::AudioProcessingConfigPtr processing_config) = 0;

  virtual void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const std::string& output_device_id) = 0;
};

class RendererAudioInputStreamFactoryClientProxy;

template <typename ImplRefTraits>
class RendererAudioInputStreamFactoryClientStub;

class RendererAudioInputStreamFactoryClientRequestValidator;


class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryClient
    : public RendererAudioInputStreamFactoryClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.RendererAudioInputStreamFactoryClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererAudioInputStreamFactoryClientInterfaceBase;
  using Proxy_ = RendererAudioInputStreamFactoryClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAudioInputStreamFactoryClientStub<ImplRefTraits>;

  using RequestValidator_ = RendererAudioInputStreamFactoryClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStreamCreatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StreamCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererAudioInputStreamFactoryClient() = default;

  virtual void StreamCreated(::mojo::PendingRemote<::media::mojom::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> client_request, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe, bool initially_muted, const std::optional<::base::UnguessableToken>& stream_id) = 0;
};



class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryProxy
    : public RendererAudioInputStreamFactory {
 public:
  using InterfaceType = RendererAudioInputStreamFactory;

  explicit RendererAudioInputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateStream(::mojo::PendingRemote<RendererAudioInputStreamFactoryClient> client, const ::base::UnguessableToken& session_id, const ::media::AudioParameters& params, bool automatic_gain_control, uint32_t shared_memory_count, ::media::mojom::AudioProcessingConfigPtr processing_config) final;
  
  void AssociateInputAndOutputForAec(const ::base::UnguessableToken& input_stream_id, const std::string& output_device_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryClientProxy
    : public RendererAudioInputStreamFactoryClient {
 public:
  using InterfaceType = RendererAudioInputStreamFactoryClient;

  explicit RendererAudioInputStreamFactoryClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StreamCreated(::mojo::PendingRemote<::media::mojom::AudioInputStream> stream, ::mojo::PendingReceiver<::media::mojom::AudioInputStreamClient> client_request, ::media::mojom::ReadWriteAudioDataPipePtr data_pipe, bool initially_muted, const std::optional<::base::UnguessableToken>& stream_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryStubDispatch {
 public:
  static bool Accept(RendererAudioInputStreamFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAudioInputStreamFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAudioInputStreamFactory>>
class RendererAudioInputStreamFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAudioInputStreamFactoryStub() = default;
  ~RendererAudioInputStreamFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryClientStubDispatch {
 public:
  static bool Accept(RendererAudioInputStreamFactoryClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAudioInputStreamFactoryClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAudioInputStreamFactoryClient>>
class RendererAudioInputStreamFactoryClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAudioInputStreamFactoryClientStub() = default;
  ~RendererAudioInputStreamFactoryClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioInputStreamFactoryClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RendererAudioInputStreamFactoryClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_INPUT_STREAM_FACTORY_MOJOM_H_