// third_party/blink/public/mojom/media/capture_handle_config.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/media/capture_handle_config.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function CaptureHandleConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CaptureHandleConfig.prototype.initDefaults_ = function() {
    this.exposeOrigin = false;
    this.allOriginsPermitted = false;
    this.captureHandle = null;
    this.permittedOrigins = null;
  };
  CaptureHandleConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CaptureHandleConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CaptureHandleConfig.captureHandle
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CaptureHandleConfig.permittedOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CaptureHandleConfig.encodedSize = codec.kStructHeaderSize + 24;

  CaptureHandleConfig.decode = function(decoder) {
    var packed;
    var val = new CaptureHandleConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.exposeOrigin = (packed >> 0) & 1 ? true : false;
    val.allOriginsPermitted = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.captureHandle =
        decoder.decodeStructPointer(string16$.String16);
    val.permittedOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  CaptureHandleConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CaptureHandleConfig.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.exposeOrigin & 1) << 0
    packed |= (val.allOriginsPermitted & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.captureHandle);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.permittedOrigins);
  };
  exports.CaptureHandleConfig = CaptureHandleConfig;
})();