// third_party/blink/public/mojom/manifest/manifest_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  ManifestRequestResult as blink_mojom_ManifestRequestResult,
  ManifestRequestResultSpec as blink_mojom_ManifestRequestResultSpec,
  Manifest as blink_mojom_Manifest,
  ManifestSpec as blink_mojom_ManifestSpec,
  ManifestDebugInfo as blink_mojom_ManifestDebugInfo,
  ManifestDebugInfoSpec as blink_mojom_ManifestDebugInfoSpec,
  ManifestError as blink_mojom_ManifestError,
  ManifestErrorSpec as blink_mojom_ManifestErrorSpec
} from './manifest.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ManifestManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ManifestManager', scope);
  }
}

/** @interface */
export class ManifestManagerInterface {
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_ManifestRequestResult,
        url: !url_mojom_Url,
        manifest: !blink_mojom_Manifest,
   *  }>}
   */

  requestManifest() {}
  
  /**
   * @return {!Promise<{
        result: !ManifestManager_RequestManifestAndErrors_ResponseParam_Result,
   *  }>}
   */

  requestManifestAndErrors() {}
  
  /**
   * @return {!Promise<{
        url: !url_mojom_Url,
        parsedManifest: !blink_mojom_Manifest,
        debugInfo: !blink_mojom_ManifestDebugInfo,
   *  }>}
   */

  requestManifestDebugInfo() {}
  
  /**
   * @param { !url_mojom_Url } documentUrl
   * @param { !url_mojom_Url } manifestUrl
   * @param { !string } manifestContent
   * @return {!Promise<{
        parsedManifest: ?blink_mojom_Manifest,
   *  }>}
   */

  parseManifestFromString(documentUrl, manifestUrl, manifestContent) {}
}

/**
 * @implements { ManifestManagerInterface }
 */
export class ManifestManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ManifestManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ManifestManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ManifestManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_ManifestRequestResult,
        url: !url_mojom_Url,
        manifest: !blink_mojom_Manifest,
   *  }>}
   */

  requestManifest() {
    return this.proxy.sendMessage(
        0,
        ManifestManager_RequestManifest_ParamsSpec.$,
        ManifestManager_RequestManifest_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !ManifestManager_RequestManifestAndErrors_ResponseParam_Result,
   *  }>}
   */

  requestManifestAndErrors() {
    return this.proxy.sendMessage(
        1,
        ManifestManager_RequestManifestAndErrors_ParamsSpec.$,
        ManifestManager_RequestManifestAndErrors_ResponseParamsSpec.$,
        [
        ],
        true);
  }

  
  /**
   * @return {!Promise<{
        url: !url_mojom_Url,
        parsedManifest: !blink_mojom_Manifest,
        debugInfo: !blink_mojom_ManifestDebugInfo,
   *  }>}
   */

  requestManifestDebugInfo() {
    return this.proxy.sendMessage(
        2,
        ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } documentUrl
   * @param { !url_mojom_Url } manifestUrl
   * @param { !string } manifestContent
   * @return {!Promise<{
        parsedManifest: ?blink_mojom_Manifest,
   *  }>}
   */

  parseManifestFromString(
      documentUrl,
      manifestUrl,
      manifestContent) {
    return this.proxy.sendMessage(
        3,
        ManifestManager_ParseManifestFromString_ParamsSpec.$,
        ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        [
          documentUrl,
          manifestUrl,
          manifestContent
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ManifestManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ManifestManagerReceiver {
  /**
   * @param {!ManifestManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ManifestManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ManifestManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ManifestManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ManifestManager_RequestManifest_ParamsSpec.$,
        ManifestManager_RequestManifest_ResponseParamsSpec.$,
        impl.requestManifest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ManifestManager_RequestManifestAndErrors_ParamsSpec.$,
        ManifestManager_RequestManifestAndErrors_ResponseParamsSpec.$,
        impl.requestManifestAndErrors.bind(impl),
        true);
    this.helper_internal_.registerHandler(
        2,
        ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        impl.requestManifestDebugInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ManifestManager_ParseManifestFromString_ParamsSpec.$,
        ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        impl.parseManifestFromString.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ManifestManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ManifestManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ManifestManagerRemote}
   */
  static getRemote() {
    let remote = new ManifestManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ManifestManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ManifestManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ManifestManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ManifestManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestManifest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ManifestManager_RequestManifest_ParamsSpec.$,
        ManifestManager_RequestManifest_ResponseParamsSpec.$,
        this.requestManifest.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestManifestAndErrors =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ManifestManager_RequestManifestAndErrors_ParamsSpec.$,
        ManifestManager_RequestManifestAndErrors_ResponseParamsSpec.$,
        this.requestManifestAndErrors.createReceiverHandler(true /* expectsResponse */),
        true);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestManifestDebugInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
        ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
        this.requestManifestDebugInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseManifestFromString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ManifestManager_ParseManifestFromString_ParamsSpec.$,
        ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
        this.parseManifestFromString.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RequestManifestErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifestAndErrors_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifestAndErrors_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifestDebugInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_ParseManifestFromString_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ManifestManager_ParseManifestFromString_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const ManifestManager_RequestManifestAndErrors_ResponseParam_ResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RequestManifestErrorSpec.$,
    'RequestManifestError',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink_mojom_ManifestRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'details', 8,
        0,
        mojo.internal.Array(blink_mojom_ManifestErrorSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RequestManifestError {
  constructor() {
    /** @type { !blink_mojom_ManifestRequestResult } */
    this.error;
    /** @type { !Array<!blink_mojom_ManifestError> } */
    this.details;
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifest_ParamsSpec.$,
    'ManifestManager_RequestManifest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ManifestManager_RequestManifest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifest_ResponseParamsSpec.$,
    'ManifestManager_RequestManifest_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_ManifestRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifest', 16,
        0,
        blink_mojom_ManifestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ManifestManager_RequestManifest_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ManifestRequestResult } */
    this.result;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !blink_mojom_Manifest } */
    this.manifest;
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifestAndErrors_ParamsSpec.$,
    'ManifestManager_RequestManifestAndErrors_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ManifestManager_RequestManifestAndErrors_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifestAndErrors_ResponseParamsSpec.$,
    'ManifestManager_RequestManifestAndErrors_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        ManifestManager_RequestManifestAndErrors_ResponseParam_ResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ManifestManager_RequestManifestAndErrors_ResponseParams {
  constructor() {
    /** @type { !ManifestManager_RequestManifestAndErrors_ResponseParam_Result } */
    this.result;
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifestDebugInfo_ParamsSpec.$,
    'ManifestManager_RequestManifestDebugInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class ManifestManager_RequestManifestDebugInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    ManifestManager_RequestManifestDebugInfo_ResponseParamsSpec.$,
    'ManifestManager_RequestManifestDebugInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parsedManifest', 8,
        0,
        blink_mojom_ManifestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'debugInfo', 16,
        0,
        blink_mojom_ManifestDebugInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ManifestManager_RequestManifestDebugInfo_ResponseParams {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !blink_mojom_Manifest } */
    this.parsedManifest;
    /** @type { !blink_mojom_ManifestDebugInfo } */
    this.debugInfo;
  }
}



mojo.internal.Struct(
    ManifestManager_ParseManifestFromString_ParamsSpec.$,
    'ManifestManager_ParseManifestFromString_Params',
    [
      mojo.internal.StructField(
        'documentUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifestUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'manifestContent', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ManifestManager_ParseManifestFromString_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.documentUrl;
    /** @type { !url_mojom_Url } */
    this.manifestUrl;
    /** @type { !string } */
    this.manifestContent;
  }
}



mojo.internal.Struct(
    ManifestManager_ParseManifestFromString_ResponseParamsSpec.$,
    'ManifestManager_ParseManifestFromString_ResponseParams',
    [
      mojo.internal.StructField(
        'parsedManifest', 0,
        0,
        blink_mojom_ManifestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ManifestManager_ParseManifestFromString_ResponseParams {
  constructor() {
    /** @type { (blink_mojom_Manifest|undefined) } */
    this.parsedManifest;
  }
}

mojo.internal.Union(
    ManifestManager_RequestManifestAndErrors_ResponseParam_ResultSpec.$, 'ManifestManager_RequestManifestAndErrors_ResponseParam_Result',
    {
      'success': {
        'ordinal': 0,
        'type': blink_mojom_ManifestSpec.$,
      },
      'failure': {
        'ordinal': 1,
        'type': RequestManifestErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!blink_mojom_Manifest|undefined),
 *   failure: (!RequestManifestError|undefined),
 * } }
 */
export const ManifestManager_RequestManifestAndErrors_ResponseParam_Result = {};
