// third_party/blink/public/mojom/manifest/manifest.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/manifest/manifest.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var screen_orientation_lock_types$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/screen_orientation_lock_types.mojom', '../../../../../services/device/public/mojom/screen_orientation_lock_types.mojom.js');
  }
  var display_mode$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/manifest/display_mode.mojom', 'display_mode.mojom.js');
  }
  var manifest_launch_handler$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/manifest/manifest_launch_handler.mojom', 'manifest_launch_handler.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var safe_url_pattern$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/safe_url_pattern.mojom', '../safe_url_pattern.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var TabStripMemberVisibility = {};
  TabStripMemberVisibility.kAuto = 0;
  TabStripMemberVisibility.kAbsent = 1;
  TabStripMemberVisibility.MIN_VALUE = 0;
  TabStripMemberVisibility.MAX_VALUE = 1;

  TabStripMemberVisibility.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  TabStripMemberVisibility.toKnownEnumValue = function(value) {
    return value;
  };

  TabStripMemberVisibility.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ManifestRequestResult = {};
  ManifestRequestResult.kUnexpectedFailure = 0;
  ManifestRequestResult.kNoManifestAllowed = 1;
  ManifestRequestResult.kNoManifestSpecified = 2;
  ManifestRequestResult.kManifestFailedToFetch = 3;
  ManifestRequestResult.kManifestFailedToParse = 4;
  ManifestRequestResult.kSuccess = 5;
  ManifestRequestResult.MIN_VALUE = 0;
  ManifestRequestResult.MAX_VALUE = 5;

  ManifestRequestResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  ManifestRequestResult.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestRequestResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Manifest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  Manifest.TextDirection = {};
  Manifest.TextDirection.kAuto = 0;
  Manifest.TextDirection.kLTR = 1;
  Manifest.TextDirection.kRTL = 2;
  Manifest.TextDirection.MIN_VALUE = 0;
  Manifest.TextDirection.MAX_VALUE = 2;

  Manifest.TextDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  Manifest.TextDirection.toKnownEnumValue = function(value) {
    return value;
  };

  Manifest.TextDirection.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  Manifest.prototype.initDefaults_ = function() {
    this.manifestUrl = null;
    this.dir = 0;
    this.hasCustomId = false;
    this.hasValidSpecifiedStartUrl = false;
    this.preferRelatedApplications = false;
    this.hasThemeColor = false;
    this.hasBackgroundColor = false;
    this.hasDarkThemeColor = false;
    this.hasDarkBackgroundColor = false;
    this.name = null;
    this.shortName = null;
    this.description = null;
    this.id = null;
    this.startUrl = null;
    this.display = 0;
    this.orientation = 0;
    this.displayOverride = null;
    this.borderlessUrlPatterns = null;
    this.icons = null;
    this.screenshots = null;
    this.shortcuts = null;
    this.shareTarget = null;
    this.fileHandlers = null;
    this.protocolHandlers = null;
    this.scopeExtensions = null;
    this.lockScreen = null;
    this.noteTaking = null;
    this.relatedApplications = null;
    this.themeColor = 0;
    this.backgroundColor = 0;
    this.gcmSenderId = null;
    this.scope = null;
    this.permissionsPolicy = null;
    this.launchHandler = null;
    this.translations = null;
    this.darkThemeColor = 0;
    this.darkBackgroundColor = 0;
    this.tabStrip = null;
    this.version = null;
    this.nameLocalized = null;
    this.shortNameLocalized = null;
    this.descriptionLocalized = null;
    this.iconsLocalized = null;
  };
  Manifest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Manifest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 272}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.manifestUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.dir
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, Manifest.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.shortName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.description
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Manifest.startUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Manifest.display
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, display_mode$.DisplayMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.displayOverride
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 64, 4, new codec.Enum(display_mode$.DisplayMode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.borderlessUrlPatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 72, 8, new codec.PointerTo(safe_url_pattern$.SafeUrlPattern), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.orientation
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 60, screen_orientation_lock_types$.ScreenOrientationLockType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.icons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 80, 8, new codec.PointerTo(ManifestImageResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.screenshots
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 88, 8, new codec.PointerTo(ManifestScreenshot), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.shortcuts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 96, 8, new codec.PointerTo(ManifestShortcutItem), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.shareTarget
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, ManifestShareTarget, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.fileHandlers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 112, 8, new codec.PointerTo(ManifestFileHandler), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.protocolHandlers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 8, new codec.PointerTo(ManifestProtocolHandler), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.scopeExtensions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 128, 8, new codec.PointerTo(ManifestScopeExtension), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.lockScreen
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, ManifestLockScreen, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.noteTaking
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, ManifestNoteTaking, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.relatedApplications
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 152, 8, new codec.PointerTo(ManifestRelatedApplication), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;







    // validate Manifest.gcmSenderId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 168, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.scope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.permissionsPolicy
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 184, 8, new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.launchHandler
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, manifest_launch_handler$.ManifestLaunchHandler, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.translations
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 200, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestTranslationItem), false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate Manifest.tabStrip
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, ManifestTabStrip, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.version
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 224, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.nameLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 232, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.shortNameLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 240, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.descriptionLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 248, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Manifest.iconsLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 256, false, new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Manifest.encodedSize = codec.kStructHeaderSize + 264;

  Manifest.decode = function(decoder) {
    var packed;
    var val = new Manifest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.manifestUrl =
        decoder.decodeStructPointer(url$.Url);
    val.dir =
        decoder.decodeStruct(new codec.Enum(Manifest.TextDirection));
    packed = decoder.readUint8();
    val.hasCustomId = (packed >> 0) & 1 ? true : false;
    val.hasValidSpecifiedStartUrl = (packed >> 1) & 1 ? true : false;
    val.preferRelatedApplications = (packed >> 2) & 1 ? true : false;
    val.hasThemeColor = (packed >> 3) & 1 ? true : false;
    val.hasBackgroundColor = (packed >> 4) & 1 ? true : false;
    val.hasDarkThemeColor = (packed >> 5) & 1 ? true : false;
    val.hasDarkBackgroundColor = (packed >> 6) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.name =
        decoder.decodeStructPointer(string16$.String16);
    val.shortName =
        decoder.decodeStructPointer(string16$.String16);
    val.description =
        decoder.decodeStructPointer(string16$.String16);
    val.id =
        decoder.decodeStructPointer(url$.Url);
    val.startUrl =
        decoder.decodeStructPointer(url$.Url);
    val.display =
        decoder.decodeStruct(new codec.Enum(display_mode$.DisplayMode));
    val.orientation =
        decoder.decodeStruct(new codec.Enum(screen_orientation_lock_types$.ScreenOrientationLockType));
    val.displayOverride =
        decoder.decodeArrayPointer(new codec.Enum(display_mode$.DisplayMode));
    val.borderlessUrlPatterns =
        decoder.decodeArrayPointer(new codec.PointerTo(safe_url_pattern$.SafeUrlPattern));
    val.icons =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestImageResource));
    val.screenshots =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestScreenshot));
    val.shortcuts =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestShortcutItem));
    val.shareTarget =
        decoder.decodeStructPointer(ManifestShareTarget);
    val.fileHandlers =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestFileHandler));
    val.protocolHandlers =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestProtocolHandler));
    val.scopeExtensions =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestScopeExtension));
    val.lockScreen =
        decoder.decodeStructPointer(ManifestLockScreen);
    val.noteTaking =
        decoder.decodeStructPointer(ManifestNoteTaking);
    val.relatedApplications =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestRelatedApplication));
    val.themeColor =
        decoder.decodeStruct(codec.Uint32);
    val.backgroundColor =
        decoder.decodeStruct(codec.Uint32);
    val.gcmSenderId =
        decoder.decodeStructPointer(string16$.String16);
    val.scope =
        decoder.decodeStructPointer(url$.Url);
    val.permissionsPolicy =
        decoder.decodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration));
    val.launchHandler =
        decoder.decodeStructPointer(manifest_launch_handler$.ManifestLaunchHandler);
    val.translations =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestTranslationItem));
    val.darkThemeColor =
        decoder.decodeStruct(codec.Uint32);
    val.darkBackgroundColor =
        decoder.decodeStruct(codec.Uint32);
    val.tabStrip =
        decoder.decodeStructPointer(ManifestTabStrip);
    val.version =
        decoder.decodeStructPointer(string16$.String16);
    val.nameLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.shortNameLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.descriptionLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.iconsLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)));
    return val;
  };

  Manifest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Manifest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.manifestUrl);
    encoder.encodeStruct(codec.Int32, val.dir);
    packed = 0;
    packed |= (val.hasCustomId & 1) << 0
    packed |= (val.hasValidSpecifiedStartUrl & 1) << 1
    packed |= (val.preferRelatedApplications & 1) << 2
    packed |= (val.hasThemeColor & 1) << 3
    packed |= (val.hasBackgroundColor & 1) << 4
    packed |= (val.hasDarkThemeColor & 1) << 5
    packed |= (val.hasDarkBackgroundColor & 1) << 6
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.name);
    encoder.encodeStructPointer(string16$.String16, val.shortName);
    encoder.encodeStructPointer(string16$.String16, val.description);
    encoder.encodeStructPointer(url$.Url, val.id);
    encoder.encodeStructPointer(url$.Url, val.startUrl);
    encoder.encodeStruct(codec.Int32, val.display);
    encoder.encodeStruct(codec.Int32, val.orientation);
    encoder.encodeArrayPointer(new codec.Enum(display_mode$.DisplayMode), val.displayOverride);
    encoder.encodeArrayPointer(new codec.PointerTo(safe_url_pattern$.SafeUrlPattern), val.borderlessUrlPatterns);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestImageResource), val.icons);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestScreenshot), val.screenshots);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestShortcutItem), val.shortcuts);
    encoder.encodeStructPointer(ManifestShareTarget, val.shareTarget);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestFileHandler), val.fileHandlers);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestProtocolHandler), val.protocolHandlers);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestScopeExtension), val.scopeExtensions);
    encoder.encodeStructPointer(ManifestLockScreen, val.lockScreen);
    encoder.encodeStructPointer(ManifestNoteTaking, val.noteTaking);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestRelatedApplication), val.relatedApplications);
    encoder.encodeStruct(codec.Uint32, val.themeColor);
    encoder.encodeStruct(codec.Uint32, val.backgroundColor);
    encoder.encodeStructPointer(string16$.String16, val.gcmSenderId);
    encoder.encodeStructPointer(url$.Url, val.scope);
    encoder.encodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), val.permissionsPolicy);
    encoder.encodeStructPointer(manifest_launch_handler$.ManifestLaunchHandler, val.launchHandler);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestTranslationItem), val.translations);
    encoder.encodeStruct(codec.Uint32, val.darkThemeColor);
    encoder.encodeStruct(codec.Uint32, val.darkBackgroundColor);
    encoder.encodeStructPointer(ManifestTabStrip, val.tabStrip);
    encoder.encodeStructPointer(string16$.String16, val.version);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.nameLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.shortNameLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.descriptionLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)), val.iconsLocalized);
  };
  function ManifestLocalizedTextObject(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestLocalizedTextObject.prototype.initDefaults_ = function() {
    this.value = null;
    this.dir_$flag = false;
    this.dir_$value = 0;
    this.lang = null;
  };
  ManifestLocalizedTextObject.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestLocalizedTextObject.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestLocalizedTextObject.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ManifestLocalizedTextObject.dir_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, Manifest.TextDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestLocalizedTextObject.lang
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestLocalizedTextObject.encodedSize = codec.kStructHeaderSize + 24;

  ManifestLocalizedTextObject.decode = function(decoder) {
    var packed;
    var val = new ManifestLocalizedTextObject();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(string16$.String16);
    packed = decoder.readUint8();
    val.dir_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.dir_$value =
        decoder.decodeStruct(new codec.Enum(Manifest.TextDirection));
    val.lang =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ManifestLocalizedTextObject.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestLocalizedTextObject.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.value);
    packed = 0;
    packed |= (val.dir_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.dir_$value);
    encoder.encodeStructPointer(string16$.String16, val.lang);
  };
  function ManifestShortcutItem(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestShortcutItem.prototype.initDefaults_ = function() {
    this.name = null;
    this.shortName = null;
    this.description = null;
    this.url = null;
    this.icons = null;
    this.nameLocalized = null;
    this.shortNameLocalized = null;
    this.descriptionLocalized = null;
    this.iconsLocalized = null;
  };
  ManifestShortcutItem.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestShortcutItem.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.shortName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.description
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.icons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ManifestImageResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.nameLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.shortNameLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 48, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.descriptionLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 56, false, new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShortcutItem.iconsLocalized
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 64, false, new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestShortcutItem.encodedSize = codec.kStructHeaderSize + 72;

  ManifestShortcutItem.decode = function(decoder) {
    var packed;
    var val = new ManifestShortcutItem();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string16$.String16);
    val.shortName =
        decoder.decodeStructPointer(string16$.String16);
    val.description =
        decoder.decodeStructPointer(string16$.String16);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.icons =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestImageResource));
    val.nameLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.shortNameLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.descriptionLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject));
    val.iconsLocalized =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)));
    return val;
  };

  ManifestShortcutItem.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestShortcutItem.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.name);
    encoder.encodeStructPointer(string16$.String16, val.shortName);
    encoder.encodeStructPointer(string16$.String16, val.description);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestImageResource), val.icons);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.nameLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.shortNameLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.PointerTo(ManifestLocalizedTextObject), val.descriptionLocalized);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(ManifestImageResource)), val.iconsLocalized);
  };
  function ManifestImageResource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ManifestImageResource.Purpose = {};
  ManifestImageResource.Purpose.ANY = 0;
  ManifestImageResource.Purpose.MONOCHROME = 1;
  ManifestImageResource.Purpose.MASKABLE = 2;
  ManifestImageResource.Purpose.MIN_VALUE = 0;
  ManifestImageResource.Purpose.MAX_VALUE = 2;

  ManifestImageResource.Purpose.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ManifestImageResource.Purpose.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestImageResource.Purpose.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ManifestImageResource.prototype.initDefaults_ = function() {
    this.src = null;
    this.type = null;
    this.sizes = null;
    this.purpose = null;
  };
  ManifestImageResource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestImageResource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestImageResource.src
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestImageResource.type
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestImageResource.sizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestImageResource.purpose
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 4, new codec.Enum(ManifestImageResource.Purpose), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestImageResource.encodedSize = codec.kStructHeaderSize + 32;

  ManifestImageResource.decode = function(decoder) {
    var packed;
    var val = new ManifestImageResource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.src =
        decoder.decodeStructPointer(url$.Url);
    val.type =
        decoder.decodeStructPointer(string16$.String16);
    val.sizes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    val.purpose =
        decoder.decodeArrayPointer(new codec.Enum(ManifestImageResource.Purpose));
    return val;
  };

  ManifestImageResource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestImageResource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.src);
    encoder.encodeStructPointer(string16$.String16, val.type);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.sizes);
    encoder.encodeArrayPointer(new codec.Enum(ManifestImageResource.Purpose), val.purpose);
  };
  function ManifestScreenshot(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ManifestScreenshot.FormFactor = {};
  ManifestScreenshot.FormFactor.kUnknown = 0;
  ManifestScreenshot.FormFactor.kWide = 1;
  ManifestScreenshot.FormFactor.kNarrow = 2;
  ManifestScreenshot.FormFactor.MIN_VALUE = 0;
  ManifestScreenshot.FormFactor.MAX_VALUE = 2;

  ManifestScreenshot.FormFactor.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ManifestScreenshot.FormFactor.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestScreenshot.FormFactor.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ManifestScreenshot.prototype.initDefaults_ = function() {
    this.image = null;
    this.formFactor = 0;
    this.label = null;
  };
  ManifestScreenshot.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestScreenshot.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestScreenshot.image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ManifestImageResource, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestScreenshot.formFactor
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ManifestScreenshot.FormFactor);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestScreenshot.label
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestScreenshot.encodedSize = codec.kStructHeaderSize + 24;

  ManifestScreenshot.decode = function(decoder) {
    var packed;
    var val = new ManifestScreenshot();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeStructPointer(ManifestImageResource);
    val.formFactor =
        decoder.decodeStruct(new codec.Enum(ManifestScreenshot.FormFactor));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.label =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ManifestScreenshot.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestScreenshot.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ManifestImageResource, val.image);
    encoder.encodeStruct(codec.Int32, val.formFactor);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(string16$.String16, val.label);
  };
  function ManifestFileFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestFileFilter.prototype.initDefaults_ = function() {
    this.name = null;
    this.accept = null;
  };
  ManifestFileFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestFileFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileFilter.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileFilter.accept
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(string16$.String16), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestFileFilter.encodedSize = codec.kStructHeaderSize + 16;

  ManifestFileFilter.decode = function(decoder) {
    var packed;
    var val = new ManifestFileFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string16$.String16);
    val.accept =
        decoder.decodeArrayPointer(new codec.PointerTo(string16$.String16));
    return val;
  };

  ManifestFileFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestFileFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(string16$.String16), val.accept);
  };
  function ManifestProtocolHandler(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestProtocolHandler.prototype.initDefaults_ = function() {
    this.protocol = null;
    this.url = null;
  };
  ManifestProtocolHandler.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestProtocolHandler.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestProtocolHandler.protocol
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestProtocolHandler.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestProtocolHandler.encodedSize = codec.kStructHeaderSize + 16;

  ManifestProtocolHandler.decode = function(decoder) {
    var packed;
    var val = new ManifestProtocolHandler();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.protocol =
        decoder.decodeStructPointer(string16$.String16);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ManifestProtocolHandler.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestProtocolHandler.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.protocol);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function ManifestScopeExtension(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestScopeExtension.prototype.initDefaults_ = function() {
    this.origin = null;
    this.hasOriginWildcard = false;
  };
  ManifestScopeExtension.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestScopeExtension.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestScopeExtension.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ManifestScopeExtension.encodedSize = codec.kStructHeaderSize + 16;

  ManifestScopeExtension.decode = function(decoder) {
    var packed;
    var val = new ManifestScopeExtension();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.hasOriginWildcard = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ManifestScopeExtension.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestScopeExtension.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.hasOriginWildcard & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ManifestLockScreen(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestLockScreen.prototype.initDefaults_ = function() {
    this.startUrl = null;
  };
  ManifestLockScreen.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestLockScreen.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestLockScreen.startUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestLockScreen.encodedSize = codec.kStructHeaderSize + 8;

  ManifestLockScreen.decode = function(decoder) {
    var packed;
    var val = new ManifestLockScreen();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.startUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ManifestLockScreen.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestLockScreen.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.startUrl);
  };
  function ManifestNoteTaking(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestNoteTaking.prototype.initDefaults_ = function() {
    this.newNoteUrl = null;
  };
  ManifestNoteTaking.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestNoteTaking.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestNoteTaking.newNoteUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestNoteTaking.encodedSize = codec.kStructHeaderSize + 8;

  ManifestNoteTaking.decode = function(decoder) {
    var packed;
    var val = new ManifestNoteTaking();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.newNoteUrl =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  ManifestNoteTaking.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestNoteTaking.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.newNoteUrl);
  };
  function ManifestRelatedApplication(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestRelatedApplication.prototype.initDefaults_ = function() {
    this.platform = null;
    this.url = null;
    this.id = null;
  };
  ManifestRelatedApplication.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestRelatedApplication.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestRelatedApplication.platform
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestRelatedApplication.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestRelatedApplication.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestRelatedApplication.encodedSize = codec.kStructHeaderSize + 24;

  ManifestRelatedApplication.decode = function(decoder) {
    var packed;
    var val = new ManifestRelatedApplication();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.platform =
        decoder.decodeStructPointer(string16$.String16);
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.id =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ManifestRelatedApplication.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestRelatedApplication.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.platform);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(string16$.String16, val.id);
  };
  function ManifestShareTargetParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestShareTargetParams.prototype.initDefaults_ = function() {
    this.title = null;
    this.text = null;
    this.url = null;
    this.files = null;
  };
  ManifestShareTargetParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestShareTargetParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTargetParams.title
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTargetParams.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTargetParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTargetParams.files
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ManifestFileFilter), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestShareTargetParams.encodedSize = codec.kStructHeaderSize + 32;

  ManifestShareTargetParams.decode = function(decoder) {
    var packed;
    var val = new ManifestShareTargetParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStructPointer(string16$.String16);
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    val.url =
        decoder.decodeStructPointer(string16$.String16);
    val.files =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestFileFilter));
    return val;
  };

  ManifestShareTargetParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestShareTargetParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.title);
    encoder.encodeStructPointer(string16$.String16, val.text);
    encoder.encodeStructPointer(string16$.String16, val.url);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestFileFilter), val.files);
  };
  function ManifestShareTarget(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ManifestShareTarget.Method = {};
  ManifestShareTarget.Method.kGet = 0;
  ManifestShareTarget.Method.kPost = 1;
  ManifestShareTarget.Method.MIN_VALUE = 0;
  ManifestShareTarget.Method.MAX_VALUE = 1;

  ManifestShareTarget.Method.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ManifestShareTarget.Method.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestShareTarget.Method.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  ManifestShareTarget.Enctype = {};
  ManifestShareTarget.Enctype.kFormUrlEncoded = 0;
  ManifestShareTarget.Enctype.kMultipartFormData = 1;
  ManifestShareTarget.Enctype.MIN_VALUE = 0;
  ManifestShareTarget.Enctype.MAX_VALUE = 1;

  ManifestShareTarget.Enctype.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ManifestShareTarget.Enctype.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestShareTarget.Enctype.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ManifestShareTarget.prototype.initDefaults_ = function() {
    this.action = null;
    this.method = 0;
    this.enctype = 0;
    this.params = null;
  };
  ManifestShareTarget.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestShareTarget.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTarget.action
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTarget.method
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, ManifestShareTarget.Method);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTarget.enctype
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, ManifestShareTarget.Enctype);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestShareTarget.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, ManifestShareTargetParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestShareTarget.encodedSize = codec.kStructHeaderSize + 24;

  ManifestShareTarget.decode = function(decoder) {
    var packed;
    var val = new ManifestShareTarget();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStructPointer(url$.Url);
    val.method =
        decoder.decodeStruct(new codec.Enum(ManifestShareTarget.Method));
    val.enctype =
        decoder.decodeStruct(new codec.Enum(ManifestShareTarget.Enctype));
    val.params =
        decoder.decodeStructPointer(ManifestShareTargetParams);
    return val;
  };

  ManifestShareTarget.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestShareTarget.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.action);
    encoder.encodeStruct(codec.Int32, val.method);
    encoder.encodeStruct(codec.Int32, val.enctype);
    encoder.encodeStructPointer(ManifestShareTargetParams, val.params);
  };
  function ManifestFileHandler(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  ManifestFileHandler.LaunchType = {};
  ManifestFileHandler.LaunchType.kSingleClient = 0;
  ManifestFileHandler.LaunchType.kMultipleClients = 1;
  ManifestFileHandler.LaunchType.MIN_VALUE = 0;
  ManifestFileHandler.LaunchType.MAX_VALUE = 1;

  ManifestFileHandler.LaunchType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ManifestFileHandler.LaunchType.toKnownEnumValue = function(value) {
    return value;
  };

  ManifestFileHandler.LaunchType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  ManifestFileHandler.prototype.initDefaults_ = function() {
    this.action = null;
    this.name = null;
    this.icons = null;
    this.accept = null;
    this.launchType = 0;
  };
  ManifestFileHandler.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestFileHandler.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileHandler.action
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileHandler.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileHandler.icons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ManifestImageResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileHandler.accept
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 24, false, new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(string16$.String16)), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestFileHandler.launchType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, ManifestFileHandler.LaunchType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestFileHandler.encodedSize = codec.kStructHeaderSize + 40;

  ManifestFileHandler.decode = function(decoder) {
    var packed;
    var val = new ManifestFileHandler();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStructPointer(url$.Url);
    val.name =
        decoder.decodeStructPointer(string16$.String16);
    val.icons =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestImageResource));
    val.accept =
        decoder.decodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(string16$.String16)));
    val.launchType =
        decoder.decodeStruct(new codec.Enum(ManifestFileHandler.LaunchType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ManifestFileHandler.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestFileHandler.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.action);
    encoder.encodeStructPointer(string16$.String16, val.name);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestImageResource), val.icons);
    encoder.encodeMapPointer(new codec.PointerTo(string16$.String16), new codec.ArrayOf(new codec.PointerTo(string16$.String16)), val.accept);
    encoder.encodeStruct(codec.Int32, val.launchType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ManifestTranslationItem(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestTranslationItem.prototype.initDefaults_ = function() {
    this.name = null;
    this.shortName = null;
    this.description = null;
  };
  ManifestTranslationItem.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestTranslationItem.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestTranslationItem.name
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestTranslationItem.shortName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestTranslationItem.description
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestTranslationItem.encodedSize = codec.kStructHeaderSize + 24;

  ManifestTranslationItem.decode = function(decoder) {
    var packed;
    var val = new ManifestTranslationItem();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStructPointer(string16$.String16);
    val.shortName =
        decoder.decodeStructPointer(string16$.String16);
    val.description =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  ManifestTranslationItem.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestTranslationItem.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.name);
    encoder.encodeStructPointer(string16$.String16, val.shortName);
    encoder.encodeStructPointer(string16$.String16, val.description);
  };
  function ManifestTabStrip(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestTabStrip.prototype.initDefaults_ = function() {
    this.homeTab = null;
    this.newTabButton = null;
  };
  ManifestTabStrip.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestTabStrip.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestTabStrip.homeTab
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, HomeTabUnion, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestTabStrip.newTabButton
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, NewTabButtonParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestTabStrip.encodedSize = codec.kStructHeaderSize + 24;

  ManifestTabStrip.decode = function(decoder) {
    var packed;
    var val = new ManifestTabStrip();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.homeTab =
        decoder.decodeStruct(HomeTabUnion);
    val.newTabButton =
        decoder.decodeStructPointer(NewTabButtonParams);
    return val;
  };

  ManifestTabStrip.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestTabStrip.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(HomeTabUnion, val.homeTab);
    encoder.encodeStructPointer(NewTabButtonParams, val.newTabButton);
  };
  function HomeTabParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  HomeTabParams.prototype.initDefaults_ = function() {
    this.icons = null;
    this.scopePatterns = null;
  };
  HomeTabParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  HomeTabParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HomeTabParams.icons
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ManifestImageResource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate HomeTabParams.scopePatterns
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(safe_url_pattern$.SafeUrlPattern), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  HomeTabParams.encodedSize = codec.kStructHeaderSize + 16;

  HomeTabParams.decode = function(decoder) {
    var packed;
    var val = new HomeTabParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.icons =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestImageResource));
    val.scopePatterns =
        decoder.decodeArrayPointer(new codec.PointerTo(safe_url_pattern$.SafeUrlPattern));
    return val;
  };

  HomeTabParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(HomeTabParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestImageResource), val.icons);
    encoder.encodeArrayPointer(new codec.PointerTo(safe_url_pattern$.SafeUrlPattern), val.scopePatterns);
  };
  function NewTabButtonParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NewTabButtonParams.prototype.initDefaults_ = function() {
    this.url = null;
  };
  NewTabButtonParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NewTabButtonParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NewTabButtonParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NewTabButtonParams.encodedSize = codec.kStructHeaderSize + 8;

  NewTabButtonParams.decode = function(decoder) {
    var packed;
    var val = new NewTabButtonParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    return val;
  };

  NewTabButtonParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NewTabButtonParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
  };
  function ManifestDebugInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestDebugInfo.prototype.initDefaults_ = function() {
    this.errors = null;
    this.rawManifest = null;
  };
  ManifestDebugInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestDebugInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestDebugInfo.errors
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ManifestError), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestDebugInfo.rawManifest
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ManifestDebugInfo.encodedSize = codec.kStructHeaderSize + 16;

  ManifestDebugInfo.decode = function(decoder) {
    var packed;
    var val = new ManifestDebugInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errors =
        decoder.decodeArrayPointer(new codec.PointerTo(ManifestError));
    val.rawManifest =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ManifestDebugInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestDebugInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ManifestError), val.errors);
    encoder.encodeStruct(codec.String, val.rawManifest);
  };
  function ManifestError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ManifestError.prototype.initDefaults_ = function() {
    this.message = null;
    this.critical = false;
    this.line = 0;
    this.column = 0;
  };
  ManifestError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ManifestError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ManifestError.message
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ManifestError.encodedSize = codec.kStructHeaderSize + 24;

  ManifestError.decode = function(decoder) {
    var packed;
    var val = new ManifestError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.message =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.critical = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.line =
        decoder.decodeStruct(codec.Uint32);
    val.column =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ManifestError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ManifestError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.message);
    packed = 0;
    packed |= (val.critical & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.line);
    encoder.encodeStruct(codec.Uint32, val.column);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function HomeTabUnion(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  HomeTabUnion.Tags = {
    visibility: 0,
    params: 1,
  };

  HomeTabUnion.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  HomeTabUnion.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "visibility",
        "params",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a HomeTabUnion member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(HomeTabUnion.prototype, "visibility", {
    get: function() {
      if (this.$tag != HomeTabUnion.Tags.visibility) {
        throw new ReferenceError(
            "HomeTabUnion.visibility is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = HomeTabUnion.Tags.visibility;
      this.$data = value;
    }
  });
  Object.defineProperty(HomeTabUnion.prototype, "params", {
    get: function() {
      if (this.$tag != HomeTabUnion.Tags.params) {
        throw new ReferenceError(
            "HomeTabUnion.params is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = HomeTabUnion.Tags.params;
      this.$data = value;
    }
  });


    HomeTabUnion.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case HomeTabUnion.Tags.visibility:
          encoder.encodeStruct(codec.Int32, val.visibility);
          break;
        case HomeTabUnion.Tags.params:
          encoder.encodeStructPointer(HomeTabParams, val.params);
          break;
      }
      encoder.align();
    };


    HomeTabUnion.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new HomeTabUnion();
      var tag = decoder.readUint32();
      switch (tag) {
        case HomeTabUnion.Tags.visibility:
          result.visibility = decoder.decodeStruct(new codec.Enum(TabStripMemberVisibility));
          break;
        case HomeTabUnion.Tags.params:
          result.params = decoder.decodeStructPointer(HomeTabParams);
          break;
      }
      decoder.align();

      return result;
    };


    HomeTabUnion.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case HomeTabUnion.Tags.visibility:
          

    // validate HomeTabUnion.visibility
    err = messageValidator.validateEnum(data_offset, TabStripMemberVisibility);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case HomeTabUnion.Tags.params:
          

    // validate HomeTabUnion.params
    err = messageValidator.validateStructPointer(data_offset, HomeTabParams, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  HomeTabUnion.encodedSize = 16;
  exports.TabStripMemberVisibility = TabStripMemberVisibility;
  exports.ManifestRequestResult = ManifestRequestResult;
  exports.Manifest = Manifest;
  exports.ManifestLocalizedTextObject = ManifestLocalizedTextObject;
  exports.ManifestShortcutItem = ManifestShortcutItem;
  exports.ManifestImageResource = ManifestImageResource;
  exports.ManifestScreenshot = ManifestScreenshot;
  exports.ManifestFileFilter = ManifestFileFilter;
  exports.ManifestProtocolHandler = ManifestProtocolHandler;
  exports.ManifestScopeExtension = ManifestScopeExtension;
  exports.ManifestLockScreen = ManifestLockScreen;
  exports.ManifestNoteTaking = ManifestNoteTaking;
  exports.ManifestRelatedApplication = ManifestRelatedApplication;
  exports.ManifestShareTargetParams = ManifestShareTargetParams;
  exports.ManifestShareTarget = ManifestShareTarget;
  exports.ManifestFileHandler = ManifestFileHandler;
  exports.ManifestTranslationItem = ManifestTranslationItem;
  exports.ManifestTabStrip = ManifestTabStrip;
  exports.HomeTabParams = HomeTabParams;
  exports.NewTabButtonParams = NewTabButtonParams;
  exports.ManifestDebugInfo = ManifestDebugInfo;
  exports.ManifestError = ManifestError;
  exports.HomeTabUnion = HomeTabUnion;
})();