// third_party/blink/public/mojom/loader/fetch_later.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FetchLaterLoaderFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FetchLaterLoaderFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FetchLaterLoaderFactoryInterface }
 */
blink.mojom.FetchLaterLoaderFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FetchLaterLoaderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FetchLaterLoaderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FetchLaterLoaderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } loader
   * @param { !number } requestId
   * @param { !number } options
   * @param { !network.mojom.URLRequest } request
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   */

  createLoader(
      loader,
      requestId,
      options,
      request,
      trafficAnnotation) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        [
          loader,
          requestId,
          options,
          request,
          trafficAnnotation
        ],
        false);
  }

  
  /**
   * @param { !Object } factory
   */

  clone(
      factory) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        [
          factory
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FetchLaterLoaderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FetchLaterLoaderFactoryReceiver = class {
  /**
   * @param {!blink.mojom.FetchLaterLoaderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FetchLaterLoaderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FetchLaterLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FetchLaterLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        impl.createLoader.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FetchLaterLoaderFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FetchLaterLoaderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FetchLaterLoaderFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FetchLaterLoaderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FetchLaterLoaderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FetchLaterLoaderFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FetchLaterLoaderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FetchLaterLoaderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createLoader =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
        null,
        this.createLoader.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FetchLaterLoaderFactory_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FetchLaterLoaderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FetchLaterLoader.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FetchLaterLoaderInterface }
 */
blink.mojom.FetchLaterLoaderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FetchLaterLoaderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FetchLaterLoaderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FetchLaterLoaderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  sendNow() {
    this.proxy.sendMessage(
        0,
        blink.mojom.FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  cancel() {
    this.proxy.sendMessage(
        1,
        blink.mojom.FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FetchLaterLoader
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FetchLaterLoaderReceiver = class {
  /**
   * @param {!blink.mojom.FetchLaterLoaderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FetchLaterLoaderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FetchLaterLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FetchLaterLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        impl.sendNow.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FetchLaterLoader = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FetchLaterLoader";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FetchLaterLoaderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FetchLaterLoaderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FetchLaterLoader
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FetchLaterLoaderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FetchLaterLoaderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FetchLaterLoaderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendNow =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FetchLaterLoader_SendNow_ParamsSpec.$,
        null,
        this.sendNow.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FetchLaterLoader_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchLaterLoaderFactory_CreateLoader_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchLaterLoaderFactory_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchLaterLoader_SendNow_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FetchLaterLoader_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FetchLaterLoaderFactory_CreateLoader_ParamsSpec.$,
    'FetchLaterLoaderFactory_CreateLoader_Params',
    [
      mojo.internal.StructField(
        'loader', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.FetchLaterLoaderPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 16,
        0,
        network.mojom.URLRequestSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 24,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.FetchLaterLoaderFactory_CreateLoader_Params = class {
  constructor() {
    /** @export { !Object } */
    this.loader;
    /** @export { !number } */
    this.requestId;
    /** @export { !number } */
    this.options;
    /** @export { !network.mojom.URLRequest } */
    this.request;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
  }
};



mojo.internal.Struct(
    blink.mojom.FetchLaterLoaderFactory_Clone_ParamsSpec.$,
    'FetchLaterLoaderFactory_Clone_Params',
    [
      mojo.internal.StructField(
        'factory', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(blink.mojom.FetchLaterLoaderFactoryPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FetchLaterLoaderFactory_Clone_Params = class {
  constructor() {
    /** @export { !Object } */
    this.factory;
  }
};



mojo.internal.Struct(
    blink.mojom.FetchLaterLoader_SendNow_ParamsSpec.$,
    'FetchLaterLoader_SendNow_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FetchLaterLoader_SendNow_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FetchLaterLoader_Cancel_ParamsSpec.$,
    'FetchLaterLoader_Cancel_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FetchLaterLoader_Cancel_Params = class {
  constructor() {
  }
};

