// third_party/blink/public/mojom/loader/fetch_later.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/fetch_later.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/fetch_later.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/fetch_later.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/loader/fetch_later.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

FetchLaterLoaderFactory::IPCStableHashFunction FetchLaterLoaderFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FetchLaterLoaderFactory>(message.name())) {
    case messages::FetchLaterLoaderFactory::kCreateLoader: {
      return &FetchLaterLoaderFactory::CreateLoader_Sym::IPCStableHash;
    }
    case messages::FetchLaterLoaderFactory::kClone: {
      return &FetchLaterLoaderFactory::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FetchLaterLoaderFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FetchLaterLoaderFactory>(message.name())) {
      case messages::FetchLaterLoaderFactory::kCreateLoader:
            return "Receive blink::mojom::FetchLaterLoaderFactory::CreateLoader";
      case messages::FetchLaterLoaderFactory::kClone:
            return "Receive blink::mojom::FetchLaterLoaderFactory::Clone";
    }
  } else {
    switch (static_cast<messages::FetchLaterLoaderFactory>(message.name())) {
      case messages::FetchLaterLoaderFactory::kCreateLoader:
            return "Receive reply blink::mojom::FetchLaterLoaderFactory::CreateLoader";
      case messages::FetchLaterLoaderFactory::kClone:
            return "Receive reply blink::mojom::FetchLaterLoaderFactory::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FetchLaterLoaderFactory::CreateLoader_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7bdd3cf;  // IPCStableHash for blink::mojom::FetchLaterLoaderFactory::CreateLoader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FetchLaterLoaderFactory::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10e5e72b;  // IPCStableHash for blink::mojom::FetchLaterLoaderFactory::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FetchLaterLoaderFactoryProxy::FetchLaterLoaderFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FetchLaterLoaderFactoryProxy::CreateLoader(
    ::mojo::PendingAssociatedReceiver<FetchLaterLoader> in_loader, int32_t in_request_id, uint32_t in_options, const ::network::ResourceRequest& in_request, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FetchLaterLoaderFactory::CreateLoader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("loader"), in_loader,
                        "<value of type ::mojo::PendingAssociatedReceiver<FetchLaterLoader>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type const ::network::ResourceRequest&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("traffic_annotation"), in_traffic_annotation,
                        "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FetchLaterLoaderFactory::kCreateLoader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FetchLaterLoaderFactory_CreateLoader_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FetchLaterLoaderAssociatedRequestDataView>(
    in_loader,
    &params->loader,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->loader)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid loader in FetchLaterLoaderFactory.CreateLoader request");

  params->request_id = in_request_id;

  params->options = in_options;
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in FetchLaterLoaderFactory.CreateLoader request");
  mojo::internal::MessageFragment<
      typename decltype(params->traffic_annotation)::BaseType> traffic_annotation_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
    in_traffic_annotation,
    traffic_annotation_fragment);

  params->traffic_annotation.Set(
      traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->traffic_annotation.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null traffic_annotation in FetchLaterLoaderFactory.CreateLoader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FetchLaterLoaderFactory::Name_);
  message.set_method_name("CreateLoader");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FetchLaterLoaderFactoryProxy::Clone(
    ::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FetchLaterLoaderFactory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FetchLaterLoaderFactory::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FetchLaterLoaderFactory_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FetchLaterLoaderFactoryAssociatedRequestDataView>(
    in_factory,
    &params->factory,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->factory)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid factory in FetchLaterLoaderFactory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FetchLaterLoaderFactory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FetchLaterLoaderFactoryStubDispatch::Accept(
    FetchLaterLoaderFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FetchLaterLoaderFactory>(message->header()->name)) {
    case messages::FetchLaterLoaderFactory::kCreateLoader: {
      DCHECK(message->is_serialized());
      internal::FetchLaterLoaderFactory_CreateLoader_Params_Data* params =
          reinterpret_cast<internal::FetchLaterLoaderFactory_CreateLoader_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FetchLaterLoaderFactory.0
      bool success = true;
      ::mojo::PendingAssociatedReceiver<FetchLaterLoader> p_loader{};
      int32_t p_request_id{};
      uint32_t p_options{};
      ::network::ResourceRequest p_request{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      FetchLaterLoaderFactory_CreateLoader_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_loader =
            input_data_view.TakeLoader<decltype(p_loader)>();
      }
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FetchLaterLoaderFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateLoader(        
        std::move(p_loader), 
        std::move(p_request_id), 
        std::move(p_options), 
        p_request, 
        std::move(p_traffic_annotation));
      return true;
    }
    case messages::FetchLaterLoaderFactory::kClone: {
      DCHECK(message->is_serialized());
      internal::FetchLaterLoaderFactory_Clone_Params_Data* params =
          reinterpret_cast<internal::FetchLaterLoaderFactory_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FetchLaterLoaderFactory.1
      bool success = true;
      ::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory> p_factory{};
      FetchLaterLoaderFactory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FetchLaterLoaderFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_factory));
      return true;
    }
  }
  return false;
}

// static
bool FetchLaterLoaderFactoryStubDispatch::AcceptWithResponder(
    FetchLaterLoaderFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FetchLaterLoaderFactory>(message->header()->name)) {
    case messages::FetchLaterLoaderFactory::kCreateLoader: {
      break;
    }
    case messages::FetchLaterLoaderFactory::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFetchLaterLoaderFactoryValidationInfo[] = {
    { &internal::FetchLaterLoaderFactory_CreateLoader_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FetchLaterLoaderFactory_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool FetchLaterLoaderFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FetchLaterLoaderFactory::Name_,
    kFetchLaterLoaderFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

FetchLaterLoader::IPCStableHashFunction FetchLaterLoader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FetchLaterLoader>(message.name())) {
    case messages::FetchLaterLoader::kSendNow: {
      return &FetchLaterLoader::SendNow_Sym::IPCStableHash;
    }
    case messages::FetchLaterLoader::kCancel: {
      return &FetchLaterLoader::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FetchLaterLoader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FetchLaterLoader>(message.name())) {
      case messages::FetchLaterLoader::kSendNow:
            return "Receive blink::mojom::FetchLaterLoader::SendNow";
      case messages::FetchLaterLoader::kCancel:
            return "Receive blink::mojom::FetchLaterLoader::Cancel";
    }
  } else {
    switch (static_cast<messages::FetchLaterLoader>(message.name())) {
      case messages::FetchLaterLoader::kSendNow:
            return "Receive reply blink::mojom::FetchLaterLoader::SendNow";
      case messages::FetchLaterLoader::kCancel:
            return "Receive reply blink::mojom::FetchLaterLoader::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FetchLaterLoader::SendNow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xacfeb597;  // IPCStableHash for blink::mojom::FetchLaterLoader::SendNow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FetchLaterLoader::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20f247d7;  // IPCStableHash for blink::mojom::FetchLaterLoader::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FetchLaterLoaderProxy::FetchLaterLoaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FetchLaterLoaderProxy::SendNow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FetchLaterLoader::SendNow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FetchLaterLoader::kSendNow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FetchLaterLoader_SendNow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FetchLaterLoader::Name_);
  message.set_method_name("SendNow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FetchLaterLoaderProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FetchLaterLoader::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FetchLaterLoader::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FetchLaterLoader_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FetchLaterLoader::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FetchLaterLoaderStubDispatch::Accept(
    FetchLaterLoader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FetchLaterLoader>(message->header()->name)) {
    case messages::FetchLaterLoader::kSendNow: {
      DCHECK(message->is_serialized());
      internal::FetchLaterLoader_SendNow_Params_Data* params =
          reinterpret_cast<internal::FetchLaterLoader_SendNow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FetchLaterLoader.0
      bool success = true;
      FetchLaterLoader_SendNow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FetchLaterLoader::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendNow(        );
      return true;
    }
    case messages::FetchLaterLoader::kCancel: {
      DCHECK(message->is_serialized());
      internal::FetchLaterLoader_Cancel_Params_Data* params =
          reinterpret_cast<internal::FetchLaterLoader_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FetchLaterLoader.1
      bool success = true;
      FetchLaterLoader_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FetchLaterLoader::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool FetchLaterLoaderStubDispatch::AcceptWithResponder(
    FetchLaterLoader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FetchLaterLoader>(message->header()->name)) {
    case messages::FetchLaterLoader::kSendNow: {
      break;
    }
    case messages::FetchLaterLoader::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFetchLaterLoaderValidationInfo[] = {
    { &internal::FetchLaterLoader_SendNow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FetchLaterLoader_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool FetchLaterLoaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FetchLaterLoader::Name_,
    kFetchLaterLoaderValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FetchLaterLoaderFactoryInterceptorForTesting::CreateLoader(::mojo::PendingAssociatedReceiver<FetchLaterLoader> loader, int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) {
  GetForwardingInterface()->CreateLoader(
    std::move(loader)
    , 
    std::move(request_id)
    , 
    std::move(options)
    , 
    request, 
    std::move(traffic_annotation)
    );
}
void FetchLaterLoaderFactoryInterceptorForTesting::Clone(::mojo::PendingAssociatedReceiver<FetchLaterLoaderFactory> factory) {
  GetForwardingInterface()->Clone(
    std::move(factory)
    );
}
FetchLaterLoaderFactoryAsyncWaiter::FetchLaterLoaderFactoryAsyncWaiter(
    FetchLaterLoaderFactory* proxy) : proxy_(proxy) {}

FetchLaterLoaderFactoryAsyncWaiter::~FetchLaterLoaderFactoryAsyncWaiter() = default;





void FetchLaterLoaderInterceptorForTesting::SendNow() {
  GetForwardingInterface()->SendNow();
}
void FetchLaterLoaderInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
FetchLaterLoaderAsyncWaiter::FetchLaterLoaderAsyncWaiter(
    FetchLaterLoader* proxy) : proxy_(proxy) {}

FetchLaterLoaderAsyncWaiter::~FetchLaterLoaderAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif