// third_party/blink/public/mojom/leak_detector/leak_detector.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class LeakDetectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.LeakDetector', scope);
  }
}

/** @interface */
export class LeakDetectorInterface {
  
  /**
   * @return {!Promise<{
        result: ?LeakDetectionResult,
   *  }>}
   */

  performLeakDetection() {}
}

/**
 * @implements { LeakDetectorInterface }
 */
export class LeakDetectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!LeakDetectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          LeakDetectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!LeakDetectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: ?LeakDetectionResult,
   *  }>}
   */

  performLeakDetection() {
    return this.proxy.sendMessage(
        0,
        LeakDetector_PerformLeakDetection_ParamsSpec.$,
        LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the LeakDetector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LeakDetectorReceiver {
  /**
   * @param {!LeakDetectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!LeakDetectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        LeakDetectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LeakDetectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        LeakDetector_PerformLeakDetection_ParamsSpec.$,
        LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        impl.performLeakDetection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class LeakDetector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LeakDetector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!LeakDetectorRemote}
   */
  static getRemote() {
    let remote = new LeakDetectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the LeakDetector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LeakDetectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      LeakDetectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!LeakDetectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.performLeakDetection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        LeakDetector_PerformLeakDetection_ParamsSpec.$,
        LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        this.performLeakDetection.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LeakDetectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LeakDetector_PerformLeakDetection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LeakDetector_PerformLeakDetection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    LeakDetectionResultSpec.$,
    'LeakDetectionResult',
    [
      mojo.internal.StructField(
        'numberOfLiveAudioNodes', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveDocuments', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveNodes', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveLayoutObjects', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveResources', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveContextLifecycleStateObservers', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveFrames', 24,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveV8PerContextData', 28,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfWorkerGlobalScopes', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveUaCssResources', 36,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'numberOfLiveResourceFetchers', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class LeakDetectionResult {
  constructor() {
    /** @type { !number } */
    this.numberOfLiveAudioNodes;
    /** @type { !number } */
    this.numberOfLiveDocuments;
    /** @type { !number } */
    this.numberOfLiveNodes;
    /** @type { !number } */
    this.numberOfLiveLayoutObjects;
    /** @type { !number } */
    this.numberOfLiveResources;
    /** @type { !number } */
    this.numberOfLiveContextLifecycleStateObservers;
    /** @type { !number } */
    this.numberOfLiveFrames;
    /** @type { !number } */
    this.numberOfLiveV8PerContextData;
    /** @type { !number } */
    this.numberOfWorkerGlobalScopes;
    /** @type { !number } */
    this.numberOfLiveUaCssResources;
    /** @type { !number } */
    this.numberOfLiveResourceFetchers;
  }
}



mojo.internal.Struct(
    LeakDetector_PerformLeakDetection_ParamsSpec.$,
    'LeakDetector_PerformLeakDetection_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class LeakDetector_PerformLeakDetection_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
    'LeakDetector_PerformLeakDetection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        LeakDetectionResultSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class LeakDetector_PerformLeakDetection_ResponseParams {
  constructor() {
    /** @type { (LeakDetectionResult|undefined) } */
    this.result;
  }
}

