// third_party/blink/public/mojom/leak_detector/leak_detector.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.LeakDetector');
goog.provide('blink.mojom.LeakDetectorReceiver');
goog.provide('blink.mojom.LeakDetectorCallbackRouter');
goog.provide('blink.mojom.LeakDetectorInterface');
goog.provide('blink.mojom.LeakDetectorRemote');
goog.provide('blink.mojom.LeakDetectorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.LeakDetectorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.LeakDetector.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.LeakDetectorInterface = class {
  
  /**
   * @return {!Promise<{
        result: ?blink.mojom.LeakDetectionResult,
   *  }>}
   */

  performLeakDetection() {}
};

/**
 * @export
 * @implements { blink.mojom.LeakDetectorInterface }
 */
blink.mojom.LeakDetectorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.LeakDetectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.LeakDetectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.LeakDetectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: ?blink.mojom.LeakDetectionResult,
   *  }>}
   */

  performLeakDetection() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec.$,
        blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the LeakDetector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.LeakDetectorReceiver = class {
  /**
   * @param {!blink.mojom.LeakDetectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.LeakDetectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.LeakDetectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LeakDetectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec.$,
        blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        impl.performLeakDetection.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.LeakDetector = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.LeakDetector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.LeakDetectorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.LeakDetectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the LeakDetector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.LeakDetectorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.LeakDetectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.LeakDetectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.performLeakDetection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec.$,
        blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
        this.performLeakDetection.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.LeakDetectionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LeakDetectionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.LeakDetectionResultSpec.$,
    'LeakDetectionResult',
    [
      mojo.internal.StructField(
        'numberOfLiveAudioNodes', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveDocuments', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveNodes', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveLayoutObjects', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveResources', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveContextLifecycleStateObservers', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveFrames', 24,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveV8PerContextData', 28,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfWorkerGlobalScopes', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveUaCssResources', 36,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfLiveResourceFetchers', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 56],]);



goog.provide('blink.mojom.LeakDetectionResult');

/** @record */
blink.mojom.LeakDetectionResult = class {
  constructor() {
    /** @export { !number } */
    this.numberOfLiveAudioNodes;
    /** @export { !number } */
    this.numberOfLiveDocuments;
    /** @export { !number } */
    this.numberOfLiveNodes;
    /** @export { !number } */
    this.numberOfLiveLayoutObjects;
    /** @export { !number } */
    this.numberOfLiveResources;
    /** @export { !number } */
    this.numberOfLiveContextLifecycleStateObservers;
    /** @export { !number } */
    this.numberOfLiveFrames;
    /** @export { !number } */
    this.numberOfLiveV8PerContextData;
    /** @export { !number } */
    this.numberOfWorkerGlobalScopes;
    /** @export { !number } */
    this.numberOfLiveUaCssResources;
    /** @export { !number } */
    this.numberOfLiveResourceFetchers;
  }
};



mojo.internal.Struct(
    blink.mojom.LeakDetector_PerformLeakDetection_ParamsSpec.$,
    'LeakDetector_PerformLeakDetection_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.LeakDetector_PerformLeakDetection_Params');

/** @record */
blink.mojom.LeakDetector_PerformLeakDetection_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.LeakDetector_PerformLeakDetection_ResponseParamsSpec.$,
    'LeakDetector_PerformLeakDetection_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink.mojom.LeakDetectionResultSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.LeakDetector_PerformLeakDetection_ResponseParams');

/** @record */
blink.mojom.LeakDetector_PerformLeakDetection_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.LeakDetectionResult|undefined) } */
    this.result;
  }
};

