// third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function LcpElement(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LcpElement.prototype.initDefaults_ = function() {
    this.locator = null;
    this.isImage = false;
    this.predicted_index_$flag = false;
    this.predicted_index_$value = 0;
  };
  LcpElement.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LcpElement.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LcpElement.locator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, true);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  LcpElement.encodedSize = codec.kStructHeaderSize + 16;

  LcpElement.decode = function(decoder) {
    var packed;
    var val = new LcpElement();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.locator =
        decoder.decodeStructPointer(byte_string$.ByteString);
    packed = decoder.readUint8();
    val.isImage = (packed >> 0) & 1 ? true : false;
    val.predicted_index_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.predicted_index_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  LcpElement.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LcpElement.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.locator);
    packed = 0;
    packed |= (val.isImage & 1) << 0
    packed |= (val.predicted_index_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.predicted_index_$value);
  };
  function LCPCriticalPathPredictorNavigationTimeHint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorNavigationTimeHint.prototype.initDefaults_ = function() {
    this.lcpElementLocators = null;
    this.lcpElementLocatorsAll = null;
    this.lcpInfluencerScripts = null;
    this.fetchedFonts = null;
    this.preconnectOrigins = null;
    this.unusedPreloads = null;
    this.forTesting = false;
  };
  LCPCriticalPathPredictorNavigationTimeHint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorNavigationTimeHint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.lcpElementLocators
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(byte_string$.ByteString), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.lcpElementLocatorsAll
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(byte_string$.ByteString), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.lcpInfluencerScripts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.fetchedFonts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.preconnectOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorNavigationTimeHint.unusedPreloads
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorNavigationTimeHint.encodedSize = codec.kStructHeaderSize + 56;

  LCPCriticalPathPredictorNavigationTimeHint.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorNavigationTimeHint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lcpElementLocators =
        decoder.decodeArrayPointer(new codec.PointerTo(byte_string$.ByteString));
    val.lcpElementLocatorsAll =
        decoder.decodeArrayPointer(new codec.PointerTo(byte_string$.ByteString));
    val.lcpInfluencerScripts =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.fetchedFonts =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.preconnectOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    val.unusedPreloads =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    packed = decoder.readUint8();
    val.forTesting = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LCPCriticalPathPredictorNavigationTimeHint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorNavigationTimeHint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(byte_string$.ByteString), val.lcpElementLocators);
    encoder.encodeArrayPointer(new codec.PointerTo(byte_string$.ByteString), val.lcpElementLocatorsAll);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.lcpInfluencerScripts);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.fetchedFonts);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.preconnectOrigins);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.unusedPreloads);
    packed = 0;
    packed |= (val.forTesting & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LCPCriticalPathPredictorHost_OnLcpUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.prototype.initDefaults_ = function() {
    this.lcpElement = null;
  };
  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_OnLcpUpdated_Params.lcpElement
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LcpElement, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_OnLcpUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lcpElement =
        decoder.decodeStructPointer(LcpElement);
    return val;
  };

  LCPCriticalPathPredictorHost_OnLcpUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_OnLcpUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LcpElement, val.lcpElement);
  };
  function LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.prototype.initDefaults_ = function() {
    this.elementLocator = null;
  };
  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.elementLocator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.encodedSize = codec.kStructHeaderSize + 8;

  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.elementLocator =
        decoder.decodeStructPointer(byte_string$.ByteString);
    return val;
  };

  LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.elementLocator);
  };
  function LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.prototype.initDefaults_ = function() {
    this.lcpInfluencerScripts = null;
  };
  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.lcpInfluencerScripts
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.encodedSize = codec.kStructHeaderSize + 8;

  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lcpInfluencerScripts =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    return val;
  };

  LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.lcpInfluencerScripts);
  };
  function LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.prototype.initDefaults_ = function() {
    this.origin = null;
  };
  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.encodedSize = codec.kStructHeaderSize + 8;

  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
  };
  function LCPCriticalPathPredictorHost_NotifyFetchedFont_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.prototype.initDefaults_ = function() {
    this.fontUrl = null;
    this.hit = false;
  };
  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.fontUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.encodedSize = codec.kStructHeaderSize + 16;

  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_NotifyFetchedFont_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.fontUrl =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.hit = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.fontUrl);
    packed = 0;
    packed |= (val.hit & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.prototype.initDefaults_ = function() {
    this.subresourceUrl = null;
    this.subresourceLoadStart = null;
    this.requestDestination = 0;
  };
  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.subresourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.subresourceLoadStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.requestDestination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.encodedSize = codec.kStructHeaderSize + 24;

  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.subresourceUrl =
        decoder.decodeStructPointer(url$.Url);
    val.subresourceLoadStart =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.requestDestination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.subresourceUrl);
    encoder.encodeStructPointer(time$.TimeDelta, val.subresourceLoadStart);
    encoder.encodeStruct(codec.Int32, val.requestDestination);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LCPCriticalPathPredictorHost_SetUnusedPreloads_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.prototype.initDefaults_ = function() {
    this.unusedPreloads = null;
  };
  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.unusedPreloads
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.encodedSize = codec.kStructHeaderSize + 8;

  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.decode = function(decoder) {
    var packed;
    var val = new LCPCriticalPathPredictorHost_SetUnusedPreloads_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.unusedPreloads =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    return val;
  };

  LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.unusedPreloads);
  };
  var kLCPCriticalPathPredictorHost_OnLcpUpdated_Name = 0;
  var kLCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Name = 1;
  var kLCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Name = 2;
  var kLCPCriticalPathPredictorHost_AddPreconnectOrigin_Name = 3;
  var kLCPCriticalPathPredictorHost_NotifyFetchedFont_Name = 4;
  var kLCPCriticalPathPredictorHost_NotifyFetchedSubresource_Name = 5;
  var kLCPCriticalPathPredictorHost_SetUnusedPreloads_Name = 6;

  function LCPCriticalPathPredictorHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LCPCriticalPathPredictorHost,
                                                   handleOrPtrInfo);
  }

  function LCPCriticalPathPredictorHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LCPCriticalPathPredictorHost, associatedInterfacePtrInfo);
  }

  LCPCriticalPathPredictorHostAssociatedPtr.prototype =
      Object.create(LCPCriticalPathPredictorHostPtr.prototype);
  LCPCriticalPathPredictorHostAssociatedPtr.prototype.constructor =
      LCPCriticalPathPredictorHostAssociatedPtr;

  function LCPCriticalPathPredictorHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  LCPCriticalPathPredictorHostPtr.prototype.onLcpUpdated = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.onLcpUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.onLcpUpdated = function(lcpElement) {
    var params_ = new LCPCriticalPathPredictorHost_OnLcpUpdated_Params();
    params_.lcpElement = lcpElement;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_OnLcpUpdated_Name,
        codec.align(LCPCriticalPathPredictorHost_OnLcpUpdated_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_OnLcpUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.onLcpTimingPredictedForTesting = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.onLcpTimingPredictedForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.onLcpTimingPredictedForTesting = function(elementLocator) {
    var params_ = new LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params();
    params_.elementLocator = elementLocator;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Name,
        codec.align(LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.setLcpInfluencerScriptUrls = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.setLcpInfluencerScriptUrls
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.setLcpInfluencerScriptUrls = function(lcpInfluencerScripts) {
    var params_ = new LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params();
    params_.lcpInfluencerScripts = lcpInfluencerScripts;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Name,
        codec.align(LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.addPreconnectOrigin = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.addPreconnectOrigin
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.addPreconnectOrigin = function(origin) {
    var params_ = new LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params();
    params_.origin = origin;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_AddPreconnectOrigin_Name,
        codec.align(LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.notifyFetchedFont = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.notifyFetchedFont
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.notifyFetchedFont = function(fontUrl, hit) {
    var params_ = new LCPCriticalPathPredictorHost_NotifyFetchedFont_Params();
    params_.fontUrl = fontUrl;
    params_.hit = hit;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_NotifyFetchedFont_Name,
        codec.align(LCPCriticalPathPredictorHost_NotifyFetchedFont_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_NotifyFetchedFont_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.notifyFetchedSubresource = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.notifyFetchedSubresource
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.notifyFetchedSubresource = function(subresourceUrl, subresourceLoadStart, requestDestination) {
    var params_ = new LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params();
    params_.subresourceUrl = subresourceUrl;
    params_.subresourceLoadStart = subresourceLoadStart;
    params_.requestDestination = requestDestination;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_NotifyFetchedSubresource_Name,
        codec.align(LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LCPCriticalPathPredictorHostPtr.prototype.setUnusedPreloads = function() {
    return LCPCriticalPathPredictorHostProxy.prototype.setUnusedPreloads
        .apply(this.ptr.getProxy(), arguments);
  };

  LCPCriticalPathPredictorHostProxy.prototype.setUnusedPreloads = function(unusedPreloads) {
    var params_ = new LCPCriticalPathPredictorHost_SetUnusedPreloads_Params();
    params_.unusedPreloads = unusedPreloads;
    var builder = new codec.MessageV0Builder(
        kLCPCriticalPathPredictorHost_SetUnusedPreloads_Name,
        codec.align(LCPCriticalPathPredictorHost_SetUnusedPreloads_Params.encodedSize));
    builder.encodeStruct(LCPCriticalPathPredictorHost_SetUnusedPreloads_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LCPCriticalPathPredictorHostStub(delegate) {
    this.delegate_ = delegate;
  }
  LCPCriticalPathPredictorHostStub.prototype.onLcpUpdated = function(lcpElement) {
    return this.delegate_ && this.delegate_.onLcpUpdated && this.delegate_.onLcpUpdated(lcpElement);
  }
  LCPCriticalPathPredictorHostStub.prototype.onLcpTimingPredictedForTesting = function(elementLocator) {
    return this.delegate_ && this.delegate_.onLcpTimingPredictedForTesting && this.delegate_.onLcpTimingPredictedForTesting(elementLocator);
  }
  LCPCriticalPathPredictorHostStub.prototype.setLcpInfluencerScriptUrls = function(lcpInfluencerScripts) {
    return this.delegate_ && this.delegate_.setLcpInfluencerScriptUrls && this.delegate_.setLcpInfluencerScriptUrls(lcpInfluencerScripts);
  }
  LCPCriticalPathPredictorHostStub.prototype.addPreconnectOrigin = function(origin) {
    return this.delegate_ && this.delegate_.addPreconnectOrigin && this.delegate_.addPreconnectOrigin(origin);
  }
  LCPCriticalPathPredictorHostStub.prototype.notifyFetchedFont = function(fontUrl, hit) {
    return this.delegate_ && this.delegate_.notifyFetchedFont && this.delegate_.notifyFetchedFont(fontUrl, hit);
  }
  LCPCriticalPathPredictorHostStub.prototype.notifyFetchedSubresource = function(subresourceUrl, subresourceLoadStart, requestDestination) {
    return this.delegate_ && this.delegate_.notifyFetchedSubresource && this.delegate_.notifyFetchedSubresource(subresourceUrl, subresourceLoadStart, requestDestination);
  }
  LCPCriticalPathPredictorHostStub.prototype.setUnusedPreloads = function(unusedPreloads) {
    return this.delegate_ && this.delegate_.setUnusedPreloads && this.delegate_.setUnusedPreloads(unusedPreloads);
  }

  LCPCriticalPathPredictorHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLCPCriticalPathPredictorHost_OnLcpUpdated_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_OnLcpUpdated_Params);
      this.onLcpUpdated(params.lcpElement);
      return true;
    case kLCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params);
      this.onLcpTimingPredictedForTesting(params.elementLocator);
      return true;
    case kLCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params);
      this.setLcpInfluencerScriptUrls(params.lcpInfluencerScripts);
      return true;
    case kLCPCriticalPathPredictorHost_AddPreconnectOrigin_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params);
      this.addPreconnectOrigin(params.origin);
      return true;
    case kLCPCriticalPathPredictorHost_NotifyFetchedFont_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_NotifyFetchedFont_Params);
      this.notifyFetchedFont(params.fontUrl, params.hit);
      return true;
    case kLCPCriticalPathPredictorHost_NotifyFetchedSubresource_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params);
      this.notifyFetchedSubresource(params.subresourceUrl, params.subresourceLoadStart, params.requestDestination);
      return true;
    case kLCPCriticalPathPredictorHost_SetUnusedPreloads_Name:
      var params = reader.decodeStruct(LCPCriticalPathPredictorHost_SetUnusedPreloads_Params);
      this.setUnusedPreloads(params.unusedPreloads);
      return true;
    default:
      return false;
    }
  };

  LCPCriticalPathPredictorHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateLCPCriticalPathPredictorHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLCPCriticalPathPredictorHost_OnLcpUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_OnLcpUpdated_Params;
      break;
      case kLCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_OnLcpTimingPredictedForTesting_Params;
      break;
      case kLCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_SetLcpInfluencerScriptUrls_Params;
      break;
      case kLCPCriticalPathPredictorHost_AddPreconnectOrigin_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_AddPreconnectOrigin_Params;
      break;
      case kLCPCriticalPathPredictorHost_NotifyFetchedFont_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_NotifyFetchedFont_Params;
      break;
      case kLCPCriticalPathPredictorHost_NotifyFetchedSubresource_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_NotifyFetchedSubresource_Params;
      break;
      case kLCPCriticalPathPredictorHost_SetUnusedPreloads_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LCPCriticalPathPredictorHost_SetUnusedPreloads_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLCPCriticalPathPredictorHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var LCPCriticalPathPredictorHost = {
    name: 'blink.mojom.LCPCriticalPathPredictorHost',
    kVersion: 0,
    ptrClass: LCPCriticalPathPredictorHostPtr,
    proxyClass: LCPCriticalPathPredictorHostProxy,
    stubClass: LCPCriticalPathPredictorHostStub,
    validateRequest: validateLCPCriticalPathPredictorHostRequest,
    validateResponse: null,
  };
  LCPCriticalPathPredictorHostStub.prototype.validator = validateLCPCriticalPathPredictorHostRequest;
  LCPCriticalPathPredictorHostProxy.prototype.validator = null;
  exports.LcpElement = LcpElement;
  exports.LCPCriticalPathPredictorNavigationTimeHint = LCPCriticalPathPredictorNavigationTimeHint;
  exports.LCPCriticalPathPredictorHost = LCPCriticalPathPredictorHost;
  exports.LCPCriticalPathPredictorHostPtr = LCPCriticalPathPredictorHostPtr;
  exports.LCPCriticalPathPredictorHostAssociatedPtr = LCPCriticalPathPredictorHostAssociatedPtr;
})();