// third_party/blink/public/mojom/interest_group/interest_group_types.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigBuffer as mojoBase_mojom_BigBuffer,
  BigBufferSpec as mojoBase_mojom_BigBufferSpec
} from '../../../../../mojo/public/mojom/base/big_buffer.mojom.m.js';

import {
  Uint128 as mojoBase_mojom_Uint128,
  Uint128Spec as mojoBase_mojom_Uint128Spec
} from '../../../../../mojo/public/mojom/base/int128.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  Uuid as mojoBase_mojom_Uuid,
  UuidSpec as mojoBase_mojom_UuidSpec
} from '../../../../../mojo/public/mojom/base/uuid.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  AdSize as blink_mojom_AdSize,
  AdSizeSpec as blink_mojom_AdSizeSpec
} from './ad_display_size.mojom.m.js';


/**
 * @const { !number }
 */
export const MAX_INTEREST_GROUP_SIZE = 1048576;


/**
 * @const { !number }
 */
export const MAX_ALLOWED_REPORTING_ORIGINS = 10;



/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterestGroupAdSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SellerCapabilitiesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionServerRequestFlagsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdKeywordReplacementSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const InterestGroupSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PreviousWinSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ViewOrClickCountsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ViewAndClickCountsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BiddingBrowserSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StorageInterestGroupSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectFromSellerSignalsSubresourceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DirectFromSellerSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionAdConfigBuyerTimeoutsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdCurrencySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionAdConfigBuyerCurrenciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionAdServerResponseConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionReportBuyerDebugModeConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionReportBuyersConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionAdConfigNonSharedParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionAdConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionDataBuyerConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AuctionDataConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdAuctionPerSellerRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromiseJsonSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromisePerBuyerSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromiseBuyerTimeoutsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromiseBuyerCurrenciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromiseDirectFromSellerSignalsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AdAuctionRequestOrErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    InterestGroupAdSpec.$,
    'InterestGroupAd',
    [
      mojo.internal.StructField(
        'renderUrl', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizeGroup', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerReportingId', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerAndSellerReportingId', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'selectableBuyerAndSellerReportingIds', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adRenderId', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowedReportingOrigins', 56,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'creativeScanningMetadata', 64,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class InterestGroupAd {
  constructor() {
    /** @type { !string } */
    this.renderUrl;
    /** @type { (string|undefined) } */
    this.sizeGroup;
    /** @type { (string|undefined) } */
    this.buyerReportingId;
    /** @type { (string|undefined) } */
    this.buyerAndSellerReportingId;
    /** @type { (Array<!string>|undefined) } */
    this.selectableBuyerAndSellerReportingIds;
    /** @type { (string|undefined) } */
    this.metadata;
    /** @type { (string|undefined) } */
    this.adRenderId;
    /** @type { (Array<!url_mojom_Origin>|undefined) } */
    this.allowedReportingOrigins;
    /** @type { (string|undefined) } */
    this.creativeScanningMetadata;
  }
}



mojo.internal.Struct(
    SellerCapabilitiesSpec.$,
    'SellerCapabilities',
    [
      mojo.internal.StructField(
        'allowsInterestGroupCounts', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowsLatencyStats', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SellerCapabilities {
  constructor() {
    /** @type { !boolean } */
    this.allowsInterestGroupCounts;
    /** @type { !boolean } */
    this.allowsLatencyStats;
  }
}



mojo.internal.Struct(
    AuctionServerRequestFlagsSpec.$,
    'AuctionServerRequestFlags',
    [
      mojo.internal.StructField(
        'omitAds', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeFullAds', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'omitUserBiddingSignals', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AuctionServerRequestFlags {
  constructor() {
    /** @type { !boolean } */
    this.omitAds;
    /** @type { !boolean } */
    this.includeFullAds;
    /** @type { !boolean } */
    this.omitUserBiddingSignals;
  }
}



mojo.internal.Struct(
    AdKeywordReplacementSpec.$,
    'AdKeywordReplacement',
    [
      mojo.internal.StructField(
        'match', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'replacement', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AdKeywordReplacement {
  constructor() {
    /** @type { !string } */
    this.match;
    /** @type { !string } */
    this.replacement;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InterestGroup_ExecutionModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InterestGroup_ExecutionMode = {
  
  kCompatibilityMode: 0,
  kGroupedByOriginMode: 1,
  kFrozenContext: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const InterestGroup_TrustedBiddingSignalsSlotSizeModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const InterestGroup_TrustedBiddingSignalsSlotSizeMode = {
  
  kNone: 0,
  kSlotSize: 1,
  kAllSlotsRequestedSizes: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    InterestGroupSpec.$,
    'InterestGroup',
    [
      mojo.internal.StructField(
        'expiry', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'owner', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 24,
        0,
        mojo.internal.Double,
        0.0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableBiddingSignalsPrioritization', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priorityVector', 40,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Double, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prioritySignalsOverrides', 48,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Double, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerCapabilities', 56,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, SellerCapabilitiesSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allSellersCapabilities', 64,
        0,
        SellerCapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'executionMode', 36,
        0,
        InterestGroup_ExecutionModeSpec.$,
        InterestGroup_ExecutionMode.kCompatibilityMode,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedBiddingSignalsSlotSizeMode', 72,
        0,
        InterestGroup_TrustedBiddingSignalsSlotSizeModeSpec.$,
        InterestGroup_TrustedBiddingSignalsSlotSizeMode.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'biddingUrl', 80,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'biddingWasmHelperUrl', 88,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateUrl', 96,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedBiddingSignalsUrl', 104,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedBiddingSignalsKeys', 112,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTrustedBiddingSignalsUrlLength', 76,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedBiddingSignalsCoordinator', 120,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewAndClickCountsProviders', 128,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userBiddingSignals', 136,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ads', 144,
        0,
        mojo.internal.Array(InterestGroupAdSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adComponents', 152,
        0,
        mojo.internal.Array(InterestGroupAdSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adSizes', 160,
        0,
        mojo.internal.Map(mojo.internal.String, blink_mojom_AdSizeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizeGroups', 168,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.String, false), false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionServerRequestFlags', 176,
        0,
        AuctionServerRequestFlagsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'additionalBidKey', 184,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aggregationCoordinatorOrigin', 192,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 208],]);



/**
 * @record
 */
export class InterestGroup {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.expiry;
    /** @type { !url_mojom_Origin } */
    this.owner;
    /** @type { !string } */
    this.name;
    /** @type { !number } */
    this.priority;
    /** @type { !boolean } */
    this.enableBiddingSignalsPrioritization;
    /** @type { (Object<!string, !number>|undefined) } */
    this.priorityVector;
    /** @type { (Object<!string, !number>|undefined) } */
    this.prioritySignalsOverrides;
    /** @type { (Map<!url_mojom_Origin, !SellerCapabilities>|undefined) } */
    this.sellerCapabilities;
    /** @type { !SellerCapabilities } */
    this.allSellersCapabilities;
    /** @type { !InterestGroup_ExecutionMode } */
    this.executionMode;
    /** @type { !InterestGroup_TrustedBiddingSignalsSlotSizeMode } */
    this.trustedBiddingSignalsSlotSizeMode;
    /** @type { (url_mojom_Url|undefined) } */
    this.biddingUrl;
    /** @type { (url_mojom_Url|undefined) } */
    this.biddingWasmHelperUrl;
    /** @type { (url_mojom_Url|undefined) } */
    this.updateUrl;
    /** @type { (url_mojom_Url|undefined) } */
    this.trustedBiddingSignalsUrl;
    /** @type { (Array<!string>|undefined) } */
    this.trustedBiddingSignalsKeys;
    /** @type { !number } */
    this.maxTrustedBiddingSignalsUrlLength;
    /** @type { (url_mojom_Origin|undefined) } */
    this.trustedBiddingSignalsCoordinator;
    /** @type { (Array<!url_mojom_Origin>|undefined) } */
    this.viewAndClickCountsProviders;
    /** @type { (string|undefined) } */
    this.userBiddingSignals;
    /** @type { (Array<!InterestGroupAd>|undefined) } */
    this.ads;
    /** @type { (Array<!InterestGroupAd>|undefined) } */
    this.adComponents;
    /** @type { (Object<!string, !blink_mojom_AdSize>|undefined) } */
    this.adSizes;
    /** @type { (Object<!string, !Array<!string>>|undefined) } */
    this.sizeGroups;
    /** @type { !AuctionServerRequestFlags } */
    this.auctionServerRequestFlags;
    /** @type { (Array<!number>|undefined) } */
    this.additionalBidKey;
    /** @type { (url_mojom_Origin|undefined) } */
    this.aggregationCoordinatorOrigin;
  }
}



mojo.internal.Struct(
    PreviousWinSpec.$,
    'PreviousWin',
    [
      mojo.internal.StructField(
        'time', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'adJson', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PreviousWin {
  constructor() {
    /** @type { !mojoBase_mojom_Time } */
    this.time;
    /** @type { !string } */
    this.adJson;
  }
}



mojo.internal.Struct(
    ViewOrClickCountsSpec.$,
    'ViewOrClickCounts',
    [
      mojo.internal.StructField(
        'pastHour', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pastDay', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pastWeek', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'past30Days', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'past90Days', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ViewOrClickCounts {
  constructor() {
    /** @type { !number } */
    this.pastHour;
    /** @type { !number } */
    this.pastDay;
    /** @type { !number } */
    this.pastWeek;
    /** @type { !number } */
    this.past30Days;
    /** @type { !number } */
    this.past90Days;
  }
}



mojo.internal.Struct(
    ViewAndClickCountsSpec.$,
    'ViewAndClickCounts',
    [
      mojo.internal.StructField(
        'viewCounts', 0,
        0,
        ViewOrClickCountsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clickCounts', 8,
        0,
        ViewOrClickCountsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ViewAndClickCounts {
  constructor() {
    /** @type { !ViewOrClickCounts } */
    this.viewCounts;
    /** @type { !ViewOrClickCounts } */
    this.clickCounts;
  }
}



mojo.internal.Struct(
    BiddingBrowserSignalsSpec.$,
    'BiddingBrowserSignals',
    [
      mojo.internal.StructField(
        'joinCount', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bidCount', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'prevWins', 8,
        0,
        mojo.internal.Array(PreviousWinSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forDebuggingOnlyInCooldownOrLockout', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'viewAndClickCounts', 24,
        0,
        ViewAndClickCountsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class BiddingBrowserSignals {
  constructor() {
    /** @type { !number } */
    this.joinCount;
    /** @type { !number } */
    this.bidCount;
    /** @type { !Array<!PreviousWin> } */
    this.prevWins;
    /** @type { !boolean } */
    this.forDebuggingOnlyInCooldownOrLockout;
    /** @type { !ViewAndClickCounts } */
    this.viewAndClickCounts;
  }
}



mojo.internal.Struct(
    StorageInterestGroupSpec.$,
    'StorageInterestGroup',
    [
      mojo.internal.StructField(
        'interestGroup', 0,
        0,
        InterestGroupSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'biddingBrowserSignals', 8,
        0,
        BiddingBrowserSignalsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'joiningOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'joinTime', 24,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastUpdated', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nextUpdateAfter', 40,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'estimatedSize', 48,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class StorageInterestGroup {
  constructor() {
    /** @type { !InterestGroup } */
    this.interestGroup;
    /** @type { !BiddingBrowserSignals } */
    this.biddingBrowserSignals;
    /** @type { !url_mojom_Origin } */
    this.joiningOrigin;
    /** @type { !mojoBase_mojom_Time } */
    this.joinTime;
    /** @type { !mojoBase_mojom_Time } */
    this.lastUpdated;
    /** @type { !mojoBase_mojom_Time } */
    this.nextUpdateAfter;
    /** @type { !bigint } */
    this.estimatedSize;
  }
}



mojo.internal.Struct(
    DirectFromSellerSignalsSubresourceSpec.$,
    'DirectFromSellerSignalsSubresource',
    [
      mojo.internal.StructField(
        'bundleUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'token', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DirectFromSellerSignalsSubresource {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.bundleUrl;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.token;
  }
}



mojo.internal.Struct(
    DirectFromSellerSignalsSpec.$,
    'DirectFromSellerSignals',
    [
      mojo.internal.StructField(
        'prefix', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerSignals', 8,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, DirectFromSellerSignalsSubresourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerSignals', 16,
        0,
        DirectFromSellerSignalsSubresourceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionSignals', 24,
        0,
        DirectFromSellerSignalsSubresourceSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DirectFromSellerSignals {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.prefix;
    /** @type { !Map<!url_mojom_Origin, !DirectFromSellerSignalsSubresource> } */
    this.perBuyerSignals;
    /** @type { (DirectFromSellerSignalsSubresource|undefined) } */
    this.sellerSignals;
    /** @type { (DirectFromSellerSignalsSubresource|undefined) } */
    this.auctionSignals;
  }
}



mojo.internal.Struct(
    AuctionAdConfigBuyerTimeoutsSpec.$,
    'AuctionAdConfigBuyerTimeouts',
    [
      mojo.internal.StructField(
        'allBuyersTimeout', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerTimeouts', 8,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojoBase_mojom_TimeDeltaSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuctionAdConfigBuyerTimeouts {
  constructor() {
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.allBuyersTimeout;
    /** @type { (Map<!url_mojom_Origin, !mojoBase_mojom_TimeDelta>|undefined) } */
    this.perBuyerTimeouts;
  }
}



mojo.internal.Struct(
    AdCurrencySpec.$,
    'AdCurrency',
    [
      mojo.internal.StructField(
        'currencyCode', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AdCurrency {
  constructor() {
    /** @type { !string } */
    this.currencyCode;
  }
}



mojo.internal.Struct(
    AuctionAdConfigBuyerCurrenciesSpec.$,
    'AuctionAdConfigBuyerCurrencies',
    [
      mojo.internal.StructField(
        'allBuyersCurrency', 0,
        0,
        AdCurrencySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerCurrencies', 8,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, AdCurrencySpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuctionAdConfigBuyerCurrencies {
  constructor() {
    /** @type { (AdCurrency|undefined) } */
    this.allBuyersCurrency;
    /** @type { (Map<!url_mojom_Origin, !AdCurrency>|undefined) } */
    this.perBuyerCurrencies;
  }
}



mojo.internal.Struct(
    AuctionAdServerResponseConfigSpec.$,
    'AuctionAdServerResponseConfig',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AuctionAdServerResponseConfig {
  constructor() {
    /** @type { !mojoBase_mojom_Uuid } */
    this.requestId;
  }
}



mojo.internal.Struct(
    AuctionReportBuyerDebugModeConfigSpec.$,
    'AuctionReportBuyerDebugModeConfig',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'debug_key_$flag', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "debug_key_$value",
          originalFieldName: "debugKey",
        }
      ),
      mojo.internal.StructField(
        'debug_key_$value', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "debugKey",
        }
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuctionReportBuyerDebugModeConfig {
  constructor() {
    /** @type { !boolean } */
    this.isEnabled;
    /** @type { (bigint|undefined) } */
    this.debugKey;
  }
}



mojo.internal.Struct(
    AuctionReportBuyersConfigSpec.$,
    'AuctionReportBuyersConfig',
    [
      mojo.internal.StructField(
        'bucket', 0,
        0,
        mojoBase_mojom_Uint128Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scale', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuctionReportBuyersConfig {
  constructor() {
    /** @type { !mojoBase_mojom_Uint128 } */
    this.bucket;
    /** @type { !number } */
    this.scale;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuctionAdConfigNonSharedParams_BuyerReportTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuctionAdConfigNonSharedParams_BuyerReportType = {
  
  kInterestGroupCount: 0,
  kBidCount: 1,
  kTotalGenerateBidLatency: 2,
  kTotalSignalsFetchLatency: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AuctionAdConfigNonSharedParams_RealTimeReportingTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AuctionAdConfigNonSharedParams_RealTimeReportingType = {
  
  kDefaultLocalReporting: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};


mojo.internal.Struct(
    AuctionAdConfigNonSharedParamsSpec.$,
    'AuctionAdConfigNonSharedParams',
    [
      mojo.internal.StructField(
        'interestGroupBuyers', 0,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionSignals', 8,
        0,
        AuctionAdConfigMaybePromiseJsonSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerSignals', 24,
        0,
        AuctionAdConfigMaybePromiseJsonSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerTkvSignals', 40,
        0,
        AuctionAdConfigMaybePromiseJsonSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerTimeout', 56,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerSignals', 64,
        0,
        AuctionAdConfigMaybePromisePerBuyerSignalsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerTkvSignals', 80,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, AuctionAdConfigMaybePromiseJsonSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerTimeouts', 88,
        0,
        AuctionAdConfigMaybePromiseBuyerTimeoutsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingTimeout', 104,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sellerCurrency', 112,
        0,
        AdCurrencySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerCurrencies', 120,
        0,
        AuctionAdConfigMaybePromiseBuyerCurrenciesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buyerCumulativeTimeouts', 136,
        0,
        AuctionAdConfigMaybePromiseBuyerTimeoutsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerGroupLimits', 152,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerPrioritySignals', 160,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.Map(mojo.internal.String, mojo.internal.Double, false), false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allBuyersPrioritySignals', 168,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Double, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allBuyersGroupLimit', 176,
        0,
        mojo.internal.Uint16,
        65535,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionReportBuyerKeys', 184,
        0,
        mojo.internal.Array(mojoBase_mojom_Uint128Spec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionReportBuyers', 192,
        0,
        mojo.internal.Map(AuctionAdConfigNonSharedParams_BuyerReportTypeSpec.$, AuctionReportBuyersConfigSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionReportBuyerDebugModeConfig', 200,
        0,
        AuctionReportBuyerDebugModeConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requiredSellerCapabilities', 208,
        0,
        SellerCapabilitiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestedSize', 216,
        0,
        blink_mojom_AdSizeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allSlotsRequestedSizes', 224,
        0,
        mojo.internal.Array(blink_mojom_AdSizeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'perBuyerMultiBidLimits', 232,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allBuyersMultiBidLimit', 178,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionNonce', 240,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seller_real_time_reporting_type_$flag', 180,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "seller_real_time_reporting_type_$value",
          originalFieldName: "sellerRealTimeReportingType",
        }
      ),
      mojo.internal.StructField(
        'seller_real_time_reporting_type_$value', 248,
        0,
        AuctionAdConfigNonSharedParams_RealTimeReportingTypeSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sellerRealTimeReportingType",
        }
      ),
      mojo.internal.StructField(
        'perBuyerRealTimeReportingTypes', 256,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, AuctionAdConfigNonSharedParams_RealTimeReportingTypeSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'componentAuctions', 264,
        0,
        mojo.internal.Array(AuctionAdConfigSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deprecatedRenderUrlReplacements', 272,
        0,
        AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTrustedScoringSignalsUrlLength', 252,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedScoringSignalsCoordinator', 288,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'executionMode', 296,
        0,
        InterestGroup_ExecutionModeSpec.$,
        InterestGroup_ExecutionMode.kCompatibilityMode,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 312],]);



/**
 * @record
 */
export class AuctionAdConfigNonSharedParams {
  constructor() {
    /** @type { (Array<!url_mojom_Origin>|undefined) } */
    this.interestGroupBuyers;
    /** @type { !AuctionAdConfigMaybePromiseJson } */
    this.auctionSignals;
    /** @type { !AuctionAdConfigMaybePromiseJson } */
    this.sellerSignals;
    /** @type { !AuctionAdConfigMaybePromiseJson } */
    this.sellerTkvSignals;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.sellerTimeout;
    /** @type { !AuctionAdConfigMaybePromisePerBuyerSignals } */
    this.perBuyerSignals;
    /** @type { !Map<!url_mojom_Origin, !AuctionAdConfigMaybePromiseJson> } */
    this.perBuyerTkvSignals;
    /** @type { !AuctionAdConfigMaybePromiseBuyerTimeouts } */
    this.buyerTimeouts;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.reportingTimeout;
    /** @type { (AdCurrency|undefined) } */
    this.sellerCurrency;
    /** @type { !AuctionAdConfigMaybePromiseBuyerCurrencies } */
    this.buyerCurrencies;
    /** @type { !AuctionAdConfigMaybePromiseBuyerTimeouts } */
    this.buyerCumulativeTimeouts;
    /** @type { !Map<!url_mojom_Origin, !number> } */
    this.perBuyerGroupLimits;
    /** @type { (Map<!url_mojom_Origin, !Object<!string, !number>>|undefined) } */
    this.perBuyerPrioritySignals;
    /** @type { (Object<!string, !number>|undefined) } */
    this.allBuyersPrioritySignals;
    /** @type { !number } */
    this.allBuyersGroupLimit;
    /** @type { (Array<!mojoBase_mojom_Uint128>|undefined) } */
    this.auctionReportBuyerKeys;
    /** @type { (Object<!AuctionAdConfigNonSharedParams_BuyerReportType, !AuctionReportBuyersConfig>|undefined) } */
    this.auctionReportBuyers;
    /** @type { (AuctionReportBuyerDebugModeConfig|undefined) } */
    this.auctionReportBuyerDebugModeConfig;
    /** @type { !SellerCapabilities } */
    this.requiredSellerCapabilities;
    /** @type { (blink_mojom_AdSize|undefined) } */
    this.requestedSize;
    /** @type { (Array<!blink_mojom_AdSize>|undefined) } */
    this.allSlotsRequestedSizes;
    /** @type { !Map<!url_mojom_Origin, !number> } */
    this.perBuyerMultiBidLimits;
    /** @type { !number } */
    this.allBuyersMultiBidLimit;
    /** @type { (mojoBase_mojom_Uuid|undefined) } */
    this.auctionNonce;
    /** @type { (AuctionAdConfigNonSharedParams_RealTimeReportingType|undefined) } */
    this.sellerRealTimeReportingType;
    /** @type { (Map<!url_mojom_Origin, !AuctionAdConfigNonSharedParams_RealTimeReportingType>|undefined) } */
    this.perBuyerRealTimeReportingTypes;
    /** @type { !Array<!AuctionAdConfig> } */
    this.componentAuctions;
    /** @type { !AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements } */
    this.deprecatedRenderUrlReplacements;
    /** @type { !number } */
    this.maxTrustedScoringSignalsUrlLength;
    /** @type { (url_mojom_Origin|undefined) } */
    this.trustedScoringSignalsCoordinator;
    /** @type { !InterestGroup_ExecutionMode } */
    this.executionMode;
  }
}



mojo.internal.Struct(
    AuctionAdConfigSpec.$,
    'AuctionAdConfig',
    [
      mojo.internal.StructField(
        'seller', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serverResponse', 8,
        0,
        AuctionAdServerResponseConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'decisionLogicUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedScoringSignalsUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'auctionAdConfigNonSharedParams', 32,
        0,
        AuctionAdConfigNonSharedParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directFromSellerSignals', 40,
        0,
        AuctionAdConfigMaybePromiseDirectFromSellerSignalsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectsDirectFromSellerSignalsHeaderAdSlot', 56,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'seller_experiment_group_id_$flag', 56,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "seller_experiment_group_id_$value",
          originalFieldName: "sellerExperimentGroupId",
        }
      ),
      mojo.internal.StructField(
        'seller_experiment_group_id_$value', 58,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sellerExperimentGroupId",
        }
      ),
      mojo.internal.StructField(
        'all_buyer_experiment_group_id_$flag', 56,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "all_buyer_experiment_group_id_$value",
          originalFieldName: "allBuyerExperimentGroupId",
        }
      ),
      mojo.internal.StructField(
        'all_buyer_experiment_group_id_$value', 60,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "allBuyerExperimentGroupId",
        }
      ),
      mojo.internal.StructField(
        'perBuyerExperimentGroupIds', 64,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expectsAdditionalBids', 56,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aggregationCoordinatorOrigin', 72,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'send_creative_scanning_metadata_$flag', 56,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "send_creative_scanning_metadata_$value",
          originalFieldName: "sendCreativeScanningMetadata",
        }
      ),
      mojo.internal.StructField(
        'send_creative_scanning_metadata_$value', 56,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "sendCreativeScanningMetadata",
        }
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class AuctionAdConfig {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.seller;
    /** @type { (AuctionAdServerResponseConfig|undefined) } */
    this.serverResponse;
    /** @type { (url_mojom_Url|undefined) } */
    this.decisionLogicUrl;
    /** @type { (url_mojom_Url|undefined) } */
    this.trustedScoringSignalsUrl;
    /** @type { !AuctionAdConfigNonSharedParams } */
    this.auctionAdConfigNonSharedParams;
    /** @type { !AuctionAdConfigMaybePromiseDirectFromSellerSignals } */
    this.directFromSellerSignals;
    /** @type { !boolean } */
    this.expectsDirectFromSellerSignalsHeaderAdSlot;
    /** @type { (number|undefined) } */
    this.sellerExperimentGroupId;
    /** @type { (number|undefined) } */
    this.allBuyerExperimentGroupId;
    /** @type { !Map<!url_mojom_Origin, !number> } */
    this.perBuyerExperimentGroupIds;
    /** @type { !boolean } */
    this.expectsAdditionalBids;
    /** @type { (url_mojom_Origin|undefined) } */
    this.aggregationCoordinatorOrigin;
    /** @type { (boolean|undefined) } */
    this.sendCreativeScanningMetadata;
  }
}



mojo.internal.Struct(
    AuctionDataBuyerConfigSpec.$,
    'AuctionDataBuyerConfig',
    [
      mojo.internal.StructField(
        'target_size_$flag', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "target_size_$value",
          originalFieldName: "targetSize",
        }
      ),
      mojo.internal.StructField(
        'target_size_$value', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "targetSize",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AuctionDataBuyerConfig {
  constructor() {
    /** @type { (number|undefined) } */
    this.targetSize;
  }
}



mojo.internal.Struct(
    AuctionDataConfigSpec.$,
    'AuctionDataConfig',
    [
      mojo.internal.StructField(
        'perBuyerConfigs', 0,
        0,
        mojo.internal.Map(url_mojom_OriginSpec.$, AuctionDataBuyerConfigSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'request_size_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "request_size_$value",
          originalFieldName: "requestSize",
        }
      ),
      mojo.internal.StructField(
        'request_size_$value', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "requestSize",
        }
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AuctionDataConfig {
  constructor() {
    /** @type { !Map<!url_mojom_Origin, !AuctionDataBuyerConfig> } */
    this.perBuyerConfigs;
    /** @type { (number|undefined) } */
    this.requestSize;
  }
}



mojo.internal.Struct(
    AdAuctionPerSellerRequestSpec.$,
    'AdAuctionPerSellerRequest',
    [
      mojo.internal.StructField(
        'seller', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        AdAuctionRequestOrErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AdAuctionPerSellerRequest {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.seller;
    /** @type { !AdAuctionRequestOrError } */
    this.data;
  }
}

mojo.internal.Union(
    AuctionAdConfigMaybePromiseJsonSpec.$, 'AuctionAdConfigMaybePromiseJson',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': mojo.internal.String,
        'nullable': true,
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (?string|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromiseJson = {};
mojo.internal.Union(
    AuctionAdConfigMaybePromisePerBuyerSignalsSpec.$, 'AuctionAdConfigMaybePromisePerBuyerSignals',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': mojo.internal.Map(url_mojom_OriginSpec.$, mojo.internal.String, false),
        'nullable': true,
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (?Map<!url_mojom_Origin, !string>|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromisePerBuyerSignals = {};
mojo.internal.Union(
    AuctionAdConfigMaybePromiseBuyerTimeoutsSpec.$, 'AuctionAdConfigMaybePromiseBuyerTimeouts',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': AuctionAdConfigBuyerTimeoutsSpec.$,
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (!AuctionAdConfigBuyerTimeouts|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromiseBuyerTimeouts = {};
mojo.internal.Union(
    AuctionAdConfigMaybePromiseBuyerCurrenciesSpec.$, 'AuctionAdConfigMaybePromiseBuyerCurrencies',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': AuctionAdConfigBuyerCurrenciesSpec.$,
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (!AuctionAdConfigBuyerCurrencies|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromiseBuyerCurrencies = {};
mojo.internal.Union(
    AuctionAdConfigMaybePromiseDirectFromSellerSignalsSpec.$, 'AuctionAdConfigMaybePromiseDirectFromSellerSignals',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': DirectFromSellerSignalsSpec.$,
        'nullable': true,
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (?DirectFromSellerSignals|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromiseDirectFromSellerSignals = {};
mojo.internal.Union(
    AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacementsSpec.$, 'AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements',
    {
      'promise': {
        'ordinal': 0,
        'type': mojo.internal.Uint32,
      },
      'value': {
        'ordinal': 1,
        'type': mojo.internal.Array(AdKeywordReplacementSpec.$, false),
      },
    });

/**
 * @typedef { {
 *   promise: (!number|undefined),
 *   value: (!Array<!AdKeywordReplacement>|undefined),
 * } }
 */
export const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements = {};
mojo.internal.Union(
    AdAuctionRequestOrErrorSpec.$, 'AdAuctionRequestOrError',
    {
      'request': {
        'ordinal': 0,
        'type': mojoBase_mojom_BigBufferSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   request: (!mojoBase_mojom_BigBuffer|undefined),
 *   error: (!string|undefined),
 * } }
 */
export const AdAuctionRequestOrError = {};
