// third_party/blink/public/mojom/interest_group/interest_group_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/interest_group/interest_group_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var big_buffer$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/big_buffer.mojom', '../../../../../mojo/public/mojom/base/big_buffer.mojom.js');
  }
  var int128$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/int128.mojom', '../../../../../mojo/public/mojom/base/int128.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var uuid$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/uuid.mojom', '../../../../../mojo/public/mojom/base/uuid.mojom.js');
  }
  var ad_display_size$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/interest_group/ad_display_size.mojom', 'ad_display_size.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var MAX_INTEREST_GROUP_SIZE = 1048576;
  var MAX_ALLOWED_REPORTING_ORIGINS = 10;

  function InterestGroupAd(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  InterestGroupAd.prototype.initDefaults_ = function() {
    this.renderUrl = null;
    this.sizeGroup = null;
    this.buyerReportingId = null;
    this.buyerAndSellerReportingId = null;
    this.selectableBuyerAndSellerReportingIds = null;
    this.metadata = null;
    this.adRenderId = null;
    this.allowedReportingOrigins = null;
    this.creativeScanningMetadata = null;
  };
  InterestGroupAd.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterestGroupAd.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.renderUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.sizeGroup
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.buyerReportingId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.buyerAndSellerReportingId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.selectableBuyerAndSellerReportingIds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.metadata
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.adRenderId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.allowedReportingOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(origin$.Origin), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroupAd.creativeScanningMetadata
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterestGroupAd.encodedSize = codec.kStructHeaderSize + 72;

  InterestGroupAd.decode = function(decoder) {
    var packed;
    var val = new InterestGroupAd();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.renderUrl =
        decoder.decodeStruct(codec.String);
    val.sizeGroup =
        decoder.decodeStruct(codec.String);
    val.buyerReportingId =
        decoder.decodeStruct(codec.String);
    val.buyerAndSellerReportingId =
        decoder.decodeStruct(codec.String);
    val.selectableBuyerAndSellerReportingIds =
        decoder.decodeArrayPointer(codec.String);
    val.metadata =
        decoder.decodeStruct(codec.String);
    val.adRenderId =
        decoder.decodeStruct(codec.String);
    val.allowedReportingOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    val.creativeScanningMetadata =
        decoder.decodeStruct(codec.String);
    return val;
  };

  InterestGroupAd.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterestGroupAd.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.renderUrl);
    encoder.encodeStruct(codec.String, val.sizeGroup);
    encoder.encodeStruct(codec.String, val.buyerReportingId);
    encoder.encodeStruct(codec.String, val.buyerAndSellerReportingId);
    encoder.encodeArrayPointer(codec.String, val.selectableBuyerAndSellerReportingIds);
    encoder.encodeStruct(codec.String, val.metadata);
    encoder.encodeStruct(codec.String, val.adRenderId);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.allowedReportingOrigins);
    encoder.encodeStruct(codec.String, val.creativeScanningMetadata);
  };
  function SellerCapabilities(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SellerCapabilities.prototype.initDefaults_ = function() {
    this.allowsInterestGroupCounts = false;
    this.allowsLatencyStats = false;
  };
  SellerCapabilities.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SellerCapabilities.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SellerCapabilities.encodedSize = codec.kStructHeaderSize + 8;

  SellerCapabilities.decode = function(decoder) {
    var packed;
    var val = new SellerCapabilities();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.allowsInterestGroupCounts = (packed >> 0) & 1 ? true : false;
    val.allowsLatencyStats = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SellerCapabilities.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SellerCapabilities.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.allowsInterestGroupCounts & 1) << 0
    packed |= (val.allowsLatencyStats & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AuctionServerRequestFlags(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionServerRequestFlags.prototype.initDefaults_ = function() {
    this.omitAds = false;
    this.includeFullAds = false;
    this.omitUserBiddingSignals = false;
  };
  AuctionServerRequestFlags.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionServerRequestFlags.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  AuctionServerRequestFlags.encodedSize = codec.kStructHeaderSize + 8;

  AuctionServerRequestFlags.decode = function(decoder) {
    var packed;
    var val = new AuctionServerRequestFlags();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.omitAds = (packed >> 0) & 1 ? true : false;
    val.includeFullAds = (packed >> 1) & 1 ? true : false;
    val.omitUserBiddingSignals = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AuctionServerRequestFlags.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionServerRequestFlags.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.omitAds & 1) << 0
    packed |= (val.includeFullAds & 1) << 1
    packed |= (val.omitUserBiddingSignals & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AdKeywordReplacement(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdKeywordReplacement.prototype.initDefaults_ = function() {
    this.match = null;
    this.replacement = null;
  };
  AdKeywordReplacement.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdKeywordReplacement.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdKeywordReplacement.match
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdKeywordReplacement.replacement
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdKeywordReplacement.encodedSize = codec.kStructHeaderSize + 16;

  AdKeywordReplacement.decode = function(decoder) {
    var packed;
    var val = new AdKeywordReplacement();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.match =
        decoder.decodeStruct(codec.String);
    val.replacement =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AdKeywordReplacement.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdKeywordReplacement.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.match);
    encoder.encodeStruct(codec.String, val.replacement);
  };
  function InterestGroup(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  InterestGroup.ExecutionMode = {};
  InterestGroup.ExecutionMode.kCompatibilityMode = 0;
  InterestGroup.ExecutionMode.kGroupedByOriginMode = 1;
  InterestGroup.ExecutionMode.kFrozenContext = 2;
  InterestGroup.ExecutionMode.MIN_VALUE = 0;
  InterestGroup.ExecutionMode.MAX_VALUE = 2;
  InterestGroup.ExecutionMode.DEFAULT_VALUE = 0;

  InterestGroup.ExecutionMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  InterestGroup.ExecutionMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  InterestGroup.ExecutionMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  InterestGroup.TrustedBiddingSignalsSlotSizeMode = {};
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.kNone = 0;
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.kSlotSize = 1;
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.kAllSlotsRequestedSizes = 2;
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.MIN_VALUE = 0;
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.MAX_VALUE = 2;
  InterestGroup.TrustedBiddingSignalsSlotSizeMode.DEFAULT_VALUE = 0;

  InterestGroup.TrustedBiddingSignalsSlotSizeMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  InterestGroup.TrustedBiddingSignalsSlotSizeMode.toKnownEnumValue = function(value) {
    if (this.isKnownEnumValue(value))
      return value;
    return this.DEFAULT_VALUE;
  };

  InterestGroup.TrustedBiddingSignalsSlotSizeMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  InterestGroup.prototype.initDefaults_ = function() {
    this.expiry = null;
    this.owner = null;
    this.name = null;
    this.priority = 0.0;
    this.enableBiddingSignalsPrioritization = false;
    this.executionMode = InterestGroup.ExecutionMode.kCompatibilityMode;
    this.priorityVector = null;
    this.prioritySignalsOverrides = null;
    this.sellerCapabilities = null;
    this.allSellersCapabilities = null;
    this.trustedBiddingSignalsSlotSizeMode = InterestGroup.TrustedBiddingSignalsSlotSizeMode.kNone;
    this.maxTrustedBiddingSignalsUrlLength = 0;
    this.biddingUrl = null;
    this.biddingWasmHelperUrl = null;
    this.updateUrl = null;
    this.trustedBiddingSignalsUrl = null;
    this.trustedBiddingSignalsKeys = null;
    this.trustedBiddingSignalsCoordinator = null;
    this.viewAndClickCountsProviders = null;
    this.userBiddingSignals = null;
    this.ads = null;
    this.adComponents = null;
    this.adSizes = null;
    this.sizeGroups = null;
    this.auctionServerRequestFlags = null;
    this.additionalBidKey = null;
    this.aggregationCoordinatorOrigin = null;
  };
  InterestGroup.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  InterestGroup.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 208}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.expiry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.owner
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate InterestGroup.priorityVector
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 40, true, codec.String, codec.Double, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.prioritySignalsOverrides
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 48, true, codec.String, codec.Double, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.sellerCapabilities
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 56, true, new codec.PointerTo(origin$.Origin), new codec.PointerTo(SellerCapabilities), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.allSellersCapabilities
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, SellerCapabilities, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.executionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, InterestGroup.ExecutionMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.trustedBiddingSignalsSlotSizeMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 72, InterestGroup.TrustedBiddingSignalsSlotSizeMode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.biddingUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.biddingWasmHelperUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.updateUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.trustedBiddingSignalsUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.trustedBiddingSignalsKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 112, 8, codec.String, true, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate InterestGroup.trustedBiddingSignalsCoordinator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.viewAndClickCountsProviders
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 128, 8, new codec.PointerTo(origin$.Origin), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.userBiddingSignals
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 136, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.ads
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(InterestGroupAd), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.adComponents
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 152, 8, new codec.PointerTo(InterestGroupAd), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.adSizes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 160, true, codec.String, new codec.PointerTo(ad_display_size$.AdSize), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.sizeGroups
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 168, true, codec.String, new codec.ArrayOf(codec.String), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.auctionServerRequestFlags
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, AuctionServerRequestFlags, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.additionalBidKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 184, 1, codec.Uint8, true, [32], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate InterestGroup.aggregationCoordinatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  InterestGroup.encodedSize = codec.kStructHeaderSize + 200;

  InterestGroup.decode = function(decoder) {
    var packed;
    var val = new InterestGroup();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.expiry =
        decoder.decodeStructPointer(time$.Time);
    val.owner =
        decoder.decodeStructPointer(origin$.Origin);
    val.name =
        decoder.decodeStruct(codec.String);
    val.priority =
        decoder.decodeStruct(codec.Double);
    packed = decoder.readUint8();
    val.enableBiddingSignalsPrioritization = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.executionMode =
        decoder.decodeStruct(new codec.Enum(InterestGroup.ExecutionMode));
    val.priorityVector =
        decoder.decodeMapPointer(codec.String, codec.Double);
    val.prioritySignalsOverrides =
        decoder.decodeMapPointer(codec.String, codec.Double);
    val.sellerCapabilities =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(SellerCapabilities));
    val.allSellersCapabilities =
        decoder.decodeStructPointer(SellerCapabilities);
    val.trustedBiddingSignalsSlotSizeMode =
        decoder.decodeStruct(new codec.Enum(InterestGroup.TrustedBiddingSignalsSlotSizeMode));
    val.maxTrustedBiddingSignalsUrlLength =
        decoder.decodeStruct(codec.Int32);
    val.biddingUrl =
        decoder.decodeStructPointer(url$.Url);
    val.biddingWasmHelperUrl =
        decoder.decodeStructPointer(url$.Url);
    val.updateUrl =
        decoder.decodeStructPointer(url$.Url);
    val.trustedBiddingSignalsUrl =
        decoder.decodeStructPointer(url$.Url);
    val.trustedBiddingSignalsKeys =
        decoder.decodeArrayPointer(codec.String);
    val.trustedBiddingSignalsCoordinator =
        decoder.decodeStructPointer(origin$.Origin);
    val.viewAndClickCountsProviders =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    val.userBiddingSignals =
        decoder.decodeStruct(codec.String);
    val.ads =
        decoder.decodeArrayPointer(new codec.PointerTo(InterestGroupAd));
    val.adComponents =
        decoder.decodeArrayPointer(new codec.PointerTo(InterestGroupAd));
    val.adSizes =
        decoder.decodeMapPointer(codec.String, new codec.PointerTo(ad_display_size$.AdSize));
    val.sizeGroups =
        decoder.decodeMapPointer(codec.String, new codec.ArrayOf(codec.String));
    val.auctionServerRequestFlags =
        decoder.decodeStructPointer(AuctionServerRequestFlags);
    val.additionalBidKey =
        decoder.decodeArrayPointer(codec.Uint8);
    val.aggregationCoordinatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  InterestGroup.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(InterestGroup.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.expiry);
    encoder.encodeStructPointer(origin$.Origin, val.owner);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.Double, val.priority);
    packed = 0;
    packed |= (val.enableBiddingSignalsPrioritization & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.executionMode);
    encoder.encodeMapPointer(codec.String, codec.Double, val.priorityVector);
    encoder.encodeMapPointer(codec.String, codec.Double, val.prioritySignalsOverrides);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(SellerCapabilities), val.sellerCapabilities);
    encoder.encodeStructPointer(SellerCapabilities, val.allSellersCapabilities);
    encoder.encodeStruct(codec.Int32, val.trustedBiddingSignalsSlotSizeMode);
    encoder.encodeStruct(codec.Int32, val.maxTrustedBiddingSignalsUrlLength);
    encoder.encodeStructPointer(url$.Url, val.biddingUrl);
    encoder.encodeStructPointer(url$.Url, val.biddingWasmHelperUrl);
    encoder.encodeStructPointer(url$.Url, val.updateUrl);
    encoder.encodeStructPointer(url$.Url, val.trustedBiddingSignalsUrl);
    encoder.encodeArrayPointer(codec.String, val.trustedBiddingSignalsKeys);
    encoder.encodeStructPointer(origin$.Origin, val.trustedBiddingSignalsCoordinator);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.viewAndClickCountsProviders);
    encoder.encodeStruct(codec.String, val.userBiddingSignals);
    encoder.encodeArrayPointer(new codec.PointerTo(InterestGroupAd), val.ads);
    encoder.encodeArrayPointer(new codec.PointerTo(InterestGroupAd), val.adComponents);
    encoder.encodeMapPointer(codec.String, new codec.PointerTo(ad_display_size$.AdSize), val.adSizes);
    encoder.encodeMapPointer(codec.String, new codec.ArrayOf(codec.String), val.sizeGroups);
    encoder.encodeStructPointer(AuctionServerRequestFlags, val.auctionServerRequestFlags);
    encoder.encodeArrayPointer(codec.Uint8, val.additionalBidKey);
    encoder.encodeStructPointer(origin$.Origin, val.aggregationCoordinatorOrigin);
  };
  function PreviousWin(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PreviousWin.prototype.initDefaults_ = function() {
    this.time = null;
    this.adJson = null;
  };
  PreviousWin.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PreviousWin.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PreviousWin.time
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PreviousWin.adJson
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PreviousWin.encodedSize = codec.kStructHeaderSize + 16;

  PreviousWin.decode = function(decoder) {
    var packed;
    var val = new PreviousWin();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.time =
        decoder.decodeStructPointer(time$.Time);
    val.adJson =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PreviousWin.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PreviousWin.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.time);
    encoder.encodeStruct(codec.String, val.adJson);
  };
  function ViewOrClickCounts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewOrClickCounts.prototype.initDefaults_ = function() {
    this.pastHour = 0;
    this.pastDay = 0;
    this.pastWeek = 0;
    this.past30Days = 0;
    this.past90Days = 0;
  };
  ViewOrClickCounts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewOrClickCounts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;






    return validator.validationError.NONE;
  };

  ViewOrClickCounts.encodedSize = codec.kStructHeaderSize + 24;

  ViewOrClickCounts.decode = function(decoder) {
    var packed;
    var val = new ViewOrClickCounts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pastHour =
        decoder.decodeStruct(codec.Int32);
    val.pastDay =
        decoder.decodeStruct(codec.Int32);
    val.pastWeek =
        decoder.decodeStruct(codec.Int32);
    val.past30Days =
        decoder.decodeStruct(codec.Int32);
    val.past90Days =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ViewOrClickCounts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewOrClickCounts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.pastHour);
    encoder.encodeStruct(codec.Int32, val.pastDay);
    encoder.encodeStruct(codec.Int32, val.pastWeek);
    encoder.encodeStruct(codec.Int32, val.past30Days);
    encoder.encodeStruct(codec.Int32, val.past90Days);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ViewAndClickCounts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewAndClickCounts.prototype.initDefaults_ = function() {
    this.viewCounts = null;
    this.clickCounts = null;
  };
  ViewAndClickCounts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewAndClickCounts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewAndClickCounts.viewCounts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ViewOrClickCounts, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewAndClickCounts.clickCounts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ViewOrClickCounts, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewAndClickCounts.encodedSize = codec.kStructHeaderSize + 16;

  ViewAndClickCounts.decode = function(decoder) {
    var packed;
    var val = new ViewAndClickCounts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.viewCounts =
        decoder.decodeStructPointer(ViewOrClickCounts);
    val.clickCounts =
        decoder.decodeStructPointer(ViewOrClickCounts);
    return val;
  };

  ViewAndClickCounts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewAndClickCounts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ViewOrClickCounts, val.viewCounts);
    encoder.encodeStructPointer(ViewOrClickCounts, val.clickCounts);
  };
  function BiddingBrowserSignals(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BiddingBrowserSignals.prototype.initDefaults_ = function() {
    this.joinCount = 0;
    this.bidCount = 0;
    this.prevWins = null;
    this.forDebuggingOnlyInCooldownOrLockout = false;
    this.viewAndClickCounts = null;
  };
  BiddingBrowserSignals.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BiddingBrowserSignals.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BiddingBrowserSignals.prevWins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(PreviousWin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BiddingBrowserSignals.viewAndClickCounts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, ViewAndClickCounts, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BiddingBrowserSignals.encodedSize = codec.kStructHeaderSize + 32;

  BiddingBrowserSignals.decode = function(decoder) {
    var packed;
    var val = new BiddingBrowserSignals();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.joinCount =
        decoder.decodeStruct(codec.Int32);
    val.bidCount =
        decoder.decodeStruct(codec.Int32);
    val.prevWins =
        decoder.decodeArrayPointer(new codec.PointerTo(PreviousWin));
    packed = decoder.readUint8();
    val.forDebuggingOnlyInCooldownOrLockout = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.viewAndClickCounts =
        decoder.decodeStructPointer(ViewAndClickCounts);
    return val;
  };

  BiddingBrowserSignals.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BiddingBrowserSignals.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.joinCount);
    encoder.encodeStruct(codec.Int32, val.bidCount);
    encoder.encodeArrayPointer(new codec.PointerTo(PreviousWin), val.prevWins);
    packed = 0;
    packed |= (val.forDebuggingOnlyInCooldownOrLockout & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ViewAndClickCounts, val.viewAndClickCounts);
  };
  function StorageInterestGroup(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StorageInterestGroup.prototype.initDefaults_ = function() {
    this.interestGroup = null;
    this.biddingBrowserSignals = null;
    this.joiningOrigin = null;
    this.joinTime = null;
    this.lastUpdated = null;
    this.nextUpdateAfter = null;
    this.estimatedSize = 0;
  };
  StorageInterestGroup.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StorageInterestGroup.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.interestGroup
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, InterestGroup, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.biddingBrowserSignals
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, BiddingBrowserSignals, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.joiningOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.joinTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.lastUpdated
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StorageInterestGroup.nextUpdateAfter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  StorageInterestGroup.encodedSize = codec.kStructHeaderSize + 56;

  StorageInterestGroup.decode = function(decoder) {
    var packed;
    var val = new StorageInterestGroup();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interestGroup =
        decoder.decodeStructPointer(InterestGroup);
    val.biddingBrowserSignals =
        decoder.decodeStructPointer(BiddingBrowserSignals);
    val.joiningOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.joinTime =
        decoder.decodeStructPointer(time$.Time);
    val.lastUpdated =
        decoder.decodeStructPointer(time$.Time);
    val.nextUpdateAfter =
        decoder.decodeStructPointer(time$.Time);
    val.estimatedSize =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  StorageInterestGroup.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StorageInterestGroup.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(InterestGroup, val.interestGroup);
    encoder.encodeStructPointer(BiddingBrowserSignals, val.biddingBrowserSignals);
    encoder.encodeStructPointer(origin$.Origin, val.joiningOrigin);
    encoder.encodeStructPointer(time$.Time, val.joinTime);
    encoder.encodeStructPointer(time$.Time, val.lastUpdated);
    encoder.encodeStructPointer(time$.Time, val.nextUpdateAfter);
    encoder.encodeStruct(codec.Uint64, val.estimatedSize);
  };
  function DirectFromSellerSignalsSubresource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectFromSellerSignalsSubresource.prototype.initDefaults_ = function() {
    this.bundleUrl = null;
    this.token = null;
  };
  DirectFromSellerSignalsSubresource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectFromSellerSignalsSubresource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignalsSubresource.bundleUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignalsSubresource.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectFromSellerSignalsSubresource.encodedSize = codec.kStructHeaderSize + 16;

  DirectFromSellerSignalsSubresource.decode = function(decoder) {
    var packed;
    var val = new DirectFromSellerSignalsSubresource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bundleUrl =
        decoder.decodeStructPointer(url$.Url);
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  DirectFromSellerSignalsSubresource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectFromSellerSignalsSubresource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.bundleUrl);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
  };
  function DirectFromSellerSignals(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DirectFromSellerSignals.prototype.initDefaults_ = function() {
    this.prefix = null;
    this.perBuyerSignals = null;
    this.sellerSignals = null;
    this.auctionSignals = null;
  };
  DirectFromSellerSignals.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DirectFromSellerSignals.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignals.prefix
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignals.perBuyerSignals
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.PointerTo(origin$.Origin), new codec.PointerTo(DirectFromSellerSignalsSubresource), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignals.sellerSignals
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, DirectFromSellerSignalsSubresource, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DirectFromSellerSignals.auctionSignals
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, DirectFromSellerSignalsSubresource, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DirectFromSellerSignals.encodedSize = codec.kStructHeaderSize + 32;

  DirectFromSellerSignals.decode = function(decoder) {
    var packed;
    var val = new DirectFromSellerSignals();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prefix =
        decoder.decodeStructPointer(url$.Url);
    val.perBuyerSignals =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(DirectFromSellerSignalsSubresource));
    val.sellerSignals =
        decoder.decodeStructPointer(DirectFromSellerSignalsSubresource);
    val.auctionSignals =
        decoder.decodeStructPointer(DirectFromSellerSignalsSubresource);
    return val;
  };

  DirectFromSellerSignals.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DirectFromSellerSignals.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.prefix);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(DirectFromSellerSignalsSubresource), val.perBuyerSignals);
    encoder.encodeStructPointer(DirectFromSellerSignalsSubresource, val.sellerSignals);
    encoder.encodeStructPointer(DirectFromSellerSignalsSubresource, val.auctionSignals);
  };
  function AuctionAdConfigBuyerTimeouts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionAdConfigBuyerTimeouts.prototype.initDefaults_ = function() {
    this.allBuyersTimeout = null;
    this.perBuyerTimeouts = null;
  };
  AuctionAdConfigBuyerTimeouts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionAdConfigBuyerTimeouts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigBuyerTimeouts.allBuyersTimeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigBuyerTimeouts.perBuyerTimeouts
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, true, new codec.PointerTo(origin$.Origin), new codec.PointerTo(time$.TimeDelta), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuctionAdConfigBuyerTimeouts.encodedSize = codec.kStructHeaderSize + 16;

  AuctionAdConfigBuyerTimeouts.decode = function(decoder) {
    var packed;
    var val = new AuctionAdConfigBuyerTimeouts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allBuyersTimeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.perBuyerTimeouts =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(time$.TimeDelta));
    return val;
  };

  AuctionAdConfigBuyerTimeouts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionAdConfigBuyerTimeouts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.allBuyersTimeout);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(time$.TimeDelta), val.perBuyerTimeouts);
  };
  function AdCurrency(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdCurrency.prototype.initDefaults_ = function() {
    this.currencyCode = null;
  };
  AdCurrency.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdCurrency.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdCurrency.currencyCode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdCurrency.encodedSize = codec.kStructHeaderSize + 8;

  AdCurrency.decode = function(decoder) {
    var packed;
    var val = new AdCurrency();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.currencyCode =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AdCurrency.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdCurrency.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.currencyCode);
  };
  function AuctionAdConfigBuyerCurrencies(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionAdConfigBuyerCurrencies.prototype.initDefaults_ = function() {
    this.allBuyersCurrency = null;
    this.perBuyerCurrencies = null;
  };
  AuctionAdConfigBuyerCurrencies.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionAdConfigBuyerCurrencies.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigBuyerCurrencies.allBuyersCurrency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AdCurrency, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigBuyerCurrencies.perBuyerCurrencies
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, true, new codec.PointerTo(origin$.Origin), new codec.PointerTo(AdCurrency), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuctionAdConfigBuyerCurrencies.encodedSize = codec.kStructHeaderSize + 16;

  AuctionAdConfigBuyerCurrencies.decode = function(decoder) {
    var packed;
    var val = new AuctionAdConfigBuyerCurrencies();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.allBuyersCurrency =
        decoder.decodeStructPointer(AdCurrency);
    val.perBuyerCurrencies =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(AdCurrency));
    return val;
  };

  AuctionAdConfigBuyerCurrencies.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionAdConfigBuyerCurrencies.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AdCurrency, val.allBuyersCurrency);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(AdCurrency), val.perBuyerCurrencies);
  };
  function AuctionAdServerResponseConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionAdServerResponseConfig.prototype.initDefaults_ = function() {
    this.requestId = null;
  };
  AuctionAdServerResponseConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionAdServerResponseConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdServerResponseConfig.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, uuid$.Uuid, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuctionAdServerResponseConfig.encodedSize = codec.kStructHeaderSize + 8;

  AuctionAdServerResponseConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionAdServerResponseConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(uuid$.Uuid);
    return val;
  };

  AuctionAdServerResponseConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionAdServerResponseConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(uuid$.Uuid, val.requestId);
  };
  function AuctionReportBuyerDebugModeConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionReportBuyerDebugModeConfig.prototype.initDefaults_ = function() {
    this.isEnabled = false;
    this.debug_key_$flag = false;
    this.debug_key_$value = 0;
  };
  AuctionReportBuyerDebugModeConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionReportBuyerDebugModeConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  AuctionReportBuyerDebugModeConfig.encodedSize = codec.kStructHeaderSize + 16;

  AuctionReportBuyerDebugModeConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionReportBuyerDebugModeConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isEnabled = (packed >> 0) & 1 ? true : false;
    val.debug_key_$flag = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.debug_key_$value =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  AuctionReportBuyerDebugModeConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionReportBuyerDebugModeConfig.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isEnabled & 1) << 0
    packed |= (val.debug_key_$flag & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint64, val.debug_key_$value);
  };
  function AuctionReportBuyersConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionReportBuyersConfig.prototype.initDefaults_ = function() {
    this.bucket = null;
    this.scale = 0;
  };
  AuctionReportBuyersConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionReportBuyersConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionReportBuyersConfig.bucket
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, int128$.Uint128, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AuctionReportBuyersConfig.encodedSize = codec.kStructHeaderSize + 16;

  AuctionReportBuyersConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionReportBuyersConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bucket =
        decoder.decodeStructPointer(int128$.Uint128);
    val.scale =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  AuctionReportBuyersConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionReportBuyersConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(int128$.Uint128, val.bucket);
    encoder.encodeStruct(codec.Double, val.scale);
  };
  function AuctionAdConfigNonSharedParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  AuctionAdConfigNonSharedParams.BuyerReportType = {};
  AuctionAdConfigNonSharedParams.BuyerReportType.kInterestGroupCount = 0;
  AuctionAdConfigNonSharedParams.BuyerReportType.kBidCount = 1;
  AuctionAdConfigNonSharedParams.BuyerReportType.kTotalGenerateBidLatency = 2;
  AuctionAdConfigNonSharedParams.BuyerReportType.kTotalSignalsFetchLatency = 3;
  AuctionAdConfigNonSharedParams.BuyerReportType.MIN_VALUE = 0;
  AuctionAdConfigNonSharedParams.BuyerReportType.MAX_VALUE = 3;

  AuctionAdConfigNonSharedParams.BuyerReportType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AuctionAdConfigNonSharedParams.BuyerReportType.toKnownEnumValue = function(value) {
    return value;
  };

  AuctionAdConfigNonSharedParams.BuyerReportType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  AuctionAdConfigNonSharedParams.RealTimeReportingType = {};
  AuctionAdConfigNonSharedParams.RealTimeReportingType.kDefaultLocalReporting = 0;
  AuctionAdConfigNonSharedParams.RealTimeReportingType.MIN_VALUE = 0;
  AuctionAdConfigNonSharedParams.RealTimeReportingType.MAX_VALUE = 0;

  AuctionAdConfigNonSharedParams.RealTimeReportingType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  AuctionAdConfigNonSharedParams.RealTimeReportingType.toKnownEnumValue = function(value) {
    return value;
  };

  AuctionAdConfigNonSharedParams.RealTimeReportingType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  AuctionAdConfigNonSharedParams.prototype.initDefaults_ = function() {
    this.interestGroupBuyers = null;
    this.auctionSignals = null;
    this.sellerSignals = null;
    this.sellerTkvSignals = null;
    this.sellerTimeout = null;
    this.perBuyerSignals = null;
    this.perBuyerTkvSignals = null;
    this.buyerTimeouts = null;
    this.reportingTimeout = null;
    this.sellerCurrency = null;
    this.buyerCurrencies = null;
    this.buyerCumulativeTimeouts = null;
    this.perBuyerGroupLimits = null;
    this.perBuyerPrioritySignals = null;
    this.allBuyersPrioritySignals = null;
    this.allBuyersGroupLimit = 65535;
    this.allBuyersMultiBidLimit = 0;
    this.seller_real_time_reporting_type_$flag = false;
    this.auctionReportBuyerKeys = null;
    this.auctionReportBuyers = null;
    this.auctionReportBuyerDebugModeConfig = null;
    this.requiredSellerCapabilities = null;
    this.requestedSize = null;
    this.allSlotsRequestedSizes = null;
    this.perBuyerMultiBidLimits = null;
    this.auctionNonce = null;
    this.seller_real_time_reporting_type_$value = 0;
    this.maxTrustedScoringSignalsUrlLength = 0;
    this.perBuyerRealTimeReportingTypes = null;
    this.componentAuctions = null;
    this.deprecatedRenderUrlReplacements = null;
    this.trustedScoringSignalsCoordinator = null;
    this.executionMode = InterestGroup.ExecutionMode.kCompatibilityMode;
  };
  AuctionAdConfigNonSharedParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionAdConfigNonSharedParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 312}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.interestGroupBuyers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(origin$.Origin), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.auctionSignals
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, AuctionAdConfigMaybePromiseJson, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.sellerSignals
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, AuctionAdConfigMaybePromiseJson, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.sellerTkvSignals
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 40, AuctionAdConfigMaybePromiseJson, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.sellerTimeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerSignals
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 64, AuctionAdConfigMaybePromisePerBuyerSignals, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerTkvSignals
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 80, false, new codec.PointerTo(origin$.Origin), AuctionAdConfigMaybePromiseJson, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.buyerTimeouts
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 88, AuctionAdConfigMaybePromiseBuyerTimeouts, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.reportingTimeout
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.sellerCurrency
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, AdCurrency, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.buyerCurrencies
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 120, AuctionAdConfigMaybePromiseBuyerCurrencies, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.buyerCumulativeTimeouts
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 136, AuctionAdConfigMaybePromiseBuyerTimeouts, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerGroupLimits
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 152, false, new codec.PointerTo(origin$.Origin), codec.Uint16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerPrioritySignals
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 160, true, new codec.PointerTo(origin$.Origin), new codec.MapOf(codec.String, codec.Double), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.allBuyersPrioritySignals
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 168, true, codec.String, codec.Double, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuctionAdConfigNonSharedParams.auctionReportBuyerKeys
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 184, 8, new codec.PointerTo(int128$.Uint128), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.auctionReportBuyers
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 192, true, new codec.Enum(AuctionAdConfigNonSharedParams.BuyerReportType), new codec.PointerTo(AuctionReportBuyersConfig), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.auctionReportBuyerDebugModeConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 200, AuctionReportBuyerDebugModeConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.requiredSellerCapabilities
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 208, SellerCapabilities, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.requestedSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, ad_display_size$.AdSize, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.allSlotsRequestedSizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 224, 8, new codec.PointerTo(ad_display_size$.AdSize), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerMultiBidLimits
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 232, false, new codec.PointerTo(origin$.Origin), codec.Uint16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuctionAdConfigNonSharedParams.auctionNonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 240, uuid$.Uuid, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuctionAdConfigNonSharedParams.seller_real_time_reporting_type_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 248, AuctionAdConfigNonSharedParams.RealTimeReportingType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.perBuyerRealTimeReportingTypes
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 256, true, new codec.PointerTo(origin$.Origin), new codec.Enum(AuctionAdConfigNonSharedParams.RealTimeReportingType), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.componentAuctions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 264, 8, new codec.PointerTo(AuctionAdConfig), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.deprecatedRenderUrlReplacements
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 272, AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuctionAdConfigNonSharedParams.trustedScoringSignalsCoordinator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 288, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfigNonSharedParams.executionMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 296, InterestGroup.ExecutionMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AuctionAdConfigNonSharedParams.encodedSize = codec.kStructHeaderSize + 304;

  AuctionAdConfigNonSharedParams.decode = function(decoder) {
    var packed;
    var val = new AuctionAdConfigNonSharedParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.interestGroupBuyers =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    val.auctionSignals =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseJson);
    val.sellerSignals =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseJson);
    val.sellerTkvSignals =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseJson);
    val.sellerTimeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.perBuyerSignals =
        decoder.decodeStruct(AuctionAdConfigMaybePromisePerBuyerSignals);
    val.perBuyerTkvSignals =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), AuctionAdConfigMaybePromiseJson);
    val.buyerTimeouts =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseBuyerTimeouts);
    val.reportingTimeout =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.sellerCurrency =
        decoder.decodeStructPointer(AdCurrency);
    val.buyerCurrencies =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseBuyerCurrencies);
    val.buyerCumulativeTimeouts =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseBuyerTimeouts);
    val.perBuyerGroupLimits =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16);
    val.perBuyerPrioritySignals =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.MapOf(codec.String, codec.Double));
    val.allBuyersPrioritySignals =
        decoder.decodeMapPointer(codec.String, codec.Double);
    val.allBuyersGroupLimit =
        decoder.decodeStruct(codec.Uint16);
    val.allBuyersMultiBidLimit =
        decoder.decodeStruct(codec.Uint16);
    packed = decoder.readUint8();
    val.seller_real_time_reporting_type_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.auctionReportBuyerKeys =
        decoder.decodeArrayPointer(new codec.PointerTo(int128$.Uint128));
    val.auctionReportBuyers =
        decoder.decodeMapPointer(new codec.Enum(AuctionAdConfigNonSharedParams.BuyerReportType), new codec.PointerTo(AuctionReportBuyersConfig));
    val.auctionReportBuyerDebugModeConfig =
        decoder.decodeStructPointer(AuctionReportBuyerDebugModeConfig);
    val.requiredSellerCapabilities =
        decoder.decodeStructPointer(SellerCapabilities);
    val.requestedSize =
        decoder.decodeStructPointer(ad_display_size$.AdSize);
    val.allSlotsRequestedSizes =
        decoder.decodeArrayPointer(new codec.PointerTo(ad_display_size$.AdSize));
    val.perBuyerMultiBidLimits =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16);
    val.auctionNonce =
        decoder.decodeStructPointer(uuid$.Uuid);
    val.seller_real_time_reporting_type_$value =
        decoder.decodeStruct(new codec.Enum(AuctionAdConfigNonSharedParams.RealTimeReportingType));
    val.maxTrustedScoringSignalsUrlLength =
        decoder.decodeStruct(codec.Int32);
    val.perBuyerRealTimeReportingTypes =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.Enum(AuctionAdConfigNonSharedParams.RealTimeReportingType));
    val.componentAuctions =
        decoder.decodeArrayPointer(new codec.PointerTo(AuctionAdConfig));
    val.deprecatedRenderUrlReplacements =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements);
    val.trustedScoringSignalsCoordinator =
        decoder.decodeStructPointer(origin$.Origin);
    val.executionMode =
        decoder.decodeStruct(new codec.Enum(InterestGroup.ExecutionMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AuctionAdConfigNonSharedParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionAdConfigNonSharedParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.interestGroupBuyers);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseJson, val.auctionSignals);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseJson, val.sellerSignals);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseJson, val.sellerTkvSignals);
    encoder.encodeStructPointer(time$.TimeDelta, val.sellerTimeout);
    encoder.encodeStruct(AuctionAdConfigMaybePromisePerBuyerSignals, val.perBuyerSignals);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), AuctionAdConfigMaybePromiseJson, val.perBuyerTkvSignals);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseBuyerTimeouts, val.buyerTimeouts);
    encoder.encodeStructPointer(time$.TimeDelta, val.reportingTimeout);
    encoder.encodeStructPointer(AdCurrency, val.sellerCurrency);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseBuyerCurrencies, val.buyerCurrencies);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseBuyerTimeouts, val.buyerCumulativeTimeouts);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16, val.perBuyerGroupLimits);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.MapOf(codec.String, codec.Double), val.perBuyerPrioritySignals);
    encoder.encodeMapPointer(codec.String, codec.Double, val.allBuyersPrioritySignals);
    encoder.encodeStruct(codec.Uint16, val.allBuyersGroupLimit);
    encoder.encodeStruct(codec.Uint16, val.allBuyersMultiBidLimit);
    packed = 0;
    packed |= (val.seller_real_time_reporting_type_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(int128$.Uint128), val.auctionReportBuyerKeys);
    encoder.encodeMapPointer(new codec.Enum(AuctionAdConfigNonSharedParams.BuyerReportType), new codec.PointerTo(AuctionReportBuyersConfig), val.auctionReportBuyers);
    encoder.encodeStructPointer(AuctionReportBuyerDebugModeConfig, val.auctionReportBuyerDebugModeConfig);
    encoder.encodeStructPointer(SellerCapabilities, val.requiredSellerCapabilities);
    encoder.encodeStructPointer(ad_display_size$.AdSize, val.requestedSize);
    encoder.encodeArrayPointer(new codec.PointerTo(ad_display_size$.AdSize), val.allSlotsRequestedSizes);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16, val.perBuyerMultiBidLimits);
    encoder.encodeStructPointer(uuid$.Uuid, val.auctionNonce);
    encoder.encodeStruct(codec.Int32, val.seller_real_time_reporting_type_$value);
    encoder.encodeStruct(codec.Int32, val.maxTrustedScoringSignalsUrlLength);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.Enum(AuctionAdConfigNonSharedParams.RealTimeReportingType), val.perBuyerRealTimeReportingTypes);
    encoder.encodeArrayPointer(new codec.PointerTo(AuctionAdConfig), val.componentAuctions);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements, val.deprecatedRenderUrlReplacements);
    encoder.encodeStructPointer(origin$.Origin, val.trustedScoringSignalsCoordinator);
    encoder.encodeStruct(codec.Int32, val.executionMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AuctionAdConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionAdConfig.prototype.initDefaults_ = function() {
    this.seller = null;
    this.serverResponse = null;
    this.decisionLogicUrl = null;
    this.trustedScoringSignalsUrl = null;
    this.auctionAdConfigNonSharedParams = null;
    this.directFromSellerSignals = null;
    this.expectsDirectFromSellerSignalsHeaderAdSlot = false;
    this.seller_experiment_group_id_$flag = false;
    this.all_buyer_experiment_group_id_$flag = false;
    this.expectsAdditionalBids = false;
    this.send_creative_scanning_metadata_$flag = false;
    this.send_creative_scanning_metadata_$value = false;
    this.seller_experiment_group_id_$value = 0;
    this.all_buyer_experiment_group_id_$value = 0;
    this.perBuyerExperimentGroupIds = null;
    this.aggregationCoordinatorOrigin = null;
  };
  AuctionAdConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionAdConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 88}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.seller
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.serverResponse
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, AuctionAdServerResponseConfig, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.decisionLogicUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.trustedScoringSignalsUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.auctionAdConfigNonSharedParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, AuctionAdConfigNonSharedParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionAdConfig.directFromSellerSignals
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 40, AuctionAdConfigMaybePromiseDirectFromSellerSignals, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate AuctionAdConfig.perBuyerExperimentGroupIds
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 64, false, new codec.PointerTo(origin$.Origin), codec.Uint16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AuctionAdConfig.aggregationCoordinatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AuctionAdConfig.encodedSize = codec.kStructHeaderSize + 80;

  AuctionAdConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionAdConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seller =
        decoder.decodeStructPointer(origin$.Origin);
    val.serverResponse =
        decoder.decodeStructPointer(AuctionAdServerResponseConfig);
    val.decisionLogicUrl =
        decoder.decodeStructPointer(url$.Url);
    val.trustedScoringSignalsUrl =
        decoder.decodeStructPointer(url$.Url);
    val.auctionAdConfigNonSharedParams =
        decoder.decodeStructPointer(AuctionAdConfigNonSharedParams);
    val.directFromSellerSignals =
        decoder.decodeStruct(AuctionAdConfigMaybePromiseDirectFromSellerSignals);
    packed = decoder.readUint8();
    val.expectsDirectFromSellerSignalsHeaderAdSlot = (packed >> 0) & 1 ? true : false;
    val.seller_experiment_group_id_$flag = (packed >> 1) & 1 ? true : false;
    val.all_buyer_experiment_group_id_$flag = (packed >> 2) & 1 ? true : false;
    val.expectsAdditionalBids = (packed >> 3) & 1 ? true : false;
    val.send_creative_scanning_metadata_$flag = (packed >> 4) & 1 ? true : false;
    val.send_creative_scanning_metadata_$value = (packed >> 5) & 1 ? true : false;
    decoder.skip(1);
    val.seller_experiment_group_id_$value =
        decoder.decodeStruct(codec.Uint16);
    val.all_buyer_experiment_group_id_$value =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    val.perBuyerExperimentGroupIds =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16);
    val.aggregationCoordinatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    return val;
  };

  AuctionAdConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionAdConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.seller);
    encoder.encodeStructPointer(AuctionAdServerResponseConfig, val.serverResponse);
    encoder.encodeStructPointer(url$.Url, val.decisionLogicUrl);
    encoder.encodeStructPointer(url$.Url, val.trustedScoringSignalsUrl);
    encoder.encodeStructPointer(AuctionAdConfigNonSharedParams, val.auctionAdConfigNonSharedParams);
    encoder.encodeStruct(AuctionAdConfigMaybePromiseDirectFromSellerSignals, val.directFromSellerSignals);
    packed = 0;
    packed |= (val.expectsDirectFromSellerSignalsHeaderAdSlot & 1) << 0
    packed |= (val.seller_experiment_group_id_$flag & 1) << 1
    packed |= (val.all_buyer_experiment_group_id_$flag & 1) << 2
    packed |= (val.expectsAdditionalBids & 1) << 3
    packed |= (val.send_creative_scanning_metadata_$flag & 1) << 4
    packed |= (val.send_creative_scanning_metadata_$value & 1) << 5
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.seller_experiment_group_id_$value);
    encoder.encodeStruct(codec.Uint16, val.all_buyer_experiment_group_id_$value);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), codec.Uint16, val.perBuyerExperimentGroupIds);
    encoder.encodeStructPointer(origin$.Origin, val.aggregationCoordinatorOrigin);
  };
  function AuctionDataBuyerConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionDataBuyerConfig.prototype.initDefaults_ = function() {
    this.target_size_$flag = false;
    this.target_size_$value = 0;
  };
  AuctionDataBuyerConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionDataBuyerConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AuctionDataBuyerConfig.encodedSize = codec.kStructHeaderSize + 8;

  AuctionDataBuyerConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionDataBuyerConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.target_size_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.target_size_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AuctionDataBuyerConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionDataBuyerConfig.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.target_size_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.target_size_$value);
  };
  function AuctionDataConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AuctionDataConfig.prototype.initDefaults_ = function() {
    this.perBuyerConfigs = null;
    this.request_size_$flag = false;
    this.request_size_$value = 0;
  };
  AuctionDataConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AuctionDataConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AuctionDataConfig.perBuyerConfigs
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(origin$.Origin), new codec.PointerTo(AuctionDataBuyerConfig), false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AuctionDataConfig.encodedSize = codec.kStructHeaderSize + 16;

  AuctionDataConfig.decode = function(decoder) {
    var packed;
    var val = new AuctionDataConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.perBuyerConfigs =
        decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(AuctionDataBuyerConfig));
    packed = decoder.readUint8();
    val.request_size_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.request_size_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AuctionDataConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AuctionDataConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), new codec.PointerTo(AuctionDataBuyerConfig), val.perBuyerConfigs);
    packed = 0;
    packed |= (val.request_size_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.request_size_$value);
  };
  function AdAuctionPerSellerRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AdAuctionPerSellerRequest.prototype.initDefaults_ = function() {
    this.seller = null;
    this.data = null;
  };
  AdAuctionPerSellerRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdAuctionPerSellerRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionPerSellerRequest.seller
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionPerSellerRequest.data
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, AdAuctionRequestOrError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdAuctionPerSellerRequest.encodedSize = codec.kStructHeaderSize + 24;

  AdAuctionPerSellerRequest.decode = function(decoder) {
    var packed;
    var val = new AdAuctionPerSellerRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seller =
        decoder.decodeStructPointer(origin$.Origin);
    val.data =
        decoder.decodeStruct(AdAuctionRequestOrError);
    return val;
  };

  AdAuctionPerSellerRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdAuctionPerSellerRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.seller);
    encoder.encodeStruct(AdAuctionRequestOrError, val.data);
  };

  function AuctionAdConfigMaybePromiseJson(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromiseJson.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromiseJson.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromiseJson.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromiseJson member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromiseJson.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseJson.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseJson.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseJson.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromiseJson.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseJson.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseJson.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseJson.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromiseJson.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromiseJson.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromiseJson.Tags.value:
          encoder.encodeStruct(codec.String, val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromiseJson.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromiseJson();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromiseJson.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromiseJson.Tags.value:
          result.value = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromiseJson.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromiseJson.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromiseJson.Tags.value:
          

    // validate AuctionAdConfigMaybePromiseJson.value
    err = messageValidator.validateStringPointer(data_offset, true)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromiseJson.encodedSize = 16;

  function AuctionAdConfigMaybePromisePerBuyerSignals(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromisePerBuyerSignals.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromisePerBuyerSignals.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromisePerBuyerSignals.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromisePerBuyerSignals member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromisePerBuyerSignals.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromisePerBuyerSignals.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromisePerBuyerSignals.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromisePerBuyerSignals.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromisePerBuyerSignals.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromisePerBuyerSignals.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromisePerBuyerSignals.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromisePerBuyerSignals.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromisePerBuyerSignals.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.value:
          encoder.encodeMapPointer(new codec.PointerTo(origin$.Origin), codec.String, val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromisePerBuyerSignals.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromisePerBuyerSignals();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.value:
          result.value = decoder.decodeMapPointer(new codec.PointerTo(origin$.Origin), codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromisePerBuyerSignals.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromisePerBuyerSignals.Tags.value:
          

    // validate AuctionAdConfigMaybePromisePerBuyerSignals.value
    err = messageValidator.validateMapPointer(data_offset, true, new codec.PointerTo(origin$.Origin), codec.String, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromisePerBuyerSignals.encodedSize = 16;

  function AuctionAdConfigMaybePromiseBuyerTimeouts(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromiseBuyerTimeouts.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromiseBuyerTimeouts.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromiseBuyerTimeouts.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromiseBuyerTimeouts member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromiseBuyerTimeouts.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseBuyerTimeouts.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromiseBuyerTimeouts.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseBuyerTimeouts.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromiseBuyerTimeouts.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.value:
          encoder.encodeStructPointer(AuctionAdConfigBuyerTimeouts, val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromiseBuyerTimeouts.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromiseBuyerTimeouts();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.value:
          result.value = decoder.decodeStructPointer(AuctionAdConfigBuyerTimeouts);
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromiseBuyerTimeouts.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromiseBuyerTimeouts.Tags.value:
          

    // validate AuctionAdConfigMaybePromiseBuyerTimeouts.value
    err = messageValidator.validateStructPointer(data_offset, AuctionAdConfigBuyerTimeouts, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromiseBuyerTimeouts.encodedSize = 16;

  function AuctionAdConfigMaybePromiseBuyerCurrencies(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromiseBuyerCurrencies.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromiseBuyerCurrencies.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromiseBuyerCurrencies.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromiseBuyerCurrencies member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromiseBuyerCurrencies.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseBuyerCurrencies.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromiseBuyerCurrencies.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseBuyerCurrencies.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromiseBuyerCurrencies.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.value:
          encoder.encodeStructPointer(AuctionAdConfigBuyerCurrencies, val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromiseBuyerCurrencies.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromiseBuyerCurrencies();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.value:
          result.value = decoder.decodeStructPointer(AuctionAdConfigBuyerCurrencies);
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromiseBuyerCurrencies.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromiseBuyerCurrencies.Tags.value:
          

    // validate AuctionAdConfigMaybePromiseBuyerCurrencies.value
    err = messageValidator.validateStructPointer(data_offset, AuctionAdConfigBuyerCurrencies, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromiseBuyerCurrencies.encodedSize = 16;

  function AuctionAdConfigMaybePromiseDirectFromSellerSignals(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromiseDirectFromSellerSignals.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromiseDirectFromSellerSignals.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromiseDirectFromSellerSignals member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromiseDirectFromSellerSignals.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseDirectFromSellerSignals.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromiseDirectFromSellerSignals.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseDirectFromSellerSignals.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromiseDirectFromSellerSignals.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.value:
          encoder.encodeStructPointer(DirectFromSellerSignals, val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromiseDirectFromSellerSignals.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromiseDirectFromSellerSignals();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.value:
          result.value = decoder.decodeStructPointer(DirectFromSellerSignals);
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromiseDirectFromSellerSignals.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromiseDirectFromSellerSignals.Tags.value:
          

    // validate AuctionAdConfigMaybePromiseDirectFromSellerSignals.value
    err = messageValidator.validateStructPointer(data_offset, DirectFromSellerSignals, true);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromiseDirectFromSellerSignals.encodedSize = 16;

  function AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags = {
    promise: 0,
    value: 1,
  };

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "promise",
        "value",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.prototype, "promise", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.promise) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.promise is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.promise;
      this.$data = value;
    }
  });
  Object.defineProperty(AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.prototype, "value", {
    get: function() {
      if (this.$tag != AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.value) {
        throw new ReferenceError(
            "AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.value is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.value;
      this.$data = value;
    }
  });


    AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.promise:
          encoder.encodeStruct(codec.Uint32, val.promise);
          break;
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.value:
          encoder.encodeArrayPointer(new codec.PointerTo(AdKeywordReplacement), val.value);
          break;
      }
      encoder.align();
    };


    AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements();
      var tag = decoder.readUint32();
      switch (tag) {
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.promise:
          result.promise = decoder.decodeStruct(codec.Uint32);
          break;
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.value:
          result.value = decoder.decodeArrayPointer(new codec.PointerTo(AdKeywordReplacement));
          break;
      }
      decoder.align();

      return result;
    };


    AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.promise:
          

          break;
        case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.Tags.value:
          

    // validate AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.value
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(AdKeywordReplacement), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements.encodedSize = 16;

  function AdAuctionRequestOrError(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AdAuctionRequestOrError.Tags = {
    request: 0,
    error: 1,
  };

  AdAuctionRequestOrError.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AdAuctionRequestOrError.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "request",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AdAuctionRequestOrError member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AdAuctionRequestOrError.prototype, "request", {
    get: function() {
      if (this.$tag != AdAuctionRequestOrError.Tags.request) {
        throw new ReferenceError(
            "AdAuctionRequestOrError.request is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AdAuctionRequestOrError.Tags.request;
      this.$data = value;
    }
  });
  Object.defineProperty(AdAuctionRequestOrError.prototype, "error", {
    get: function() {
      if (this.$tag != AdAuctionRequestOrError.Tags.error) {
        throw new ReferenceError(
            "AdAuctionRequestOrError.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AdAuctionRequestOrError.Tags.error;
      this.$data = value;
    }
  });


    AdAuctionRequestOrError.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AdAuctionRequestOrError.Tags.request:
          encoder.encodeStructPointer(big_buffer$.BigBuffer, val.request);
          break;
        case AdAuctionRequestOrError.Tags.error:
          encoder.encodeStruct(codec.String, val.error);
          break;
      }
      encoder.align();
    };


    AdAuctionRequestOrError.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AdAuctionRequestOrError();
      var tag = decoder.readUint32();
      switch (tag) {
        case AdAuctionRequestOrError.Tags.request:
          result.request = decoder.decodeStructPointer(big_buffer$.BigBuffer);
          break;
        case AdAuctionRequestOrError.Tags.error:
          result.error = decoder.decodeStruct(codec.String);
          break;
      }
      decoder.align();

      return result;
    };


    AdAuctionRequestOrError.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AdAuctionRequestOrError.Tags.request:
          
    // validate AdAuctionRequestOrError.request
    err = messageValidator.validateNestedUnion(data_offset, big_buffer$.BigBuffer, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AdAuctionRequestOrError.Tags.error:
          

    // validate AdAuctionRequestOrError.error
    err = messageValidator.validateStringPointer(data_offset, false)
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AdAuctionRequestOrError.encodedSize = 16;
  exports.MAX_INTEREST_GROUP_SIZE = MAX_INTEREST_GROUP_SIZE;
  exports.MAX_ALLOWED_REPORTING_ORIGINS = MAX_ALLOWED_REPORTING_ORIGINS;
  exports.InterestGroupAd = InterestGroupAd;
  exports.SellerCapabilities = SellerCapabilities;
  exports.AuctionServerRequestFlags = AuctionServerRequestFlags;
  exports.AdKeywordReplacement = AdKeywordReplacement;
  exports.InterestGroup = InterestGroup;
  exports.PreviousWin = PreviousWin;
  exports.ViewOrClickCounts = ViewOrClickCounts;
  exports.ViewAndClickCounts = ViewAndClickCounts;
  exports.BiddingBrowserSignals = BiddingBrowserSignals;
  exports.StorageInterestGroup = StorageInterestGroup;
  exports.DirectFromSellerSignalsSubresource = DirectFromSellerSignalsSubresource;
  exports.DirectFromSellerSignals = DirectFromSellerSignals;
  exports.AuctionAdConfigBuyerTimeouts = AuctionAdConfigBuyerTimeouts;
  exports.AdCurrency = AdCurrency;
  exports.AuctionAdConfigBuyerCurrencies = AuctionAdConfigBuyerCurrencies;
  exports.AuctionAdServerResponseConfig = AuctionAdServerResponseConfig;
  exports.AuctionReportBuyerDebugModeConfig = AuctionReportBuyerDebugModeConfig;
  exports.AuctionReportBuyersConfig = AuctionReportBuyersConfig;
  exports.AuctionAdConfigNonSharedParams = AuctionAdConfigNonSharedParams;
  exports.AuctionAdConfig = AuctionAdConfig;
  exports.AuctionDataBuyerConfig = AuctionDataBuyerConfig;
  exports.AuctionDataConfig = AuctionDataConfig;
  exports.AdAuctionPerSellerRequest = AdAuctionPerSellerRequest;
  exports.AuctionAdConfigMaybePromiseJson = AuctionAdConfigMaybePromiseJson;
  exports.AuctionAdConfigMaybePromisePerBuyerSignals = AuctionAdConfigMaybePromisePerBuyerSignals;
  exports.AuctionAdConfigMaybePromiseBuyerTimeouts = AuctionAdConfigMaybePromiseBuyerTimeouts;
  exports.AuctionAdConfigMaybePromiseBuyerCurrencies = AuctionAdConfigMaybePromiseBuyerCurrencies;
  exports.AuctionAdConfigMaybePromiseDirectFromSellerSignals = AuctionAdConfigMaybePromiseDirectFromSellerSignals;
  exports.AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements = AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements;
  exports.AdAuctionRequestOrError = AdAuctionRequestOrError;
})();