// third_party/blink/public/mojom/interest_group/ad_auction_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/interest_group/ad_auction_service.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT AbortableAdAuctionInterceptorForTesting : public AbortableAdAuction {
  virtual AbortableAdAuction* GetForwardingInterface() = 0;
  void ResolvedPromiseParam(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigField field, const std::optional<std::string>& json_value) override;
  void ResolvedPerBuyerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<base::flat_map<::url::Origin, std::string>>& per_buyer_signals) override;
  void ResolvedBuyerTkvSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const ::url::Origin& buyer, const std::optional<std::string>& json_value) override;
  void ResolvedBuyerTimeoutsPromise(AuctionAdConfigAuctionIdPtr auction, AuctionAdConfigBuyerTimeoutField field, const ::blink::AuctionConfig::BuyerTimeouts& buyer_timeouts) override;
  void ResolvedBuyerCurrenciesPromise(AuctionAdConfigAuctionIdPtr auction, const ::blink::AuctionConfig::BuyerCurrencies& per_buyer_currencies) override;
  void ResolvedDirectFromSellerSignalsPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<::blink::DirectFromSellerSignals>& direct_from_seller_signals) override;
  void ResolvedDirectFromSellerSignalsHeaderAdSlotPromise(AuctionAdConfigAuctionIdPtr auction, const std::optional<std::string>& direct_from_seller_signals_header_ad_slot) override;
  void ResolvedDeprecatedRenderURLReplacementsPromise(AuctionAdConfigAuctionIdPtr auction, const std::vector<::blink::AuctionConfig::AdKeywordReplacement>& deprecated_render_url_replacements) override;
  void ResolvedAuctionAdResponsePromise(AuctionAdConfigAuctionIdPtr auction, ::mojo_base::BigBuffer result) override;
  void ResolvedAdditionalBids(AuctionAdConfigAuctionIdPtr auction) override;
  void Abort() override;
};
class BLINK_COMMON_EXPORT AbortableAdAuctionAsyncWaiter {
 public:
  explicit AbortableAdAuctionAsyncWaiter(AbortableAdAuction* proxy);

  AbortableAdAuctionAsyncWaiter(const AbortableAdAuctionAsyncWaiter&) = delete;
  AbortableAdAuctionAsyncWaiter& operator=(const AbortableAdAuctionAsyncWaiter&) = delete;

  ~AbortableAdAuctionAsyncWaiter();

 private:
  AbortableAdAuction* const proxy_;
};


class BLINK_COMMON_EXPORT AdAuctionServiceInterceptorForTesting : public AdAuctionService {
  virtual AdAuctionService* GetForwardingInterface() = 0;
  void CreateAdRequest(::blink::mojom::AdRequestConfigPtr config, CreateAdRequestCallback callback) override;
  void FinalizeAd(const std::string& ads_guid, const ::blink::AuctionConfig& config, FinalizeAdCallback callback) override;
  void RunAdAuction(const ::blink::AuctionConfig& config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, RunAdAuctionCallback callback) override;
  void JoinInterestGroup(const ::blink::InterestGroup& group, JoinInterestGroupCallback callback) override;
  void LeaveInterestGroup(const ::url::Origin& owner, const std::string& name, LeaveInterestGroupCallback callback) override;
  void LeaveInterestGroupForDocument() override;
  void ClearOriginJoinedInterestGroups(const ::url::Origin& owner, const std::vector<std::string>& interest_groups_to_keep, ClearOriginJoinedInterestGroupsCallback callback) override;
  void UpdateAdInterestGroups() override;
  void DeprecatedGetURLFromURN(const ::GURL& uuid_url, bool send_reports, DeprecatedGetURLFromURNCallback callback) override;
  void DeprecatedReplaceInURN(const ::GURL& uuid_url, const std::vector<::blink::AuctionConfig::AdKeywordReplacement>& replacements, DeprecatedReplaceInURNCallback callback) override;
  void GetInterestGroupAdAuctionData(const base::flat_map<::url::Origin, std::optional<::url::Origin>>& sellers, ::blink::mojom::AuctionDataConfigPtr config, GetInterestGroupAdAuctionDataCallback callback) override;
};
class BLINK_COMMON_EXPORT AdAuctionServiceAsyncWaiter {
 public:
  explicit AdAuctionServiceAsyncWaiter(AdAuctionService* proxy);

  AdAuctionServiceAsyncWaiter(const AdAuctionServiceAsyncWaiter&) = delete;
  AdAuctionServiceAsyncWaiter& operator=(const AdAuctionServiceAsyncWaiter&) = delete;

  ~AdAuctionServiceAsyncWaiter();
  void CreateAdRequest(
      ::blink::mojom::AdRequestConfigPtr config, std::optional<std::string>* out_ads_guid);
  std::optional<std::string> CreateAdRequest(::blink::mojom::AdRequestConfigPtr config);
  void FinalizeAd(
      const std::string& ads_guid, const ::blink::AuctionConfig& config, std::optional<::GURL>* out_ad_display_url);
  std::optional<::GURL> FinalizeAd(const std::string& ads_guid, const ::blink::AuctionConfig& config);
  void RunAdAuction(
      const ::blink::AuctionConfig& config, ::mojo::PendingReceiver<AbortableAdAuction> abort_receiver, bool* out_aborted_by_script, std::optional<::blink::FencedFrame::RedactedFencedFrameConfig>* out_config);
  
  void JoinInterestGroup(
      const ::blink::InterestGroup& group, bool* out_failed_well_known_check);
  bool JoinInterestGroup(const ::blink::InterestGroup& group);
  void LeaveInterestGroup(
      const ::url::Origin& owner, const std::string& name, bool* out_failed_well_known_check);
  bool LeaveInterestGroup(const ::url::Origin& owner, const std::string& name);
  void ClearOriginJoinedInterestGroups(
      const ::url::Origin& owner, const std::vector<std::string>& interest_groups_to_keep, bool* out_failed_well_known_check);
  bool ClearOriginJoinedInterestGroups(const ::url::Origin& owner, const std::vector<std::string>& interest_groups_to_keep);
  void DeprecatedGetURLFromURN(
      const ::GURL& uuid_url, bool send_reports, std::optional<::GURL>* out_decoded_url);
  std::optional<::GURL> DeprecatedGetURLFromURN(const ::GURL& uuid_url, bool send_reports);
  void DeprecatedReplaceInURN(
      const ::GURL& uuid_url, const std::vector<::blink::AuctionConfig::AdKeywordReplacement>& replacements);
  
  void GetInterestGroupAdAuctionData(
      const base::flat_map<::url::Origin, std::optional<::url::Origin>>& sellers, ::blink::mojom::AuctionDataConfigPtr config, std::vector<::blink::mojom::AdAuctionPerSellerRequestPtr>* out_requests, std::optional<::base::Uuid>* out_request_id);
  

 private:
  AdAuctionService* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_AUCTION_SERVICE_MOJOM_TEST_UTILS_H_