// third_party/blink/public/mojom/input/text_input_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/input/text_input_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }



  function TextInputHost_GotCharacterIndexAtPoint_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextInputHost_GotCharacterIndexAtPoint_Params.prototype.initDefaults_ = function() {
    this.index = 0;
  };
  TextInputHost_GotCharacterIndexAtPoint_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextInputHost_GotCharacterIndexAtPoint_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TextInputHost_GotCharacterIndexAtPoint_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextInputHost_GotCharacterIndexAtPoint_Params.decode = function(decoder) {
    var packed;
    var val = new TextInputHost_GotCharacterIndexAtPoint_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.index =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TextInputHost_GotCharacterIndexAtPoint_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextInputHost_GotCharacterIndexAtPoint_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.index);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function TextInputHost_GotFirstRectForRange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TextInputHost_GotFirstRectForRange_Params.prototype.initDefaults_ = function() {
    this.rect = null;
  };
  TextInputHost_GotFirstRectForRange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TextInputHost_GotFirstRectForRange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TextInputHost_GotFirstRectForRange_Params.rect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TextInputHost_GotFirstRectForRange_Params.encodedSize = codec.kStructHeaderSize + 8;

  TextInputHost_GotFirstRectForRange_Params.decode = function(decoder) {
    var packed;
    var val = new TextInputHost_GotFirstRectForRange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.rect =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  TextInputHost_GotFirstRectForRange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TextInputHost_GotFirstRectForRange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Rect, val.rect);
  };
  var kTextInputHost_GotCharacterIndexAtPoint_Name = 0;
  var kTextInputHost_GotFirstRectForRange_Name = 1;

  function TextInputHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(TextInputHost,
                                                   handleOrPtrInfo);
  }

  function TextInputHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        TextInputHost, associatedInterfacePtrInfo);
  }

  TextInputHostAssociatedPtr.prototype =
      Object.create(TextInputHostPtr.prototype);
  TextInputHostAssociatedPtr.prototype.constructor =
      TextInputHostAssociatedPtr;

  function TextInputHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  TextInputHostPtr.prototype.gotCharacterIndexAtPoint = function() {
    return TextInputHostProxy.prototype.gotCharacterIndexAtPoint
        .apply(this.ptr.getProxy(), arguments);
  };

  TextInputHostProxy.prototype.gotCharacterIndexAtPoint = function(index) {
    var params_ = new TextInputHost_GotCharacterIndexAtPoint_Params();
    params_.index = index;
    var builder = new codec.MessageV0Builder(
        kTextInputHost_GotCharacterIndexAtPoint_Name,
        codec.align(TextInputHost_GotCharacterIndexAtPoint_Params.encodedSize));
    builder.encodeStruct(TextInputHost_GotCharacterIndexAtPoint_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  TextInputHostPtr.prototype.gotFirstRectForRange = function() {
    return TextInputHostProxy.prototype.gotFirstRectForRange
        .apply(this.ptr.getProxy(), arguments);
  };

  TextInputHostProxy.prototype.gotFirstRectForRange = function(rect) {
    var params_ = new TextInputHost_GotFirstRectForRange_Params();
    params_.rect = rect;
    var builder = new codec.MessageV0Builder(
        kTextInputHost_GotFirstRectForRange_Name,
        codec.align(TextInputHost_GotFirstRectForRange_Params.encodedSize));
    builder.encodeStruct(TextInputHost_GotFirstRectForRange_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function TextInputHostStub(delegate) {
    this.delegate_ = delegate;
  }
  TextInputHostStub.prototype.gotCharacterIndexAtPoint = function(index) {
    return this.delegate_ && this.delegate_.gotCharacterIndexAtPoint && this.delegate_.gotCharacterIndexAtPoint(index);
  }
  TextInputHostStub.prototype.gotFirstRectForRange = function(rect) {
    return this.delegate_ && this.delegate_.gotFirstRectForRange && this.delegate_.gotFirstRectForRange(rect);
  }

  TextInputHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kTextInputHost_GotCharacterIndexAtPoint_Name:
      var params = reader.decodeStruct(TextInputHost_GotCharacterIndexAtPoint_Params);
      this.gotCharacterIndexAtPoint(params.index);
      return true;
    case kTextInputHost_GotFirstRectForRange_Name:
      var params = reader.decodeStruct(TextInputHost_GotFirstRectForRange_Params);
      this.gotFirstRectForRange(params.rect);
      return true;
    default:
      return false;
    }
  };

  TextInputHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateTextInputHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kTextInputHost_GotCharacterIndexAtPoint_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TextInputHost_GotCharacterIndexAtPoint_Params;
      break;
      case kTextInputHost_GotFirstRectForRange_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = TextInputHost_GotFirstRectForRange_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateTextInputHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var TextInputHost = {
    name: 'blink.mojom.TextInputHost',
    kVersion: 0,
    ptrClass: TextInputHostPtr,
    proxyClass: TextInputHostProxy,
    stubClass: TextInputHostStub,
    validateRequest: validateTextInputHostRequest,
    validateResponse: null,
  };
  TextInputHostStub.prototype.validator = validateTextInputHostRequest;
  TextInputHostProxy.prototype.validator = null;
  exports.TextInputHost = TextInputHost;
  exports.TextInputHostPtr = TextInputHostPtr;
  exports.TextInputHostAssociatedPtr = TextInputHostAssociatedPtr;
})();