// third_party/blink/public/mojom/input/text_input_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('gfx.mojom.Rect');






goog.provide('blink.mojom.TextInputHost');
goog.provide('blink.mojom.TextInputHostReceiver');
goog.provide('blink.mojom.TextInputHostCallbackRouter');
goog.provide('blink.mojom.TextInputHostInterface');
goog.provide('blink.mojom.TextInputHostRemote');
goog.provide('blink.mojom.TextInputHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TextInputHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.TextInputHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.TextInputHostInterface = class {
  
  /**
   * @param { !number } index
   */

  gotCharacterIndexAtPoint(index) {}
  
  /**
   * @param { !gfx.mojom.Rect } rect
   */

  gotFirstRectForRange(rect) {}
};

/**
 * @export
 * @implements { blink.mojom.TextInputHostInterface }
 */
blink.mojom.TextInputHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TextInputHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TextInputHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TextInputHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } index
   */

  gotCharacterIndexAtPoint(
      index) {
    this.proxy.sendMessage(
        0,
        blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        [
          index
        ],
        false);
  }

  
  /**
   * @param { !gfx.mojom.Rect } rect
   */

  gotFirstRectForRange(
      rect) {
    this.proxy.sendMessage(
        1,
        blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        [
          rect
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TextInputHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TextInputHostReceiver = class {
  /**
   * @param {!blink.mojom.TextInputHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TextInputHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TextInputHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextInputHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        impl.gotCharacterIndexAtPoint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        impl.gotFirstRectForRange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.TextInputHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.TextInputHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TextInputHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TextInputHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TextInputHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TextInputHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TextInputHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TextInputHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.gotCharacterIndexAtPoint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
        null,
        this.gotCharacterIndexAtPoint.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.gotFirstRectForRange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec.$,
        null,
        this.gotFirstRectForRange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.TextInputHost_GotCharacterIndexAtPoint_ParamsSpec.$,
    'TextInputHost_GotCharacterIndexAtPoint_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TextInputHost_GotCharacterIndexAtPoint_Params');

/** @record */
blink.mojom.TextInputHost_GotCharacterIndexAtPoint_Params = class {
  constructor() {
    /** @export { !number } */
    this.index;
  }
};



mojo.internal.Struct(
    blink.mojom.TextInputHost_GotFirstRectForRange_ParamsSpec.$,
    'TextInputHost_GotFirstRectForRange_Params',
    [
      mojo.internal.StructField(
        'rect', 0,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.TextInputHost_GotFirstRectForRange_Params');

/** @record */
blink.mojom.TextInputHost_GotFirstRectForRange_Params = class {
  constructor() {
    /** @export { !gfx.mojom.Rect } */
    this.rect;
  }
};

