// third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::StylusWritingGestureAction>
    : public mojo::internal::EnumHashImpl<::blink::mojom::StylusWritingGestureAction> {};

template <>
struct hash<::blink::mojom::StylusWritingGestureGranularity>
    : public mojo::internal::EnumHashImpl<::blink::mojom::StylusWritingGestureGranularity> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StylusWritingGestureAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::StylusWritingGestureAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::StylusWritingGestureAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StylusWritingGestureGranularity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::StylusWritingGestureGranularity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::StylusWritingGestureGranularity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StylusWritingGestureDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StylusWritingGestureDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StylusWritingGestureData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::StylusWritingGestureAction>(
      Traits::action(input),
      &fragment->action);

    
    mojo::internal::Serialize<::blink::mojom::StylusWritingGestureGranularity>(
      Traits::granularity(input),
      &fragment->granularity);

    decltype(Traits::start_rect(input)) in_start_rect = Traits::start_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_rect)::BaseType> start_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_start_rect,
      start_rect_fragment);

    fragment->start_rect.Set(
        start_rect_fragment.is_null() ? nullptr : start_rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_rect in StylusWritingGestureData struct");

    decltype(Traits::end_rect(input)) in_end_rect = Traits::end_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->end_rect)::BaseType> end_rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_end_rect,
      end_rect_fragment);

    fragment->end_rect.Set(
        end_rect_fragment.is_null() ? nullptr : end_rect_fragment.data());

    decltype(Traits::text_alternative(input)) in_text_alternative = Traits::text_alternative(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_alternative)::BaseType> text_alternative_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text_alternative,
      text_alternative_fragment);

    fragment->text_alternative.Set(
        text_alternative_fragment.is_null() ? nullptr : text_alternative_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_alternative.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_alternative in StylusWritingGestureData struct");

    decltype(Traits::text_to_insert(input)) in_text_to_insert = Traits::text_to_insert(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_to_insert)::BaseType> text_to_insert_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_text_to_insert,
      text_to_insert_fragment);

    fragment->text_to_insert.Set(
        text_to_insert_fragment.is_null() ? nullptr : text_to_insert_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::StylusWritingGestureData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StylusWritingGestureDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void StylusWritingGestureDataDataView::GetStartRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->start_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void StylusWritingGestureDataDataView::GetEndRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->end_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void StylusWritingGestureDataDataView::GetTextAlternativeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text_alternative.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void StylusWritingGestureDataDataView::GetTextToInsertDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text_to_insert.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::StylusWritingGestureAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::StylusWritingGestureAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::StylusWritingGestureGranularity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::StylusWritingGestureGranularity value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_SHARED_H_