// third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/input/stylus_writing_gesture.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class StylusWritingGestureDataDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::StylusWritingGestureDataDataView> {
  using Data = ::blink::mojom::internal::StylusWritingGestureData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class StylusWritingGestureAction : int32_t {
  
  DELETE_TEXT = 0,
  
  ADD_SPACE_OR_TEXT = 1,
  
  REMOVE_SPACES = 2,
  
  SPLIT_OR_MERGE = 3,
  
  SELECT_TEXT = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, StylusWritingGestureAction value);
inline bool IsKnownEnumValue(StylusWritingGestureAction value) {
  return internal::StylusWritingGestureAction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StylusWritingGestureGranularity : int32_t {
  
  CHARACTER = 0,
  
  WORD = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, StylusWritingGestureGranularity value);
inline bool IsKnownEnumValue(StylusWritingGestureGranularity value) {
  return internal::StylusWritingGestureGranularity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class StylusWritingGestureDataDataView {
 public:
  StylusWritingGestureDataDataView() = default;

  StylusWritingGestureDataDataView(
      internal::StylusWritingGestureData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) const {
    auto data_value = data_->action;
    return mojo::internal::Deserialize<::blink::mojom::StylusWritingGestureAction>(
        data_value, output);
  }
  StylusWritingGestureAction action() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::StylusWritingGestureAction>(data_->action));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadGranularity(UserType* output) const {
    auto data_value = data_->granularity;
    return mojo::internal::Deserialize<::blink::mojom::StylusWritingGestureGranularity>(
        data_value, output);
  }
  StylusWritingGestureGranularity granularity() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::StylusWritingGestureGranularity>(data_->granularity));
  }
  inline void GetStartRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartRect(UserType* output) {
    
    auto* pointer = data_->start_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetEndRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndRect(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectDataView, UserType>(),
    "Attempting to read the optional `end_rect` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEndRect` instead "
    "of `ReadEndRect if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->end_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetTextAlternativeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextAlternative(UserType* output) {
    
    auto* pointer = data_->text_alternative.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTextToInsertDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextToInsert(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `text_to_insert` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTextToInsert` instead "
    "of `ReadTextToInsert if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->text_to_insert.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::StylusWritingGestureData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_STYLUS_WRITING_GESTURE_MOJOM_DATA_VIEW_H_