// third_party/blink/public/mojom/input/ime_host.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/input/ime_host.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/input/ime_host.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EditorBoundsInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EditorBoundsInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EditorBoundsInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::editor_bounds(input)) in_editor_bounds = Traits::editor_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->editor_bounds)::BaseType> editor_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_editor_bounds,
      editor_bounds_fragment);

    fragment->editor_bounds.Set(
        editor_bounds_fragment.is_null() ? nullptr : editor_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->editor_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null editor_bounds in EditorBoundsInfo struct");

    decltype(Traits::handwriting_bounds(input)) in_handwriting_bounds = Traits::handwriting_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->handwriting_bounds)::BaseType> handwriting_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_handwriting_bounds,
      handwriting_bounds_fragment);

    fragment->handwriting_bounds.Set(
        handwriting_bounds_fragment.is_null() ? nullptr : handwriting_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->handwriting_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null handwriting_bounds in EditorBoundsInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::EditorBoundsInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::EditorBoundsInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::TextAppearanceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TextAppearanceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TextAppearanceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text_color(input)) in_text_color = Traits::text_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_color)::BaseType> text_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_text_color,
      text_color_fragment);

    fragment->text_color.Set(
        text_color_fragment.is_null() ? nullptr : text_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_color in TextAppearanceInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::TextAppearanceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::TextAppearanceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InputCursorAnchorInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InputCursorAnchorInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InputCursorAnchorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::character_bounds(input)) in_character_bounds = Traits::character_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->character_bounds)::BaseType>
        character_bounds_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& character_bounds_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
      in_character_bounds,
      character_bounds_fragment,
      &character_bounds_validate_params);

    fragment->character_bounds.Set(
        character_bounds_fragment.is_null() ? nullptr : character_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->character_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null character_bounds in InputCursorAnchorInfo struct");

    decltype(Traits::editor_bounds_info(input)) in_editor_bounds_info = Traits::editor_bounds_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->editor_bounds_info)::BaseType> editor_bounds_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::EditorBoundsInfoDataView>(
      in_editor_bounds_info,
      editor_bounds_info_fragment);

    fragment->editor_bounds_info.Set(
        editor_bounds_info_fragment.is_null() ? nullptr : editor_bounds_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->editor_bounds_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null editor_bounds_info in InputCursorAnchorInfo struct");

    decltype(Traits::text_appearance_info(input)) in_text_appearance_info = Traits::text_appearance_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_appearance_info)::BaseType> text_appearance_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::TextAppearanceInfoDataView>(
      in_text_appearance_info,
      text_appearance_info_fragment);

    fragment->text_appearance_info.Set(
        text_appearance_info_fragment.is_null() ? nullptr : text_appearance_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_appearance_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_appearance_info in InputCursorAnchorInfo struct");

    decltype(Traits::visible_line_bounds(input)) in_visible_line_bounds = Traits::visible_line_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_line_bounds)::BaseType>
        visible_line_bounds_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& visible_line_bounds_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
      in_visible_line_bounds,
      visible_line_bounds_fragment,
      &visible_line_bounds_validate_params);

    fragment->visible_line_bounds.Set(
        visible_line_bounds_fragment.is_null() ? nullptr : visible_line_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visible_line_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visible_line_bounds in InputCursorAnchorInfo struct");

    fragment->requested = Traits::requested(input);
  }

  static bool Deserialize(::blink::mojom::internal::InputCursorAnchorInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InputCursorAnchorInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void EditorBoundsInfoDataView::GetEditorBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->editor_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}
inline void EditorBoundsInfoDataView::GetHandwritingBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->handwriting_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, message_);
}


inline void TextAppearanceInfoDataView::GetTextColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->text_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}


inline void InputCursorAnchorInfoDataView::GetCharacterBoundsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->character_bounds.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}
inline void InputCursorAnchorInfoDataView::GetEditorBoundsInfoDataView(
    EditorBoundsInfoDataView* output) {
  auto pointer = data_->editor_bounds_info.Get();
  *output = EditorBoundsInfoDataView(pointer, message_);
}
inline void InputCursorAnchorInfoDataView::GetTextAppearanceInfoDataView(
    TextAppearanceInfoDataView* output) {
  auto pointer = data_->text_appearance_info.Get();
  *output = TextAppearanceInfoDataView(pointer, message_);
}
inline void InputCursorAnchorInfoDataView::GetVisibleLineBoundsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->visible_line_bounds.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_SHARED_H_