// third_party/blink/public/mojom/input/ime_host.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/input/ime_host.mojom-shared-internal.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class EditorBoundsInfoDataView;

class TextAppearanceInfoDataView;

class InputCursorAnchorInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::EditorBoundsInfoDataView> {
  using Data = ::blink::mojom::internal::EditorBoundsInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TextAppearanceInfoDataView> {
  using Data = ::blink::mojom::internal::TextAppearanceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::InputCursorAnchorInfoDataView> {
  using Data = ::blink::mojom::internal::InputCursorAnchorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class ImeRenderWidgetHostInterfaceBase {};

using ImeRenderWidgetHostPtrDataView =
    mojo::InterfacePtrDataView<ImeRenderWidgetHostInterfaceBase>;
using ImeRenderWidgetHostRequestDataView =
    mojo::InterfaceRequestDataView<ImeRenderWidgetHostInterfaceBase>;
using ImeRenderWidgetHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImeRenderWidgetHostInterfaceBase>;
using ImeRenderWidgetHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImeRenderWidgetHostInterfaceBase>;


class EditorBoundsInfoDataView {
 public:
  EditorBoundsInfoDataView() = default;

  EditorBoundsInfoDataView(
      internal::EditorBoundsInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEditorBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditorBounds(UserType* output) {
    
    auto* pointer = data_->editor_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetHandwritingBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHandwritingBounds(UserType* output) {
    
    auto* pointer = data_->handwriting_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
 private:
  internal::EditorBoundsInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TextAppearanceInfoDataView {
 public:
  TextAppearanceInfoDataView() = default;

  TextAppearanceInfoDataView(
      internal::TextAppearanceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextColor(UserType* output) {
    
    auto* pointer = data_->text_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
 private:
  internal::TextAppearanceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class InputCursorAnchorInfoDataView {
 public:
  InputCursorAnchorInfoDataView() = default;

  InputCursorAnchorInfoDataView(
      internal::InputCursorAnchorInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCharacterBoundsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCharacterBounds(UserType* output) {
    
    auto* pointer = data_->character_bounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  inline void GetEditorBoundsInfoDataView(
      EditorBoundsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEditorBoundsInfo(UserType* output) {
    
    auto* pointer = data_->editor_bounds_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::EditorBoundsInfoDataView>(
        pointer, output, message_);
  }
  inline void GetTextAppearanceInfoDataView(
      TextAppearanceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextAppearanceInfo(UserType* output) {
    
    auto* pointer = data_->text_appearance_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::TextAppearanceInfoDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleLineBoundsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleLineBounds(UserType* output) {
    
    auto* pointer = data_->visible_line_bounds.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  bool requested() const {
    return data_->requested;
  }
 private:
  internal::InputCursorAnchorInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_IME_HOST_MOJOM_DATA_VIEW_H_