// third_party/blink/public/mojom/image_downloader/image_downloader.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/image_downloader/image_downloader.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var bitmap$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/bitmap.mojom', '../../../../../skia/public/mojom/bitmap.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function ImageDownloader_DownloadImage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageDownloader_DownloadImage_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.isFavicon = false;
    this.bypassCache = false;
    this.maxBitmapSize = 0;
    this.preferredSize = null;
  };
  ImageDownloader_DownloadImage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageDownloader_DownloadImage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageDownloader_DownloadImage_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ImageDownloader_DownloadImage_Params.preferredSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ImageDownloader_DownloadImage_Params.encodedSize = codec.kStructHeaderSize + 24;

  ImageDownloader_DownloadImage_Params.decode = function(decoder) {
    var packed;
    var val = new ImageDownloader_DownloadImage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.isFavicon = (packed >> 0) & 1 ? true : false;
    val.bypassCache = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.maxBitmapSize =
        decoder.decodeStruct(codec.Uint32);
    val.preferredSize =
        decoder.decodeStructPointer(geometry$.Size);
    return val;
  };

  ImageDownloader_DownloadImage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageDownloader_DownloadImage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    packed = 0;
    packed |= (val.isFavicon & 1) << 0
    packed |= (val.bypassCache & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.maxBitmapSize);
    encoder.encodeStructPointer(geometry$.Size, val.preferredSize);
  };
  function ImageDownloader_DownloadImage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageDownloader_DownloadImage_ResponseParams.prototype.initDefaults_ = function() {
    this.httpStatusCode = 0;
    this.images = null;
    this.originalImageSizes = null;
  };
  ImageDownloader_DownloadImage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageDownloader_DownloadImage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ImageDownloader_DownloadImage_ResponseParams.images
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(bitmap$.BitmapN32), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageDownloader_DownloadImage_ResponseParams.originalImageSizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageDownloader_DownloadImage_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ImageDownloader_DownloadImage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ImageDownloader_DownloadImage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.httpStatusCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.images =
        decoder.decodeArrayPointer(new codec.PointerTo(bitmap$.BitmapN32));
    val.originalImageSizes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    return val;
  };

  ImageDownloader_DownloadImage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageDownloader_DownloadImage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.httpStatusCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(bitmap$.BitmapN32), val.images);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.originalImageSizes);
  };
  function ImageDownloader_DownloadImageFromAxNode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageDownloader_DownloadImageFromAxNode_Params.prototype.initDefaults_ = function() {
    this.axNodeId = 0;
    this.maxBitmapSize = 0;
    this.preferredSize = null;
    this.bypassCache = false;
  };
  ImageDownloader_DownloadImageFromAxNode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageDownloader_DownloadImageFromAxNode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ImageDownloader_DownloadImageFromAxNode_Params.preferredSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ImageDownloader_DownloadImageFromAxNode_Params.encodedSize = codec.kStructHeaderSize + 24;

  ImageDownloader_DownloadImageFromAxNode_Params.decode = function(decoder) {
    var packed;
    var val = new ImageDownloader_DownloadImageFromAxNode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.axNodeId =
        decoder.decodeStruct(codec.Int32);
    val.maxBitmapSize =
        decoder.decodeStruct(codec.Uint32);
    val.preferredSize =
        decoder.decodeStructPointer(geometry$.Size);
    packed = decoder.readUint8();
    val.bypassCache = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ImageDownloader_DownloadImageFromAxNode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageDownloader_DownloadImageFromAxNode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.axNodeId);
    encoder.encodeStruct(codec.Uint32, val.maxBitmapSize);
    encoder.encodeStructPointer(geometry$.Size, val.preferredSize);
    packed = 0;
    packed |= (val.bypassCache & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ImageDownloader_DownloadImageFromAxNode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ImageDownloader_DownloadImageFromAxNode_ResponseParams.prototype.initDefaults_ = function() {
    this.httpStatusCode = 0;
    this.images = null;
    this.originalImageSizes = null;
  };
  ImageDownloader_DownloadImageFromAxNode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ImageDownloader_DownloadImageFromAxNode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ImageDownloader_DownloadImageFromAxNode_ResponseParams.images
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(bitmap$.BitmapN32), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ImageDownloader_DownloadImageFromAxNode_ResponseParams.originalImageSizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ImageDownloader_DownloadImageFromAxNode_ResponseParams.encodedSize = codec.kStructHeaderSize + 24;

  ImageDownloader_DownloadImageFromAxNode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new ImageDownloader_DownloadImageFromAxNode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.httpStatusCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.images =
        decoder.decodeArrayPointer(new codec.PointerTo(bitmap$.BitmapN32));
    val.originalImageSizes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    return val;
  };

  ImageDownloader_DownloadImageFromAxNode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ImageDownloader_DownloadImageFromAxNode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.httpStatusCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(bitmap$.BitmapN32), val.images);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.originalImageSizes);
  };
  var kImageDownloader_DownloadImage_Name = 0;
  var kImageDownloader_DownloadImageFromAxNode_Name = 1;

  function ImageDownloaderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ImageDownloader,
                                                   handleOrPtrInfo);
  }

  function ImageDownloaderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ImageDownloader, associatedInterfacePtrInfo);
  }

  ImageDownloaderAssociatedPtr.prototype =
      Object.create(ImageDownloaderPtr.prototype);
  ImageDownloaderAssociatedPtr.prototype.constructor =
      ImageDownloaderAssociatedPtr;

  function ImageDownloaderProxy(receiver) {
    this.receiver_ = receiver;
  }
  ImageDownloaderPtr.prototype.downloadImage = function() {
    return ImageDownloaderProxy.prototype.downloadImage
        .apply(this.ptr.getProxy(), arguments);
  };

  ImageDownloaderProxy.prototype.downloadImage = function(url, isFavicon, preferredSize, maxBitmapSize, bypassCache) {
    var params_ = new ImageDownloader_DownloadImage_Params();
    params_.url = url;
    params_.isFavicon = isFavicon;
    params_.preferredSize = preferredSize;
    params_.maxBitmapSize = maxBitmapSize;
    params_.bypassCache = bypassCache;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kImageDownloader_DownloadImage_Name,
          codec.align(ImageDownloader_DownloadImage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ImageDownloader_DownloadImage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ImageDownloader_DownloadImage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  ImageDownloaderPtr.prototype.downloadImageFromAxNode = function() {
    return ImageDownloaderProxy.prototype.downloadImageFromAxNode
        .apply(this.ptr.getProxy(), arguments);
  };

  ImageDownloaderProxy.prototype.downloadImageFromAxNode = function(axNodeId, preferredSize, maxBitmapSize, bypassCache) {
    var params_ = new ImageDownloader_DownloadImageFromAxNode_Params();
    params_.axNodeId = axNodeId;
    params_.preferredSize = preferredSize;
    params_.maxBitmapSize = maxBitmapSize;
    params_.bypassCache = bypassCache;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kImageDownloader_DownloadImageFromAxNode_Name,
          codec.align(ImageDownloader_DownloadImageFromAxNode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(ImageDownloader_DownloadImageFromAxNode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(ImageDownloader_DownloadImageFromAxNode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function ImageDownloaderStub(delegate) {
    this.delegate_ = delegate;
  }
  ImageDownloaderStub.prototype.downloadImage = function(url, isFavicon, preferredSize, maxBitmapSize, bypassCache) {
    return this.delegate_ && this.delegate_.downloadImage && this.delegate_.downloadImage(url, isFavicon, preferredSize, maxBitmapSize, bypassCache);
  }
  ImageDownloaderStub.prototype.downloadImageFromAxNode = function(axNodeId, preferredSize, maxBitmapSize, bypassCache) {
    return this.delegate_ && this.delegate_.downloadImageFromAxNode && this.delegate_.downloadImageFromAxNode(axNodeId, preferredSize, maxBitmapSize, bypassCache);
  }

  ImageDownloaderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  ImageDownloaderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kImageDownloader_DownloadImage_Name:
      var params = reader.decodeStruct(ImageDownloader_DownloadImage_Params);
      this.downloadImage(params.url, params.isFavicon, params.preferredSize, params.maxBitmapSize, params.bypassCache).then(function(response) {
        var responseParams =
            new ImageDownloader_DownloadImage_ResponseParams();
        responseParams.httpStatusCode = response.httpStatusCode;
        responseParams.images = response.images;
        responseParams.originalImageSizes = response.originalImageSizes;
        var builder = new codec.MessageV1Builder(
            kImageDownloader_DownloadImage_Name,
            codec.align(ImageDownloader_DownloadImage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ImageDownloader_DownloadImage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kImageDownloader_DownloadImageFromAxNode_Name:
      var params = reader.decodeStruct(ImageDownloader_DownloadImageFromAxNode_Params);
      this.downloadImageFromAxNode(params.axNodeId, params.preferredSize, params.maxBitmapSize, params.bypassCache).then(function(response) {
        var responseParams =
            new ImageDownloader_DownloadImageFromAxNode_ResponseParams();
        responseParams.httpStatusCode = response.httpStatusCode;
        responseParams.images = response.images;
        responseParams.originalImageSizes = response.originalImageSizes;
        var builder = new codec.MessageV1Builder(
            kImageDownloader_DownloadImageFromAxNode_Name,
            codec.align(ImageDownloader_DownloadImageFromAxNode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(ImageDownloader_DownloadImageFromAxNode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateImageDownloaderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kImageDownloader_DownloadImage_Name:
        if (message.expectsResponse())
          paramsClass = ImageDownloader_DownloadImage_Params;
      break;
      case kImageDownloader_DownloadImageFromAxNode_Name:
        if (message.expectsResponse())
          paramsClass = ImageDownloader_DownloadImageFromAxNode_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateImageDownloaderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kImageDownloader_DownloadImage_Name:
        if (message.isResponse())
          paramsClass = ImageDownloader_DownloadImage_ResponseParams;
        break;
      case kImageDownloader_DownloadImageFromAxNode_Name:
        if (message.isResponse())
          paramsClass = ImageDownloader_DownloadImageFromAxNode_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var ImageDownloader = {
    name: 'blink.mojom.ImageDownloader',
    kVersion: 0,
    ptrClass: ImageDownloaderPtr,
    proxyClass: ImageDownloaderProxy,
    stubClass: ImageDownloaderStub,
    validateRequest: validateImageDownloaderRequest,
    validateResponse: validateImageDownloaderResponse,
  };
  ImageDownloaderStub.prototype.validator = validateImageDownloaderRequest;
  ImageDownloaderProxy.prototype.validator = validateImageDownloaderResponse;
  exports.ImageDownloader = ImageDownloader;
  exports.ImageDownloaderPtr = ImageDownloaderPtr;
  exports.ImageDownloaderAssociatedPtr = ImageDownloaderAssociatedPtr;
})();