// third_party/blink/public/mojom/image_downloader/image_downloader.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-params-data.h"
#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-import-headers.h"
#include "third_party/blink/public/mojom/image_downloader/image_downloader.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

ImageDownloader::IPCStableHashFunction ImageDownloader::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageDownloader>(message.name())) {
    case messages::ImageDownloader::kDownloadImage: {
      return &ImageDownloader::DownloadImage_Sym::IPCStableHash;
    }
    case messages::ImageDownloader::kDownloadImageFromAxNode: {
      return &ImageDownloader::DownloadImageFromAxNode_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageDownloader::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageDownloader>(message.name())) {
      case messages::ImageDownloader::kDownloadImage:
            return "Receive blink::mojom::ImageDownloader::DownloadImage";
      case messages::ImageDownloader::kDownloadImageFromAxNode:
            return "Receive blink::mojom::ImageDownloader::DownloadImageFromAxNode";
    }
  } else {
    switch (static_cast<messages::ImageDownloader>(message.name())) {
      case messages::ImageDownloader::kDownloadImage:
            return "Receive reply blink::mojom::ImageDownloader::DownloadImage";
      case messages::ImageDownloader::kDownloadImageFromAxNode:
            return "Receive reply blink::mojom::ImageDownloader::DownloadImageFromAxNode";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageDownloader::DownloadImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb151dce;  // IPCStableHash for blink::mojom::ImageDownloader::DownloadImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ImageDownloader::DownloadImageFromAxNode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa351b766;  // IPCStableHash for blink::mojom::ImageDownloader::DownloadImageFromAxNode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ImageDownloader_DownloadImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDownloader_DownloadImage_ForwardToCallback(
      ImageDownloader::DownloadImageCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageDownloader_DownloadImage_ForwardToCallback(const ImageDownloader_DownloadImage_ForwardToCallback&) = delete;
  ImageDownloader_DownloadImage_ForwardToCallback& operator=(const ImageDownloader_DownloadImage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageDownloader::DownloadImageCallback callback_;
};

class ImageDownloader_DownloadImageFromAxNode_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageDownloader_DownloadImageFromAxNode_ForwardToCallback(
      ImageDownloader::DownloadImageFromAxNodeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageDownloader_DownloadImageFromAxNode_ForwardToCallback(const ImageDownloader_DownloadImageFromAxNode_ForwardToCallback&) = delete;
  ImageDownloader_DownloadImageFromAxNode_ForwardToCallback& operator=(const ImageDownloader_DownloadImageFromAxNode_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageDownloader::DownloadImageFromAxNodeCallback callback_;
};

ImageDownloaderProxy::ImageDownloaderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageDownloaderProxy::DownloadImage(
    const ::GURL& in_url, bool in_is_favicon, const ::gfx::Size& in_preferred_size, uint32_t in_max_bitmap_size, bool in_bypass_cache, DownloadImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ImageDownloader::DownloadImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_favicon"), in_is_favicon,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_size"), in_preferred_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bitmap_size"), in_max_bitmap_size,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bypass_cache"), in_bypass_cache,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDownloader::kDownloadImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ImageDownloader.DownloadImage request");

  params->is_favicon = in_is_favicon;
  mojo::internal::MessageFragment<
      typename decltype(params->preferred_size)::BaseType> preferred_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_preferred_size,
    preferred_size_fragment);

  params->preferred_size.Set(
      preferred_size_fragment.is_null() ? nullptr : preferred_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->preferred_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null preferred_size in ImageDownloader.DownloadImage request");

  params->max_bitmap_size = in_max_bitmap_size;

  params->bypass_cache = in_bypass_cache;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDownloader_DownloadImage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ImageDownloaderProxy::DownloadImageFromAxNode(
    int32_t in_ax_node_id, const ::gfx::Size& in_preferred_size, uint32_t in_max_bitmap_size, bool in_bypass_cache, DownloadImageFromAxNodeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ImageDownloader::DownloadImageFromAxNode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ax_node_id"), in_ax_node_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("preferred_size"), in_preferred_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_bitmap_size"), in_max_bitmap_size,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bypass_cache"), in_bypass_cache,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDownloader::kDownloadImageFromAxNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImageFromAxNode_Params_Data> params(
          message);
  params.Allocate();

  params->ax_node_id = in_ax_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->preferred_size)::BaseType> preferred_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_preferred_size,
    preferred_size_fragment);

  params->preferred_size.Set(
      preferred_size_fragment.is_null() ? nullptr : preferred_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->preferred_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null preferred_size in ImageDownloader.DownloadImageFromAxNode request");

  params->max_bitmap_size = in_max_bitmap_size;

  params->bypass_cache = in_bypass_cache;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImageFromAxNode");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageDownloader_DownloadImageFromAxNode_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ImageDownloader_DownloadImage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageDownloader::DownloadImageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageDownloader_DownloadImage_ProxyToResponder> proxy(
        new ImageDownloader_DownloadImage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageDownloader_DownloadImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDownloader_DownloadImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageDownloader_DownloadImage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageDownloader::DownloadImageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes);
};

bool ImageDownloader_DownloadImage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageDownloader_DownloadImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDownloader_DownloadImage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageDownloader.0
  bool success = true;
  int32_t p_http_status_code{};
  std::vector<::SkBitmap> p_images{};
  std::vector<::gfx::Size> p_original_image_sizes{};
  ImageDownloader_DownloadImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_http_status_code = input_data_view.http_status_code();
  if (success && !input_data_view.ReadImages(&p_images))
    success = false;
  if (success && !input_data_view.ReadOriginalImageSizes(&p_original_image_sizes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDownloader::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_http_status_code), 
std::move(p_images), 
std::move(p_original_image_sizes));
  }
  return true;
}

void ImageDownloader_DownloadImage_ProxyToResponder::Run(
    int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ImageDownloader::DownloadImage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_status_code"), in_http_status_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images,
                        "<value of type const std::vector<::SkBitmap>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_image_sizes"), in_original_image_sizes,
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDownloader::kDownloadImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImage_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->http_status_code = in_http_status_code;
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
    in_images,
    images_fragment,
    &images_validate_params);

  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null images in ");
  mojo::internal::MessageFragment<
      typename decltype(params->original_image_sizes)::BaseType>
      original_image_sizes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& original_image_sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
    in_original_image_sizes,
    original_image_sizes_fragment,
    &original_image_sizes_validate_params);

  params->original_image_sizes.Set(
      original_image_sizes_fragment.is_null() ? nullptr : original_image_sizes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_image_sizes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_image_sizes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ImageDownloader_DownloadImageFromAxNode_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageDownloader::DownloadImageFromAxNodeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageDownloader_DownloadImageFromAxNode_ProxyToResponder> proxy(
        new ImageDownloader_DownloadImageFromAxNode_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageDownloader_DownloadImageFromAxNode_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageDownloader_DownloadImageFromAxNode_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageDownloader_DownloadImageFromAxNode_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageDownloader::DownloadImageFromAxNodeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes);
};

bool ImageDownloader_DownloadImageFromAxNode_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageDownloader_DownloadImageFromAxNode_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageDownloader_DownloadImageFromAxNode_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageDownloader.1
  bool success = true;
  int32_t p_http_status_code{};
  std::vector<::SkBitmap> p_images{};
  std::vector<::gfx::Size> p_original_image_sizes{};
  ImageDownloader_DownloadImageFromAxNode_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_http_status_code = input_data_view.http_status_code();
  if (success && !input_data_view.ReadImages(&p_images))
    success = false;
  if (success && !input_data_view.ReadOriginalImageSizes(&p_original_image_sizes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageDownloader::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_http_status_code), 
std::move(p_images), 
std::move(p_original_image_sizes));
  }
  return true;
}

void ImageDownloader_DownloadImageFromAxNode_ProxyToResponder::Run(
    int32_t in_http_status_code, const std::vector<::SkBitmap>& in_images, const std::vector<::gfx::Size>& in_original_image_sizes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ImageDownloader::DownloadImageFromAxNode", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_status_code"), in_http_status_code,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("images"), in_images,
                        "<value of type const std::vector<::SkBitmap>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("original_image_sizes"), in_original_image_sizes,
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageDownloader::kDownloadImageFromAxNode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ImageDownloader_DownloadImageFromAxNode_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->http_status_code = in_http_status_code;
  mojo::internal::MessageFragment<
      typename decltype(params->images)::BaseType>
      images_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::skia::mojom::BitmapN32DataView>>(
    in_images,
    images_fragment,
    &images_validate_params);

  params->images.Set(
      images_fragment.is_null() ? nullptr : images_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->images.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null images in ");
  mojo::internal::MessageFragment<
      typename decltype(params->original_image_sizes)::BaseType>
      original_image_sizes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& original_image_sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
    in_original_image_sizes,
    original_image_sizes_fragment,
    &original_image_sizes_validate_params);

  params->original_image_sizes.Set(
      original_image_sizes_fragment.is_null() ? nullptr : original_image_sizes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->original_image_sizes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null original_image_sizes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageDownloader::Name_);
  message.set_method_name("DownloadImageFromAxNode");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageDownloaderStubDispatch::Accept(
    ImageDownloader* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageDownloader>(message->header()->name)) {
    case messages::ImageDownloader::kDownloadImage: {
      break;
    }
    case messages::ImageDownloader::kDownloadImageFromAxNode: {
      break;
    }
  }
  return false;
}

// static
bool ImageDownloaderStubDispatch::AcceptWithResponder(
    ImageDownloader* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageDownloader>(message->header()->name)) {
    case messages::ImageDownloader::kDownloadImage: {
      internal::ImageDownloader_DownloadImage_Params_Data* params =
          reinterpret_cast<
              internal::ImageDownloader_DownloadImage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageDownloader.0
      bool success = true;
      ::GURL p_url{};
      bool p_is_favicon{};
      ::gfx::Size p_preferred_size{};
      uint32_t p_max_bitmap_size{};
      bool p_bypass_cache{};
      ImageDownloader_DownloadImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_is_favicon = input_data_view.is_favicon();
      if (success && !input_data_view.ReadPreferredSize(&p_preferred_size))
        success = false;
      if (success)
        p_max_bitmap_size = input_data_view.max_bitmap_size();
      if (success)
        p_bypass_cache = input_data_view.bypass_cache();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDownloader::Name_, 0, false);
        return false;
      }
      auto callback =
          ImageDownloader_DownloadImage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadImage(        
        std::move(p_url), 
        std::move(p_is_favicon), 
        std::move(p_preferred_size), 
        std::move(p_max_bitmap_size), 
        std::move(p_bypass_cache), std::move(callback));
      return true;
    }
    case messages::ImageDownloader::kDownloadImageFromAxNode: {
      internal::ImageDownloader_DownloadImageFromAxNode_Params_Data* params =
          reinterpret_cast<
              internal::ImageDownloader_DownloadImageFromAxNode_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageDownloader.1
      bool success = true;
      int32_t p_ax_node_id{};
      ::gfx::Size p_preferred_size{};
      uint32_t p_max_bitmap_size{};
      bool p_bypass_cache{};
      ImageDownloader_DownloadImageFromAxNode_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_ax_node_id = input_data_view.ax_node_id();
      if (success && !input_data_view.ReadPreferredSize(&p_preferred_size))
        success = false;
      if (success)
        p_max_bitmap_size = input_data_view.max_bitmap_size();
      if (success)
        p_bypass_cache = input_data_view.bypass_cache();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageDownloader::Name_, 1, false);
        return false;
      }
      auto callback =
          ImageDownloader_DownloadImageFromAxNode_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadImageFromAxNode(        
        std::move(p_ax_node_id), 
        std::move(p_preferred_size), 
        std::move(p_max_bitmap_size), 
        std::move(p_bypass_cache), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageDownloaderValidationInfo[] = {
    { &internal::ImageDownloader_DownloadImage_Params_Data::Validate,
     &internal::ImageDownloader_DownloadImage_ResponseParams_Data::Validate},
    { &internal::ImageDownloader_DownloadImageFromAxNode_Params_Data::Validate,
     &internal::ImageDownloader_DownloadImageFromAxNode_ResponseParams_Data::Validate},
};

bool ImageDownloaderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ImageDownloader::Name_,
    kImageDownloaderValidationInfo);
}

bool ImageDownloaderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::ImageDownloader::Name_,
    kImageDownloaderValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ImageDownloaderInterceptorForTesting::DownloadImage(const ::GURL& url, bool is_favicon, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageCallback callback) {
  GetForwardingInterface()->DownloadImage(
    std::move(url)
    , 
    std::move(is_favicon)
    , 
    std::move(preferred_size)
    , 
    std::move(max_bitmap_size)
    , 
    std::move(bypass_cache)
    , std::move(callback));
}
void ImageDownloaderInterceptorForTesting::DownloadImageFromAxNode(int32_t ax_node_id, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, DownloadImageFromAxNodeCallback callback) {
  GetForwardingInterface()->DownloadImageFromAxNode(
    std::move(ax_node_id)
    , 
    std::move(preferred_size)
    , 
    std::move(max_bitmap_size)
    , 
    std::move(bypass_cache)
    , std::move(callback));
}
ImageDownloaderAsyncWaiter::ImageDownloaderAsyncWaiter(
    ImageDownloader* proxy) : proxy_(proxy) {}

ImageDownloaderAsyncWaiter::~ImageDownloaderAsyncWaiter() = default;


void ImageDownloaderAsyncWaiter::DownloadImage(
    const ::GURL& url, bool is_favicon, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, int32_t* out_http_status_code, std::vector<::SkBitmap>* out_images, std::vector<::gfx::Size>* out_original_image_sizes) {
  base::RunLoop loop;
  proxy_->DownloadImage(
      std::move(url),
      std::move(is_favicon),
      std::move(preferred_size),
      std::move(max_bitmap_size),
      std::move(bypass_cache),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_http_status_code
,
             std::vector<::SkBitmap>* out_images
,
             std::vector<::gfx::Size>* out_original_image_sizes
,
             int32_t http_status_code,
             const std::vector<::SkBitmap>& images,
             const std::vector<::gfx::Size>& original_image_sizes) {*out_http_status_code = std::move(http_status_code);*out_images = std::move(images);*out_original_image_sizes = std::move(original_image_sizes);
            loop->Quit();
          },
          &loop,
          out_http_status_code,
          out_images,
          out_original_image_sizes));
  loop.Run();
}



void ImageDownloaderAsyncWaiter::DownloadImageFromAxNode(
    int32_t ax_node_id, const ::gfx::Size& preferred_size, uint32_t max_bitmap_size, bool bypass_cache, int32_t* out_http_status_code, std::vector<::SkBitmap>* out_images, std::vector<::gfx::Size>* out_original_image_sizes) {
  base::RunLoop loop;
  proxy_->DownloadImageFromAxNode(
      std::move(ax_node_id),
      std::move(preferred_size),
      std::move(max_bitmap_size),
      std::move(bypass_cache),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_http_status_code
,
             std::vector<::SkBitmap>* out_images
,
             std::vector<::gfx::Size>* out_original_image_sizes
,
             int32_t http_status_code,
             const std::vector<::SkBitmap>& images,
             const std::vector<::gfx::Size>& original_image_sizes) {*out_http_status_code = std::move(http_status_code);*out_images = std::move(images);*out_original_image_sizes = std::move(original_image_sizes);
            loop->Quit();
          },
          &loop,
          out_http_status_code,
          out_images,
          out_original_image_sizes));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif