// third_party/blink/public/mojom/hyphenation/hyphenation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-params-data.h"
#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-import-headers.h"
#include "third_party/blink/public/mojom/hyphenation/hyphenation.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

Hyphenation::IPCStableHashFunction Hyphenation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Hyphenation>(message.name())) {
    case messages::Hyphenation::kOpenDictionary: {
      return &Hyphenation::OpenDictionary_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Hyphenation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Hyphenation>(message.name())) {
      case messages::Hyphenation::kOpenDictionary:
            return "Receive blink::mojom::Hyphenation::OpenDictionary";
    }
  } else {
    switch (static_cast<messages::Hyphenation>(message.name())) {
      case messages::Hyphenation::kOpenDictionary:
            return "Receive reply blink::mojom::Hyphenation::OpenDictionary";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Hyphenation::OpenDictionary_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x799560c4;  // IPCStableHash for blink::mojom::Hyphenation::OpenDictionary
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Hyphenation::OpenDictionary(const std::string& locale, ::base::File* out_hyphenation_dictionary_handle) {
  NOTREACHED();
}
class Hyphenation_OpenDictionary_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Hyphenation_OpenDictionary_HandleSyncResponse(
      bool* result, ::base::File* out_hyphenation_dictionary_handle)
      : result_(result), out_hyphenation_dictionary_handle_(out_hyphenation_dictionary_handle) {
    DCHECK(!*result_);
  }

  Hyphenation_OpenDictionary_HandleSyncResponse(const Hyphenation_OpenDictionary_HandleSyncResponse&) = delete;
  Hyphenation_OpenDictionary_HandleSyncResponse& operator=(const Hyphenation_OpenDictionary_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_hyphenation_dictionary_handle_;};

class Hyphenation_OpenDictionary_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Hyphenation_OpenDictionary_ForwardToCallback(
      Hyphenation::OpenDictionaryCallback callback
      ) : callback_(std::move(callback)) {
  }

  Hyphenation_OpenDictionary_ForwardToCallback(const Hyphenation_OpenDictionary_ForwardToCallback&) = delete;
  Hyphenation_OpenDictionary_ForwardToCallback& operator=(const Hyphenation_OpenDictionary_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Hyphenation::OpenDictionaryCallback callback_;
};

HyphenationProxy::HyphenationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool HyphenationProxy::OpenDictionary(
    const std::string& param_locale, ::base::File* out_param_hyphenation_dictionary_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::Hyphenation::OpenDictionary (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale"), param_locale,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "Hyphenation::OpenDictionary");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Hyphenation::kOpenDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->locale)::BaseType> locale_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_locale,
    locale_fragment);

  params->locale.Set(
      locale_fragment.is_null() ? nullptr : locale_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->locale.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null locale in Hyphenation.OpenDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Hyphenation_OpenDictionary_HandleSyncResponse(
          &result, out_param_hyphenation_dictionary_handle));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Hyphenation::OpenDictionary", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hyphenation_dictionary_handle"), out_param_hyphenation_dictionary_handle,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void HyphenationProxy::OpenDictionary(
    const std::string& in_locale, OpenDictionaryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Hyphenation::OpenDictionary", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("locale"), in_locale,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Hyphenation::kOpenDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->locale)::BaseType> locale_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_locale,
    locale_fragment);

  params->locale.Set(
      locale_fragment.is_null() ? nullptr : locale_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->locale.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null locale in Hyphenation.OpenDictionary request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Hyphenation_OpenDictionary_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Hyphenation_OpenDictionary_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Hyphenation::OpenDictionaryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Hyphenation_OpenDictionary_ProxyToResponder> proxy(
        new Hyphenation_OpenDictionary_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Hyphenation_OpenDictionary_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Hyphenation_OpenDictionary_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Hyphenation_OpenDictionary_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Hyphenation::OpenDictionaryCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_hyphenation_dictionary_handle);
};

bool Hyphenation_OpenDictionary_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Hyphenation_OpenDictionary_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Hyphenation_OpenDictionary_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Hyphenation.0
  bool success = true;
  ::base::File p_hyphenation_dictionary_handle{};
  Hyphenation_OpenDictionary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHyphenationDictionaryHandle(&p_hyphenation_dictionary_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Hyphenation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_hyphenation_dictionary_handle));
  }
  return true;
}

void Hyphenation_OpenDictionary_ProxyToResponder::Run(
    ::base::File in_hyphenation_dictionary_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Hyphenation::OpenDictionary", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hyphenation_dictionary_handle"), in_hyphenation_dictionary_handle,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Hyphenation::kOpenDictionary), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Hyphenation_OpenDictionary_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hyphenation_dictionary_handle)::BaseType> hyphenation_dictionary_handle_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_hyphenation_dictionary_handle,
    hyphenation_dictionary_handle_fragment);

  params->hyphenation_dictionary_handle.Set(
      hyphenation_dictionary_handle_fragment.is_null() ? nullptr : hyphenation_dictionary_handle_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Hyphenation::Name_);
  message.set_method_name("OpenDictionary");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Hyphenation_OpenDictionary_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Hyphenation_OpenDictionary_ResponseParams_Data* params =
      reinterpret_cast<internal::Hyphenation_OpenDictionary_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for Hyphenation.0
  bool success = true;
  ::base::File p_hyphenation_dictionary_handle{};
  Hyphenation_OpenDictionary_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHyphenationDictionaryHandle(&p_hyphenation_dictionary_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Hyphenation::Name_, 0, true);
    return false;
  }
  *out_hyphenation_dictionary_handle_ = std::move(p_hyphenation_dictionary_handle);
  *result_ = true;
  return true;
}

// static
bool HyphenationStubDispatch::Accept(
    Hyphenation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Hyphenation>(message->header()->name)) {
    case messages::Hyphenation::kOpenDictionary: {
      break;
    }
  }
  return false;
}

// static
bool HyphenationStubDispatch::AcceptWithResponder(
    Hyphenation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Hyphenation>(message->header()->name)) {
    case messages::Hyphenation::kOpenDictionary: {
      internal::Hyphenation_OpenDictionary_Params_Data* params =
          reinterpret_cast<
              internal::Hyphenation_OpenDictionary_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Hyphenation.0
      bool success = true;
      std::string p_locale{};
      Hyphenation_OpenDictionary_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLocale(&p_locale))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Hyphenation::Name_, 0, false);
        return false;
      }
      auto callback =
          Hyphenation_OpenDictionary_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDictionary(        
        std::move(p_locale), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHyphenationValidationInfo[] = {
    { &internal::Hyphenation_OpenDictionary_Params_Data::Validate,
     &internal::Hyphenation_OpenDictionary_ResponseParams_Data::Validate},
};

bool HyphenationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::Hyphenation::Name_,
    kHyphenationValidationInfo);
}

bool HyphenationResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::Hyphenation::Name_,
    kHyphenationValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void HyphenationInterceptorForTesting::OpenDictionary(const std::string& locale, OpenDictionaryCallback callback) {
  GetForwardingInterface()->OpenDictionary(
    std::move(locale)
    , std::move(callback));
}
HyphenationAsyncWaiter::HyphenationAsyncWaiter(
    Hyphenation* proxy) : proxy_(proxy) {}

HyphenationAsyncWaiter::~HyphenationAsyncWaiter() = default;


void HyphenationAsyncWaiter::OpenDictionary(
    const std::string& locale, ::base::File* out_hyphenation_dictionary_handle) {
  base::RunLoop loop;
  proxy_->OpenDictionary(
      std::move(locale),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File* out_hyphenation_dictionary_handle
,
             ::base::File hyphenation_dictionary_handle) {*out_hyphenation_dictionary_handle = std::move(hyphenation_dictionary_handle);
            loop->Quit();
          },
          &loop,
          out_hyphenation_dictionary_handle));
  loop.Run();
}

::base::File HyphenationAsyncWaiter::OpenDictionary(
    const std::string& locale) {
  ::base::File async_wait_result;
  OpenDictionary(std::move(locale),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif