// third_party/blink/public/mojom/hid/hid.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  HidConnectionRemote as device_mojom_HidConnectionRemote,
  HidConnectionPendingReceiver as device_mojom_HidConnectionPendingReceiver,
  HidConnectionClientRemote as device_mojom_HidConnectionClientRemote,
  HidConnectionClientPendingReceiver as device_mojom_HidConnectionClientPendingReceiver,
  HidManagerClientRemote as device_mojom_HidManagerClientRemote,
  HidManagerClientPendingReceiver as device_mojom_HidManagerClientPendingReceiver,
  HidDeviceInfo as device_mojom_HidDeviceInfo,
  HidDeviceInfoSpec as device_mojom_HidDeviceInfoSpec,
  HidUsageAndPage as device_mojom_HidUsageAndPage,
  HidUsageAndPageSpec as device_mojom_HidUsageAndPageSpec
} from '../../../../../services/device/public/mojom/hid.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.HidService', scope);
  }
}

/** @interface */
export class HidServiceInterface {
  
  /**
   * @param { !Object } client
   */

  registerClient(client) {}
  
  /**
   * @return {!Promise<{
        devices: !Array<!device_mojom_HidDeviceInfo>,
   *  }>}
   */

  getDevices() {}
  
  /**
   * @param { !Array<!HidDeviceFilter> } filters
   * @param { !Array<!HidDeviceFilter> } exclusionFilters
   * @return {!Promise<{
        devices: !Array<!device_mojom_HidDeviceInfo>,
   *  }>}
   */

  requestDevice(filters, exclusionFilters) {}
  
  /**
   * @param { !string } deviceGuid
   * @param { !device_mojom_HidConnectionClientRemote } client
   * @return {!Promise<{
        connection: ?device_mojom_HidConnectionRemote,
   *  }>}
   */

  connect(deviceGuid, client) {}
  
  /**
   * @param { !device_mojom_HidDeviceInfo } deviceInfo
   * @return {!Promise}
   */

  forget(deviceInfo) {}
}

/**
 * @implements { HidServiceInterface }
 */
export class HidServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   */

  registerClient(
      client) {
    this.proxy.sendMessage(
        0,
        HidService_RegisterClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!device_mojom_HidDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        HidService_GetDevices_ParamsSpec.$,
        HidService_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!HidDeviceFilter> } filters
   * @param { !Array<!HidDeviceFilter> } exclusionFilters
   * @return {!Promise<{
        devices: !Array<!device_mojom_HidDeviceInfo>,
   *  }>}
   */

  requestDevice(
      filters,
      exclusionFilters) {
    return this.proxy.sendMessage(
        2,
        HidService_RequestDevice_ParamsSpec.$,
        HidService_RequestDevice_ResponseParamsSpec.$,
        [
          filters,
          exclusionFilters
        ],
        false);
  }

  
  /**
   * @param { !string } deviceGuid
   * @param { !device_mojom_HidConnectionClientRemote } client
   * @return {!Promise<{
        connection: ?device_mojom_HidConnectionRemote,
   *  }>}
   */

  connect(
      deviceGuid,
      client) {
    return this.proxy.sendMessage(
        3,
        HidService_Connect_ParamsSpec.$,
        HidService_Connect_ResponseParamsSpec.$,
        [
          deviceGuid,
          client
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_HidDeviceInfo } deviceInfo
   * @return {!Promise}
   */

  forget(
      deviceInfo) {
    return this.proxy.sendMessage(
        4,
        HidService_Forget_ParamsSpec.$,
        HidService_Forget_ResponseParamsSpec.$,
        [
          deviceInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HidService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidServiceReceiver {
  /**
   * @param {!HidServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HidService_RegisterClient_ParamsSpec.$,
        null,
        impl.registerClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HidService_GetDevices_ParamsSpec.$,
        HidService_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HidService_RequestDevice_ParamsSpec.$,
        HidService_RequestDevice_ResponseParamsSpec.$,
        impl.requestDevice.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        HidService_Connect_ParamsSpec.$,
        HidService_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        HidService_Forget_ParamsSpec.$,
        HidService_Forget_ResponseParamsSpec.$,
        impl.forget.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.HidService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidServiceRemote}
   */
  static getRemote() {
    let remote = new HidServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HidService_RegisterClient_ParamsSpec.$,
        null,
        this.registerClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HidService_GetDevices_ParamsSpec.$,
        HidService_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestDevice =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HidService_RequestDevice_ParamsSpec.$,
        HidService_RequestDevice_ResponseParamsSpec.$,
        this.requestDevice.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        HidService_Connect_ParamsSpec.$,
        HidService_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forget =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        HidService_Forget_ParamsSpec.$,
        HidService_Forget_ResponseParamsSpec.$,
        this.forget.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VendorAndProductSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidDeviceFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_RegisterClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_RequestDevice_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_RequestDevice_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_Forget_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidService_Forget_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const DeviceIdFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const UsageFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VendorAndProductSpec.$,
    'VendorAndProduct',
    [
      mojo.internal.StructField(
        'vendor', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'product', 2,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VendorAndProduct {
  constructor() {
    /** @type { !number } */
    this.vendor;
    /** @type { !number } */
    this.product;
  }
}



mojo.internal.Struct(
    HidDeviceFilterSpec.$,
    'HidDeviceFilter',
    [
      mojo.internal.StructField(
        'deviceIds', 0,
        0,
        DeviceIdFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usage', 16,
        0,
        UsageFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class HidDeviceFilter {
  constructor() {
    /** @type { (DeviceIdFilter|undefined) } */
    this.deviceIds;
    /** @type { (UsageFilter|undefined) } */
    this.usage;
  }
}



mojo.internal.Struct(
    HidService_RegisterClient_ParamsSpec.$,
    'HidService_RegisterClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device_mojom_HidManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidService_RegisterClient_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    HidService_GetDevices_ParamsSpec.$,
    'HidService_GetDevices_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class HidService_GetDevices_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    HidService_GetDevices_ResponseParamsSpec.$,
    'HidService_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device_mojom_HidDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidService_GetDevices_ResponseParams {
  constructor() {
    /** @type { !Array<!device_mojom_HidDeviceInfo> } */
    this.devices;
  }
}



mojo.internal.Struct(
    HidService_RequestDevice_ParamsSpec.$,
    'HidService_RequestDevice_Params',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(HidDeviceFilterSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exclusionFilters', 8,
        0,
        mojo.internal.Array(HidDeviceFilterSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidService_RequestDevice_Params {
  constructor() {
    /** @type { !Array<!HidDeviceFilter> } */
    this.filters;
    /** @type { !Array<!HidDeviceFilter> } */
    this.exclusionFilters;
  }
}



mojo.internal.Struct(
    HidService_RequestDevice_ResponseParamsSpec.$,
    'HidService_RequestDevice_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device_mojom_HidDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidService_RequestDevice_ResponseParams {
  constructor() {
    /** @type { !Array<!device_mojom_HidDeviceInfo> } */
    this.devices;
  }
}



mojo.internal.Struct(
    HidService_Connect_ParamsSpec.$,
    'HidService_Connect_Params',
    [
      mojo.internal.StructField(
        'deviceGuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceProxy(device_mojom_HidConnectionClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidService_Connect_Params {
  constructor() {
    /** @type { !string } */
    this.deviceGuid;
    /** @type { !device_mojom_HidConnectionClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    HidService_Connect_ResponseParamsSpec.$,
    'HidService_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(device_mojom_HidConnectionRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidService_Connect_ResponseParams {
  constructor() {
    /** @type { (device_mojom_HidConnectionRemote|undefined) } */
    this.connection;
  }
}



mojo.internal.Struct(
    HidService_Forget_ParamsSpec.$,
    'HidService_Forget_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device_mojom_HidDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidService_Forget_Params {
  constructor() {
    /** @type { !device_mojom_HidDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    HidService_Forget_ResponseParamsSpec.$,
    'HidService_Forget_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class HidService_Forget_ResponseParams {
  constructor() {
  }
}

mojo.internal.Union(
    DeviceIdFilterSpec.$, 'DeviceIdFilter',
    {
      'vendor': {
        'ordinal': 0,
        'type': mojo.internal.Uint16,
      },
      'vendorAndProduct': {
        'ordinal': 1,
        'type': VendorAndProductSpec.$,
      },
    });

/**
 * @typedef { {
 *   vendor: (!number|undefined),
 *   vendorAndProduct: (!VendorAndProduct|undefined),
 * } }
 */
export const DeviceIdFilter = {};
mojo.internal.Union(
    UsageFilterSpec.$, 'UsageFilter',
    {
      'page': {
        'ordinal': 0,
        'type': mojo.internal.Uint16,
      },
      'usageAndPage': {
        'ordinal': 1,
        'type': device_mojom_HidUsageAndPageSpec.$,
      },
    });

/**
 * @typedef { {
 *   page: (!number|undefined),
 *   usageAndPage: (!device_mojom_HidUsageAndPage|undefined),
 * } }
 */
export const UsageFilter = {};
