// third_party/blink/public/mojom/hid/hid.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/hid/hid.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/hid/hid.mojom-forward.h"  // IWYU pragma: export
#include "services/device/public/mojom/hid.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class HidServiceProxy;

template <typename ImplRefTraits>
class HidServiceStub;

class HidServiceRequestValidator;
class HidServiceResponseValidator;


class BLINK_COMMON_EXPORT HidService
    : public HidServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.HidService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidServiceInterfaceBase;
  using Proxy_ = HidServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidServiceStub<ImplRefTraits>;

  using RequestValidator_ = HidServiceRequestValidator;
  using ResponseValidator_ = HidServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRegisterClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kRequestDeviceMinVersion = 0,
    kConnectMinVersion = 0,
    kForgetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Forget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidService() = default;

  virtual void RegisterClient(::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient> client) = 0;

  using GetDevicesCallback = base::OnceCallback<void(std::vector<::device::mojom::HidDeviceInfoPtr>)>;
  using GetDevicesMojoCallback = base::OnceCallback<void(std::vector<::device::mojom::HidDeviceInfoPtr>)>;

  virtual void GetDevices(GetDevicesCallback callback) = 0;

  using RequestDeviceCallback = base::OnceCallback<void(std::vector<::device::mojom::HidDeviceInfoPtr>)>;
  using RequestDeviceMojoCallback = base::OnceCallback<void(std::vector<::device::mojom::HidDeviceInfoPtr>)>;

  virtual void RequestDevice(std::vector<HidDeviceFilterPtr> filters, std::vector<HidDeviceFilterPtr> exclusion_filters, RequestDeviceCallback callback) = 0;

  using ConnectCallback = base::OnceCallback<void(::mojo::PendingRemote<::device::mojom::HidConnection>)>;
  using ConnectMojoCallback = base::OnceCallback<void(::mojo::PendingRemote<::device::mojom::HidConnection>)>;

  virtual void Connect(const std::string& device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> client, ConnectCallback callback) = 0;

  using ForgetCallback = base::OnceCallback<void()>;
  using ForgetMojoCallback = base::OnceCallback<void()>;

  virtual void Forget(::device::mojom::HidDeviceInfoPtr device_info, ForgetCallback callback) = 0;
};



class BLINK_COMMON_EXPORT HidServiceProxy
    : public HidService {
 public:
  using InterfaceType = HidService;

  explicit HidServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterClient(::mojo::PendingAssociatedRemote<::device::mojom::HidManagerClient> client) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void RequestDevice(std::vector<HidDeviceFilterPtr> filters, std::vector<HidDeviceFilterPtr> exclusion_filters, RequestDeviceCallback callback) final;
  
  void Connect(const std::string& device_guid, ::mojo::PendingRemote<::device::mojom::HidConnectionClient> client, ConnectCallback callback) final;
  
  void Forget(::device::mojom::HidDeviceInfoPtr device_info, ForgetCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT HidServiceStubDispatch {
 public:
  static bool Accept(HidService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidService>>
class HidServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidServiceStub() = default;
  ~HidServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT HidServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT HidServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT VendorAndProduct {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VendorAndProduct, T>::value>;
  using DataView = VendorAndProductDataView;
  using Data_ = internal::VendorAndProduct_Data;

  template <typename... Args>
  static VendorAndProductPtr New(Args&&... args) {
    return VendorAndProductPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VendorAndProductPtr From(const U& u) {
    return mojo::TypeConverter<VendorAndProductPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VendorAndProduct>::Convert(*this);
  }


  VendorAndProduct();

  VendorAndProduct(
      uint16_t vendor,
      uint16_t product);


  ~VendorAndProduct();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VendorAndProductPtr>
  VendorAndProductPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VendorAndProduct::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VendorAndProduct::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VendorAndProduct::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VendorAndProduct_UnserializedMessageContext<
            UserType, VendorAndProduct::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VendorAndProduct::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VendorAndProduct::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VendorAndProduct_UnserializedMessageContext<
            UserType, VendorAndProduct::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VendorAndProduct::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t vendor;
  
  uint16_t product;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VendorAndProduct::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_COMMON_EXPORT DeviceIdFilter {
 public:
  using DataView = DeviceIdFilterDataView;
  using Data_ = internal::DeviceIdFilter_Data;
  using Tag = Data_::DeviceIdFilter_Tag;

  template <typename... Args>
  static DeviceIdFilterPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |vendor|.
  static DeviceIdFilterPtr NewVendor(
      uint16_t value);
  // Construct an instance holding |vendor_and_product|.
  static DeviceIdFilterPtr NewVendorAndProduct(
      VendorAndProductPtr value);

  template <typename U>
  static DeviceIdFilterPtr From(const U& u) {
    return mojo::TypeConverter<DeviceIdFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceIdFilter>::Convert(*this);
  }
  ~DeviceIdFilter();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  DeviceIdFilter(const DeviceIdFilter& other) = delete;
  DeviceIdFilter& operator=(const DeviceIdFilter& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DeviceIdFilterPtr>
  DeviceIdFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeviceIdFilter>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, DeviceIdFilter>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_vendor() const { return tag_ == Tag::kVendor; }
  uint16_t get_vendor() const {
    CHECK(tag_ == Tag::kVendor);
    return data_.vendor;
  }
  void set_vendor(uint16_t vendor);

  bool is_vendor_and_product() const { return tag_ == Tag::kVendorAndProduct; }
  const VendorAndProductPtr& get_vendor_and_product() const {
    CHECK(tag_ == Tag::kVendorAndProduct);
    return data_.vendor_and_product;
  }
  VendorAndProductPtr& get_vendor_and_product() {
    CHECK(tag_ == Tag::kVendorAndProduct);
    return data_.vendor_and_product;
  }
  void set_vendor_and_product(VendorAndProductPtr vendor_and_product);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceIdFilter::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DeviceIdFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kVendor)>,
        uint16_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kVendorAndProduct)>,
        VendorAndProductPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint16_t vendor;
    VendorAndProductPtr vendor_and_product;
  };

  DeviceIdFilter(
      std::in_place_index_t<static_cast<size_t>(Tag::kVendor)>,
      uint16_t value);
  DeviceIdFilter(
      std::in_place_index_t<static_cast<size_t>(Tag::kVendorAndProduct)>,
      VendorAndProductPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class BLINK_COMMON_EXPORT UsageFilter {
 public:
  using DataView = UsageFilterDataView;
  using Data_ = internal::UsageFilter_Data;
  using Tag = Data_::UsageFilter_Tag;

  template <typename... Args>
  static UsageFilterPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |page|.
  static UsageFilterPtr NewPage(
      uint16_t value);
  // Construct an instance holding |usage_and_page|.
  static UsageFilterPtr NewUsageAndPage(
      ::device::mojom::HidUsageAndPagePtr value);

  template <typename U>
  static UsageFilterPtr From(const U& u) {
    return mojo::TypeConverter<UsageFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsageFilter>::Convert(*this);
  }
  ~UsageFilter();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UsageFilter(const UsageFilter& other) = delete;
  UsageFilter& operator=(const UsageFilter& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UsageFilterPtr>
  UsageFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UsageFilter>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UsageFilter>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_page() const { return tag_ == Tag::kPage; }
  uint16_t get_page() const {
    CHECK(tag_ == Tag::kPage);
    return data_.page;
  }
  void set_page(uint16_t page);

  bool is_usage_and_page() const { return tag_ == Tag::kUsageAndPage; }
  const ::device::mojom::HidUsageAndPagePtr& get_usage_and_page() const {
    CHECK(tag_ == Tag::kUsageAndPage);
    return data_.usage_and_page;
  }
  ::device::mojom::HidUsageAndPagePtr& get_usage_and_page() {
    CHECK(tag_ == Tag::kUsageAndPage);
    return data_.usage_and_page;
  }
  void set_usage_and_page(::device::mojom::HidUsageAndPagePtr usage_and_page);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsageFilter::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UsageFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPage)>,
        uint16_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kUsageAndPage)>,
        ::device::mojom::HidUsageAndPagePtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint16_t page;
    ::device::mojom::HidUsageAndPagePtr usage_and_page;
  };

  UsageFilter(
      std::in_place_index_t<static_cast<size_t>(Tag::kPage)>,
      uint16_t value);
  UsageFilter(
      std::in_place_index_t<static_cast<size_t>(Tag::kUsageAndPage)>,
      ::device::mojom::HidUsageAndPagePtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class BLINK_COMMON_EXPORT HidDeviceFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidDeviceFilter, T>::value>;
  using DataView = HidDeviceFilterDataView;
  using Data_ = internal::HidDeviceFilter_Data;

  template <typename... Args>
  static HidDeviceFilterPtr New(Args&&... args) {
    return HidDeviceFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidDeviceFilterPtr From(const U& u) {
    return mojo::TypeConverter<HidDeviceFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidDeviceFilter>::Convert(*this);
  }


  HidDeviceFilter();

  HidDeviceFilter(
      DeviceIdFilterPtr device_ids,
      UsageFilterPtr usage);

HidDeviceFilter(const HidDeviceFilter&) = delete;
HidDeviceFilter& operator=(const HidDeviceFilter&) = delete;

  ~HidDeviceFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidDeviceFilterPtr>
  HidDeviceFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidDeviceFilter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidDeviceFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidDeviceFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidDeviceFilter_UnserializedMessageContext<
            UserType, HidDeviceFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidDeviceFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidDeviceFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidDeviceFilter_UnserializedMessageContext<
            UserType, HidDeviceFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidDeviceFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeviceIdFilterPtr device_ids;
  
  UsageFilterPtr usage;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DeviceIdFilterPtr DeviceIdFilter::Clone() const {
  switch (tag_) {
    case Tag::kVendor:
      return NewVendor(
          mojo::Clone(data_.vendor));
    case Tag::kVendorAndProduct:
      return NewVendorAndProduct(
          mojo::Clone(data_.vendor_and_product));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DeviceIdFilter>::value>::type*>
bool DeviceIdFilter::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kVendor:
      return mojo::Equals(data_.vendor, other.data_.vendor);
    case Tag::kVendorAndProduct:
      return mojo::Equals(data_.vendor_and_product, other.data_.vendor_and_product);
  }

  return false;
}
template <typename UnionPtrType>
UsageFilterPtr UsageFilter::Clone() const {
  switch (tag_) {
    case Tag::kPage:
      return NewPage(
          mojo::Clone(data_.page));
    case Tag::kUsageAndPage:
      return NewUsageAndPage(
          mojo::Clone(data_.usage_and_page));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UsageFilter>::value>::type*>
bool UsageFilter::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPage:
      return mojo::Equals(data_.page, other.data_.page);
    case Tag::kUsageAndPage:
      return mojo::Equals(data_.usage_and_page, other.data_.usage_and_page);
  }

  return false;
}
template <typename StructPtrType>
VendorAndProductPtr VendorAndProduct::Clone() const {
  return New(
      mojo::Clone(vendor),
      mojo::Clone(product)
  );
}

template <typename T, VendorAndProduct::EnableIfSame<T>*>
bool VendorAndProduct::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->vendor, other_struct.vendor))
    return false;
  if (!mojo::Equals(this->product, other_struct.product))
    return false;
  return true;
}

template <typename T, VendorAndProduct::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.vendor < rhs.vendor)
    return true;
  if (rhs.vendor < lhs.vendor)
    return false;
  if (lhs.product < rhs.product)
    return true;
  if (rhs.product < lhs.product)
    return false;
  return false;
}
template <typename StructPtrType>
HidDeviceFilterPtr HidDeviceFilter::Clone() const {
  return New(
      mojo::Clone(device_ids),
      mojo::Clone(usage)
  );
}

template <typename T, HidDeviceFilter::EnableIfSame<T>*>
bool HidDeviceFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_ids, other_struct.device_ids))
    return false;
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  return true;
}

template <typename T, HidDeviceFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_ids < rhs.device_ids)
    return true;
  if (rhs.device_ids < lhs.device_ids)
    return false;
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::VendorAndProduct::DataView,
                                         ::blink::mojom::VendorAndProductPtr> {
  static bool IsNull(const ::blink::mojom::VendorAndProductPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::VendorAndProductPtr* output) { output->reset(); }

  static decltype(::blink::mojom::VendorAndProduct::vendor) vendor(
      const ::blink::mojom::VendorAndProductPtr& input) {
    return input->vendor;
  }

  static decltype(::blink::mojom::VendorAndProduct::product) product(
      const ::blink::mojom::VendorAndProductPtr& input) {
    return input->product;
  }

  static bool Read(::blink::mojom::VendorAndProduct::DataView input, ::blink::mojom::VendorAndProductPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::HidDeviceFilter::DataView,
                                         ::blink::mojom::HidDeviceFilterPtr> {
  static bool IsNull(const ::blink::mojom::HidDeviceFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::HidDeviceFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::HidDeviceFilter::device_ids)& device_ids(
      const ::blink::mojom::HidDeviceFilterPtr& input) {
    return input->device_ids;
  }

  static const decltype(::blink::mojom::HidDeviceFilter::usage)& usage(
      const ::blink::mojom::HidDeviceFilterPtr& input) {
    return input->usage;
  }

  static bool Read(::blink::mojom::HidDeviceFilter::DataView input, ::blink::mojom::HidDeviceFilterPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::DeviceIdFilter::DataView,
                                        ::blink::mojom::DeviceIdFilterPtr> {
  static bool IsNull(const ::blink::mojom::DeviceIdFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DeviceIdFilterPtr* output) { output->reset(); }

  static ::blink::mojom::DeviceIdFilter::Tag GetTag(const ::blink::mojom::DeviceIdFilterPtr& input) {
    return input->which();
  }

  static  uint16_t vendor(const ::blink::mojom::DeviceIdFilterPtr& input) {
    return input->get_vendor();
  }

  static const ::blink::mojom::VendorAndProductPtr& vendor_and_product(const ::blink::mojom::DeviceIdFilterPtr& input) {
    return input->get_vendor_and_product();
  }

  static bool Read(::blink::mojom::DeviceIdFilter::DataView input, ::blink::mojom::DeviceIdFilterPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::UsageFilter::DataView,
                                        ::blink::mojom::UsageFilterPtr> {
  static bool IsNull(const ::blink::mojom::UsageFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::UsageFilterPtr* output) { output->reset(); }

  static ::blink::mojom::UsageFilter::Tag GetTag(const ::blink::mojom::UsageFilterPtr& input) {
    return input->which();
  }

  static  uint16_t page(const ::blink::mojom::UsageFilterPtr& input) {
    return input->get_page();
  }

  static const ::device::mojom::HidUsageAndPagePtr& usage_and_page(const ::blink::mojom::UsageFilterPtr& input) {
    return input->get_usage_and_page();
  }

  static bool Read(::blink::mojom::UsageFilter::DataView input, ::blink::mojom::UsageFilterPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_H_