// third_party/blink/public/mojom/geolocation/geolocation_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  GeolocationRemote as device_mojom_GeolocationRemote,
  GeolocationPendingReceiver as device_mojom_GeolocationPendingReceiver
} from '../../../../../services/device/public/mojom/geolocation.mojom.m.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../permissions/permission_status.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GeolocationServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.GeolocationService', scope);
  }
}

/** @interface */
export class GeolocationServiceInterface {
  
  /**
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  createGeolocation(receiver, userGesture) {}
}

/**
 * @implements { GeolocationServiceInterface }
 */
export class GeolocationServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GeolocationServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GeolocationServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GeolocationServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_GeolocationPendingReceiver } receiver
   * @param { !boolean } userGesture
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  createGeolocation(
      receiver,
      userGesture) {
    return this.proxy.sendMessage(
        0,
        GeolocationService_CreateGeolocation_ParamsSpec.$,
        GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        [
          receiver,
          userGesture
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GeolocationService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GeolocationServiceReceiver {
  /**
   * @param {!GeolocationServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GeolocationServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GeolocationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GeolocationService_CreateGeolocation_ParamsSpec.$,
        GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        impl.createGeolocation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GeolocationService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.GeolocationService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GeolocationServiceRemote}
   */
  static getRemote() {
    let remote = new GeolocationServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GeolocationService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GeolocationServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GeolocationServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createGeolocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GeolocationService_CreateGeolocation_ParamsSpec.$,
        GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
        this.createGeolocation.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationService_CreateGeolocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationService_CreateGeolocation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GeolocationService_CreateGeolocation_ParamsSpec.$,
    'GeolocationService_CreateGeolocation_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(device_mojom_GeolocationPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'userGesture', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GeolocationService_CreateGeolocation_Params {
  constructor() {
    /** @type { !device_mojom_GeolocationPendingReceiver } */
    this.receiver;
    /** @type { !boolean } */
    this.userGesture;
  }
}



mojo.internal.Struct(
    GeolocationService_CreateGeolocation_ResponseParamsSpec.$,
    'GeolocationService_CreateGeolocation_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class GeolocationService_CreateGeolocation_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}

