// third_party/blink/public/mojom/frame/remote_frame.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/frame/remote_frame.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-params-data.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-import-headers.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-test-utils.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/device_bound_sessions.mojom.h"
#include "services/network/public/mojom/devtools_observer.mojom.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom.h"
#include "third_party/blink/public/common/messaging/accelerated_static_bitmap_image_mojom_traits.h"
#include "third_party/blink/public/common/messaging/cloneable_message_mojom_traits.h"
#include "third_party/blink/public/common/messaging/task_attribution_id_mojom_traits.h"
#include "third_party/blink/public/common/messaging/transferable_message_mojom_traits.h"


namespace blink::mojom {
RemoteMainFrameInterfaces::RemoteMainFrameInterfaces()
    : main_frame_host(),
      main_frame() {}

RemoteMainFrameInterfaces::RemoteMainFrameInterfaces(
    ::mojo::PendingAssociatedRemote<RemoteMainFrameHost> main_frame_host_in,
    ::mojo::PendingAssociatedReceiver<RemoteMainFrame> main_frame_in)
    : main_frame_host(std::move(main_frame_host_in)),
      main_frame(std::move(main_frame_in)) {}

RemoteMainFrameInterfaces::~RemoteMainFrameInterfaces() = default;

void RemoteMainFrameInterfaces::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame_host"), this->main_frame_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<RemoteMainFrameHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "main_frame"), this->main_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<RemoteMainFrame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemoteMainFrameInterfaces::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RemoteFrameInterfacesFromRenderer::RemoteFrameInterfacesFromRenderer()
    : frame(),
      frame_host_receiver() {}

RemoteFrameInterfacesFromRenderer::RemoteFrameInterfacesFromRenderer(
    ::mojo::PendingAssociatedRemote<RemoteFrame> frame_in,
    ::mojo::PendingAssociatedReceiver<RemoteFrameHost> frame_host_receiver_in)
    : frame(std::move(frame_in)),
      frame_host_receiver(std::move(frame_host_receiver_in)) {}

RemoteFrameInterfacesFromRenderer::~RemoteFrameInterfacesFromRenderer() = default;

void RemoteFrameInterfacesFromRenderer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame"), this->frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<RemoteFrame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_host_receiver"), this->frame_host_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<RemoteFrameHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemoteFrameInterfacesFromRenderer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RemoteFrameInterfacesFromBrowser::RemoteFrameInterfacesFromBrowser()
    : frame_receiver(),
      frame_host() {}

RemoteFrameInterfacesFromBrowser::RemoteFrameInterfacesFromBrowser(
    ::mojo::PendingAssociatedReceiver<RemoteFrame> frame_receiver_in,
    ::mojo::PendingAssociatedRemote<RemoteFrameHost> frame_host_in)
    : frame_receiver(std::move(frame_receiver_in)),
      frame_host(std::move(frame_host_in)) {}

RemoteFrameInterfacesFromBrowser::~RemoteFrameInterfacesFromBrowser() = default;

void RemoteFrameInterfacesFromBrowser::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_receiver"), this->frame_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedReceiver<RemoteFrame>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_host"), this->frame_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingAssociatedRemote<RemoteFrameHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemoteFrameInterfacesFromBrowser::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateRemoteChildParams::CreateRemoteChildParams()
    : token(),
      opener_frame_token(),
      tree_scope_type(),
      replication_state(),
      owner_properties(),
      is_loading(),
      devtools_frame_token(),
      frame_interfaces(),
      child_params() {}

CreateRemoteChildParams::CreateRemoteChildParams(
    const ::blink::RemoteFrameToken& token_in,
    const std::optional<::blink::FrameToken>& opener_frame_token_in,
    ::blink::mojom::TreeScopeType tree_scope_type_in,
    ::blink::mojom::FrameReplicationStatePtr replication_state_in,
    ::blink::mojom::FrameOwnerPropertiesPtr owner_properties_in,
    bool is_loading_in,
    const ::base::UnguessableToken& devtools_frame_token_in,
    RemoteFrameInterfacesFromBrowserPtr frame_interfaces_in,
    std::vector<CreateRemoteChildParamsPtr> child_params_in)
    : token(std::move(token_in)),
      opener_frame_token(std::move(opener_frame_token_in)),
      tree_scope_type(std::move(tree_scope_type_in)),
      replication_state(std::move(replication_state_in)),
      owner_properties(std::move(owner_properties_in)),
      is_loading(std::move(is_loading_in)),
      devtools_frame_token(std::move(devtools_frame_token_in)),
      frame_interfaces(std::move(frame_interfaces_in)),
      child_params(std::move(child_params_in)) {}

CreateRemoteChildParams::~CreateRemoteChildParams() = default;

void CreateRemoteChildParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::RemoteFrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opener_frame_token"), this->opener_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::FrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tree_scope_type"), this->tree_scope_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::TreeScopeType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replication_state"), this->replication_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FrameReplicationStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "owner_properties"), this->owner_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_loading"), this->is_loading,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_frame_token"), this->devtools_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_interfaces"), this->frame_interfaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RemoteFrameInterfacesFromBrowserPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "child_params"), this->child_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CreateRemoteChildParamsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateRemoteChildParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenURLParams::OpenURLParams()
    : url(),
      initiator_origin(),
      initiator_base_url(),
      actual_navigation_start(),
      initiator_frame_token(),
      post_body(),
      extra_headers(),
      referrer(),
      is_form_submission(),
      disposition(),
      should_replace_current_entry(),
      user_gesture(),
      is_unfenced_top_navigation(false),
      triggering_event_info(),
      blob_url_token(),
      href_translate(),
      impression(),
      download_policy(),
      source_location(),
      initiator_navigation_state_keep_alive_handle(),
      initiator_activation_and_ad_status(),
      is_container_initiated(false),
      has_rel_opener(false),
      storage_access_api_status(mojo::internal::ConvertEnumValue<::network::mojom::StorageAccessApiStatus, ::net::StorageAccessApiStatus>(::network::mojom::StorageAccessApiStatus::kNone)) {}

OpenURLParams::OpenURLParams(
    const ::GURL& url_in,
    const ::url::Origin& initiator_origin_in,
    const std::optional<::GURL>& initiator_base_url_in,
    ::base::TimeTicks actual_navigation_start_in,
    const std::optional<::blink::LocalFrameToken>& initiator_frame_token_in,
    ::scoped_refptr<::network::ResourceRequestBody> post_body_in,
    const std::string& extra_headers_in,
    ::blink::mojom::ReferrerPtr referrer_in,
    bool is_form_submission_in,
    ::WindowOpenDisposition disposition_in,
    bool should_replace_current_entry_in,
    bool user_gesture_in,
    bool is_unfenced_top_navigation_in,
    ::blink::mojom::TriggeringEventInfo triggering_event_info_in,
    ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token_in,
    const std::string& href_translate_in,
    const std::optional<::blink::Impression>& impression_in,
    const ::blink::NavigationDownloadPolicy& download_policy_in,
    ::network::mojom::SourceLocationPtr source_location_in,
    ::mojo::PendingRemote<NavigationStateKeepAliveHandle> initiator_navigation_state_keep_alive_handle_in,
    ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status_in,
    bool is_container_initiated_in,
    bool has_rel_opener_in,
    ::net::StorageAccessApiStatus storage_access_api_status_in)
    : url(std::move(url_in)),
      initiator_origin(std::move(initiator_origin_in)),
      initiator_base_url(std::move(initiator_base_url_in)),
      actual_navigation_start(std::move(actual_navigation_start_in)),
      initiator_frame_token(std::move(initiator_frame_token_in)),
      post_body(std::move(post_body_in)),
      extra_headers(std::move(extra_headers_in)),
      referrer(std::move(referrer_in)),
      is_form_submission(std::move(is_form_submission_in)),
      disposition(std::move(disposition_in)),
      should_replace_current_entry(std::move(should_replace_current_entry_in)),
      user_gesture(std::move(user_gesture_in)),
      is_unfenced_top_navigation(std::move(is_unfenced_top_navigation_in)),
      triggering_event_info(std::move(triggering_event_info_in)),
      blob_url_token(std::move(blob_url_token_in)),
      href_translate(std::move(href_translate_in)),
      impression(std::move(impression_in)),
      download_policy(std::move(download_policy_in)),
      source_location(std::move(source_location_in)),
      initiator_navigation_state_keep_alive_handle(std::move(initiator_navigation_state_keep_alive_handle_in)),
      initiator_activation_and_ad_status(std::move(initiator_activation_and_ad_status_in)),
      is_container_initiated(std::move(is_container_initiated_in)),
      has_rel_opener(std::move(has_rel_opener_in)),
      storage_access_api_status(std::move(storage_access_api_status_in)) {}

OpenURLParams::~OpenURLParams() = default;

void OpenURLParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_origin"), this->initiator_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_base_url"), this->initiator_base_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "actual_navigation_start"), this->actual_navigation_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_frame_token"), this->initiator_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::LocalFrameToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "post_body"), this->post_body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::scoped_refptr<::network::ResourceRequestBody>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_headers"), this->extra_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer"), this->referrer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::ReferrerPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_form_submission"), this->is_form_submission,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disposition"), this->disposition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::WindowOpenDisposition>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_replace_current_entry"), this->should_replace_current_entry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_gesture"), this->user_gesture,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_unfenced_top_navigation"), this->is_unfenced_top_navigation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triggering_event_info"), this->triggering_event_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::TriggeringEventInfo>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob_url_token"), this->blob_url_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BlobURLToken>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "href_translate"), this->href_translate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Impression>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "download_policy"), this->download_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::NavigationDownloadPolicy&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_location"), this->source_location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SourceLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_navigation_state_keep_alive_handle"), this->initiator_navigation_state_keep_alive_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<NavigationStateKeepAliveHandle>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initiator_activation_and_ad_status"), this->initiator_activation_and_ad_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::NavigationInitiatorActivationAndAdStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_container_initiated"), this->is_container_initiated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_rel_opener"), this->has_rel_opener,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_access_api_status"), this->storage_access_api_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::StorageAccessApiStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OpenURLParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NavigationStateKeepAliveHandle::IPCStableHashFunction NavigationStateKeepAliveHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NavigationStateKeepAliveHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

NavigationStateKeepAliveHandleProxy::NavigationStateKeepAliveHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool NavigationStateKeepAliveHandleStubDispatch::Accept(
    NavigationStateKeepAliveHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool NavigationStateKeepAliveHandleStubDispatch::AcceptWithResponder(
    NavigationStateKeepAliveHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool NavigationStateKeepAliveHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::blink::mojom::NavigationStateKeepAliveHandle::Name_,
    {});
}

// The declaration includes the definition on other builds.

RemoteFrameHost::IPCStableHashFunction RemoteFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemoteFrameHost>(message.name())) {
    case messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction: {
      return &RemoteFrameHost::SetInheritedEffectiveTouchAction_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kUpdateRenderThrottlingStatus: {
      return &RemoteFrameHost::UpdateRenderThrottlingStatus_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kVisibilityChanged: {
      return &RemoteFrameHost::VisibilityChanged_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kDidFocusFrame: {
      return &RemoteFrameHost::DidFocusFrame_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kCheckCompleted: {
      return &RemoteFrameHost::CheckCompleted_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe: {
      return &RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kSetIsInert: {
      return &RemoteFrameHost::SetIsInert_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kDidChangeOpener: {
      return &RemoteFrameHost::DidChangeOpener_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kAdvanceFocus: {
      return &RemoteFrameHost::AdvanceFocus_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kRouteMessageEvent: {
      return &RemoteFrameHost::RouteMessageEvent_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kPrintCrossProcessSubframe: {
      return &RemoteFrameHost::PrintCrossProcessSubframe_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kDetach: {
      return &RemoteFrameHost::Detach_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kUpdateViewportIntersection: {
      return &RemoteFrameHost::UpdateViewportIntersection_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kSynchronizeVisualProperties: {
      return &RemoteFrameHost::SynchronizeVisualProperties_Sym::IPCStableHash;
    }
    case messages::RemoteFrameHost::kOpenURL: {
      return &RemoteFrameHost::OpenURL_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemoteFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemoteFrameHost>(message.name())) {
      case messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction:
            return "Receive blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction";
      case messages::RemoteFrameHost::kUpdateRenderThrottlingStatus:
            return "Receive blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus";
      case messages::RemoteFrameHost::kVisibilityChanged:
            return "Receive blink::mojom::RemoteFrameHost::VisibilityChanged";
      case messages::RemoteFrameHost::kDidFocusFrame:
            return "Receive blink::mojom::RemoteFrameHost::DidFocusFrame";
      case messages::RemoteFrameHost::kCheckCompleted:
            return "Receive blink::mojom::RemoteFrameHost::CheckCompleted";
      case messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe:
            return "Receive blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe";
      case messages::RemoteFrameHost::kSetIsInert:
            return "Receive blink::mojom::RemoteFrameHost::SetIsInert";
      case messages::RemoteFrameHost::kDidChangeOpener:
            return "Receive blink::mojom::RemoteFrameHost::DidChangeOpener";
      case messages::RemoteFrameHost::kAdvanceFocus:
            return "Receive blink::mojom::RemoteFrameHost::AdvanceFocus";
      case messages::RemoteFrameHost::kRouteMessageEvent:
            return "Receive blink::mojom::RemoteFrameHost::RouteMessageEvent";
      case messages::RemoteFrameHost::kPrintCrossProcessSubframe:
            return "Receive blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe";
      case messages::RemoteFrameHost::kDetach:
            return "Receive blink::mojom::RemoteFrameHost::Detach";
      case messages::RemoteFrameHost::kUpdateViewportIntersection:
            return "Receive blink::mojom::RemoteFrameHost::UpdateViewportIntersection";
      case messages::RemoteFrameHost::kSynchronizeVisualProperties:
            return "Receive blink::mojom::RemoteFrameHost::SynchronizeVisualProperties";
      case messages::RemoteFrameHost::kOpenURL:
            return "Receive blink::mojom::RemoteFrameHost::OpenURL";
    }
  } else {
    switch (static_cast<messages::RemoteFrameHost>(message.name())) {
      case messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction:
            return "Receive reply blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction";
      case messages::RemoteFrameHost::kUpdateRenderThrottlingStatus:
            return "Receive reply blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus";
      case messages::RemoteFrameHost::kVisibilityChanged:
            return "Receive reply blink::mojom::RemoteFrameHost::VisibilityChanged";
      case messages::RemoteFrameHost::kDidFocusFrame:
            return "Receive reply blink::mojom::RemoteFrameHost::DidFocusFrame";
      case messages::RemoteFrameHost::kCheckCompleted:
            return "Receive reply blink::mojom::RemoteFrameHost::CheckCompleted";
      case messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe:
            return "Receive reply blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe";
      case messages::RemoteFrameHost::kSetIsInert:
            return "Receive reply blink::mojom::RemoteFrameHost::SetIsInert";
      case messages::RemoteFrameHost::kDidChangeOpener:
            return "Receive reply blink::mojom::RemoteFrameHost::DidChangeOpener";
      case messages::RemoteFrameHost::kAdvanceFocus:
            return "Receive reply blink::mojom::RemoteFrameHost::AdvanceFocus";
      case messages::RemoteFrameHost::kRouteMessageEvent:
            return "Receive reply blink::mojom::RemoteFrameHost::RouteMessageEvent";
      case messages::RemoteFrameHost::kPrintCrossProcessSubframe:
            return "Receive reply blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe";
      case messages::RemoteFrameHost::kDetach:
            return "Receive reply blink::mojom::RemoteFrameHost::Detach";
      case messages::RemoteFrameHost::kUpdateViewportIntersection:
            return "Receive reply blink::mojom::RemoteFrameHost::UpdateViewportIntersection";
      case messages::RemoteFrameHost::kSynchronizeVisualProperties:
            return "Receive reply blink::mojom::RemoteFrameHost::SynchronizeVisualProperties";
      case messages::RemoteFrameHost::kOpenURL:
            return "Receive reply blink::mojom::RemoteFrameHost::OpenURL";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemoteFrameHost::SetInheritedEffectiveTouchAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbe6cc5a;  // IPCStableHash for blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::UpdateRenderThrottlingStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x710cd1d3;  // IPCStableHash for blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::VisibilityChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4711d56b;  // IPCStableHash for blink::mojom::RemoteFrameHost::VisibilityChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::DidFocusFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x287010c7;  // IPCStableHash for blink::mojom::RemoteFrameHost::DidFocusFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::CheckCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0165dfb4;  // IPCStableHash for blink::mojom::RemoteFrameHost::CheckCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x753820f5;  // IPCStableHash for blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::SetIsInert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x268dcc54;  // IPCStableHash for blink::mojom::RemoteFrameHost::SetIsInert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::DidChangeOpener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x77e0266a;  // IPCStableHash for blink::mojom::RemoteFrameHost::DidChangeOpener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::AdvanceFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x299186b6;  // IPCStableHash for blink::mojom::RemoteFrameHost::AdvanceFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::RouteMessageEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8463e751;  // IPCStableHash for blink::mojom::RemoteFrameHost::RouteMessageEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::PrintCrossProcessSubframe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf555fa7b;  // IPCStableHash for blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::Detach_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xebcff988;  // IPCStableHash for blink::mojom::RemoteFrameHost::Detach
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::UpdateViewportIntersection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x657d28fb;  // IPCStableHash for blink::mojom::RemoteFrameHost::UpdateViewportIntersection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::SynchronizeVisualProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f850ade;  // IPCStableHash for blink::mojom::RemoteFrameHost::SynchronizeVisualProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrameHost::OpenURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x74be669b;  // IPCStableHash for blink::mojom::RemoteFrameHost::OpenURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemoteFrameHostProxy::RemoteFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameHostProxy::SetInheritedEffectiveTouchAction(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::SetInheritedEffectiveTouchAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("touch_action"), in_touch_action,
                        "<value of type ::cc::TouchAction>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
    in_touch_action,
    &params->touch_action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetInheritedEffectiveTouchAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::UpdateRenderThrottlingStatus(
    bool in_is_throttled, bool in_subtree_throttled, bool in_display_locked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::UpdateRenderThrottlingStatus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_throttled"), in_is_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subtree_throttled"), in_subtree_throttled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("display_locked"), in_display_locked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kUpdateRenderThrottlingStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data> params(
          message);
  params.Allocate();

  params->is_throttled = in_is_throttled;

  params->subtree_throttled = in_subtree_throttled;

  params->display_locked = in_display_locked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("UpdateRenderThrottlingStatus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::VisibilityChanged(
    ::blink::mojom::FrameVisibility in_visibility) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::VisibilityChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visibility"), in_visibility,
                        "<value of type ::blink::mojom::FrameVisibility>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kVisibilityChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_VisibilityChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FrameVisibility>(
    in_visibility,
    &params->visibility);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("VisibilityChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::DidFocusFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrameHost::DidFocusFrame");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kDidFocusFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_DidFocusFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidFocusFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::CheckCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrameHost::CheckCompleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kCheckCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_CheckCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CheckCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::CapturePaintPreviewOfCrossProcessSubframe(
    const ::gfx::Rect& in_clip_rect, const ::base::UnguessableToken& in_guid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::CapturePaintPreviewOfCrossProcessSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clip_rect"), in_clip_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clip_rect)::BaseType> clip_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_clip_rect,
    clip_rect_fragment);

  params->clip_rect.Set(
      clip_rect_fragment.is_null() ? nullptr : clip_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clip_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clip_rect in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in RemoteFrameHost.CapturePaintPreviewOfCrossProcessSubframe request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("CapturePaintPreviewOfCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::SetIsInert(
    bool in_inert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::SetIsInert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inert"), in_inert,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kSetIsInert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SetIsInert_Params_Data> params(
          message);
  params.Allocate();

  params->inert = in_inert;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SetIsInert");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::DidChangeOpener(
    const std::optional<::blink::LocalFrameToken>& in_opener_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::DidChangeOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame"), in_opener_frame,
                        "<value of type const std::optional<::blink::LocalFrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kDidChangeOpener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_DidChangeOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->opener_frame)::BaseType> opener_frame_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_opener_frame,
    opener_frame_fragment);

  params->opener_frame.Set(
      opener_frame_fragment.is_null() ? nullptr : opener_frame_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("DidChangeOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::AdvanceFocus(
    ::blink::mojom::FocusType in_focus_type, const ::blink::LocalFrameToken& in_source_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::AdvanceFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus_type"), in_focus_type,
                        "<value of type ::blink::mojom::FocusType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kAdvanceFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_AdvanceFocus_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::FocusType>(
    in_focus_type,
    &params->focus_type);
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_source_frame_token,
    source_frame_token_fragment);

  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_frame_token in RemoteFrameHost.AdvanceFocus request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("AdvanceFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::RouteMessageEvent(
    const std::optional<::blink::LocalFrameToken>& in_source_frame_token, const ::url::Origin& in_source_origin, const std::optional<::url::Origin>& in_target_origin, ::blink::TransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::RouteMessageEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_frame_token"), in_source_frame_token,
                        "<value of type const std::optional<::blink::LocalFrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_origin"), in_source_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_origin"), in_target_origin,
                        "<value of type const std::optional<::url::Origin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type ::blink::TransferableMessage>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kRouteMessageEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_RouteMessageEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_frame_token)::BaseType> source_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_source_frame_token,
    source_frame_token_fragment);

  params->source_frame_token.Set(
      source_frame_token_fragment.is_null() ? nullptr : source_frame_token_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->source_origin)::BaseType> source_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_source_origin,
    source_origin_fragment);

  params->source_origin.Set(
      source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_origin in RemoteFrameHost.RouteMessageEvent request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_origin)::BaseType> target_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_target_origin,
    target_origin_fragment);

  params->target_origin.Set(
      target_origin_fragment.is_null() ? nullptr : target_origin_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in RemoteFrameHost.RouteMessageEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("RouteMessageEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::PrintCrossProcessSubframe(
    const ::gfx::Rect& in_frame_content_rect, int32_t in_document_cookie) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::PrintCrossProcessSubframe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_content_rect"), in_frame_content_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_cookie"), in_document_cookie,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kPrintCrossProcessSubframe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_content_rect)::BaseType> frame_content_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_frame_content_rect,
    frame_content_rect_fragment);

  params->frame_content_rect.Set(
      frame_content_rect_fragment.is_null() ? nullptr : frame_content_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_content_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_content_rect in RemoteFrameHost.PrintCrossProcessSubframe request");

  params->document_cookie = in_document_cookie;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("PrintCrossProcessSubframe");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::Detach(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrameHost::Detach");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kDetach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_Detach_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("Detach");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::UpdateViewportIntersection(
    ::blink::mojom::ViewportIntersectionStatePtr in_intersection_state, const std::optional<::blink::FrameVisualProperties>& in_visual_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::UpdateViewportIntersection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("intersection_state"), in_intersection_state,
                        "<value of type ::blink::mojom::ViewportIntersectionStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visual_properties"), in_visual_properties,
                        "<value of type const std::optional<::blink::FrameVisualProperties>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kUpdateViewportIntersection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->intersection_state)::BaseType> intersection_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ViewportIntersectionStateDataView>(
    in_intersection_state,
    intersection_state_fragment);

  params->intersection_state.Set(
      intersection_state_fragment.is_null() ? nullptr : intersection_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->intersection_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null intersection_state in RemoteFrameHost.UpdateViewportIntersection request");
  mojo::internal::MessageFragment<
      typename decltype(params->visual_properties)::BaseType> visual_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameVisualPropertiesDataView>(
    in_visual_properties,
    visual_properties_fragment);

  params->visual_properties.Set(
      visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("UpdateViewportIntersection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::SynchronizeVisualProperties(
    const ::blink::FrameVisualProperties& in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::SynchronizeVisualProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type const ::blink::FrameVisualProperties&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kSynchronizeVisualProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameVisualPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in RemoteFrameHost.SynchronizeVisualProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("SynchronizeVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameHostProxy::OpenURL(
    OpenURLParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrameHost::OpenURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type OpenURLParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrameHost::kOpenURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrameHost_OpenURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::OpenURLParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RemoteFrameHost.OpenURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrameHost::Name_);
  message.set_method_name("OpenURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemoteFrameHostStubDispatch::Accept(
    RemoteFrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemoteFrameHost>(message->header()->name)) {
    case messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.0
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      RemoteFrameHost_SetInheritedEffectiveTouchAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInheritedEffectiveTouchAction(        
        std::move(p_touch_action));
      return true;
    }
    case messages::RemoteFrameHost::kUpdateRenderThrottlingStatus: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.1
      bool success = true;
      bool p_is_throttled{};
      bool p_subtree_throttled{};
      bool p_display_locked{};
      RemoteFrameHost_UpdateRenderThrottlingStatus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_throttled = input_data_view.is_throttled();
      if (success)
        p_subtree_throttled = input_data_view.subtree_throttled();
      if (success)
        p_display_locked = input_data_view.display_locked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRenderThrottlingStatus(        
        std::move(p_is_throttled), 
        std::move(p_subtree_throttled), 
        std::move(p_display_locked));
      return true;
    }
    case messages::RemoteFrameHost::kVisibilityChanged: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_VisibilityChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_VisibilityChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.2
      bool success = true;
      ::blink::mojom::FrameVisibility p_visibility{};
      RemoteFrameHost_VisibilityChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadVisibility(&p_visibility))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisibilityChanged(        
        std::move(p_visibility));
      return true;
    }
    case messages::RemoteFrameHost::kDidFocusFrame: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidFocusFrame_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidFocusFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.3
      bool success = true;
      RemoteFrameHost_DidFocusFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFocusFrame(        );
      return true;
    }
    case messages::RemoteFrameHost::kCheckCompleted: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CheckCompleted_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CheckCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.4
      bool success = true;
      RemoteFrameHost_CheckCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckCompleted(        );
      return true;
    }
    case messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.5
      bool success = true;
      ::gfx::Rect p_clip_rect{};
      ::base::UnguessableToken p_guid{};
      RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClipRect(&p_clip_rect))
        success = false;
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CapturePaintPreviewOfCrossProcessSubframe(        
        std::move(p_clip_rect), 
        std::move(p_guid));
      return true;
    }
    case messages::RemoteFrameHost::kSetIsInert: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SetIsInert_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SetIsInert_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.6
      bool success = true;
      bool p_inert{};
      RemoteFrameHost_SetIsInert_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_inert = input_data_view.inert();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsInert(        
        std::move(p_inert));
      return true;
    }
    case messages::RemoteFrameHost::kDidChangeOpener: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_DidChangeOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_DidChangeOpener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.7
      bool success = true;
      std::optional<::blink::LocalFrameToken> p_opener_frame{};
      RemoteFrameHost_DidChangeOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrame(&p_opener_frame))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidChangeOpener(        
        std::move(p_opener_frame));
      return true;
    }
    case messages::RemoteFrameHost::kAdvanceFocus: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_AdvanceFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_AdvanceFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.8
      bool success = true;
      ::blink::mojom::FocusType p_focus_type{};
      ::blink::LocalFrameToken p_source_frame_token{};
      RemoteFrameHost_AdvanceFocus_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFocusType(&p_focus_type))
        success = false;
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AdvanceFocus(        
        std::move(p_focus_type), 
        std::move(p_source_frame_token));
      return true;
    }
    case messages::RemoteFrameHost::kRouteMessageEvent: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_RouteMessageEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_RouteMessageEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.9
      bool success = true;
      std::optional<::blink::LocalFrameToken> p_source_frame_token{};
      ::url::Origin p_source_origin{};
      std::optional<::url::Origin> p_target_origin{};
      ::blink::TransferableMessage p_message{};
      RemoteFrameHost_RouteMessageEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceFrameToken(&p_source_frame_token))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadTargetOrigin(&p_target_origin))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteMessageEvent(        
        std::move(p_source_frame_token), 
        std::move(p_source_origin), 
        std::move(p_target_origin), 
        std::move(p_message));
      return true;
    }
    case messages::RemoteFrameHost::kPrintCrossProcessSubframe: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.10
      bool success = true;
      ::gfx::Rect p_frame_content_rect{};
      int32_t p_document_cookie{};
      RemoteFrameHost_PrintCrossProcessSubframe_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameContentRect(&p_frame_content_rect))
        success = false;
      if (success)
        p_document_cookie = input_data_view.document_cookie();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PrintCrossProcessSubframe(        
        std::move(p_frame_content_rect), 
        std::move(p_document_cookie));
      return true;
    }
    case messages::RemoteFrameHost::kDetach: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_Detach_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_Detach_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.11
      bool success = true;
      RemoteFrameHost_Detach_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Detach(        );
      return true;
    }
    case messages::RemoteFrameHost::kUpdateViewportIntersection: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.12
      bool success = true;
      ::blink::mojom::ViewportIntersectionStatePtr p_intersection_state{};
      std::optional<::blink::FrameVisualProperties> p_visual_properties{};
      RemoteFrameHost_UpdateViewportIntersection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIntersectionState(&p_intersection_state))
        success = false;
      if (success && !input_data_view.ReadVisualProperties(&p_visual_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateViewportIntersection(        
        std::move(p_intersection_state), 
        std::move(p_visual_properties));
      return true;
    }
    case messages::RemoteFrameHost::kSynchronizeVisualProperties: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.13
      bool success = true;
      ::blink::FrameVisualProperties p_properties{};
      RemoteFrameHost_SynchronizeVisualProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SynchronizeVisualProperties(        
        std::move(p_properties));
      return true;
    }
    case messages::RemoteFrameHost::kOpenURL: {
      DCHECK(message->is_serialized());
      internal::RemoteFrameHost_OpenURL_Params_Data* params =
          reinterpret_cast<internal::RemoteFrameHost_OpenURL_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrameHost.14
      bool success = true;
      OpenURLParamsPtr p_params{};
      RemoteFrameHost_OpenURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrameHost::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenURL(        
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameHostStubDispatch::AcceptWithResponder(
    RemoteFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemoteFrameHost>(message->header()->name)) {
    case messages::RemoteFrameHost::kSetInheritedEffectiveTouchAction: {
      break;
    }
    case messages::RemoteFrameHost::kUpdateRenderThrottlingStatus: {
      break;
    }
    case messages::RemoteFrameHost::kVisibilityChanged: {
      break;
    }
    case messages::RemoteFrameHost::kDidFocusFrame: {
      break;
    }
    case messages::RemoteFrameHost::kCheckCompleted: {
      break;
    }
    case messages::RemoteFrameHost::kCapturePaintPreviewOfCrossProcessSubframe: {
      break;
    }
    case messages::RemoteFrameHost::kSetIsInert: {
      break;
    }
    case messages::RemoteFrameHost::kDidChangeOpener: {
      break;
    }
    case messages::RemoteFrameHost::kAdvanceFocus: {
      break;
    }
    case messages::RemoteFrameHost::kRouteMessageEvent: {
      break;
    }
    case messages::RemoteFrameHost::kPrintCrossProcessSubframe: {
      break;
    }
    case messages::RemoteFrameHost::kDetach: {
      break;
    }
    case messages::RemoteFrameHost::kUpdateViewportIntersection: {
      break;
    }
    case messages::RemoteFrameHost::kSynchronizeVisualProperties: {
      break;
    }
    case messages::RemoteFrameHost::kOpenURL: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoteFrameHostValidationInfo[] = {
    { &internal::RemoteFrameHost_SetInheritedEffectiveTouchAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_UpdateRenderThrottlingStatus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_VisibilityChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_DidFocusFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_CheckCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_CapturePaintPreviewOfCrossProcessSubframe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_SetIsInert_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_DidChangeOpener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_AdvanceFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_RouteMessageEvent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_PrintCrossProcessSubframe_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_Detach_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_UpdateViewportIntersection_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_SynchronizeVisualProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrameHost_OpenURL_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoteFrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RemoteFrameHost::Name_,
    kRemoteFrameHostValidationInfo);
}

// The declaration includes the definition on other builds.

RemoteFrame::IPCStableHashFunction RemoteFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemoteFrame>(message.name())) {
    case messages::RemoteFrame::kWillEnterFullscreen: {
      return &RemoteFrame::WillEnterFullscreen_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kEnforceInsecureNavigationsSet: {
      return &RemoteFrame::EnforceInsecureNavigationsSet_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetFrameOwnerProperties: {
      return &RemoteFrame::SetFrameOwnerProperties_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kEnforceInsecureRequestPolicy: {
      return &RemoteFrame::EnforceInsecureRequestPolicy_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetReplicatedOrigin: {
      return &RemoteFrame::SetReplicatedOrigin_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetReplicatedIsAdFrame: {
      return &RemoteFrame::SetReplicatedIsAdFrame_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetReplicatedName: {
      return &RemoteFrame::SetReplicatedName_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDispatchLoadEventForFrameOwner: {
      return &RemoteFrame::DispatchLoadEventForFrameOwner_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetNeedsOcclusionTracking: {
      return &RemoteFrame::SetNeedsOcclusionTracking_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kCollapse: {
      return &RemoteFrame::Collapse_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kFocus: {
      return &RemoteFrame::Focus_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation: {
      return &RemoteFrame::SetHadStickyUserActivationBeforeNavigation_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kBubbleLogicalScroll: {
      return &RemoteFrame::BubbleLogicalScroll_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kUpdateUserActivationState: {
      return &RemoteFrame::UpdateUserActivationState_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetEmbeddingToken: {
      return &RemoteFrame::SetEmbeddingToken_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetPageFocus: {
      return &RemoteFrame::SetPageFocus_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kRenderFallbackContent: {
      return &RemoteFrame::RenderFallbackContent_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kAddResourceTimingFromChild: {
      return &RemoteFrame::AddResourceTimingFromChild_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kScrollRectToVisible: {
      return &RemoteFrame::ScrollRectToVisible_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDidStartLoading: {
      return &RemoteFrame::DidStartLoading_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDidStopLoading: {
      return &RemoteFrame::DidStopLoading_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged: {
      return &RemoteFrame::IntrinsicSizingInfoOfChildChanged_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDidSetFramePolicyHeaders: {
      return &RemoteFrame::DidSetFramePolicyHeaders_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDidUpdateFramePolicy: {
      return &RemoteFrame::DidUpdateFramePolicy_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kUpdateOpener: {
      return &RemoteFrame::UpdateOpener_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDetachAndDispose: {
      return &RemoteFrame::DetachAndDispose_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kEnableAutoResize: {
      return &RemoteFrame::EnableAutoResize_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDisableAutoResize: {
      return &RemoteFrame::DisableAutoResize_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kDidUpdateVisualProperties: {
      return &RemoteFrame::DidUpdateVisualProperties_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kSetFrameSinkId: {
      return &RemoteFrame::SetFrameSinkId_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kChildProcessGone: {
      return &RemoteFrame::ChildProcessGone_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kCreateRemoteChild: {
      return &RemoteFrame::CreateRemoteChild_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kCreateRemoteChildren: {
      return &RemoteFrame::CreateRemoteChildren_Sym::IPCStableHash;
    }
    case messages::RemoteFrame::kForwardFencedFrameEventToEmbedder: {
      return &RemoteFrame::ForwardFencedFrameEventToEmbedder_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemoteFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemoteFrame>(message.name())) {
      case messages::RemoteFrame::kWillEnterFullscreen:
            return "Receive blink::mojom::RemoteFrame::WillEnterFullscreen";
      case messages::RemoteFrame::kEnforceInsecureNavigationsSet:
            return "Receive blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet";
      case messages::RemoteFrame::kSetFrameOwnerProperties:
            return "Receive blink::mojom::RemoteFrame::SetFrameOwnerProperties";
      case messages::RemoteFrame::kEnforceInsecureRequestPolicy:
            return "Receive blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy";
      case messages::RemoteFrame::kSetReplicatedOrigin:
            return "Receive blink::mojom::RemoteFrame::SetReplicatedOrigin";
      case messages::RemoteFrame::kSetReplicatedIsAdFrame:
            return "Receive blink::mojom::RemoteFrame::SetReplicatedIsAdFrame";
      case messages::RemoteFrame::kSetReplicatedName:
            return "Receive blink::mojom::RemoteFrame::SetReplicatedName";
      case messages::RemoteFrame::kDispatchLoadEventForFrameOwner:
            return "Receive blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner";
      case messages::RemoteFrame::kSetNeedsOcclusionTracking:
            return "Receive blink::mojom::RemoteFrame::SetNeedsOcclusionTracking";
      case messages::RemoteFrame::kCollapse:
            return "Receive blink::mojom::RemoteFrame::Collapse";
      case messages::RemoteFrame::kFocus:
            return "Receive blink::mojom::RemoteFrame::Focus";
      case messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation:
            return "Receive blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation";
      case messages::RemoteFrame::kBubbleLogicalScroll:
            return "Receive blink::mojom::RemoteFrame::BubbleLogicalScroll";
      case messages::RemoteFrame::kUpdateUserActivationState:
            return "Receive blink::mojom::RemoteFrame::UpdateUserActivationState";
      case messages::RemoteFrame::kSetEmbeddingToken:
            return "Receive blink::mojom::RemoteFrame::SetEmbeddingToken";
      case messages::RemoteFrame::kSetPageFocus:
            return "Receive blink::mojom::RemoteFrame::SetPageFocus";
      case messages::RemoteFrame::kRenderFallbackContent:
            return "Receive blink::mojom::RemoteFrame::RenderFallbackContent";
      case messages::RemoteFrame::kAddResourceTimingFromChild:
            return "Receive blink::mojom::RemoteFrame::AddResourceTimingFromChild";
      case messages::RemoteFrame::kScrollRectToVisible:
            return "Receive blink::mojom::RemoteFrame::ScrollRectToVisible";
      case messages::RemoteFrame::kDidStartLoading:
            return "Receive blink::mojom::RemoteFrame::DidStartLoading";
      case messages::RemoteFrame::kDidStopLoading:
            return "Receive blink::mojom::RemoteFrame::DidStopLoading";
      case messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged:
            return "Receive blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged";
      case messages::RemoteFrame::kDidSetFramePolicyHeaders:
            return "Receive blink::mojom::RemoteFrame::DidSetFramePolicyHeaders";
      case messages::RemoteFrame::kDidUpdateFramePolicy:
            return "Receive blink::mojom::RemoteFrame::DidUpdateFramePolicy";
      case messages::RemoteFrame::kUpdateOpener:
            return "Receive blink::mojom::RemoteFrame::UpdateOpener";
      case messages::RemoteFrame::kDetachAndDispose:
            return "Receive blink::mojom::RemoteFrame::DetachAndDispose";
      case messages::RemoteFrame::kEnableAutoResize:
            return "Receive blink::mojom::RemoteFrame::EnableAutoResize";
      case messages::RemoteFrame::kDisableAutoResize:
            return "Receive blink::mojom::RemoteFrame::DisableAutoResize";
      case messages::RemoteFrame::kDidUpdateVisualProperties:
            return "Receive blink::mojom::RemoteFrame::DidUpdateVisualProperties";
      case messages::RemoteFrame::kSetFrameSinkId:
            return "Receive blink::mojom::RemoteFrame::SetFrameSinkId";
      case messages::RemoteFrame::kChildProcessGone:
            return "Receive blink::mojom::RemoteFrame::ChildProcessGone";
      case messages::RemoteFrame::kCreateRemoteChild:
            return "Receive blink::mojom::RemoteFrame::CreateRemoteChild";
      case messages::RemoteFrame::kCreateRemoteChildren:
            return "Receive blink::mojom::RemoteFrame::CreateRemoteChildren";
      case messages::RemoteFrame::kForwardFencedFrameEventToEmbedder:
            return "Receive blink::mojom::RemoteFrame::ForwardFencedFrameEventToEmbedder";
    }
  } else {
    switch (static_cast<messages::RemoteFrame>(message.name())) {
      case messages::RemoteFrame::kWillEnterFullscreen:
            return "Receive reply blink::mojom::RemoteFrame::WillEnterFullscreen";
      case messages::RemoteFrame::kEnforceInsecureNavigationsSet:
            return "Receive reply blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet";
      case messages::RemoteFrame::kSetFrameOwnerProperties:
            return "Receive reply blink::mojom::RemoteFrame::SetFrameOwnerProperties";
      case messages::RemoteFrame::kEnforceInsecureRequestPolicy:
            return "Receive reply blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy";
      case messages::RemoteFrame::kSetReplicatedOrigin:
            return "Receive reply blink::mojom::RemoteFrame::SetReplicatedOrigin";
      case messages::RemoteFrame::kSetReplicatedIsAdFrame:
            return "Receive reply blink::mojom::RemoteFrame::SetReplicatedIsAdFrame";
      case messages::RemoteFrame::kSetReplicatedName:
            return "Receive reply blink::mojom::RemoteFrame::SetReplicatedName";
      case messages::RemoteFrame::kDispatchLoadEventForFrameOwner:
            return "Receive reply blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner";
      case messages::RemoteFrame::kSetNeedsOcclusionTracking:
            return "Receive reply blink::mojom::RemoteFrame::SetNeedsOcclusionTracking";
      case messages::RemoteFrame::kCollapse:
            return "Receive reply blink::mojom::RemoteFrame::Collapse";
      case messages::RemoteFrame::kFocus:
            return "Receive reply blink::mojom::RemoteFrame::Focus";
      case messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation:
            return "Receive reply blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation";
      case messages::RemoteFrame::kBubbleLogicalScroll:
            return "Receive reply blink::mojom::RemoteFrame::BubbleLogicalScroll";
      case messages::RemoteFrame::kUpdateUserActivationState:
            return "Receive reply blink::mojom::RemoteFrame::UpdateUserActivationState";
      case messages::RemoteFrame::kSetEmbeddingToken:
            return "Receive reply blink::mojom::RemoteFrame::SetEmbeddingToken";
      case messages::RemoteFrame::kSetPageFocus:
            return "Receive reply blink::mojom::RemoteFrame::SetPageFocus";
      case messages::RemoteFrame::kRenderFallbackContent:
            return "Receive reply blink::mojom::RemoteFrame::RenderFallbackContent";
      case messages::RemoteFrame::kAddResourceTimingFromChild:
            return "Receive reply blink::mojom::RemoteFrame::AddResourceTimingFromChild";
      case messages::RemoteFrame::kScrollRectToVisible:
            return "Receive reply blink::mojom::RemoteFrame::ScrollRectToVisible";
      case messages::RemoteFrame::kDidStartLoading:
            return "Receive reply blink::mojom::RemoteFrame::DidStartLoading";
      case messages::RemoteFrame::kDidStopLoading:
            return "Receive reply blink::mojom::RemoteFrame::DidStopLoading";
      case messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged:
            return "Receive reply blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged";
      case messages::RemoteFrame::kDidSetFramePolicyHeaders:
            return "Receive reply blink::mojom::RemoteFrame::DidSetFramePolicyHeaders";
      case messages::RemoteFrame::kDidUpdateFramePolicy:
            return "Receive reply blink::mojom::RemoteFrame::DidUpdateFramePolicy";
      case messages::RemoteFrame::kUpdateOpener:
            return "Receive reply blink::mojom::RemoteFrame::UpdateOpener";
      case messages::RemoteFrame::kDetachAndDispose:
            return "Receive reply blink::mojom::RemoteFrame::DetachAndDispose";
      case messages::RemoteFrame::kEnableAutoResize:
            return "Receive reply blink::mojom::RemoteFrame::EnableAutoResize";
      case messages::RemoteFrame::kDisableAutoResize:
            return "Receive reply blink::mojom::RemoteFrame::DisableAutoResize";
      case messages::RemoteFrame::kDidUpdateVisualProperties:
            return "Receive reply blink::mojom::RemoteFrame::DidUpdateVisualProperties";
      case messages::RemoteFrame::kSetFrameSinkId:
            return "Receive reply blink::mojom::RemoteFrame::SetFrameSinkId";
      case messages::RemoteFrame::kChildProcessGone:
            return "Receive reply blink::mojom::RemoteFrame::ChildProcessGone";
      case messages::RemoteFrame::kCreateRemoteChild:
            return "Receive reply blink::mojom::RemoteFrame::CreateRemoteChild";
      case messages::RemoteFrame::kCreateRemoteChildren:
            return "Receive reply blink::mojom::RemoteFrame::CreateRemoteChildren";
      case messages::RemoteFrame::kForwardFencedFrameEventToEmbedder:
            return "Receive reply blink::mojom::RemoteFrame::ForwardFencedFrameEventToEmbedder";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemoteFrame::WillEnterFullscreen_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc06c192f;  // IPCStableHash for blink::mojom::RemoteFrame::WillEnterFullscreen
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::EnforceInsecureNavigationsSet_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c0fff02;  // IPCStableHash for blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetFrameOwnerProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x092fce18;  // IPCStableHash for blink::mojom::RemoteFrame::SetFrameOwnerProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::EnforceInsecureRequestPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ce792b5;  // IPCStableHash for blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetReplicatedOrigin_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac5c4d99;  // IPCStableHash for blink::mojom::RemoteFrame::SetReplicatedOrigin
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetReplicatedIsAdFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb8baab7a;  // IPCStableHash for blink::mojom::RemoteFrame::SetReplicatedIsAdFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetReplicatedName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9c7a2ef6;  // IPCStableHash for blink::mojom::RemoteFrame::SetReplicatedName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DispatchLoadEventForFrameOwner_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaef40407;  // IPCStableHash for blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetNeedsOcclusionTracking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd461cab;  // IPCStableHash for blink::mojom::RemoteFrame::SetNeedsOcclusionTracking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::Collapse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f24aa13;  // IPCStableHash for blink::mojom::RemoteFrame::Collapse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::Focus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b78d9f6;  // IPCStableHash for blink::mojom::RemoteFrame::Focus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetHadStickyUserActivationBeforeNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7ea5048f;  // IPCStableHash for blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::BubbleLogicalScroll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc10ed4e7;  // IPCStableHash for blink::mojom::RemoteFrame::BubbleLogicalScroll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::UpdateUserActivationState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x628290c0;  // IPCStableHash for blink::mojom::RemoteFrame::UpdateUserActivationState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetEmbeddingToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ffd6859;  // IPCStableHash for blink::mojom::RemoteFrame::SetEmbeddingToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetPageFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaf4082c7;  // IPCStableHash for blink::mojom::RemoteFrame::SetPageFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::RenderFallbackContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5923c8bf;  // IPCStableHash for blink::mojom::RemoteFrame::RenderFallbackContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::AddResourceTimingFromChild_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8ce7dab;  // IPCStableHash for blink::mojom::RemoteFrame::AddResourceTimingFromChild
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::ScrollRectToVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x404eda39;  // IPCStableHash for blink::mojom::RemoteFrame::ScrollRectToVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DidStartLoading_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52079afe;  // IPCStableHash for blink::mojom::RemoteFrame::DidStartLoading
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DidStopLoading_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd956f95;  // IPCStableHash for blink::mojom::RemoteFrame::DidStopLoading
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::IntrinsicSizingInfoOfChildChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc66a7fb0;  // IPCStableHash for blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DidSetFramePolicyHeaders_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4d189cc;  // IPCStableHash for blink::mojom::RemoteFrame::DidSetFramePolicyHeaders
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DidUpdateFramePolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf05a18b;  // IPCStableHash for blink::mojom::RemoteFrame::DidUpdateFramePolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::UpdateOpener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb39aa560;  // IPCStableHash for blink::mojom::RemoteFrame::UpdateOpener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DetachAndDispose_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa30f3685;  // IPCStableHash for blink::mojom::RemoteFrame::DetachAndDispose
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::EnableAutoResize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x70dce578;  // IPCStableHash for blink::mojom::RemoteFrame::EnableAutoResize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DisableAutoResize_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9f75aca;  // IPCStableHash for blink::mojom::RemoteFrame::DisableAutoResize
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::DidUpdateVisualProperties_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32210e23;  // IPCStableHash for blink::mojom::RemoteFrame::DidUpdateVisualProperties
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::SetFrameSinkId_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x027e8e4a;  // IPCStableHash for blink::mojom::RemoteFrame::SetFrameSinkId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::ChildProcessGone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x266b3407;  // IPCStableHash for blink::mojom::RemoteFrame::ChildProcessGone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::CreateRemoteChild_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04a70ad6;  // IPCStableHash for blink::mojom::RemoteFrame::CreateRemoteChild
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::CreateRemoteChildren_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdea43ad9;  // IPCStableHash for blink::mojom::RemoteFrame::CreateRemoteChildren
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteFrame::ForwardFencedFrameEventToEmbedder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3fab676;  // IPCStableHash for blink::mojom::RemoteFrame::ForwardFencedFrameEventToEmbedder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemoteFrameProxy::RemoteFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteFrameProxy::WillEnterFullscreen(
    ::blink::mojom::FullscreenOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::WillEnterFullscreen", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type ::blink::mojom::FullscreenOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kWillEnterFullscreen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_WillEnterFullscreen_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FullscreenOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in RemoteFrame.WillEnterFullscreen request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("WillEnterFullscreen");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::EnforceInsecureNavigationsSet(
    const std::vector<uint32_t>& in_set) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::EnforceInsecureNavigationsSet", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("set"), in_set,
                        "<value of type const std::vector<uint32_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kEnforceInsecureNavigationsSet), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->set)::BaseType>
      set_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& set_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_set,
    set_fragment,
    &set_validate_params);

  params->set.Set(
      set_fragment.is_null() ? nullptr : set_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->set.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null set in RemoteFrame.EnforceInsecureNavigationsSet request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureNavigationsSet");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetFrameOwnerProperties(
    ::blink::mojom::FrameOwnerPropertiesPtr in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetFrameOwnerProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetFrameOwnerProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetFrameOwnerProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType> properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
    in_properties,
    properties_fragment);

  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null properties in RemoteFrame.SetFrameOwnerProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetFrameOwnerProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::EnforceInsecureRequestPolicy(
    ::blink::mojom::InsecureRequestPolicy in_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::EnforceInsecureRequestPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type ::blink::mojom::InsecureRequestPolicy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kEnforceInsecureRequestPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::InsecureRequestPolicy>(
    in_policy,
    &params->policy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnforceInsecureRequestPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetReplicatedOrigin(
    const ::url::Origin& in_origin, bool in_is_potentially_trustworthy_unique_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetReplicatedOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_potentially_trustworthy_unique_origin"), in_is_potentially_trustworthy_unique_origin,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetReplicatedOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in RemoteFrame.SetReplicatedOrigin request");

  params->is_potentially_trustworthy_unique_origin = in_is_potentially_trustworthy_unique_origin;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetReplicatedIsAdFrame(
    bool in_is_ad_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetReplicatedIsAdFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_frame"), in_is_ad_frame,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetReplicatedIsAdFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedIsAdFrame_Params_Data> params(
          message);
  params.Allocate();

  params->is_ad_frame = in_is_ad_frame;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedIsAdFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetReplicatedName(
    const std::string& in_name, const std::string& in_unique_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetReplicatedName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unique_name"), in_unique_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetReplicatedName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetReplicatedName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in RemoteFrame.SetReplicatedName request");
  mojo::internal::MessageFragment<
      typename decltype(params->unique_name)::BaseType> unique_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_unique_name,
    unique_name_fragment);

  params->unique_name.Set(
      unique_name_fragment.is_null() ? nullptr : unique_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->unique_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null unique_name in RemoteFrame.SetReplicatedName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetReplicatedName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DispatchLoadEventForFrameOwner(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::DispatchLoadEventForFrameOwner");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDispatchLoadEventForFrameOwner), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DispatchLoadEventForFrameOwner");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetNeedsOcclusionTracking(
    bool in_needs_tracking) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetNeedsOcclusionTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("needs_tracking"), in_needs_tracking,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetNeedsOcclusionTracking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data> params(
          message);
  params.Allocate();

  params->needs_tracking = in_needs_tracking;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetNeedsOcclusionTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::Collapse(
    bool in_collapsed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::Collapse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("collapsed"), in_collapsed,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kCollapse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_Collapse_Params_Data> params(
          message);
  params.Allocate();

  params->collapsed = in_collapsed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Collapse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::Focus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::Focus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_Focus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("Focus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetHadStickyUserActivationBeforeNavigation(
    bool in_has_gesture) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetHadStickyUserActivationBeforeNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_gesture"), in_has_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data> params(
          message);
  params.Allocate();

  params->has_gesture = in_has_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetHadStickyUserActivationBeforeNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::BubbleLogicalScroll(
    ::blink::mojom::ScrollDirection in_direction, ::ui::ScrollGranularity in_granularity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::BubbleLogicalScroll", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("direction"), in_direction,
                        "<value of type ::blink::mojom::ScrollDirection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("granularity"), in_granularity,
                        "<value of type ::ui::ScrollGranularity>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kBubbleLogicalScroll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_BubbleLogicalScroll_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ScrollDirection>(
    in_direction,
    &params->direction);

  
  mojo::internal::Serialize<::ui::mojom::ScrollGranularity>(
    in_granularity,
    &params->granularity);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("BubbleLogicalScroll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::UpdateUserActivationState(
    ::blink::mojom::UserActivationUpdateType in_state_update_type, ::blink::mojom::UserActivationNotificationType in_notification_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::UpdateUserActivationState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state_update_type"), in_state_update_type,
                        "<value of type ::blink::mojom::UserActivationUpdateType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notification_type"), in_notification_type,
                        "<value of type ::blink::mojom::UserActivationNotificationType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kUpdateUserActivationState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_UpdateUserActivationState_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::UserActivationUpdateType>(
    in_state_update_type,
    &params->state_update_type);

  
  mojo::internal::Serialize<::blink::mojom::UserActivationNotificationType>(
    in_notification_type,
    &params->notification_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateUserActivationState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetEmbeddingToken(
    const ::base::UnguessableToken& in_embedding_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetEmbeddingToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("embedding_token"), in_embedding_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetEmbeddingToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetEmbeddingToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->embedding_token)::BaseType> embedding_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_embedding_token,
    embedding_token_fragment);

  params->embedding_token.Set(
      embedding_token_fragment.is_null() ? nullptr : embedding_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->embedding_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null embedding_token in RemoteFrame.SetEmbeddingToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetEmbeddingToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetPageFocus(
    bool in_is_focused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetPageFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_focused"), in_is_focused,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetPageFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetPageFocus_Params_Data> params(
          message);
  params.Allocate();

  params->is_focused = in_is_focused;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetPageFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::RenderFallbackContent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::RenderFallbackContent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kRenderFallbackContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_RenderFallbackContent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("RenderFallbackContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::AddResourceTimingFromChild(
    ::blink::mojom::ResourceTimingInfoPtr in_timing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::AddResourceTimingFromChild", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("timing"), in_timing,
                        "<value of type ::blink::mojom::ResourceTimingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kAddResourceTimingFromChild), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_AddResourceTimingFromChild_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->timing)::BaseType> timing_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ResourceTimingInfoDataView>(
    in_timing,
    timing_fragment);

  params->timing.Set(
      timing_fragment.is_null() ? nullptr : timing_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->timing.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null timing in RemoteFrame.AddResourceTimingFromChild request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("AddResourceTimingFromChild");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::ScrollRectToVisible(
    const ::gfx::RectF& in_rect, ::blink::mojom::ScrollIntoViewParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::ScrollRectToVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rect"), in_rect,
                        "<value of type const ::gfx::RectF&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::blink::mojom::ScrollIntoViewParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kScrollRectToVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_ScrollRectToVisible_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->rect)::BaseType> rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
    in_rect,
    rect_fragment);

  params->rect.Set(
      rect_fragment.is_null() ? nullptr : rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null rect in RemoteFrame.ScrollRectToVisible request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ScrollIntoViewParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RemoteFrame.ScrollRectToVisible request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ScrollRectToVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DidStartLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::DidStartLoading");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDidStartLoading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidStartLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStartLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DidStopLoading(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::DidStopLoading");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDidStopLoading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidStopLoading_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidStopLoading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::IntrinsicSizingInfoOfChildChanged(
    ::blink::mojom::IntrinsicSizingInfoPtr in_sizing_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::IntrinsicSizingInfoOfChildChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sizing_info"), in_sizing_info,
                        "<value of type ::blink::mojom::IntrinsicSizingInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sizing_info)::BaseType> sizing_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::IntrinsicSizingInfoDataView>(
    in_sizing_info,
    sizing_info_fragment);

  params->sizing_info.Set(
      sizing_info_fragment.is_null() ? nullptr : sizing_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sizing_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sizing_info in RemoteFrame.IntrinsicSizingInfoOfChildChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("IntrinsicSizingInfoOfChildChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DidSetFramePolicyHeaders(
    ::network::mojom::WebSandboxFlags in_sandbox_flags, const std::vector<::network::ParsedPermissionsPolicyDeclaration>& in_parsed_permissions_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::DidSetFramePolicyHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sandbox_flags"), in_sandbox_flags,
                        "<value of type ::network::mojom::WebSandboxFlags>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_permissions_policy"), in_parsed_permissions_policy,
                        "<value of type const std::vector<::network::ParsedPermissionsPolicyDeclaration>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDidSetFramePolicyHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
    in_sandbox_flags,
    &params->sandbox_flags);
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_permissions_policy)::BaseType>
      parsed_permissions_policy_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& parsed_permissions_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedPermissionsPolicyDeclarationDataView>>(
    in_parsed_permissions_policy,
    parsed_permissions_policy_fragment,
    &parsed_permissions_policy_validate_params);

  params->parsed_permissions_policy.Set(
      parsed_permissions_policy_fragment.is_null() ? nullptr : parsed_permissions_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parsed_permissions_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parsed_permissions_policy in RemoteFrame.DidSetFramePolicyHeaders request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidSetFramePolicyHeaders");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DidUpdateFramePolicy(
    const ::blink::FramePolicy& in_frame_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::DidUpdateFramePolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_policy"), in_frame_policy,
                        "<value of type const ::blink::FramePolicy&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDidUpdateFramePolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidUpdateFramePolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_policy)::BaseType> frame_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FramePolicyDataView>(
    in_frame_policy,
    frame_policy_fragment);

  params->frame_policy.Set(
      frame_policy_fragment.is_null() ? nullptr : frame_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_policy in RemoteFrame.DidUpdateFramePolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidUpdateFramePolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::UpdateOpener(
    const std::optional<::blink::FrameToken>& in_opener_frame_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::UpdateOpener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const std::optional<::blink::FrameToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kUpdateOpener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_UpdateOpener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_opener_frame_token,
    opener_frame_token_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("UpdateOpener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DetachAndDispose(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::DetachAndDispose");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDetachAndDispose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DetachAndDispose_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DetachAndDispose");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::EnableAutoResize(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::EnableAutoResize", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_size"), in_min_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size,
                        "<value of type const ::gfx::Size&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kEnableAutoResize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_EnableAutoResize_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_size)::BaseType> min_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_min_size,
    min_size_fragment);

  params->min_size.Set(
      min_size_fragment.is_null() ? nullptr : min_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->min_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null min_size in RemoteFrame.EnableAutoResize request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
    in_max_size,
    max_size_fragment);

  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->max_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null max_size in RemoteFrame.EnableAutoResize request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("EnableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DisableAutoResize(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::DisableAutoResize");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDisableAutoResize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DisableAutoResize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DisableAutoResize");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::DidUpdateVisualProperties(
    const ::cc::RenderFrameMetadata& in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::DidUpdateVisualProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type const ::cc::RenderFrameMetadata&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kDidUpdateVisualProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_DidUpdateVisualProperties_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  
  mojo::internal::Serialize<::cc::mojom::RenderFrameMetadataDataView>(
    in_metadata,
    metadata_fragment);

  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metadata.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metadata in RemoteFrame.DidUpdateVisualProperties request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("DidUpdateVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::SetFrameSinkId(
    const ::viz::FrameSinkId& in_frame_sink_id, bool in_allow_paint_holding) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::SetFrameSinkId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_sink_id"), in_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_paint_holding"), in_allow_paint_holding,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kSetFrameSinkId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_SetFrameSinkId_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_sink_id)::BaseType> frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_frame_sink_id,
    frame_sink_id_fragment);

  params->frame_sink_id.Set(
      frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_sink_id in RemoteFrame.SetFrameSinkId request");

  params->allow_paint_holding = in_allow_paint_holding;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("SetFrameSinkId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::ChildProcessGone(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteFrame::ChildProcessGone");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kChildProcessGone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_ChildProcessGone_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ChildProcessGone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::CreateRemoteChild(
    const ::blink::RemoteFrameToken& in_token, const std::optional<::blink::FrameToken>& in_opener_frame_token, ::blink::mojom::TreeScopeType in_tree_scope_type, ::blink::mojom::FrameReplicationStatePtr in_replication_state, ::blink::mojom::FrameOwnerPropertiesPtr in_owner_properties, bool in_is_loading, const ::base::UnguessableToken& in_devtools_frame_token, RemoteFrameInterfacesFromBrowserPtr in_remote_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::CreateRemoteChild", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::blink::RemoteFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("opener_frame_token"), in_opener_frame_token,
                        "<value of type const std::optional<::blink::FrameToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tree_scope_type"), in_tree_scope_type,
                        "<value of type ::blink::mojom::TreeScopeType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replication_state"), in_replication_state,
                        "<value of type ::blink::mojom::FrameReplicationStatePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("owner_properties"), in_owner_properties,
                        "<value of type ::blink::mojom::FrameOwnerPropertiesPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_loading"), in_is_loading,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devtools_frame_token"), in_devtools_frame_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote_frame_interfaces"), in_remote_frame_interfaces,
                        "<value of type RemoteFrameInterfacesFromBrowserPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kCreateRemoteChild), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_CreateRemoteChild_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null token in RemoteFrame.CreateRemoteChild request");
  mojo::internal::MessageFragment<decltype(params->opener_frame_token)>
      opener_frame_token_fragment(params.message());
  opener_frame_token_fragment.Claim(&params->opener_frame_token);
  
  mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
    in_opener_frame_token,
    opener_frame_token_fragment,
    true);

  
  mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
    in_tree_scope_type,
    &params->tree_scope_type);
  mojo::internal::MessageFragment<
      typename decltype(params->replication_state)::BaseType> replication_state_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
    in_replication_state,
    replication_state_fragment);

  params->replication_state.Set(
      replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->replication_state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null replication_state in RemoteFrame.CreateRemoteChild request");
  mojo::internal::MessageFragment<
      typename decltype(params->owner_properties)::BaseType> owner_properties_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
    in_owner_properties,
    owner_properties_fragment);

  params->owner_properties.Set(
      owner_properties_fragment.is_null() ? nullptr : owner_properties_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->owner_properties.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null owner_properties in RemoteFrame.CreateRemoteChild request");

  params->is_loading = in_is_loading;
  mojo::internal::MessageFragment<
      typename decltype(params->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_devtools_frame_token,
    devtools_frame_token_fragment);

  params->devtools_frame_token.Set(
      devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devtools_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devtools_frame_token in RemoteFrame.CreateRemoteChild request");
  mojo::internal::MessageFragment<
      typename decltype(params->remote_frame_interfaces)::BaseType> remote_frame_interfaces_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
    in_remote_frame_interfaces,
    remote_frame_interfaces_fragment);

  params->remote_frame_interfaces.Set(
      remote_frame_interfaces_fragment.is_null() ? nullptr : remote_frame_interfaces_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->remote_frame_interfaces.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null remote_frame_interfaces in RemoteFrame.CreateRemoteChild request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("CreateRemoteChild");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::CreateRemoteChildren(
    std::vector<CreateRemoteChildParamsPtr> in_params, const std::optional<::base::UnguessableToken>& in_navigation_metrics_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::CreateRemoteChildren", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type std::vector<CreateRemoteChildParamsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("navigation_metrics_token"), in_navigation_metrics_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kCreateRemoteChildren), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_CreateRemoteChildren_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType>
      params_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CreateRemoteChildParamsDataView>>(
    in_params,
    params_fragment,
    &params_validate_params);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in RemoteFrame.CreateRemoteChildren request");
  mojo::internal::MessageFragment<
      typename decltype(params->navigation_metrics_token)::BaseType> navigation_metrics_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_navigation_metrics_token,
    navigation_metrics_token_fragment);

  params->navigation_metrics_token.Set(
      navigation_metrics_token_fragment.is_null() ? nullptr : navigation_metrics_token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("CreateRemoteChildren");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteFrameProxy::ForwardFencedFrameEventToEmbedder(
    const std::string& in_event_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteFrame::ForwardFencedFrameEventToEmbedder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_type"), in_event_type,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteFrame::kForwardFencedFrameEventToEmbedder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_type)::BaseType> event_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_event_type,
    event_type_fragment);

  params->event_type.Set(
      event_type_fragment.is_null() ? nullptr : event_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_type in RemoteFrame.ForwardFencedFrameEventToEmbedder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteFrame::Name_);
  message.set_method_name("ForwardFencedFrameEventToEmbedder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemoteFrameStubDispatch::Accept(
    RemoteFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemoteFrame>(message->header()->name)) {
    case messages::RemoteFrame::kWillEnterFullscreen: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_WillEnterFullscreen_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_WillEnterFullscreen_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.0
      bool success = true;
      ::blink::mojom::FullscreenOptionsPtr p_options{};
      RemoteFrame_WillEnterFullscreen_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WillEnterFullscreen(        
        std::move(p_options));
      return true;
    }
    case messages::RemoteFrame::kEnforceInsecureNavigationsSet: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.1
      bool success = true;
      std::vector<uint32_t> p_set{};
      RemoteFrame_EnforceInsecureNavigationsSet_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSet(&p_set))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureNavigationsSet(        
        std::move(p_set));
      return true;
    }
    case messages::RemoteFrame::kSetFrameOwnerProperties: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetFrameOwnerProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetFrameOwnerProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.2
      bool success = true;
      ::blink::mojom::FrameOwnerPropertiesPtr p_properties{};
      RemoteFrame_SetFrameOwnerProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProperties(&p_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameOwnerProperties(        
        std::move(p_properties));
      return true;
    }
    case messages::RemoteFrame::kEnforceInsecureRequestPolicy: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.3
      bool success = true;
      ::blink::mojom::InsecureRequestPolicy p_policy{};
      RemoteFrame_EnforceInsecureRequestPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolicy(&p_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnforceInsecureRequestPolicy(        
        std::move(p_policy));
      return true;
    }
    case messages::RemoteFrame::kSetReplicatedOrigin: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedOrigin_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedOrigin_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.4
      bool success = true;
      ::url::Origin p_origin{};
      bool p_is_potentially_trustworthy_unique_origin{};
      RemoteFrame_SetReplicatedOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_is_potentially_trustworthy_unique_origin = input_data_view.is_potentially_trustworthy_unique_origin();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedOrigin(        
        std::move(p_origin), 
        std::move(p_is_potentially_trustworthy_unique_origin));
      return true;
    }
    case messages::RemoteFrame::kSetReplicatedIsAdFrame: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedIsAdFrame_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedIsAdFrame_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.5
      bool success = true;
      bool p_is_ad_frame{};
      RemoteFrame_SetReplicatedIsAdFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_ad_frame = input_data_view.is_ad_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedIsAdFrame(        
        std::move(p_is_ad_frame));
      return true;
    }
    case messages::RemoteFrame::kSetReplicatedName: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetReplicatedName_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetReplicatedName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.6
      bool success = true;
      std::string p_name{};
      std::string p_unique_name{};
      RemoteFrame_SetReplicatedName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadUniqueName(&p_unique_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetReplicatedName(        
        std::move(p_name), 
        std::move(p_unique_name));
      return true;
    }
    case messages::RemoteFrame::kDispatchLoadEventForFrameOwner: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.7
      bool success = true;
      RemoteFrame_DispatchLoadEventForFrameOwner_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoadEventForFrameOwner(        );
      return true;
    }
    case messages::RemoteFrame::kSetNeedsOcclusionTracking: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.8
      bool success = true;
      bool p_needs_tracking{};
      RemoteFrame_SetNeedsOcclusionTracking_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_needs_tracking = input_data_view.needs_tracking();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsOcclusionTracking(        
        std::move(p_needs_tracking));
      return true;
    }
    case messages::RemoteFrame::kCollapse: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_Collapse_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Collapse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.9
      bool success = true;
      bool p_collapsed{};
      RemoteFrame_Collapse_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_collapsed = input_data_view.collapsed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Collapse(        
        std::move(p_collapsed));
      return true;
    }
    case messages::RemoteFrame::kFocus: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_Focus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_Focus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.10
      bool success = true;
      RemoteFrame_Focus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Focus(        );
      return true;
    }
    case messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.11
      bool success = true;
      bool p_has_gesture{};
      RemoteFrame_SetHadStickyUserActivationBeforeNavigation_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_has_gesture = input_data_view.has_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHadStickyUserActivationBeforeNavigation(        
        std::move(p_has_gesture));
      return true;
    }
    case messages::RemoteFrame::kBubbleLogicalScroll: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_BubbleLogicalScroll_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_BubbleLogicalScroll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.12
      bool success = true;
      ::blink::mojom::ScrollDirection p_direction{};
      ::ui::ScrollGranularity p_granularity{};
      RemoteFrame_BubbleLogicalScroll_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (success && !input_data_view.ReadGranularity(&p_granularity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BubbleLogicalScroll(        
        std::move(p_direction), 
        std::move(p_granularity));
      return true;
    }
    case messages::RemoteFrame::kUpdateUserActivationState: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateUserActivationState_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateUserActivationState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.13
      bool success = true;
      ::blink::mojom::UserActivationUpdateType p_state_update_type{};
      ::blink::mojom::UserActivationNotificationType p_notification_type{};
      RemoteFrame_UpdateUserActivationState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStateUpdateType(&p_state_update_type))
        success = false;
      if (success && !input_data_view.ReadNotificationType(&p_notification_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateUserActivationState(        
        std::move(p_state_update_type), 
        std::move(p_notification_type));
      return true;
    }
    case messages::RemoteFrame::kSetEmbeddingToken: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetEmbeddingToken_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetEmbeddingToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.14
      bool success = true;
      ::base::UnguessableToken p_embedding_token{};
      RemoteFrame_SetEmbeddingToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEmbeddingToken(&p_embedding_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEmbeddingToken(        
        std::move(p_embedding_token));
      return true;
    }
    case messages::RemoteFrame::kSetPageFocus: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetPageFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetPageFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.15
      bool success = true;
      bool p_is_focused{};
      RemoteFrame_SetPageFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_focused = input_data_view.is_focused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPageFocus(        
        std::move(p_is_focused));
      return true;
    }
    case messages::RemoteFrame::kRenderFallbackContent: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_RenderFallbackContent_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_RenderFallbackContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.16
      bool success = true;
      RemoteFrame_RenderFallbackContent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenderFallbackContent(        );
      return true;
    }
    case messages::RemoteFrame::kAddResourceTimingFromChild: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_AddResourceTimingFromChild_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_AddResourceTimingFromChild_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.17
      bool success = true;
      ::blink::mojom::ResourceTimingInfoPtr p_timing{};
      RemoteFrame_AddResourceTimingFromChild_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTiming(&p_timing))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddResourceTimingFromChild(        
        std::move(p_timing));
      return true;
    }
    case messages::RemoteFrame::kScrollRectToVisible: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_ScrollRectToVisible_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ScrollRectToVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.18
      bool success = true;
      ::gfx::RectF p_rect{};
      ::blink::mojom::ScrollIntoViewParamsPtr p_params{};
      RemoteFrame_ScrollRectToVisible_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRect(&p_rect))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollRectToVisible(        
        std::move(p_rect), 
        std::move(p_params));
      return true;
    }
    case messages::RemoteFrame::kDidStartLoading: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStartLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStartLoading_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.19
      bool success = true;
      RemoteFrame_DidStartLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStartLoading(        );
      return true;
    }
    case messages::RemoteFrame::kDidStopLoading: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidStopLoading_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidStopLoading_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.20
      bool success = true;
      RemoteFrame_DidStopLoading_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidStopLoading(        );
      return true;
    }
    case messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.21
      bool success = true;
      ::blink::mojom::IntrinsicSizingInfoPtr p_sizing_info{};
      RemoteFrame_IntrinsicSizingInfoOfChildChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSizingInfo(&p_sizing_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntrinsicSizingInfoOfChildChanged(        
        std::move(p_sizing_info));
      return true;
    }
    case messages::RemoteFrame::kDidSetFramePolicyHeaders: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.22
      bool success = true;
      ::network::mojom::WebSandboxFlags p_sandbox_flags{};
      std::vector<::network::ParsedPermissionsPolicyDeclaration> p_parsed_permissions_policy{};
      RemoteFrame_DidSetFramePolicyHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSandboxFlags(&p_sandbox_flags))
        success = false;
      if (success && !input_data_view.ReadParsedPermissionsPolicy(&p_parsed_permissions_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidSetFramePolicyHeaders(        
        std::move(p_sandbox_flags), 
        std::move(p_parsed_permissions_policy));
      return true;
    }
    case messages::RemoteFrame::kDidUpdateFramePolicy: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidUpdateFramePolicy_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidUpdateFramePolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.23
      bool success = true;
      ::blink::FramePolicy p_frame_policy{};
      RemoteFrame_DidUpdateFramePolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFramePolicy(&p_frame_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateFramePolicy(        
        std::move(p_frame_policy));
      return true;
    }
    case messages::RemoteFrame::kUpdateOpener: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_UpdateOpener_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_UpdateOpener_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.24
      bool success = true;
      std::optional<::blink::FrameToken> p_opener_frame_token{};
      RemoteFrame_UpdateOpener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateOpener(        
        std::move(p_opener_frame_token));
      return true;
    }
    case messages::RemoteFrame::kDetachAndDispose: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DetachAndDispose_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DetachAndDispose_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.25
      bool success = true;
      RemoteFrame_DetachAndDispose_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetachAndDispose(        );
      return true;
    }
    case messages::RemoteFrame::kEnableAutoResize: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_EnableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_EnableAutoResize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.26
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      RemoteFrame_EnableAutoResize_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAutoResize(        
        std::move(p_min_size), 
        std::move(p_max_size));
      return true;
    }
    case messages::RemoteFrame::kDisableAutoResize: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DisableAutoResize_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DisableAutoResize_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.27
      bool success = true;
      RemoteFrame_DisableAutoResize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAutoResize(        );
      return true;
    }
    case messages::RemoteFrame::kDidUpdateVisualProperties: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_DidUpdateVisualProperties_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_DidUpdateVisualProperties_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.28
      bool success = true;
      ::cc::RenderFrameMetadata p_metadata{};
      RemoteFrame_DidUpdateVisualProperties_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidUpdateVisualProperties(        
        std::move(p_metadata));
      return true;
    }
    case messages::RemoteFrame::kSetFrameSinkId: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_SetFrameSinkId_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_SetFrameSinkId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.29
      bool success = true;
      ::viz::FrameSinkId p_frame_sink_id{};
      bool p_allow_paint_holding{};
      RemoteFrame_SetFrameSinkId_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameSinkId(&p_frame_sink_id))
        success = false;
      if (success)
        p_allow_paint_holding = input_data_view.allow_paint_holding();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFrameSinkId(        
        std::move(p_frame_sink_id), 
        std::move(p_allow_paint_holding));
      return true;
    }
    case messages::RemoteFrame::kChildProcessGone: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_ChildProcessGone_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ChildProcessGone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.30
      bool success = true;
      RemoteFrame_ChildProcessGone_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChildProcessGone(        );
      return true;
    }
    case messages::RemoteFrame::kCreateRemoteChild: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_CreateRemoteChild_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_CreateRemoteChild_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.31
      bool success = true;
      ::blink::RemoteFrameToken p_token{};
      std::optional<::blink::FrameToken> p_opener_frame_token{};
      ::blink::mojom::TreeScopeType p_tree_scope_type{};
      ::blink::mojom::FrameReplicationStatePtr p_replication_state{};
      ::blink::mojom::FrameOwnerPropertiesPtr p_owner_properties{};
      bool p_is_loading{};
      ::base::UnguessableToken p_devtools_frame_token{};
      RemoteFrameInterfacesFromBrowserPtr p_remote_frame_interfaces{};
      RemoteFrame_CreateRemoteChild_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadOpenerFrameToken(&p_opener_frame_token))
        success = false;
      if (success && !input_data_view.ReadTreeScopeType(&p_tree_scope_type))
        success = false;
      if (success && !input_data_view.ReadReplicationState(&p_replication_state))
        success = false;
      if (success && !input_data_view.ReadOwnerProperties(&p_owner_properties))
        success = false;
      if (success)
        p_is_loading = input_data_view.is_loading();
      if (success && !input_data_view.ReadDevtoolsFrameToken(&p_devtools_frame_token))
        success = false;
      if (success && !input_data_view.ReadRemoteFrameInterfaces(&p_remote_frame_interfaces))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRemoteChild(        
        std::move(p_token), 
        std::move(p_opener_frame_token), 
        std::move(p_tree_scope_type), 
        std::move(p_replication_state), 
        std::move(p_owner_properties), 
        std::move(p_is_loading), 
        std::move(p_devtools_frame_token), 
        std::move(p_remote_frame_interfaces));
      return true;
    }
    case messages::RemoteFrame::kCreateRemoteChildren: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_CreateRemoteChildren_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_CreateRemoteChildren_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.32
      bool success = true;
      std::vector<CreateRemoteChildParamsPtr> p_params{};
      std::optional<::base::UnguessableToken> p_navigation_metrics_token{};
      RemoteFrame_CreateRemoteChildren_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success && !input_data_view.ReadNavigationMetricsToken(&p_navigation_metrics_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateRemoteChildren(        
        std::move(p_params), 
        std::move(p_navigation_metrics_token));
      return true;
    }
    case messages::RemoteFrame::kForwardFencedFrameEventToEmbedder: {
      DCHECK(message->is_serialized());
      internal::RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data* params =
          reinterpret_cast<internal::RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteFrame.33
      bool success = true;
      std::string p_event_type{};
      RemoteFrame_ForwardFencedFrameEventToEmbedder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventType(&p_event_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteFrame::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardFencedFrameEventToEmbedder(        
        std::move(p_event_type));
      return true;
    }
  }
  return false;
}

// static
bool RemoteFrameStubDispatch::AcceptWithResponder(
    RemoteFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemoteFrame>(message->header()->name)) {
    case messages::RemoteFrame::kWillEnterFullscreen: {
      break;
    }
    case messages::RemoteFrame::kEnforceInsecureNavigationsSet: {
      break;
    }
    case messages::RemoteFrame::kSetFrameOwnerProperties: {
      break;
    }
    case messages::RemoteFrame::kEnforceInsecureRequestPolicy: {
      break;
    }
    case messages::RemoteFrame::kSetReplicatedOrigin: {
      break;
    }
    case messages::RemoteFrame::kSetReplicatedIsAdFrame: {
      break;
    }
    case messages::RemoteFrame::kSetReplicatedName: {
      break;
    }
    case messages::RemoteFrame::kDispatchLoadEventForFrameOwner: {
      break;
    }
    case messages::RemoteFrame::kSetNeedsOcclusionTracking: {
      break;
    }
    case messages::RemoteFrame::kCollapse: {
      break;
    }
    case messages::RemoteFrame::kFocus: {
      break;
    }
    case messages::RemoteFrame::kSetHadStickyUserActivationBeforeNavigation: {
      break;
    }
    case messages::RemoteFrame::kBubbleLogicalScroll: {
      break;
    }
    case messages::RemoteFrame::kUpdateUserActivationState: {
      break;
    }
    case messages::RemoteFrame::kSetEmbeddingToken: {
      break;
    }
    case messages::RemoteFrame::kSetPageFocus: {
      break;
    }
    case messages::RemoteFrame::kRenderFallbackContent: {
      break;
    }
    case messages::RemoteFrame::kAddResourceTimingFromChild: {
      break;
    }
    case messages::RemoteFrame::kScrollRectToVisible: {
      break;
    }
    case messages::RemoteFrame::kDidStartLoading: {
      break;
    }
    case messages::RemoteFrame::kDidStopLoading: {
      break;
    }
    case messages::RemoteFrame::kIntrinsicSizingInfoOfChildChanged: {
      break;
    }
    case messages::RemoteFrame::kDidSetFramePolicyHeaders: {
      break;
    }
    case messages::RemoteFrame::kDidUpdateFramePolicy: {
      break;
    }
    case messages::RemoteFrame::kUpdateOpener: {
      break;
    }
    case messages::RemoteFrame::kDetachAndDispose: {
      break;
    }
    case messages::RemoteFrame::kEnableAutoResize: {
      break;
    }
    case messages::RemoteFrame::kDisableAutoResize: {
      break;
    }
    case messages::RemoteFrame::kDidUpdateVisualProperties: {
      break;
    }
    case messages::RemoteFrame::kSetFrameSinkId: {
      break;
    }
    case messages::RemoteFrame::kChildProcessGone: {
      break;
    }
    case messages::RemoteFrame::kCreateRemoteChild: {
      break;
    }
    case messages::RemoteFrame::kCreateRemoteChildren: {
      break;
    }
    case messages::RemoteFrame::kForwardFencedFrameEventToEmbedder: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoteFrameValidationInfo[] = {
    { &internal::RemoteFrame_WillEnterFullscreen_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_EnforceInsecureNavigationsSet_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetFrameOwnerProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_EnforceInsecureRequestPolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetReplicatedOrigin_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetReplicatedIsAdFrame_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetReplicatedName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DispatchLoadEventForFrameOwner_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetNeedsOcclusionTracking_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_Collapse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_Focus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetHadStickyUserActivationBeforeNavigation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_BubbleLogicalScroll_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_UpdateUserActivationState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetEmbeddingToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetPageFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_RenderFallbackContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_AddResourceTimingFromChild_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_ScrollRectToVisible_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DidStartLoading_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DidStopLoading_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_IntrinsicSizingInfoOfChildChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DidSetFramePolicyHeaders_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DidUpdateFramePolicy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_UpdateOpener_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DetachAndDispose_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_EnableAutoResize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DisableAutoResize_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_DidUpdateVisualProperties_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_SetFrameSinkId_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_ChildProcessGone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_CreateRemoteChild_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_CreateRemoteChildren_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteFrame_ForwardFencedFrameEventToEmbedder_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoteFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RemoteFrame::Name_,
    kRemoteFrameValidationInfo);
}

// The declaration includes the definition on other builds.

RemoteMainFrame::IPCStableHashFunction RemoteMainFrame::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemoteMainFrame>(message.name())) {
    case messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo: {
      return &RemoteMainFrame::UpdateTextAutosizerPageInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemoteMainFrame::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemoteMainFrame>(message.name())) {
      case messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo:
            return "Receive blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo";
    }
  } else {
    switch (static_cast<messages::RemoteMainFrame>(message.name())) {
      case messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo:
            return "Receive reply blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemoteMainFrame::UpdateTextAutosizerPageInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa53f8b44;  // IPCStableHash for blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

RemoteMainFrameProxy::RemoteMainFrameProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameProxy::UpdateTextAutosizerPageInfo(
    ::blink::mojom::TextAutosizerPageInfoPtr in_page_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteMainFrame::UpdateTextAutosizerPageInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_info"), in_page_info,
                        "<value of type ::blink::mojom::TextAutosizerPageInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_info)::BaseType> page_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TextAutosizerPageInfoDataView>(
    in_page_info,
    page_info_fragment);

  params->page_info.Set(
      page_info_fragment.is_null() ? nullptr : page_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_info in RemoteMainFrame.UpdateTextAutosizerPageInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrame::Name_);
  message.set_method_name("UpdateTextAutosizerPageInfo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool RemoteMainFrameStubDispatch::Accept(
    RemoteMainFrame* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemoteMainFrame>(message->header()->name)) {
    case messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo: {
      DCHECK(message->is_serialized());
      internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteMainFrame.0
      bool success = true;
      ::blink::mojom::TextAutosizerPageInfoPtr p_page_info{};
      RemoteMainFrame_UpdateTextAutosizerPageInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageInfo(&p_page_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrame::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTextAutosizerPageInfo(        
        std::move(p_page_info));
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameStubDispatch::AcceptWithResponder(
    RemoteMainFrame* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemoteMainFrame>(message->header()->name)) {
    case messages::RemoteMainFrame::kUpdateTextAutosizerPageInfo: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoteMainFrameValidationInfo[] = {
    { &internal::RemoteMainFrame_UpdateTextAutosizerPageInfo_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoteMainFrameRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RemoteMainFrame::Name_,
    kRemoteMainFrameValidationInfo);
}

// The declaration includes the definition on other builds.

RemoteMainFrameHost::IPCStableHashFunction RemoteMainFrameHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RemoteMainFrameHost>(message.name())) {
    case messages::RemoteMainFrameHost::kFocusPage: {
      return &RemoteMainFrameHost::FocusPage_Sym::IPCStableHash;
    }
    case messages::RemoteMainFrameHost::kTakeFocus: {
      return &RemoteMainFrameHost::TakeFocus_Sym::IPCStableHash;
    }
    case messages::RemoteMainFrameHost::kUpdateTargetURL: {
      return &RemoteMainFrameHost::UpdateTargetURL_Sym::IPCStableHash;
    }
    case messages::RemoteMainFrameHost::kRouteCloseEvent: {
      return &RemoteMainFrameHost::RouteCloseEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RemoteMainFrameHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RemoteMainFrameHost>(message.name())) {
      case messages::RemoteMainFrameHost::kFocusPage:
            return "Receive blink::mojom::RemoteMainFrameHost::FocusPage";
      case messages::RemoteMainFrameHost::kTakeFocus:
            return "Receive blink::mojom::RemoteMainFrameHost::TakeFocus";
      case messages::RemoteMainFrameHost::kUpdateTargetURL:
            return "Receive blink::mojom::RemoteMainFrameHost::UpdateTargetURL";
      case messages::RemoteMainFrameHost::kRouteCloseEvent:
            return "Receive blink::mojom::RemoteMainFrameHost::RouteCloseEvent";
    }
  } else {
    switch (static_cast<messages::RemoteMainFrameHost>(message.name())) {
      case messages::RemoteMainFrameHost::kFocusPage:
            return "Receive reply blink::mojom::RemoteMainFrameHost::FocusPage";
      case messages::RemoteMainFrameHost::kTakeFocus:
            return "Receive reply blink::mojom::RemoteMainFrameHost::TakeFocus";
      case messages::RemoteMainFrameHost::kUpdateTargetURL:
            return "Receive reply blink::mojom::RemoteMainFrameHost::UpdateTargetURL";
      case messages::RemoteMainFrameHost::kRouteCloseEvent:
            return "Receive reply blink::mojom::RemoteMainFrameHost::RouteCloseEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RemoteMainFrameHost::FocusPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c647d4a;  // IPCStableHash for blink::mojom::RemoteMainFrameHost::FocusPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteMainFrameHost::TakeFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x135955a1;  // IPCStableHash for blink::mojom::RemoteMainFrameHost::TakeFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteMainFrameHost::UpdateTargetURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x954ace69;  // IPCStableHash for blink::mojom::RemoteMainFrameHost::UpdateTargetURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RemoteMainFrameHost::RouteCloseEvent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x73e422d4;  // IPCStableHash for blink::mojom::RemoteMainFrameHost::RouteCloseEvent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
      RemoteMainFrameHost::UpdateTargetURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(const RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback&) = delete;
  RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback& operator=(const RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RemoteMainFrameHost::UpdateTargetURLCallback callback_;
};

RemoteMainFrameHostProxy::RemoteMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RemoteMainFrameHostProxy::FocusPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteMainFrameHost::FocusPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrameHost::kFocusPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_FocusPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("FocusPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteMainFrameHostProxy::TakeFocus(
    bool in_reverse) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteMainFrameHost::TakeFocus", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reverse"), in_reverse,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrameHost::kTakeFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_TakeFocus_Params_Data> params(
          message);
  params.Allocate();

  params->reverse = in_reverse;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("TakeFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RemoteMainFrameHostProxy::UpdateTargetURL(
    const ::GURL& in_url, UpdateTargetURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RemoteMainFrameHost::UpdateTargetURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrameHost::kUpdateTargetURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RemoteMainFrameHost.UpdateTargetURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RemoteMainFrameHostProxy::RouteCloseEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RemoteMainFrameHost::RouteCloseEvent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrameHost::kRouteCloseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("RouteCloseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RemoteMainFrameHost::UpdateTargetURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder> proxy(
        new RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RemoteMainFrameHost::UpdateTargetURLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool RemoteMainFrameHost_UpdateTargetURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RemoteMainFrameHost.2
  bool success = true;
  RemoteMainFrameHost_UpdateTargetURL_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RemoteMainFrameHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::RemoteMainFrameHost::UpdateTargetURL");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RemoteMainFrameHost::kUpdateTargetURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RemoteMainFrameHost::Name_);
  message.set_method_name("UpdateTargetURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RemoteMainFrameHostStubDispatch::Accept(
    RemoteMainFrameHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RemoteMainFrameHost>(message->header()->name)) {
    case messages::RemoteMainFrameHost::kFocusPage: {
      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_FocusPage_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_FocusPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteMainFrameHost.0
      bool success = true;
      RemoteMainFrameHost_FocusPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusPage(        );
      return true;
    }
    case messages::RemoteMainFrameHost::kTakeFocus: {
      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_TakeFocus_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_TakeFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteMainFrameHost.1
      bool success = true;
      bool p_reverse{};
      RemoteMainFrameHost_TakeFocus_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reverse = input_data_view.reverse();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TakeFocus(        
        std::move(p_reverse));
      return true;
    }
    case messages::RemoteMainFrameHost::kUpdateTargetURL: {
      break;
    }
    case messages::RemoteMainFrameHost::kRouteCloseEvent: {
      DCHECK(message->is_serialized());
      internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data* params =
          reinterpret_cast<internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RemoteMainFrameHost.3
      bool success = true;
      RemoteMainFrameHost_RouteCloseEvent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RouteCloseEvent(        );
      return true;
    }
  }
  return false;
}

// static
bool RemoteMainFrameHostStubDispatch::AcceptWithResponder(
    RemoteMainFrameHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RemoteMainFrameHost>(message->header()->name)) {
    case messages::RemoteMainFrameHost::kFocusPage: {
      break;
    }
    case messages::RemoteMainFrameHost::kTakeFocus: {
      break;
    }
    case messages::RemoteMainFrameHost::kUpdateTargetURL: {
      internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data* params =
          reinterpret_cast<
              internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RemoteMainFrameHost.2
      bool success = true;
      ::GURL p_url{};
      RemoteMainFrameHost_UpdateTargetURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RemoteMainFrameHost::Name_, 2, false);
        return false;
      }
      auto callback =
          RemoteMainFrameHost_UpdateTargetURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTargetURL(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::RemoteMainFrameHost::kRouteCloseEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRemoteMainFrameHostValidationInfo[] = {
    { &internal::RemoteMainFrameHost_FocusPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteMainFrameHost_TakeFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RemoteMainFrameHost_UpdateTargetURL_Params_Data::Validate,
     &internal::RemoteMainFrameHost_UpdateTargetURL_ResponseParams_Data::Validate},
    { &internal::RemoteMainFrameHost_RouteCloseEvent_Params_Data::Validate,
     nullptr /* no response */},
};

bool RemoteMainFrameHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RemoteMainFrameHost::Name_,
    kRemoteMainFrameHostValidationInfo);
}

bool RemoteMainFrameHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::RemoteMainFrameHost::Name_,
    kRemoteMainFrameHostValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::RemoteMainFrameInterfaces::DataView, ::blink::mojom::RemoteMainFrameInterfacesPtr>::Read(
    ::blink::mojom::RemoteMainFrameInterfaces::DataView input,
    ::blink::mojom::RemoteMainFrameInterfacesPtr* output) {
  bool success = true;
  ::blink::mojom::RemoteMainFrameInterfacesPtr result(::blink::mojom::RemoteMainFrameInterfaces::New());
  
      if (success) {
        result->main_frame_host =
            input.TakeMainFrameHost<decltype(result->main_frame_host)>();
      }
      if (success) {
        result->main_frame =
            input.TakeMainFrame<decltype(result->main_frame)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::RemoteFrameInterfacesFromRenderer::DataView, ::blink::mojom::RemoteFrameInterfacesFromRendererPtr>::Read(
    ::blink::mojom::RemoteFrameInterfacesFromRenderer::DataView input,
    ::blink::mojom::RemoteFrameInterfacesFromRendererPtr* output) {
  bool success = true;
  ::blink::mojom::RemoteFrameInterfacesFromRendererPtr result(::blink::mojom::RemoteFrameInterfacesFromRenderer::New());
  
      if (success) {
        result->frame =
            input.TakeFrame<decltype(result->frame)>();
      }
      if (success) {
        result->frame_host_receiver =
            input.TakeFrameHostReceiver<decltype(result->frame_host_receiver)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::RemoteFrameInterfacesFromBrowser::DataView, ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr>::Read(
    ::blink::mojom::RemoteFrameInterfacesFromBrowser::DataView input,
    ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr* output) {
  bool success = true;
  ::blink::mojom::RemoteFrameInterfacesFromBrowserPtr result(::blink::mojom::RemoteFrameInterfacesFromBrowser::New());
  
      if (success) {
        result->frame_receiver =
            input.TakeFrameReceiver<decltype(result->frame_receiver)>();
      }
      if (success) {
        result->frame_host =
            input.TakeFrameHost<decltype(result->frame_host)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CreateRemoteChildParams::DataView, ::blink::mojom::CreateRemoteChildParamsPtr>::Read(
    ::blink::mojom::CreateRemoteChildParams::DataView input,
    ::blink::mojom::CreateRemoteChildParamsPtr* output) {
  bool success = true;
  ::blink::mojom::CreateRemoteChildParamsPtr result(::blink::mojom::CreateRemoteChildParams::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadOpenerFrameToken(&result->opener_frame_token))
        success = false;
      if (success && !input.ReadTreeScopeType(&result->tree_scope_type))
        success = false;
      if (success && !input.ReadReplicationState(&result->replication_state))
        success = false;
      if (success && !input.ReadOwnerProperties(&result->owner_properties))
        success = false;
      if (success)
        result->is_loading = input.is_loading();
      if (success && !input.ReadDevtoolsFrameToken(&result->devtools_frame_token))
        success = false;
      if (success && !input.ReadFrameInterfaces(&result->frame_interfaces))
        success = false;
      if (success && !input.ReadChildParams(&result->child_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::OpenURLParams::DataView, ::blink::mojom::OpenURLParamsPtr>::Read(
    ::blink::mojom::OpenURLParams::DataView input,
    ::blink::mojom::OpenURLParamsPtr* output) {
  bool success = true;
  ::blink::mojom::OpenURLParamsPtr result(::blink::mojom::OpenURLParams::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadInitiatorOrigin(&result->initiator_origin))
        success = false;
      if (success && !input.ReadInitiatorBaseUrl(&result->initiator_base_url))
        success = false;
      if (success && !input.ReadActualNavigationStart(&result->actual_navigation_start))
        success = false;
      if (success && !input.ReadInitiatorFrameToken(&result->initiator_frame_token))
        success = false;
      if (success && !input.ReadPostBody(&result->post_body))
        success = false;
      if (success && !input.ReadExtraHeaders(&result->extra_headers))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success)
        result->is_form_submission = input.is_form_submission();
      if (success && !input.ReadDisposition(&result->disposition))
        success = false;
      if (success)
        result->should_replace_current_entry = input.should_replace_current_entry();
      if (success)
        result->user_gesture = input.user_gesture();
      if (success)
        result->is_unfenced_top_navigation = input.is_unfenced_top_navigation();
      if (success && !input.ReadTriggeringEventInfo(&result->triggering_event_info))
        success = false;
      if (success) {
        result->blob_url_token =
            input.TakeBlobUrlToken<decltype(result->blob_url_token)>();
      }
      if (success && !input.ReadHrefTranslate(&result->href_translate))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadDownloadPolicy(&result->download_policy))
        success = false;
      if (success && !input.ReadSourceLocation(&result->source_location))
        success = false;
      if (success) {
        result->initiator_navigation_state_keep_alive_handle =
            input.TakeInitiatorNavigationStateKeepAliveHandle<decltype(result->initiator_navigation_state_keep_alive_handle)>();
      }
      if (success && !input.ReadInitiatorActivationAndAdStatus(&result->initiator_activation_and_ad_status))
        success = false;
      if (success)
        result->is_container_initiated = input.is_container_initiated();
      if (success)
        result->has_rel_opener = input.has_rel_opener();
      if (success && !input.ReadStorageAccessApiStatus(&result->storage_access_api_status))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


NavigationStateKeepAliveHandleAsyncWaiter::NavigationStateKeepAliveHandleAsyncWaiter(
    NavigationStateKeepAliveHandle* proxy) : proxy_(proxy) {}

NavigationStateKeepAliveHandleAsyncWaiter::~NavigationStateKeepAliveHandleAsyncWaiter() = default;





void RemoteFrameHostInterceptorForTesting::SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) {
  GetForwardingInterface()->SetInheritedEffectiveTouchAction(
    std::move(touch_action)
    );
}
void RemoteFrameHostInterceptorForTesting::UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled, bool display_locked) {
  GetForwardingInterface()->UpdateRenderThrottlingStatus(
    std::move(is_throttled)
    , 
    std::move(subtree_throttled)
    , 
    std::move(display_locked)
    );
}
void RemoteFrameHostInterceptorForTesting::VisibilityChanged(::blink::mojom::FrameVisibility visibility) {
  GetForwardingInterface()->VisibilityChanged(
    std::move(visibility)
    );
}
void RemoteFrameHostInterceptorForTesting::DidFocusFrame() {
  GetForwardingInterface()->DidFocusFrame();
}
void RemoteFrameHostInterceptorForTesting::CheckCompleted() {
  GetForwardingInterface()->CheckCompleted();
}
void RemoteFrameHostInterceptorForTesting::CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) {
  GetForwardingInterface()->CapturePaintPreviewOfCrossProcessSubframe(
    std::move(clip_rect)
    , 
    std::move(guid)
    );
}
void RemoteFrameHostInterceptorForTesting::SetIsInert(bool inert) {
  GetForwardingInterface()->SetIsInert(
    std::move(inert)
    );
}
void RemoteFrameHostInterceptorForTesting::DidChangeOpener(const std::optional<::blink::LocalFrameToken>& opener_frame) {
  GetForwardingInterface()->DidChangeOpener(
    std::move(opener_frame)
    );
}
void RemoteFrameHostInterceptorForTesting::AdvanceFocus(::blink::mojom::FocusType focus_type, const ::blink::LocalFrameToken& source_frame_token) {
  GetForwardingInterface()->AdvanceFocus(
    std::move(focus_type)
    , 
    std::move(source_frame_token)
    );
}
void RemoteFrameHostInterceptorForTesting::RouteMessageEvent(const std::optional<::blink::LocalFrameToken>& source_frame_token, const ::url::Origin& source_origin, const std::optional<::url::Origin>& target_origin, ::blink::TransferableMessage message) {
  GetForwardingInterface()->RouteMessageEvent(
    std::move(source_frame_token)
    , 
    std::move(source_origin)
    , 
    std::move(target_origin)
    , 
    std::move(message)
    );
}
void RemoteFrameHostInterceptorForTesting::PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) {
  GetForwardingInterface()->PrintCrossProcessSubframe(
    std::move(frame_content_rect)
    , 
    std::move(document_cookie)
    );
}
void RemoteFrameHostInterceptorForTesting::Detach() {
  GetForwardingInterface()->Detach();
}
void RemoteFrameHostInterceptorForTesting::UpdateViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::FrameVisualProperties>& visual_properties) {
  GetForwardingInterface()->UpdateViewportIntersection(
    std::move(intersection_state)
    , 
    std::move(visual_properties)
    );
}
void RemoteFrameHostInterceptorForTesting::SynchronizeVisualProperties(const ::blink::FrameVisualProperties& properties) {
  GetForwardingInterface()->SynchronizeVisualProperties(
    std::move(properties)
    );
}
void RemoteFrameHostInterceptorForTesting::OpenURL(OpenURLParamsPtr params) {
  GetForwardingInterface()->OpenURL(
    std::move(params)
    );
}
RemoteFrameHostAsyncWaiter::RemoteFrameHostAsyncWaiter(
    RemoteFrameHost* proxy) : proxy_(proxy) {}

RemoteFrameHostAsyncWaiter::~RemoteFrameHostAsyncWaiter() = default;





void RemoteFrameInterceptorForTesting::WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) {
  GetForwardingInterface()->WillEnterFullscreen(
    std::move(options)
    );
}
void RemoteFrameInterceptorForTesting::EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) {
  GetForwardingInterface()->EnforceInsecureNavigationsSet(
    std::move(set)
    );
}
void RemoteFrameInterceptorForTesting::SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) {
  GetForwardingInterface()->SetFrameOwnerProperties(
    std::move(properties)
    );
}
void RemoteFrameInterceptorForTesting::EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) {
  GetForwardingInterface()->EnforceInsecureRequestPolicy(
    std::move(policy)
    );
}
void RemoteFrameInterceptorForTesting::SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) {
  GetForwardingInterface()->SetReplicatedOrigin(
    std::move(origin)
    , 
    std::move(is_potentially_trustworthy_unique_origin)
    );
}
void RemoteFrameInterceptorForTesting::SetReplicatedIsAdFrame(bool is_ad_frame) {
  GetForwardingInterface()->SetReplicatedIsAdFrame(
    std::move(is_ad_frame)
    );
}
void RemoteFrameInterceptorForTesting::SetReplicatedName(const std::string& name, const std::string& unique_name) {
  GetForwardingInterface()->SetReplicatedName(
    std::move(name)
    , 
    std::move(unique_name)
    );
}
void RemoteFrameInterceptorForTesting::DispatchLoadEventForFrameOwner() {
  GetForwardingInterface()->DispatchLoadEventForFrameOwner();
}
void RemoteFrameInterceptorForTesting::SetNeedsOcclusionTracking(bool needs_tracking) {
  GetForwardingInterface()->SetNeedsOcclusionTracking(
    std::move(needs_tracking)
    );
}
void RemoteFrameInterceptorForTesting::Collapse(bool collapsed) {
  GetForwardingInterface()->Collapse(
    std::move(collapsed)
    );
}
void RemoteFrameInterceptorForTesting::Focus() {
  GetForwardingInterface()->Focus();
}
void RemoteFrameInterceptorForTesting::SetHadStickyUserActivationBeforeNavigation(bool has_gesture) {
  GetForwardingInterface()->SetHadStickyUserActivationBeforeNavigation(
    std::move(has_gesture)
    );
}
void RemoteFrameInterceptorForTesting::BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) {
  GetForwardingInterface()->BubbleLogicalScroll(
    std::move(direction)
    , 
    std::move(granularity)
    );
}
void RemoteFrameInterceptorForTesting::UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) {
  GetForwardingInterface()->UpdateUserActivationState(
    std::move(state_update_type)
    , 
    std::move(notification_type)
    );
}
void RemoteFrameInterceptorForTesting::SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) {
  GetForwardingInterface()->SetEmbeddingToken(
    std::move(embedding_token)
    );
}
void RemoteFrameInterceptorForTesting::SetPageFocus(bool is_focused) {
  GetForwardingInterface()->SetPageFocus(
    std::move(is_focused)
    );
}
void RemoteFrameInterceptorForTesting::RenderFallbackContent() {
  GetForwardingInterface()->RenderFallbackContent();
}
void RemoteFrameInterceptorForTesting::AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) {
  GetForwardingInterface()->AddResourceTimingFromChild(
    std::move(timing)
    );
}
void RemoteFrameInterceptorForTesting::ScrollRectToVisible(const ::gfx::RectF& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) {
  GetForwardingInterface()->ScrollRectToVisible(
    std::move(rect)
    , 
    std::move(params)
    );
}
void RemoteFrameInterceptorForTesting::DidStartLoading() {
  GetForwardingInterface()->DidStartLoading();
}
void RemoteFrameInterceptorForTesting::DidStopLoading() {
  GetForwardingInterface()->DidStopLoading();
}
void RemoteFrameInterceptorForTesting::IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) {
  GetForwardingInterface()->IntrinsicSizingInfoOfChildChanged(
    std::move(sizing_info)
    );
}
void RemoteFrameInterceptorForTesting::DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::network::ParsedPermissionsPolicyDeclaration>& parsed_permissions_policy) {
  GetForwardingInterface()->DidSetFramePolicyHeaders(
    std::move(sandbox_flags)
    , 
    std::move(parsed_permissions_policy)
    );
}
void RemoteFrameInterceptorForTesting::DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) {
  GetForwardingInterface()->DidUpdateFramePolicy(
    std::move(frame_policy)
    );
}
void RemoteFrameInterceptorForTesting::UpdateOpener(const std::optional<::blink::FrameToken>& opener_frame_token) {
  GetForwardingInterface()->UpdateOpener(
    std::move(opener_frame_token)
    );
}
void RemoteFrameInterceptorForTesting::DetachAndDispose() {
  GetForwardingInterface()->DetachAndDispose();
}
void RemoteFrameInterceptorForTesting::EnableAutoResize(const ::gfx::Size& min_size, const ::gfx::Size& max_size) {
  GetForwardingInterface()->EnableAutoResize(
    std::move(min_size)
    , 
    std::move(max_size)
    );
}
void RemoteFrameInterceptorForTesting::DisableAutoResize() {
  GetForwardingInterface()->DisableAutoResize();
}
void RemoteFrameInterceptorForTesting::DidUpdateVisualProperties(const ::cc::RenderFrameMetadata& metadata) {
  GetForwardingInterface()->DidUpdateVisualProperties(
    std::move(metadata)
    );
}
void RemoteFrameInterceptorForTesting::SetFrameSinkId(const ::viz::FrameSinkId& frame_sink_id, bool allow_paint_holding) {
  GetForwardingInterface()->SetFrameSinkId(
    std::move(frame_sink_id)
    , 
    std::move(allow_paint_holding)
    );
}
void RemoteFrameInterceptorForTesting::ChildProcessGone() {
  GetForwardingInterface()->ChildProcessGone();
}
void RemoteFrameInterceptorForTesting::CreateRemoteChild(const ::blink::RemoteFrameToken& token, const std::optional<::blink::FrameToken>& opener_frame_token, ::blink::mojom::TreeScopeType tree_scope_type, ::blink::mojom::FrameReplicationStatePtr replication_state, ::blink::mojom::FrameOwnerPropertiesPtr owner_properties, bool is_loading, const ::base::UnguessableToken& devtools_frame_token, RemoteFrameInterfacesFromBrowserPtr remote_frame_interfaces) {
  GetForwardingInterface()->CreateRemoteChild(
    std::move(token)
    , 
    std::move(opener_frame_token)
    , 
    std::move(tree_scope_type)
    , 
    std::move(replication_state)
    , 
    std::move(owner_properties)
    , 
    std::move(is_loading)
    , 
    std::move(devtools_frame_token)
    , 
    std::move(remote_frame_interfaces)
    );
}
void RemoteFrameInterceptorForTesting::CreateRemoteChildren(std::vector<CreateRemoteChildParamsPtr> params, const std::optional<::base::UnguessableToken>& navigation_metrics_token) {
  GetForwardingInterface()->CreateRemoteChildren(
    std::move(params)
    , 
    std::move(navigation_metrics_token)
    );
}
void RemoteFrameInterceptorForTesting::ForwardFencedFrameEventToEmbedder(const std::string& event_type) {
  GetForwardingInterface()->ForwardFencedFrameEventToEmbedder(
    std::move(event_type)
    );
}
RemoteFrameAsyncWaiter::RemoteFrameAsyncWaiter(
    RemoteFrame* proxy) : proxy_(proxy) {}

RemoteFrameAsyncWaiter::~RemoteFrameAsyncWaiter() = default;





void RemoteMainFrameInterceptorForTesting::UpdateTextAutosizerPageInfo(::blink::mojom::TextAutosizerPageInfoPtr page_info) {
  GetForwardingInterface()->UpdateTextAutosizerPageInfo(
    std::move(page_info)
    );
}
RemoteMainFrameAsyncWaiter::RemoteMainFrameAsyncWaiter(
    RemoteMainFrame* proxy) : proxy_(proxy) {}

RemoteMainFrameAsyncWaiter::~RemoteMainFrameAsyncWaiter() = default;





void RemoteMainFrameHostInterceptorForTesting::FocusPage() {
  GetForwardingInterface()->FocusPage();
}
void RemoteMainFrameHostInterceptorForTesting::TakeFocus(bool reverse) {
  GetForwardingInterface()->TakeFocus(
    std::move(reverse)
    );
}
void RemoteMainFrameHostInterceptorForTesting::UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) {
  GetForwardingInterface()->UpdateTargetURL(
    std::move(url)
    , std::move(callback));
}
void RemoteMainFrameHostInterceptorForTesting::RouteCloseEvent() {
  GetForwardingInterface()->RouteCloseEvent();
}
RemoteMainFrameHostAsyncWaiter::RemoteMainFrameHostAsyncWaiter(
    RemoteMainFrameHost* proxy) : proxy_(proxy) {}

RemoteMainFrameHostAsyncWaiter::~RemoteMainFrameHostAsyncWaiter() = default;


void RemoteMainFrameHostAsyncWaiter::UpdateTargetURL(
    const ::GURL& url) {
  base::RunLoop loop;
  proxy_->UpdateTargetURL(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif