// third_party/blink/public/mojom/frame/policy_container.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared-internal.h"
#include "services/network/public/mojom/connection_allowlist.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/integrity_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PolicyContainerPoliciesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerPoliciesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerPolicies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::connection_allowlists(input)) in_connection_allowlists = Traits::connection_allowlists(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->connection_allowlists)::BaseType> connection_allowlists_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ConnectionAllowlistsDataView, send_validation>(
        in_connection_allowlists,
        connection_allowlists_fragment);

      fragment->connection_allowlists.Set(
          connection_allowlists_fragment.is_null() ? nullptr : connection_allowlists_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->connection_allowlists.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connection_allowlists in PolicyContainerPolicies struct");

      decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView, send_validation>(
        in_cross_origin_embedder_policy,
        cross_origin_embedder_policy_fragment);

      fragment->cross_origin_embedder_policy.Set(
          cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cross_origin_embedder_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_embedder_policy in PolicyContainerPolicies struct");

      decltype(Traits::integrity_policy(input)) in_integrity_policy = Traits::integrity_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->integrity_policy)::BaseType> integrity_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView, send_validation>(
        in_integrity_policy,
        integrity_policy_fragment);

      fragment->integrity_policy.Set(
          integrity_policy_fragment.is_null() ? nullptr : integrity_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->integrity_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null integrity_policy in PolicyContainerPolicies struct");

      decltype(Traits::integrity_policy_report_only(input)) in_integrity_policy_report_only = Traits::integrity_policy_report_only(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->integrity_policy_report_only)::BaseType> integrity_policy_report_only_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IntegrityPolicyDataView, send_validation>(
        in_integrity_policy_report_only,
        integrity_policy_report_only_fragment);

      fragment->integrity_policy_report_only.Set(
          integrity_policy_report_only_fragment.is_null() ? nullptr : integrity_policy_report_only_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->integrity_policy_report_only.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null integrity_policy_report_only in PolicyContainerPolicies struct");

      
      mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input),
        &fragment->referrer_policy);

      decltype(Traits::content_security_policies(input)) in_content_security_policies = Traits::content_security_policies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_security_policies)::BaseType>
          content_security_policies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& content_security_policies_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ContentSecurityPolicyDataView>, send_validation>(
        in_content_security_policies,
        content_security_policies_fragment,
        &content_security_policies_validate_params);

      fragment->content_security_policies.Set(
          content_security_policies_fragment.is_null() ? nullptr : content_security_policies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_security_policies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_security_policies in PolicyContainerPolicies struct");

      fragment->is_credentialless = Traits::is_credentialless(input);

      
      mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
        Traits::sandbox_flags(input),
        &fragment->sandbox_flags);

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::ip_address_space(input),
        &fragment->ip_address_space);

      fragment->can_navigate_top_without_user_gesture = Traits::can_navigate_top_without_user_gesture(input);

      fragment->cross_origin_isolation_enabled_by_dip = Traits::cross_origin_isolation_enabled_by_dip(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PolicyContainerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::policies(input)) in_policies = Traits::policies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->policies)::BaseType> policies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::PolicyContainerPoliciesDataView, send_validation>(
        in_policies,
        policies_fragment);

      fragment->policies.Set(
          policies_fragment.is_null() ? nullptr : policies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->policies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null policies in PolicyContainer struct");

      decltype(Traits::remote(input)) in_remote = Traits::remote(input);

      
      mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedPtrInfoDataView>(
        in_remote,
        &fragment->remote,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->remote)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid remote in PolicyContainer struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PolicyContainerBindParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PolicyContainerBindParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PolicyContainerBindParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);

      
      mojo::internal::Serialize<::blink::mojom::PolicyContainerHostAssociatedRequestDataView>(
        in_receiver,
        &fragment->receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid receiver in PolicyContainerBindParams struct");
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_SEND_VALIDATION_H_