// third_party/blink/public/mojom/frame/policy_container.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/policy_container.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/policy_container.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_allowlist.mojom-blink.h"
#include "services/network/public/mojom/content_security_policy.mojom-blink.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.h"
#include "services/network/public/mojom/integrity_policy.mojom-blink.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink-forward.h"
#include "services/network/public/mojom/referrer_policy.mojom-blink-forward.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class PolicyContainerHostProxy;

template <typename ImplRefTraits>
class PolicyContainerHostStub;

class PolicyContainerHostRequestValidator;


class CORE_EXPORT PolicyContainerHost
    : public PolicyContainerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PolicyContainerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PolicyContainerHostInterfaceBase;
  using Proxy_ = PolicyContainerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PolicyContainerHostStub<ImplRefTraits>;

  using RequestValidator_ = PolicyContainerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetReferrerPolicyMinVersion = 0,
    kAddContentSecurityPoliciesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetReferrerPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddContentSecurityPolicies_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PolicyContainerHost() = default;

  virtual void SetReferrerPolicy(::network::mojom::blink::ReferrerPolicy referrer_policy) = 0;

  virtual void AddContentSecurityPolicies(::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies) = 0;
};



class CORE_EXPORT PolicyContainerHostProxy
    : public PolicyContainerHost {
 public:
  using InterfaceType = PolicyContainerHost;

  explicit PolicyContainerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetReferrerPolicy(::network::mojom::blink::ReferrerPolicy referrer_policy) final;
  
  void AddContentSecurityPolicies(::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT PolicyContainerHostStubDispatch {
 public:
  static bool Accept(PolicyContainerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PolicyContainerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PolicyContainerHost>>
class PolicyContainerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PolicyContainerHostStub() = default;
  ~PolicyContainerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PolicyContainerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PolicyContainerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT PolicyContainerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class CORE_EXPORT PolicyContainerPolicies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainerPolicies, T>::value>;
  using DataView = PolicyContainerPoliciesDataView;
  using Data_ = internal::PolicyContainerPolicies_Data;

  template <typename... Args>
  static PolicyContainerPoliciesPtr New(Args&&... args) {
    return PolicyContainerPoliciesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerPoliciesPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerPoliciesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainerPolicies>::Convert(*this);
  }


  PolicyContainerPolicies();

  PolicyContainerPolicies(
      const ::network::ConnectionAllowlists& connection_allowlists,
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      const ::network::IntegrityPolicy& integrity_policy,
      const ::network::IntegrityPolicy& integrity_policy_report_only,
      ::network::mojom::blink::ReferrerPolicy referrer_policy,
      ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies,
      bool is_credentialless,
      ::network::mojom::blink::WebSandboxFlags sandbox_flags,
      ::network::mojom::blink::IPAddressSpace ip_address_space,
      bool can_navigate_top_without_user_gesture,
      bool cross_origin_isolation_enabled_by_dip);

PolicyContainerPolicies(const PolicyContainerPolicies&) = delete;
PolicyContainerPolicies& operator=(const PolicyContainerPolicies&) = delete;

  ~PolicyContainerPolicies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerPoliciesPtr>
  PolicyContainerPoliciesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PolicyContainerPolicies::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PolicyContainerPolicies::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainerPolicies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainerPolicies_UnserializedMessageContext<
            UserType, PolicyContainerPolicies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainerPolicies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainerPolicies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainerPolicies_UnserializedMessageContext<
            UserType, PolicyContainerPolicies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainerPolicies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::ConnectionAllowlists connection_allowlists;
  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  ::network::IntegrityPolicy integrity_policy;
  
  ::network::IntegrityPolicy integrity_policy_report_only;
  
  ::network::mojom::blink::ReferrerPolicy referrer_policy;
  
  ::blink::Vector<::network::mojom::blink::ContentSecurityPolicyPtr> content_security_policies;
  
  bool is_credentialless;
  
  ::network::mojom::blink::WebSandboxFlags sandbox_flags;
  
  ::network::mojom::blink::IPAddressSpace ip_address_space;
  
  bool can_navigate_top_without_user_gesture;
  
  bool cross_origin_isolation_enabled_by_dip;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT PolicyContainer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainer, T>::value>;
  using DataView = PolicyContainerDataView;
  using Data_ = internal::PolicyContainer_Data;

  template <typename... Args>
  static PolicyContainerPtr New(Args&&... args) {
    return PolicyContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainer>::Convert(*this);
  }


  PolicyContainer();

  PolicyContainer(
      PolicyContainerPoliciesPtr policies,
      ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote);

PolicyContainer(const PolicyContainer&) = delete;
PolicyContainer& operator=(const PolicyContainer&) = delete;

  ~PolicyContainer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerPtr>
  PolicyContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainer_UnserializedMessageContext<
            UserType, PolicyContainer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainer_UnserializedMessageContext<
            UserType, PolicyContainer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PolicyContainerPoliciesPtr policies;
  
  ::mojo::PendingAssociatedRemote<PolicyContainerHost> remote;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT PolicyContainerBindParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PolicyContainerBindParams, T>::value>;
  using DataView = PolicyContainerBindParamsDataView;
  using Data_ = internal::PolicyContainerBindParams_Data;

  template <typename... Args>
  static PolicyContainerBindParamsPtr New(Args&&... args) {
    return PolicyContainerBindParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PolicyContainerBindParamsPtr From(const U& u) {
    return mojo::TypeConverter<PolicyContainerBindParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PolicyContainerBindParams>::Convert(*this);
  }


  PolicyContainerBindParams();

  explicit PolicyContainerBindParams(
      ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver);

PolicyContainerBindParams(const PolicyContainerBindParams&) = delete;
PolicyContainerBindParams& operator=(const PolicyContainerBindParams&) = delete;

  ~PolicyContainerBindParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PolicyContainerBindParamsPtr>
  PolicyContainerBindParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PolicyContainerBindParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PolicyContainerBindParams_UnserializedMessageContext<
            UserType, PolicyContainerBindParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PolicyContainerBindParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PolicyContainerBindParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PolicyContainerBindParams_UnserializedMessageContext<
            UserType, PolicyContainerBindParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PolicyContainerBindParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedReceiver<PolicyContainerHost> receiver;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PolicyContainerPoliciesPtr PolicyContainerPolicies::Clone() const {
  return New(
      mojo::Clone(connection_allowlists),
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(integrity_policy),
      mojo::Clone(integrity_policy_report_only),
      mojo::Clone(referrer_policy),
      mojo::Clone(content_security_policies),
      mojo::Clone(is_credentialless),
      mojo::Clone(sandbox_flags),
      mojo::Clone(ip_address_space),
      mojo::Clone(can_navigate_top_without_user_gesture),
      mojo::Clone(cross_origin_isolation_enabled_by_dip)
  );
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>*>
bool PolicyContainerPolicies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->connection_allowlists, other_struct.connection_allowlists))
    return false;
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->integrity_policy, other_struct.integrity_policy))
    return false;
  if (!mojo::Equals(this->integrity_policy_report_only, other_struct.integrity_policy_report_only))
    return false;
  if (!mojo::Equals(this->referrer_policy, other_struct.referrer_policy))
    return false;
  if (!mojo::Equals(this->content_security_policies, other_struct.content_security_policies))
    return false;
  if (!mojo::Equals(this->is_credentialless, other_struct.is_credentialless))
    return false;
  if (!mojo::Equals(this->sandbox_flags, other_struct.sandbox_flags))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  if (!mojo::Equals(this->can_navigate_top_without_user_gesture, other_struct.can_navigate_top_without_user_gesture))
    return false;
  if (!mojo::Equals(this->cross_origin_isolation_enabled_by_dip, other_struct.cross_origin_isolation_enabled_by_dip))
    return false;
  return true;
}

template <typename T, PolicyContainerPolicies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.connection_allowlists < rhs.connection_allowlists)
    return true;
  if (rhs.connection_allowlists < lhs.connection_allowlists)
    return false;
  if (lhs.cross_origin_embedder_policy < rhs.cross_origin_embedder_policy)
    return true;
  if (rhs.cross_origin_embedder_policy < lhs.cross_origin_embedder_policy)
    return false;
  if (lhs.integrity_policy < rhs.integrity_policy)
    return true;
  if (rhs.integrity_policy < lhs.integrity_policy)
    return false;
  if (lhs.integrity_policy_report_only < rhs.integrity_policy_report_only)
    return true;
  if (rhs.integrity_policy_report_only < lhs.integrity_policy_report_only)
    return false;
  if (lhs.referrer_policy < rhs.referrer_policy)
    return true;
  if (rhs.referrer_policy < lhs.referrer_policy)
    return false;
  if (lhs.content_security_policies < rhs.content_security_policies)
    return true;
  if (rhs.content_security_policies < lhs.content_security_policies)
    return false;
  if (lhs.is_credentialless < rhs.is_credentialless)
    return true;
  if (rhs.is_credentialless < lhs.is_credentialless)
    return false;
  if (lhs.sandbox_flags < rhs.sandbox_flags)
    return true;
  if (rhs.sandbox_flags < lhs.sandbox_flags)
    return false;
  if (lhs.ip_address_space < rhs.ip_address_space)
    return true;
  if (rhs.ip_address_space < lhs.ip_address_space)
    return false;
  if (lhs.can_navigate_top_without_user_gesture < rhs.can_navigate_top_without_user_gesture)
    return true;
  if (rhs.can_navigate_top_without_user_gesture < lhs.can_navigate_top_without_user_gesture)
    return false;
  if (lhs.cross_origin_isolation_enabled_by_dip < rhs.cross_origin_isolation_enabled_by_dip)
    return true;
  if (rhs.cross_origin_isolation_enabled_by_dip < lhs.cross_origin_isolation_enabled_by_dip)
    return false;
  return false;
}
template <typename StructPtrType>
PolicyContainerPtr PolicyContainer::Clone() const {
  return New(
      mojo::Clone(policies),
      mojo::Clone(remote)
  );
}

template <typename T, PolicyContainer::EnableIfSame<T>*>
bool PolicyContainer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->policies, other_struct.policies))
    return false;
  if (!mojo::Equals(this->remote, other_struct.remote))
    return false;
  return true;
}

template <typename T, PolicyContainer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.policies < rhs.policies)
    return true;
  if (rhs.policies < lhs.policies)
    return false;
  if (lhs.remote < rhs.remote)
    return true;
  if (rhs.remote < lhs.remote)
    return false;
  return false;
}
template <typename StructPtrType>
PolicyContainerBindParamsPtr PolicyContainerBindParams::Clone() const {
  return New(
      mojo::Clone(receiver)
  );
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>*>
bool PolicyContainerBindParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  return true;
}

template <typename T, PolicyContainerBindParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PolicyContainerPolicies::DataView,
                                         ::blink::mojom::blink::PolicyContainerPoliciesPtr> {
  static bool IsNull(const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PolicyContainerPoliciesPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PolicyContainerPolicies::connection_allowlists)& connection_allowlists(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->connection_allowlists;
  }

  static const decltype(::blink::mojom::blink::PolicyContainerPolicies::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static const decltype(::blink::mojom::blink::PolicyContainerPolicies::integrity_policy)& integrity_policy(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->integrity_policy;
  }

  static const decltype(::blink::mojom::blink::PolicyContainerPolicies::integrity_policy_report_only)& integrity_policy_report_only(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->integrity_policy_report_only;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::referrer_policy) referrer_policy(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->referrer_policy;
  }

  static const decltype(::blink::mojom::blink::PolicyContainerPolicies::content_security_policies)& content_security_policies(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->content_security_policies;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::is_credentialless) is_credentialless(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->is_credentialless;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::sandbox_flags) sandbox_flags(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->sandbox_flags;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::ip_address_space) ip_address_space(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->ip_address_space;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::can_navigate_top_without_user_gesture) can_navigate_top_without_user_gesture(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->can_navigate_top_without_user_gesture;
  }

  static decltype(::blink::mojom::blink::PolicyContainerPolicies::cross_origin_isolation_enabled_by_dip) cross_origin_isolation_enabled_by_dip(
      const ::blink::mojom::blink::PolicyContainerPoliciesPtr& input) {
    return input->cross_origin_isolation_enabled_by_dip;
  }

  static bool Read(::blink::mojom::blink::PolicyContainerPolicies::DataView input, ::blink::mojom::blink::PolicyContainerPoliciesPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PolicyContainer::DataView,
                                         ::blink::mojom::blink::PolicyContainerPtr> {
  static bool IsNull(const ::blink::mojom::blink::PolicyContainerPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PolicyContainerPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::PolicyContainer::policies)& policies(
      const ::blink::mojom::blink::PolicyContainerPtr& input) {
    return input->policies;
  }

  static  decltype(::blink::mojom::blink::PolicyContainer::remote)& remote(
       ::blink::mojom::blink::PolicyContainerPtr& input) {
    return input->remote;
  }

  static bool Read(::blink::mojom::blink::PolicyContainer::DataView input, ::blink::mojom::blink::PolicyContainerPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::PolicyContainerBindParams::DataView,
                                         ::blink::mojom::blink::PolicyContainerBindParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::PolicyContainerBindParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::PolicyContainerBindParamsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::PolicyContainerBindParams::receiver)& receiver(
       ::blink::mojom::blink::PolicyContainerBindParamsPtr& input) {
    return input->receiver;
  }

  static bool Read(::blink::mojom::blink::PolicyContainerBindParams::DataView input, ::blink::mojom::blink::PolicyContainerBindParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_POLICY_CONTAINER_MOJOM_BLINK_H_