// third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IntrinsicSizingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IntrinsicSizingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IntrinsicSizingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in IntrinsicSizingInfo struct");

    decltype(Traits::aspect_ratio(input)) in_aspect_ratio = Traits::aspect_ratio(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aspect_ratio)::BaseType> aspect_ratio_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
      in_aspect_ratio,
      aspect_ratio_fragment);

    fragment->aspect_ratio.Set(
        aspect_ratio_fragment.is_null() ? nullptr : aspect_ratio_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aspect_ratio.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aspect_ratio in IntrinsicSizingInfo struct");

    fragment->has_width = Traits::has_width(input);

    fragment->has_height = Traits::has_height(input);
  }

  static bool Deserialize(::blink::mojom::internal::IntrinsicSizingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IntrinsicSizingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void IntrinsicSizingInfoDataView::GetSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}
inline void IntrinsicSizingInfoDataView::GetAspectRatioDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->aspect_ratio.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_SHARED_H_