// third_party/blink/public/mojom/font_access/font_access.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/font_access/font_access.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"


namespace blink::mojom {
class FontDataDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FontDataDataView> {
  using Data = ::blink::mojom::internal::FontData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class FontEnumerationStatus : int32_t {
  
  kOk = 0,
  
  kUnimplemented = 1,
  
  kUnexpectedError = 2,
  
  kNeedsUserActivation = 3,
  
  kNotVisible = 4,
  
  kPermissionDenied = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FontEnumerationStatus value);
inline bool IsKnownEnumValue(FontEnumerationStatus value) {
  return internal::FontEnumerationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FontAccessManagerInterfaceBase {};

using FontAccessManagerPtrDataView =
    mojo::InterfacePtrDataView<FontAccessManagerInterfaceBase>;
using FontAccessManagerRequestDataView =
    mojo::InterfaceRequestDataView<FontAccessManagerInterfaceBase>;
using FontAccessManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FontAccessManagerInterfaceBase>;
using FontAccessManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FontAccessManagerInterfaceBase>;


class FontDataDataView {
 public:
  FontDataDataView() = default;

  FontDataDataView(
      internal::FontData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPostscriptNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostscriptName(UserType* output) {
    
    auto* pointer = data_->postscript_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFullNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFullName(UserType* output) {
    
    auto* pointer = data_->full_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFamilyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFamily(UserType* output) {
    
    auto* pointer = data_->family.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStyleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStyle(UserType* output) {
    
    auto* pointer = data_->style.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::FontData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FONT_ACCESS_FONT_ACCESS_MOJOM_DATA_VIEW_H_