// third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  NoiseToken as blink_mojom_NoiseToken,
  NoiseTokenSpec as blink_mojom_NoiseTokenSpec
} from './noise_token.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CanvasNoiseTokenUpdaterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.CanvasNoiseTokenUpdater', scope);
  }
}

/** @interface */
export class CanvasNoiseTokenUpdaterInterface {
  
  /**
   * @param { ?blink_mojom_NoiseToken } token
   */

  onTokenReceived(token) {}
}

/**
 * @implements { CanvasNoiseTokenUpdaterInterface }
 */
export class CanvasNoiseTokenUpdaterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CanvasNoiseTokenUpdaterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CanvasNoiseTokenUpdaterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CanvasNoiseTokenUpdaterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?blink_mojom_NoiseToken } token
   */

  onTokenReceived(
      token) {
    this.proxy.sendMessage(
        0,
        CanvasNoiseTokenUpdater_OnTokenReceived_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CanvasNoiseTokenUpdater
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CanvasNoiseTokenUpdaterReceiver {
  /**
   * @param {!CanvasNoiseTokenUpdaterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CanvasNoiseTokenUpdaterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CanvasNoiseTokenUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CanvasNoiseTokenUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CanvasNoiseTokenUpdater_OnTokenReceived_ParamsSpec.$,
        null,
        impl.onTokenReceived.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CanvasNoiseTokenUpdater {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.CanvasNoiseTokenUpdater";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CanvasNoiseTokenUpdaterRemote}
   */
  static getRemote() {
    let remote = new CanvasNoiseTokenUpdaterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CanvasNoiseTokenUpdater
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CanvasNoiseTokenUpdaterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CanvasNoiseTokenUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CanvasNoiseTokenUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTokenReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CanvasNoiseTokenUpdater_OnTokenReceived_ParamsSpec.$,
        null,
        this.onTokenReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CanvasNoiseTokenUpdater_OnTokenReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CanvasNoiseTokenUpdater_OnTokenReceived_ParamsSpec.$,
    'CanvasNoiseTokenUpdater_OnTokenReceived_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        blink_mojom_NoiseTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CanvasNoiseTokenUpdater_OnTokenReceived_Params {
  constructor() {
    /** @type { (blink_mojom_NoiseToken|undefined) } */
    this.token;
  }
}

