// third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom-params-data.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom-import-headers.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

CanvasNoiseTokenUpdater::IPCStableHashFunction CanvasNoiseTokenUpdater::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CanvasNoiseTokenUpdater>(message.name())) {
    case messages::CanvasNoiseTokenUpdater::kOnTokenReceived: {
      return &CanvasNoiseTokenUpdater::OnTokenReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CanvasNoiseTokenUpdater::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CanvasNoiseTokenUpdater>(message.name())) {
      case messages::CanvasNoiseTokenUpdater::kOnTokenReceived:
            return "Receive blink::mojom::CanvasNoiseTokenUpdater::OnTokenReceived";
    }
  } else {
    switch (static_cast<messages::CanvasNoiseTokenUpdater>(message.name())) {
      case messages::CanvasNoiseTokenUpdater::kOnTokenReceived:
            return "Receive reply blink::mojom::CanvasNoiseTokenUpdater::OnTokenReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CanvasNoiseTokenUpdater::OnTokenReceived_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd18119a0;  // IPCStableHash for blink::mojom::CanvasNoiseTokenUpdater::OnTokenReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CanvasNoiseTokenUpdaterProxy::CanvasNoiseTokenUpdaterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CanvasNoiseTokenUpdaterProxy::OnTokenReceived(
    std::optional<::blink::NoiseToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::CanvasNoiseTokenUpdater::OnTokenReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type std::optional<::blink::NoiseToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CanvasNoiseTokenUpdater::kOnTokenReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::CanvasNoiseTokenUpdater_OnTokenReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::NoiseTokenDataView>(
    in_token,
    token_fragment);

  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CanvasNoiseTokenUpdater::Name_);
  message.set_method_name("OnTokenReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CanvasNoiseTokenUpdaterStubDispatch::Accept(
    CanvasNoiseTokenUpdater* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CanvasNoiseTokenUpdater>(message->header()->name)) {
    case messages::CanvasNoiseTokenUpdater::kOnTokenReceived: {
      DCHECK(message->is_serialized());
      internal::CanvasNoiseTokenUpdater_OnTokenReceived_Params_Data* params =
          reinterpret_cast<internal::CanvasNoiseTokenUpdater_OnTokenReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CanvasNoiseTokenUpdater.0
      bool success = true;
      std::optional<::blink::NoiseToken> p_token{};
      CanvasNoiseTokenUpdater_OnTokenReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CanvasNoiseTokenUpdater::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTokenReceived(        
        std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool CanvasNoiseTokenUpdaterStubDispatch::AcceptWithResponder(
    CanvasNoiseTokenUpdater* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CanvasNoiseTokenUpdater>(message->header()->name)) {
    case messages::CanvasNoiseTokenUpdater::kOnTokenReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCanvasNoiseTokenUpdaterValidationInfo[] = {
    { &internal::CanvasNoiseTokenUpdater_OnTokenReceived_Params_Data::Validate,
     nullptr /* no response */},
};

bool CanvasNoiseTokenUpdaterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::CanvasNoiseTokenUpdater::Name_,
    kCanvasNoiseTokenUpdaterValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void CanvasNoiseTokenUpdaterInterceptorForTesting::OnTokenReceived(std::optional<::blink::NoiseToken> token) {
  GetForwardingInterface()->OnTokenReceived(
    std::move(token)
    );
}
CanvasNoiseTokenUpdaterAsyncWaiter::CanvasNoiseTokenUpdaterAsyncWaiter(
    CanvasNoiseTokenUpdater* proxy) : proxy_(proxy) {}

CanvasNoiseTokenUpdaterAsyncWaiter::~CanvasNoiseTokenUpdaterAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif