// third_party/blink/public/mojom/filesystem/file_system.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/filesystem/file_system.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT FileSystemCancellableOperationInterceptorForTesting : public FileSystemCancellableOperation {
  virtual FileSystemCancellableOperation* GetForwardingInterface() = 0;
  void Cancel(CancelCallback callback) override;
};
class BLINK_COMMON_EXPORT FileSystemCancellableOperationAsyncWaiter {
 public:
  explicit FileSystemCancellableOperationAsyncWaiter(FileSystemCancellableOperation* proxy);

  FileSystemCancellableOperationAsyncWaiter(const FileSystemCancellableOperationAsyncWaiter&) = delete;
  FileSystemCancellableOperationAsyncWaiter& operator=(const FileSystemCancellableOperationAsyncWaiter&) = delete;

  ~FileSystemCancellableOperationAsyncWaiter();
  void Cancel(
      ::base::File::Error* out_error_code);
  ::base::File::Error Cancel();

 private:
  FileSystemCancellableOperation* const proxy_;
};


class BLINK_COMMON_EXPORT FileSystemOperationListenerInterceptorForTesting : public FileSystemOperationListener {
  virtual FileSystemOperationListener* GetForwardingInterface() = 0;
  void ResultsRetrieved(std::vector<::filesystem::mojom::DirectoryEntryPtr> entries, bool has_more) override;
  void DidWrite(int64_t byte_count, bool complete) override;
  void ErrorOccurred(::base::File::Error error_code) override;
};
class BLINK_COMMON_EXPORT FileSystemOperationListenerAsyncWaiter {
 public:
  explicit FileSystemOperationListenerAsyncWaiter(FileSystemOperationListener* proxy);

  FileSystemOperationListenerAsyncWaiter(const FileSystemOperationListenerAsyncWaiter&) = delete;
  FileSystemOperationListenerAsyncWaiter& operator=(const FileSystemOperationListenerAsyncWaiter&) = delete;

  ~FileSystemOperationListenerAsyncWaiter();

 private:
  FileSystemOperationListener* const proxy_;
};


class BLINK_COMMON_EXPORT ReceivedSnapshotListenerInterceptorForTesting : public ReceivedSnapshotListener {
  virtual ReceivedSnapshotListener* GetForwardingInterface() = 0;
  void DidReceiveSnapshotFile() override;
};
class BLINK_COMMON_EXPORT ReceivedSnapshotListenerAsyncWaiter {
 public:
  explicit ReceivedSnapshotListenerAsyncWaiter(ReceivedSnapshotListener* proxy);

  ReceivedSnapshotListenerAsyncWaiter(const ReceivedSnapshotListenerAsyncWaiter&) = delete;
  ReceivedSnapshotListenerAsyncWaiter& operator=(const ReceivedSnapshotListenerAsyncWaiter&) = delete;

  ~ReceivedSnapshotListenerAsyncWaiter();

 private:
  ReceivedSnapshotListener* const proxy_;
};


class BLINK_COMMON_EXPORT FileSystemManagerInterceptorForTesting : public FileSystemManager {
  virtual FileSystemManager* GetForwardingInterface() = 0;
  void Open(const ::url::Origin& origin, FileSystemType file_system_type, OpenCallback callback) override;
  void ResolveURL(const ::GURL& filesystem_url, ResolveURLCallback callback) override;
  void Move(const ::GURL& src_path, const ::GURL& dest_path, MoveCallback callback) override;
  void Copy(const ::GURL& src_path, const ::GURL& dest_path, CopyCallback callback) override;
  void Remove(const ::GURL& path, bool recursive, RemoveCallback callback) override;
  void ReadMetadata(const ::GURL& path, ReadMetadataCallback callback) override;
  void Create(const ::GURL& path, bool exclusive, bool is_directory, bool recursive, CreateCallback callback) override;
  void Exists(const ::GURL& path, bool is_directory, ExistsCallback callback) override;
  void ReadDirectory(const ::GURL& path, ::mojo::PendingRemote<FileSystemOperationListener> listener) override;
  void ReadDirectorySync(const ::GURL& path, ReadDirectorySyncCallback callback) override;
  void Write(const ::GURL& file_path, ::mojo::PendingRemote<::blink::mojom::Blob> blob, int64_t position, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, ::mojo::PendingRemote<FileSystemOperationListener> listener) override;
  void WriteSync(const ::GURL& file_path, ::mojo::PendingRemote<::blink::mojom::Blob> blob, int64_t position, WriteSyncCallback callback) override;
  void Truncate(const ::GURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, TruncateCallback callback) override;
  void TruncateSync(const ::GURL& file_path, int64_t length, TruncateSyncCallback callback) override;
  void CreateSnapshotFile(const ::GURL& file_path, CreateSnapshotFileCallback callback) override;
  void GetPlatformPath(const ::GURL& file_path, GetPlatformPathCallback callback) override;
  void RegisterBlob(const std::string& content_type, const ::GURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time, RegisterBlobCallback callback) override;
};
class BLINK_COMMON_EXPORT FileSystemManagerAsyncWaiter {
 public:
  explicit FileSystemManagerAsyncWaiter(FileSystemManager* proxy);

  FileSystemManagerAsyncWaiter(const FileSystemManagerAsyncWaiter&) = delete;
  FileSystemManagerAsyncWaiter& operator=(const FileSystemManagerAsyncWaiter&) = delete;

  ~FileSystemManagerAsyncWaiter();
  void Open(
      const ::url::Origin& origin, FileSystemType file_system_type, std::string* out_name, ::GURL* out_root_url, ::base::File::Error* out_error_code);
  
  void ResolveURL(
      const ::GURL& filesystem_url, FileSystemInfoPtr* out_info, ::base::FilePath* out_file_path, bool* out_is_directory, ::base::File::Error* out_error_code);
  
  void Move(
      const ::GURL& src_path, const ::GURL& dest_path, ::base::File::Error* out_error_code);
  ::base::File::Error Move(const ::GURL& src_path, const ::GURL& dest_path);
  void Copy(
      const ::GURL& src_path, const ::GURL& dest_path, ::base::File::Error* out_error_code);
  ::base::File::Error Copy(const ::GURL& src_path, const ::GURL& dest_path);
  void Remove(
      const ::GURL& path, bool recursive, ::base::File::Error* out_error_code);
  ::base::File::Error Remove(const ::GURL& path, bool recursive);
  void ReadMetadata(
      const ::GURL& path, ::base::File::Info* out_file_info, ::base::File::Error* out_error_code);
  
  void Create(
      const ::GURL& path, bool exclusive, bool is_directory, bool recursive, ::base::File::Error* out_error_code);
  ::base::File::Error Create(const ::GURL& path, bool exclusive, bool is_directory, bool recursive);
  void Exists(
      const ::GURL& path, bool is_directory, ::base::File::Error* out_error_code);
  ::base::File::Error Exists(const ::GURL& path, bool is_directory);
  void ReadDirectorySync(
      const ::GURL& path, std::vector<::filesystem::mojom::DirectoryEntryPtr>* out_entries, ::base::File::Error* out_error_code);
  
  void WriteSync(
      const ::GURL& file_path, ::mojo::PendingRemote<::blink::mojom::Blob> blob, int64_t position, int64_t* out_byte_count, ::base::File::Error* out_error_code);
  
  void Truncate(
      const ::GURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, ::base::File::Error* out_error_code);
  ::base::File::Error Truncate(const ::GURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver);
  void TruncateSync(
      const ::GURL& file_path, int64_t length, ::base::File::Error* out_error_code);
  ::base::File::Error TruncateSync(const ::GURL& file_path, int64_t length);
  void CreateSnapshotFile(
      const ::GURL& file_path, ::base::File::Info* out_file_info, ::base::FilePath* out_platform_path, ::base::File::Error* out_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener);
  
  void GetPlatformPath(
      const ::GURL& file_path, ::base::FilePath* out_platform_path);
  ::base::FilePath GetPlatformPath(const ::GURL& file_path);
  void RegisterBlob(
      const std::string& content_type, const ::GURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time, ::blink::mojom::SerializedBlobPtr* out_blob);
  ::blink::mojom::SerializedBlobPtr RegisterBlob(const std::string& content_type, const ::GURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time);

 private:
  FileSystemManager* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILESYSTEM_FILE_SYSTEM_MOJOM_TEST_UTILS_H_