// third_party/blink/public/mojom/filesystem/file_system.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-params-data.h"
#include "third_party/blink/public/mojom/filesystem/file_system.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/filesystem/file_system.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/filesystem/file_system.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
FileSystemInfo::FileSystemInfo()
    : name(),
      root_url(),
      mount_type(FileSystemType::kTemporary) {}

FileSystemInfo::FileSystemInfo(
    const ::blink::String& name_in,
    const ::blink::KURL& root_url_in,
    FileSystemType mount_type_in)
    : name(std::move(name_in)),
      root_url(std::move(root_url_in)),
      mount_type(std::move(mount_type_in)) {}

FileSystemInfo::~FileSystemInfo() = default;

void FileSystemInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_url"), this->root_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mount_type"), this->mount_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FileSystemType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FileSystemInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FileSystemCancellableOperation::IPCStableHashFunction FileSystemCancellableOperation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemCancellableOperation>(message.name())) {
    case messages::FileSystemCancellableOperation::kCancel: {
      return &FileSystemCancellableOperation::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemCancellableOperation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemCancellableOperation>(message.name())) {
      case messages::FileSystemCancellableOperation::kCancel:
            return "Receive blink::mojom::FileSystemCancellableOperation::Cancel";
    }
  } else {
    switch (static_cast<messages::FileSystemCancellableOperation>(message.name())) {
      case messages::FileSystemCancellableOperation::kCancel:
            return "Receive reply blink::mojom::FileSystemCancellableOperation::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemCancellableOperation::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x44d47e83;  // IPCStableHash for blink::mojom::FileSystemCancellableOperation::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemCancellableOperation_Cancel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemCancellableOperation_Cancel_ForwardToCallback(
      FileSystemCancellableOperation::CancelCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemCancellableOperation_Cancel_ForwardToCallback(const FileSystemCancellableOperation_Cancel_ForwardToCallback&) = delete;
  FileSystemCancellableOperation_Cancel_ForwardToCallback& operator=(const FileSystemCancellableOperation_Cancel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemCancellableOperation::CancelCallback callback_;
};

FileSystemCancellableOperationProxy::FileSystemCancellableOperationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemCancellableOperationProxy::Cancel(
    CancelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemCancellableOperation::Cancel");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemCancellableOperation::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemCancellableOperation_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemCancellableOperation::Name_);
  message.set_method_name("Cancel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemCancellableOperation_Cancel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemCancellableOperation_Cancel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemCancellableOperation::CancelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemCancellableOperation_Cancel_ProxyToResponder> proxy(
        new FileSystemCancellableOperation_Cancel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemCancellableOperation_Cancel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemCancellableOperation_Cancel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemCancellableOperation_Cancel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemCancellableOperation::CancelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemCancellableOperation_Cancel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemCancellableOperation.0
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemCancellableOperation_Cancel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemCancellableOperation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemCancellableOperation_Cancel_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemCancellableOperation::Cancel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemCancellableOperation::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemCancellableOperation::Name_);
  message.set_method_name("Cancel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemCancellableOperationStubDispatch::Accept(
    FileSystemCancellableOperation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemCancellableOperation>(message->header()->name)) {
    case messages::FileSystemCancellableOperation::kCancel: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemCancellableOperationStubDispatch::AcceptWithResponder(
    FileSystemCancellableOperation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemCancellableOperation>(message->header()->name)) {
    case messages::FileSystemCancellableOperation::kCancel: {
      internal::FileSystemCancellableOperation_Cancel_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemCancellableOperation_Cancel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemCancellableOperation.0
      bool success = true;
      FileSystemCancellableOperation_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemCancellableOperation::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemCancellableOperation_Cancel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemCancellableOperationValidationInfo[] = {
    { &internal::FileSystemCancellableOperation_Cancel_Params_Data::Validate,
     &internal::FileSystemCancellableOperation_Cancel_ResponseParams_Data::Validate},
};

bool FileSystemCancellableOperationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemCancellableOperation::Name_,
    kFileSystemCancellableOperationValidationInfo);
}

bool FileSystemCancellableOperationResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemCancellableOperation::Name_,
    kFileSystemCancellableOperationValidationInfo);
}
// The declaration includes the definition on other builds.

FileSystemOperationListener::IPCStableHashFunction FileSystemOperationListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemOperationListener>(message.name())) {
    case messages::FileSystemOperationListener::kResultsRetrieved: {
      return &FileSystemOperationListener::ResultsRetrieved_Sym::IPCStableHash;
    }
    case messages::FileSystemOperationListener::kDidWrite: {
      return &FileSystemOperationListener::DidWrite_Sym::IPCStableHash;
    }
    case messages::FileSystemOperationListener::kErrorOccurred: {
      return &FileSystemOperationListener::ErrorOccurred_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemOperationListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemOperationListener>(message.name())) {
      case messages::FileSystemOperationListener::kResultsRetrieved:
            return "Receive blink::mojom::FileSystemOperationListener::ResultsRetrieved";
      case messages::FileSystemOperationListener::kDidWrite:
            return "Receive blink::mojom::FileSystemOperationListener::DidWrite";
      case messages::FileSystemOperationListener::kErrorOccurred:
            return "Receive blink::mojom::FileSystemOperationListener::ErrorOccurred";
    }
  } else {
    switch (static_cast<messages::FileSystemOperationListener>(message.name())) {
      case messages::FileSystemOperationListener::kResultsRetrieved:
            return "Receive reply blink::mojom::FileSystemOperationListener::ResultsRetrieved";
      case messages::FileSystemOperationListener::kDidWrite:
            return "Receive reply blink::mojom::FileSystemOperationListener::DidWrite";
      case messages::FileSystemOperationListener::kErrorOccurred:
            return "Receive reply blink::mojom::FileSystemOperationListener::ErrorOccurred";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemOperationListener::ResultsRetrieved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6491716;  // IPCStableHash for blink::mojom::FileSystemOperationListener::ResultsRetrieved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemOperationListener::DidWrite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29816f78;  // IPCStableHash for blink::mojom::FileSystemOperationListener::DidWrite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemOperationListener::ErrorOccurred_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18548544;  // IPCStableHash for blink::mojom::FileSystemOperationListener::ErrorOccurred
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FileSystemOperationListenerProxy::FileSystemOperationListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemOperationListenerProxy::ResultsRetrieved(
    ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> in_entries, bool in_has_more) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemOperationListener::ResultsRetrieved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_more"), in_has_more,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemOperationListener::kResultsRetrieved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemOperationListener_ResultsRetrieved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in FileSystemOperationListener.ResultsRetrieved request");

  params->has_more = in_has_more;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemOperationListener::Name_);
  message.set_method_name("ResultsRetrieved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemOperationListenerProxy::DidWrite(
    int64_t in_byte_count, bool in_complete) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemOperationListener::DidWrite", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("byte_count"), in_byte_count,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("complete"), in_complete,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemOperationListener::kDidWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemOperationListener_DidWrite_Params_Data> params(
          message);
  params.Allocate();

  params->byte_count = in_byte_count;

  params->complete = in_complete;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemOperationListener::Name_);
  message.set_method_name("DidWrite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FileSystemOperationListenerProxy::ErrorOccurred(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemOperationListener::ErrorOccurred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemOperationListener::kErrorOccurred), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemOperationListener_ErrorOccurred_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemOperationListener::Name_);
  message.set_method_name("ErrorOccurred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FileSystemOperationListenerStubDispatch::Accept(
    FileSystemOperationListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemOperationListener>(message->header()->name)) {
    case messages::FileSystemOperationListener::kResultsRetrieved: {
      DCHECK(message->is_serialized());
      internal::FileSystemOperationListener_ResultsRetrieved_Params_Data* params =
          reinterpret_cast<internal::FileSystemOperationListener_ResultsRetrieved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemOperationListener.0
      bool success = true;
      ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> p_entries{};
      bool p_has_more{};
      FileSystemOperationListener_ResultsRetrieved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEntries(&p_entries))
        success = false;
      if (success)
        p_has_more = input_data_view.has_more();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemOperationListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResultsRetrieved(        
        std::move(p_entries), 
        std::move(p_has_more));
      return true;
    }
    case messages::FileSystemOperationListener::kDidWrite: {
      DCHECK(message->is_serialized());
      internal::FileSystemOperationListener_DidWrite_Params_Data* params =
          reinterpret_cast<internal::FileSystemOperationListener_DidWrite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemOperationListener.1
      bool success = true;
      int64_t p_byte_count{};
      bool p_complete{};
      FileSystemOperationListener_DidWrite_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_byte_count = input_data_view.byte_count();
      if (success)
        p_complete = input_data_view.complete();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemOperationListener::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidWrite(        
        std::move(p_byte_count), 
        std::move(p_complete));
      return true;
    }
    case messages::FileSystemOperationListener::kErrorOccurred: {
      DCHECK(message->is_serialized());
      internal::FileSystemOperationListener_ErrorOccurred_Params_Data* params =
          reinterpret_cast<internal::FileSystemOperationListener_ErrorOccurred_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemOperationListener.2
      bool success = true;
      ::base::File::Error p_error_code{};
      FileSystemOperationListener_ErrorOccurred_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorCode(&p_error_code))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemOperationListener::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ErrorOccurred(        
        std::move(p_error_code));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemOperationListenerStubDispatch::AcceptWithResponder(
    FileSystemOperationListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemOperationListener>(message->header()->name)) {
    case messages::FileSystemOperationListener::kResultsRetrieved: {
      break;
    }
    case messages::FileSystemOperationListener::kDidWrite: {
      break;
    }
    case messages::FileSystemOperationListener::kErrorOccurred: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemOperationListenerValidationInfo[] = {
    { &internal::FileSystemOperationListener_ResultsRetrieved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemOperationListener_DidWrite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemOperationListener_ErrorOccurred_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemOperationListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemOperationListener::Name_,
    kFileSystemOperationListenerValidationInfo);
}

// The declaration includes the definition on other builds.

ReceivedSnapshotListener::IPCStableHashFunction ReceivedSnapshotListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ReceivedSnapshotListener>(message.name())) {
    case messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile: {
      return &ReceivedSnapshotListener::DidReceiveSnapshotFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ReceivedSnapshotListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ReceivedSnapshotListener>(message.name())) {
      case messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile:
            return "Receive blink::mojom::ReceivedSnapshotListener::DidReceiveSnapshotFile";
    }
  } else {
    switch (static_cast<messages::ReceivedSnapshotListener>(message.name())) {
      case messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile:
            return "Receive reply blink::mojom::ReceivedSnapshotListener::DidReceiveSnapshotFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ReceivedSnapshotListener::DidReceiveSnapshotFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d95401c;  // IPCStableHash for blink::mojom::ReceivedSnapshotListener::DidReceiveSnapshotFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ReceivedSnapshotListenerProxy::ReceivedSnapshotListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReceivedSnapshotListenerProxy::DidReceiveSnapshotFile(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ReceivedSnapshotListener::DidReceiveSnapshotFile");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReceivedSnapshotListener::Name_);
  message.set_method_name("DidReceiveSnapshotFile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ReceivedSnapshotListenerStubDispatch::Accept(
    ReceivedSnapshotListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ReceivedSnapshotListener>(message->header()->name)) {
    case messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile: {
      DCHECK(message->is_serialized());
      internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data* params =
          reinterpret_cast<internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ReceivedSnapshotListener.0
      bool success = true;
      ReceivedSnapshotListener_DidReceiveSnapshotFile_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReceivedSnapshotListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveSnapshotFile(        );
      return true;
    }
  }
  return false;
}

// static
bool ReceivedSnapshotListenerStubDispatch::AcceptWithResponder(
    ReceivedSnapshotListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ReceivedSnapshotListener>(message->header()->name)) {
    case messages::ReceivedSnapshotListener::kDidReceiveSnapshotFile: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kReceivedSnapshotListenerValidationInfo[] = {
    { &internal::ReceivedSnapshotListener_DidReceiveSnapshotFile_Params_Data::Validate,
     nullptr /* no response */},
};

bool ReceivedSnapshotListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ReceivedSnapshotListener::Name_,
    kReceivedSnapshotListenerValidationInfo);
}

// The declaration includes the definition on other builds.

FileSystemManager::IPCStableHashFunction FileSystemManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemManager>(message.name())) {
    case messages::FileSystemManager::kOpen: {
      return &FileSystemManager::Open_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kResolveURL: {
      return &FileSystemManager::ResolveURL_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kMove: {
      return &FileSystemManager::Move_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kCopy: {
      return &FileSystemManager::Copy_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kRemove: {
      return &FileSystemManager::Remove_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kReadMetadata: {
      return &FileSystemManager::ReadMetadata_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kCreate: {
      return &FileSystemManager::Create_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kExists: {
      return &FileSystemManager::Exists_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kReadDirectory: {
      return &FileSystemManager::ReadDirectory_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kReadDirectorySync: {
      return &FileSystemManager::ReadDirectorySync_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kWrite: {
      return &FileSystemManager::Write_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kWriteSync: {
      return &FileSystemManager::WriteSync_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kTruncate: {
      return &FileSystemManager::Truncate_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kTruncateSync: {
      return &FileSystemManager::TruncateSync_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kCreateSnapshotFile: {
      return &FileSystemManager::CreateSnapshotFile_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kGetPlatformPath: {
      return &FileSystemManager::GetPlatformPath_Sym::IPCStableHash;
    }
    case messages::FileSystemManager::kRegisterBlob: {
      return &FileSystemManager::RegisterBlob_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemManager>(message.name())) {
      case messages::FileSystemManager::kOpen:
            return "Receive blink::mojom::FileSystemManager::Open";
      case messages::FileSystemManager::kResolveURL:
            return "Receive blink::mojom::FileSystemManager::ResolveURL";
      case messages::FileSystemManager::kMove:
            return "Receive blink::mojom::FileSystemManager::Move";
      case messages::FileSystemManager::kCopy:
            return "Receive blink::mojom::FileSystemManager::Copy";
      case messages::FileSystemManager::kRemove:
            return "Receive blink::mojom::FileSystemManager::Remove";
      case messages::FileSystemManager::kReadMetadata:
            return "Receive blink::mojom::FileSystemManager::ReadMetadata";
      case messages::FileSystemManager::kCreate:
            return "Receive blink::mojom::FileSystemManager::Create";
      case messages::FileSystemManager::kExists:
            return "Receive blink::mojom::FileSystemManager::Exists";
      case messages::FileSystemManager::kReadDirectory:
            return "Receive blink::mojom::FileSystemManager::ReadDirectory";
      case messages::FileSystemManager::kReadDirectorySync:
            return "Receive blink::mojom::FileSystemManager::ReadDirectorySync";
      case messages::FileSystemManager::kWrite:
            return "Receive blink::mojom::FileSystemManager::Write";
      case messages::FileSystemManager::kWriteSync:
            return "Receive blink::mojom::FileSystemManager::WriteSync";
      case messages::FileSystemManager::kTruncate:
            return "Receive blink::mojom::FileSystemManager::Truncate";
      case messages::FileSystemManager::kTruncateSync:
            return "Receive blink::mojom::FileSystemManager::TruncateSync";
      case messages::FileSystemManager::kCreateSnapshotFile:
            return "Receive blink::mojom::FileSystemManager::CreateSnapshotFile";
      case messages::FileSystemManager::kGetPlatformPath:
            return "Receive blink::mojom::FileSystemManager::GetPlatformPath";
      case messages::FileSystemManager::kRegisterBlob:
            return "Receive blink::mojom::FileSystemManager::RegisterBlob";
    }
  } else {
    switch (static_cast<messages::FileSystemManager>(message.name())) {
      case messages::FileSystemManager::kOpen:
            return "Receive reply blink::mojom::FileSystemManager::Open";
      case messages::FileSystemManager::kResolveURL:
            return "Receive reply blink::mojom::FileSystemManager::ResolveURL";
      case messages::FileSystemManager::kMove:
            return "Receive reply blink::mojom::FileSystemManager::Move";
      case messages::FileSystemManager::kCopy:
            return "Receive reply blink::mojom::FileSystemManager::Copy";
      case messages::FileSystemManager::kRemove:
            return "Receive reply blink::mojom::FileSystemManager::Remove";
      case messages::FileSystemManager::kReadMetadata:
            return "Receive reply blink::mojom::FileSystemManager::ReadMetadata";
      case messages::FileSystemManager::kCreate:
            return "Receive reply blink::mojom::FileSystemManager::Create";
      case messages::FileSystemManager::kExists:
            return "Receive reply blink::mojom::FileSystemManager::Exists";
      case messages::FileSystemManager::kReadDirectory:
            return "Receive reply blink::mojom::FileSystemManager::ReadDirectory";
      case messages::FileSystemManager::kReadDirectorySync:
            return "Receive reply blink::mojom::FileSystemManager::ReadDirectorySync";
      case messages::FileSystemManager::kWrite:
            return "Receive reply blink::mojom::FileSystemManager::Write";
      case messages::FileSystemManager::kWriteSync:
            return "Receive reply blink::mojom::FileSystemManager::WriteSync";
      case messages::FileSystemManager::kTruncate:
            return "Receive reply blink::mojom::FileSystemManager::Truncate";
      case messages::FileSystemManager::kTruncateSync:
            return "Receive reply blink::mojom::FileSystemManager::TruncateSync";
      case messages::FileSystemManager::kCreateSnapshotFile:
            return "Receive reply blink::mojom::FileSystemManager::CreateSnapshotFile";
      case messages::FileSystemManager::kGetPlatformPath:
            return "Receive reply blink::mojom::FileSystemManager::GetPlatformPath";
      case messages::FileSystemManager::kRegisterBlob:
            return "Receive reply blink::mojom::FileSystemManager::RegisterBlob";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemManager::Open_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde429c41;  // IPCStableHash for blink::mojom::FileSystemManager::Open
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::ResolveURL_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0c3d3fc7;  // IPCStableHash for blink::mojom::FileSystemManager::ResolveURL
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Move_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5304f88f;  // IPCStableHash for blink::mojom::FileSystemManager::Move
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Copy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92c555d4;  // IPCStableHash for blink::mojom::FileSystemManager::Copy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7a59e96;  // IPCStableHash for blink::mojom::FileSystemManager::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::ReadMetadata_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x612f4bd8;  // IPCStableHash for blink::mojom::FileSystemManager::ReadMetadata
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Create_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b90edd9;  // IPCStableHash for blink::mojom::FileSystemManager::Create
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Exists_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee8ee20f;  // IPCStableHash for blink::mojom::FileSystemManager::Exists
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::ReadDirectory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x138a4ab8;  // IPCStableHash for blink::mojom::FileSystemManager::ReadDirectory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::ReadDirectorySync_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e25f9cf;  // IPCStableHash for blink::mojom::FileSystemManager::ReadDirectorySync
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb159edf6;  // IPCStableHash for blink::mojom::FileSystemManager::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::WriteSync_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb88f7c7;  // IPCStableHash for blink::mojom::FileSystemManager::WriteSync
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::Truncate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd5d4b779;  // IPCStableHash for blink::mojom::FileSystemManager::Truncate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::TruncateSync_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdd7c4e26;  // IPCStableHash for blink::mojom::FileSystemManager::TruncateSync
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::CreateSnapshotFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7596fc3a;  // IPCStableHash for blink::mojom::FileSystemManager::CreateSnapshotFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::GetPlatformPath_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfae2862c;  // IPCStableHash for blink::mojom::FileSystemManager::GetPlatformPath
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemManager::RegisterBlob_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ddd426f;  // IPCStableHash for blink::mojom::FileSystemManager::RegisterBlob
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileSystemManager::Open(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, FileSystemType file_system_type, ::blink::String* out_name, ::blink::KURL* out_root_url, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::ResolveURL(const ::blink::KURL& filesystem_url, FileSystemInfoPtr* out_info, ::base::FilePath* out_file_path, bool* out_is_directory, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::Move(const ::blink::KURL& src_path, const ::blink::KURL& dest_path, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::Copy(const ::blink::KURL& src_path, const ::blink::KURL& dest_path, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::Remove(const ::blink::KURL& path, bool recursive, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::ReadMetadata(const ::blink::KURL& path, ::base::File::Info* out_file_info, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::Create(const ::blink::KURL& path, bool exclusive, bool is_directory, bool recursive, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::Exists(const ::blink::KURL& path, bool is_directory, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::ReadDirectorySync(const ::blink::KURL& path, ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_entries, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::WriteSync(const ::blink::KURL& file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob, int64_t position, int64_t* out_byte_count, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::TruncateSync(const ::blink::KURL& file_path, int64_t length, ::base::File::Error* out_error_code) {
  NOTREACHED();
}
bool FileSystemManager::CreateSnapshotFile(const ::blink::KURL& file_path, ::base::File::Info* out_file_info, ::base::FilePath* out_platform_path, ::base::File::Error* out_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener) {
  NOTREACHED();
}
bool FileSystemManager::GetPlatformPath(const ::blink::KURL& file_path, ::base::FilePath* out_platform_path) {
  NOTREACHED();
}
bool FileSystemManager::RegisterBlob(const ::blink::String& content_type, const ::blink::KURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time, ::scoped_refptr<::blink::BlobDataHandle>* out_blob) {
  NOTREACHED();
}
class FileSystemManager_Open_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Open_HandleSyncResponse(
      bool* result, ::blink::String* out_name, ::blink::KURL* out_root_url, ::base::File::Error* out_error_code)
      : result_(result), out_name_(out_name), out_root_url_(out_root_url), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Open_HandleSyncResponse(const FileSystemManager_Open_HandleSyncResponse&) = delete;
  FileSystemManager_Open_HandleSyncResponse& operator=(const FileSystemManager_Open_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_name_;
  ::blink::KURL* out_root_url_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Open_ForwardToCallback(
      FileSystemManager::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Open_ForwardToCallback(const FileSystemManager_Open_ForwardToCallback&) = delete;
  FileSystemManager_Open_ForwardToCallback& operator=(const FileSystemManager_Open_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::OpenCallback callback_;
};
class FileSystemManager_ResolveURL_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ResolveURL_HandleSyncResponse(
      bool* result, FileSystemInfoPtr* out_info, ::base::FilePath* out_file_path, bool* out_is_directory, ::base::File::Error* out_error_code)
      : result_(result), out_info_(out_info), out_file_path_(out_file_path), out_is_directory_(out_is_directory), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_ResolveURL_HandleSyncResponse(const FileSystemManager_ResolveURL_HandleSyncResponse&) = delete;
  FileSystemManager_ResolveURL_HandleSyncResponse& operator=(const FileSystemManager_ResolveURL_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  FileSystemInfoPtr* out_info_;
  ::base::FilePath* out_file_path_;
  bool* out_is_directory_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_ResolveURL_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ResolveURL_ForwardToCallback(
      FileSystemManager::ResolveURLCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_ResolveURL_ForwardToCallback(const FileSystemManager_ResolveURL_ForwardToCallback&) = delete;
  FileSystemManager_ResolveURL_ForwardToCallback& operator=(const FileSystemManager_ResolveURL_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::ResolveURLCallback callback_;
};
class FileSystemManager_Move_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Move_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Move_HandleSyncResponse(const FileSystemManager_Move_HandleSyncResponse&) = delete;
  FileSystemManager_Move_HandleSyncResponse& operator=(const FileSystemManager_Move_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Move_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Move_ForwardToCallback(
      FileSystemManager::MoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Move_ForwardToCallback(const FileSystemManager_Move_ForwardToCallback&) = delete;
  FileSystemManager_Move_ForwardToCallback& operator=(const FileSystemManager_Move_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::MoveCallback callback_;
};
class FileSystemManager_Copy_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Copy_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Copy_HandleSyncResponse(const FileSystemManager_Copy_HandleSyncResponse&) = delete;
  FileSystemManager_Copy_HandleSyncResponse& operator=(const FileSystemManager_Copy_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Copy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Copy_ForwardToCallback(
      FileSystemManager::CopyCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Copy_ForwardToCallback(const FileSystemManager_Copy_ForwardToCallback&) = delete;
  FileSystemManager_Copy_ForwardToCallback& operator=(const FileSystemManager_Copy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::CopyCallback callback_;
};
class FileSystemManager_Remove_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Remove_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Remove_HandleSyncResponse(const FileSystemManager_Remove_HandleSyncResponse&) = delete;
  FileSystemManager_Remove_HandleSyncResponse& operator=(const FileSystemManager_Remove_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Remove_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Remove_ForwardToCallback(
      FileSystemManager::RemoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Remove_ForwardToCallback(const FileSystemManager_Remove_ForwardToCallback&) = delete;
  FileSystemManager_Remove_ForwardToCallback& operator=(const FileSystemManager_Remove_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::RemoveCallback callback_;
};
class FileSystemManager_ReadMetadata_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ReadMetadata_HandleSyncResponse(
      bool* result, ::base::File::Info* out_file_info, ::base::File::Error* out_error_code)
      : result_(result), out_file_info_(out_file_info), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_ReadMetadata_HandleSyncResponse(const FileSystemManager_ReadMetadata_HandleSyncResponse&) = delete;
  FileSystemManager_ReadMetadata_HandleSyncResponse& operator=(const FileSystemManager_ReadMetadata_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Info* out_file_info_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_ReadMetadata_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ReadMetadata_ForwardToCallback(
      FileSystemManager::ReadMetadataCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_ReadMetadata_ForwardToCallback(const FileSystemManager_ReadMetadata_ForwardToCallback&) = delete;
  FileSystemManager_ReadMetadata_ForwardToCallback& operator=(const FileSystemManager_ReadMetadata_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::ReadMetadataCallback callback_;
};
class FileSystemManager_Create_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Create_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Create_HandleSyncResponse(const FileSystemManager_Create_HandleSyncResponse&) = delete;
  FileSystemManager_Create_HandleSyncResponse& operator=(const FileSystemManager_Create_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Create_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Create_ForwardToCallback(
      FileSystemManager::CreateCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Create_ForwardToCallback(const FileSystemManager_Create_ForwardToCallback&) = delete;
  FileSystemManager_Create_ForwardToCallback& operator=(const FileSystemManager_Create_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::CreateCallback callback_;
};
class FileSystemManager_Exists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Exists_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_Exists_HandleSyncResponse(const FileSystemManager_Exists_HandleSyncResponse&) = delete;
  FileSystemManager_Exists_HandleSyncResponse& operator=(const FileSystemManager_Exists_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_Exists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Exists_ForwardToCallback(
      FileSystemManager::ExistsCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Exists_ForwardToCallback(const FileSystemManager_Exists_ForwardToCallback&) = delete;
  FileSystemManager_Exists_ForwardToCallback& operator=(const FileSystemManager_Exists_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::ExistsCallback callback_;
};
class FileSystemManager_ReadDirectorySync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ReadDirectorySync_HandleSyncResponse(
      bool* result, ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_entries, ::base::File::Error* out_error_code)
      : result_(result), out_entries_(out_entries), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_ReadDirectorySync_HandleSyncResponse(const FileSystemManager_ReadDirectorySync_HandleSyncResponse&) = delete;
  FileSystemManager_ReadDirectorySync_HandleSyncResponse& operator=(const FileSystemManager_ReadDirectorySync_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_entries_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_ReadDirectorySync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_ReadDirectorySync_ForwardToCallback(
      FileSystemManager::ReadDirectorySyncCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_ReadDirectorySync_ForwardToCallback(const FileSystemManager_ReadDirectorySync_ForwardToCallback&) = delete;
  FileSystemManager_ReadDirectorySync_ForwardToCallback& operator=(const FileSystemManager_ReadDirectorySync_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::ReadDirectorySyncCallback callback_;
};
class FileSystemManager_WriteSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_WriteSync_HandleSyncResponse(
      bool* result, int64_t* out_byte_count, ::base::File::Error* out_error_code)
      : result_(result), out_byte_count_(out_byte_count), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_WriteSync_HandleSyncResponse(const FileSystemManager_WriteSync_HandleSyncResponse&) = delete;
  FileSystemManager_WriteSync_HandleSyncResponse& operator=(const FileSystemManager_WriteSync_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int64_t* out_byte_count_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_WriteSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_WriteSync_ForwardToCallback(
      FileSystemManager::WriteSyncCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_WriteSync_ForwardToCallback(const FileSystemManager_WriteSync_ForwardToCallback&) = delete;
  FileSystemManager_WriteSync_ForwardToCallback& operator=(const FileSystemManager_WriteSync_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::WriteSyncCallback callback_;
};

class FileSystemManager_Truncate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_Truncate_ForwardToCallback(
      FileSystemManager::TruncateCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_Truncate_ForwardToCallback(const FileSystemManager_Truncate_ForwardToCallback&) = delete;
  FileSystemManager_Truncate_ForwardToCallback& operator=(const FileSystemManager_Truncate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::TruncateCallback callback_;
};
class FileSystemManager_TruncateSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_TruncateSync_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }

  FileSystemManager_TruncateSync_HandleSyncResponse(const FileSystemManager_TruncateSync_HandleSyncResponse&) = delete;
  FileSystemManager_TruncateSync_HandleSyncResponse& operator=(const FileSystemManager_TruncateSync_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_code_;};

class FileSystemManager_TruncateSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_TruncateSync_ForwardToCallback(
      FileSystemManager::TruncateSyncCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_TruncateSync_ForwardToCallback(const FileSystemManager_TruncateSync_ForwardToCallback&) = delete;
  FileSystemManager_TruncateSync_ForwardToCallback& operator=(const FileSystemManager_TruncateSync_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::TruncateSyncCallback callback_;
};
class FileSystemManager_CreateSnapshotFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_CreateSnapshotFile_HandleSyncResponse(
      bool* result, ::base::File::Info* out_file_info, ::base::FilePath* out_platform_path, ::base::File::Error* out_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener)
      : result_(result), out_file_info_(out_file_info), out_platform_path_(out_platform_path), out_error_code_(out_error_code), out_snapshot_listener_(out_snapshot_listener) {
    DCHECK(!*result_);
  }

  FileSystemManager_CreateSnapshotFile_HandleSyncResponse(const FileSystemManager_CreateSnapshotFile_HandleSyncResponse&) = delete;
  FileSystemManager_CreateSnapshotFile_HandleSyncResponse& operator=(const FileSystemManager_CreateSnapshotFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Info* out_file_info_;
  ::base::FilePath* out_platform_path_;
  ::base::File::Error* out_error_code_;
  ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener_;};

class FileSystemManager_CreateSnapshotFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_CreateSnapshotFile_ForwardToCallback(
      FileSystemManager::CreateSnapshotFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_CreateSnapshotFile_ForwardToCallback(const FileSystemManager_CreateSnapshotFile_ForwardToCallback&) = delete;
  FileSystemManager_CreateSnapshotFile_ForwardToCallback& operator=(const FileSystemManager_CreateSnapshotFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::CreateSnapshotFileCallback callback_;
};
class FileSystemManager_GetPlatformPath_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_GetPlatformPath_HandleSyncResponse(
      bool* result, ::base::FilePath* out_platform_path)
      : result_(result), out_platform_path_(out_platform_path) {
    DCHECK(!*result_);
  }

  FileSystemManager_GetPlatformPath_HandleSyncResponse(const FileSystemManager_GetPlatformPath_HandleSyncResponse&) = delete;
  FileSystemManager_GetPlatformPath_HandleSyncResponse& operator=(const FileSystemManager_GetPlatformPath_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::FilePath* out_platform_path_;};

class FileSystemManager_GetPlatformPath_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_GetPlatformPath_ForwardToCallback(
      FileSystemManager::GetPlatformPathCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_GetPlatformPath_ForwardToCallback(const FileSystemManager_GetPlatformPath_ForwardToCallback&) = delete;
  FileSystemManager_GetPlatformPath_ForwardToCallback& operator=(const FileSystemManager_GetPlatformPath_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::GetPlatformPathCallback callback_;
};
class FileSystemManager_RegisterBlob_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_RegisterBlob_HandleSyncResponse(
      bool* result, ::scoped_refptr<::blink::BlobDataHandle>* out_blob)
      : result_(result), out_blob_(out_blob) {
    DCHECK(!*result_);
  }

  FileSystemManager_RegisterBlob_HandleSyncResponse(const FileSystemManager_RegisterBlob_HandleSyncResponse&) = delete;
  FileSystemManager_RegisterBlob_HandleSyncResponse& operator=(const FileSystemManager_RegisterBlob_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::scoped_refptr<::blink::BlobDataHandle>* out_blob_;};

class FileSystemManager_RegisterBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemManager_RegisterBlob_ForwardToCallback(
      FileSystemManager::RegisterBlobCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemManager_RegisterBlob_ForwardToCallback(const FileSystemManager_RegisterBlob_ForwardToCallback&) = delete;
  FileSystemManager_RegisterBlob_ForwardToCallback& operator=(const FileSystemManager_RegisterBlob_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemManager::RegisterBlobCallback callback_;
};

FileSystemManagerProxy::FileSystemManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileSystemManagerProxy::Open(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& param_origin, FileSystemType param_file_system_type, ::blink::String* out_param_name, ::blink::KURL* out_param_root_url, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Open (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), param_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_system_type"), param_file_system_type,
                        "<value of type FileSystemType>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Open");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Open_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in FileSystemManager.Open request");

  
  mojo::internal::Serialize<::blink::mojom::FileSystemType>(
    param_file_system_type,
    &params->file_system_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Open");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Open_HandleSyncResponse(
          &result, out_param_name, out_param_root_url, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Open", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), out_param_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_url"), out_param_root_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Open(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin, FileSystemType in_file_system_type, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Open", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_system_type"), in_file_system_type,
                        "<value of type FileSystemType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Open_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in FileSystemManager.Open request");

  
  mojo::internal::Serialize<::blink::mojom::FileSystemType>(
    in_file_system_type,
    &params->file_system_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Open_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::ResolveURL(
    const ::blink::KURL& param_filesystem_url, FileSystemInfoPtr* out_param_info, ::base::FilePath* out_param_file_path, bool* out_param_is_directory, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::ResolveURL (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filesystem_url"), param_filesystem_url,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::ResolveURL");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kResolveURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ResolveURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filesystem_url)::BaseType> filesystem_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_filesystem_url,
    filesystem_url_fragment);

  params->filesystem_url.Set(
      filesystem_url_fragment.is_null() ? nullptr : filesystem_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filesystem_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filesystem_url in FileSystemManager.ResolveURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ResolveURL");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ResolveURL_HandleSyncResponse(
          &result, out_param_info, out_param_file_path, out_param_is_directory, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::ResolveURL", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type FileSystemInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), out_param_file_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), out_param_is_directory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::ResolveURL(
    const ::blink::KURL& in_filesystem_url, ResolveURLCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::ResolveURL", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filesystem_url"), in_filesystem_url,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kResolveURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ResolveURL_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filesystem_url)::BaseType> filesystem_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_filesystem_url,
    filesystem_url_fragment);

  params->filesystem_url.Set(
      filesystem_url_fragment.is_null() ? nullptr : filesystem_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filesystem_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filesystem_url in FileSystemManager.ResolveURL request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ResolveURL");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ResolveURL_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::Move(
    const ::blink::KURL& param_src_path, const ::blink::KURL& param_dest_path, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Move (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_path"), param_src_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_path"), param_dest_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Move");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Move_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src_path)::BaseType> src_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_src_path,
    src_path_fragment);

  params->src_path.Set(
      src_path_fragment.is_null() ? nullptr : src_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_path in FileSystemManager.Move request");
  mojo::internal::MessageFragment<
      typename decltype(params->dest_path)::BaseType> dest_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_dest_path,
    dest_path_fragment);

  params->dest_path.Set(
      dest_path_fragment.is_null() ? nullptr : dest_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dest_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dest_path in FileSystemManager.Move request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Move");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Move_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Move", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Move(
    const ::blink::KURL& in_src_path, const ::blink::KURL& in_dest_path, MoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Move", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_path"), in_src_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_path"), in_dest_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Move_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src_path)::BaseType> src_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_src_path,
    src_path_fragment);

  params->src_path.Set(
      src_path_fragment.is_null() ? nullptr : src_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_path in FileSystemManager.Move request");
  mojo::internal::MessageFragment<
      typename decltype(params->dest_path)::BaseType> dest_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_dest_path,
    dest_path_fragment);

  params->dest_path.Set(
      dest_path_fragment.is_null() ? nullptr : dest_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dest_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dest_path in FileSystemManager.Move request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Move");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Move_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::Copy(
    const ::blink::KURL& param_src_path, const ::blink::KURL& param_dest_path, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Copy (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_path"), param_src_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_path"), param_dest_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Copy");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Copy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src_path)::BaseType> src_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_src_path,
    src_path_fragment);

  params->src_path.Set(
      src_path_fragment.is_null() ? nullptr : src_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_path in FileSystemManager.Copy request");
  mojo::internal::MessageFragment<
      typename decltype(params->dest_path)::BaseType> dest_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_dest_path,
    dest_path_fragment);

  params->dest_path.Set(
      dest_path_fragment.is_null() ? nullptr : dest_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dest_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dest_path in FileSystemManager.Copy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Copy");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Copy_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Copy", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Copy(
    const ::blink::KURL& in_src_path, const ::blink::KURL& in_dest_path, CopyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Copy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_path"), in_src_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dest_path"), in_dest_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Copy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src_path)::BaseType> src_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_src_path,
    src_path_fragment);

  params->src_path.Set(
      src_path_fragment.is_null() ? nullptr : src_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_path in FileSystemManager.Copy request");
  mojo::internal::MessageFragment<
      typename decltype(params->dest_path)::BaseType> dest_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_dest_path,
    dest_path_fragment);

  params->dest_path.Set(
      dest_path_fragment.is_null() ? nullptr : dest_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dest_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dest_path in FileSystemManager.Copy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Copy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Copy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::Remove(
    const ::blink::KURL& param_path, bool param_recursive, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Remove (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recursive"), param_recursive,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Remove");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Remove_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Remove request");

  params->recursive = param_recursive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Remove");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Remove_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Remove", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Remove(
    const ::blink::KURL& in_path, bool in_recursive, RemoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recursive"), in_recursive,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Remove_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Remove request");

  params->recursive = in_recursive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Remove");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Remove_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::ReadMetadata(
    const ::blink::KURL& param_path, ::base::File::Info* out_param_file_info, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::ReadMetadata (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::ReadMetadata");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.ReadMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadMetadata");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ReadMetadata_HandleSyncResponse(
          &result, out_param_file_info, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::ReadMetadata", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), out_param_file_info,
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::ReadMetadata(
    const ::blink::KURL& in_path, ReadMetadataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::ReadMetadata", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadMetadata_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.ReadMetadata request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadMetadata");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ReadMetadata_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::Create(
    const ::blink::KURL& param_path, bool param_exclusive, bool param_is_directory, bool param_recursive, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Create (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exclusive"), param_exclusive,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), param_is_directory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recursive"), param_recursive,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Create");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Create_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Create request");

  params->exclusive = param_exclusive;

  params->is_directory = param_is_directory;

  params->recursive = param_recursive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Create");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Create_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Create", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Create(
    const ::blink::KURL& in_path, bool in_exclusive, bool in_is_directory, bool in_recursive, CreateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Create", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exclusive"), in_exclusive,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), in_is_directory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("recursive"), in_recursive,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Create_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Create request");

  params->exclusive = in_exclusive;

  params->is_directory = in_is_directory;

  params->recursive = in_recursive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Create");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Create_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::Exists(
    const ::blink::KURL& param_path, bool param_is_directory, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::Exists (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), param_is_directory,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::Exists");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Exists request");

  params->is_directory = param_is_directory;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Exists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Exists_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::Exists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::Exists(
    const ::blink::KURL& in_path, bool in_is_directory, ExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Exists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), in_is_directory,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Exists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.Exists request");

  params->is_directory = in_is_directory;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Exists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Exists_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemManagerProxy::ReadDirectory(
    const ::blink::KURL& in_path, ::mojo::PendingRemote<FileSystemOperationListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::ReadDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<FileSystemOperationListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.ReadDirectory request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemOperationListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in FileSystemManager.ReadDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadDirectory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool FileSystemManagerProxy::ReadDirectorySync(
    const ::blink::KURL& param_path, ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_param_entries, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::ReadDirectorySync (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::ReadDirectorySync");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadDirectorySync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadDirectorySync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.ReadDirectorySync request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadDirectorySync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ReadDirectorySync_HandleSyncResponse(
          &result, out_param_entries, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::ReadDirectorySync", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), out_param_entries,
                        "<value of type ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::ReadDirectorySync(
    const ::blink::KURL& in_path, ReadDirectorySyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::ReadDirectorySync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadDirectorySync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadDirectorySync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_path,
    path_fragment);

  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null path in FileSystemManager.ReadDirectorySync request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadDirectorySync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_ReadDirectorySync_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemManagerProxy::Write(
    const ::blink::KURL& in_file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> in_blob, int64_t in_position, ::mojo::PendingReceiver<FileSystemCancellableOperation> in_op_receiver, ::mojo::PendingRemote<FileSystemOperationListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("op_receiver"), in_op_receiver,
                        "<value of type ::mojo::PendingReceiver<FileSystemCancellableOperation>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<FileSystemOperationListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Write_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.Write request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileSystemManager.Write request");

  params->position = in_position;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemCancellableOperationInterfaceBase>>(
    in_op_receiver,
    &params->op_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->op_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid op_receiver in FileSystemManager.Write request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemOperationListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in FileSystemManager.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Write");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool FileSystemManagerProxy::WriteSync(
    const ::blink::KURL& param_file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> param_blob, int64_t param_position, int64_t* out_param_byte_count, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::WriteSync (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), param_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), param_position,
                        "<value of type int64_t>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::WriteSync");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kWriteSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_WriteSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.WriteSync request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
    param_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileSystemManager.WriteSync request");

  params->position = param_position;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("WriteSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_WriteSync_HandleSyncResponse(
          &result, out_param_byte_count, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::WriteSync", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("byte_count"), out_param_byte_count,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::WriteSync(
    const ::blink::KURL& in_file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> in_blob, int64_t in_position, WriteSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::WriteSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kWriteSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_WriteSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.WriteSync request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
    in_blob,
    &params->blob,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->blob)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid blob in FileSystemManager.WriteSync request");

  params->position = in_position;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("WriteSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_WriteSync_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemManagerProxy::Truncate(
    const ::blink::KURL& in_file_path, int64_t in_length, ::mojo::PendingReceiver<FileSystemCancellableOperation> in_op_receiver, TruncateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::Truncate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("op_receiver"), in_op_receiver,
                        "<value of type ::mojo::PendingReceiver<FileSystemCancellableOperation>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kTruncate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Truncate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.Truncate request");

  params->length = in_length;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemCancellableOperationInterfaceBase>>(
    in_op_receiver,
    &params->op_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->op_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid op_receiver in FileSystemManager.Truncate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Truncate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_Truncate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::TruncateSync(
    const ::blink::KURL& param_file_path, int64_t param_length, ::base::File::Error* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::TruncateSync (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), param_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), param_length,
                        "<value of type int64_t>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::TruncateSync");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kTruncateSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_TruncateSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.TruncateSync request");

  params->length = param_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("TruncateSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_TruncateSync_HandleSyncResponse(
          &result, out_param_error_code));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::TruncateSync", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::TruncateSync(
    const ::blink::KURL& in_file_path, int64_t in_length, TruncateSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::TruncateSync", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kTruncateSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_TruncateSync_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.TruncateSync request");

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("TruncateSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_TruncateSync_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::CreateSnapshotFile(
    const ::blink::KURL& param_file_path, ::base::File::Info* out_param_file_info, ::base::FilePath* out_param_platform_path, ::base::File::Error* out_param_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener>* out_param_snapshot_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::CreateSnapshotFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), param_file_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::CreateSnapshotFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreateSnapshotFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_CreateSnapshotFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.CreateSnapshotFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("CreateSnapshotFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_CreateSnapshotFile_HandleSyncResponse(
          &result, out_param_file_info, out_param_platform_path, out_param_error_code, out_param_snapshot_listener));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::CreateSnapshotFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), out_param_file_info,
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_path"), out_param_platform_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), out_param_error_code,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot_listener"), out_param_snapshot_listener,
                        "<value of type ::mojo::PendingRemote<ReceivedSnapshotListener>>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::CreateSnapshotFile(
    const ::blink::KURL& in_file_path, CreateSnapshotFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::CreateSnapshotFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreateSnapshotFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_CreateSnapshotFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.CreateSnapshotFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("CreateSnapshotFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_CreateSnapshotFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::GetPlatformPath(
    const ::blink::KURL& param_file_path, ::base::FilePath* out_param_platform_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::GetPlatformPath (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), param_file_path,
                        "<value of type const ::blink::KURL&>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::GetPlatformPath");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kGetPlatformPath), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_GetPlatformPath_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.GetPlatformPath request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("GetPlatformPath");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_GetPlatformPath_HandleSyncResponse(
          &result, out_param_platform_path));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::GetPlatformPath", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_path"), out_param_platform_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::GetPlatformPath(
    const ::blink::KURL& in_file_path, GetPlatformPathCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::GetPlatformPath", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::blink::KURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kGetPlatformPath), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_GetPlatformPath_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in FileSystemManager.GetPlatformPath request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("GetPlatformPath");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_GetPlatformPath_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool FileSystemManagerProxy::RegisterBlob(
    const ::blink::String& param_content_type, const ::blink::KURL& param_url, uint64_t param_length, std::optional<::base::Time> param_expected_modification_time, ::scoped_refptr<::blink::BlobDataHandle>* out_param_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::FileSystemManager::RegisterBlob (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), param_content_type,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), param_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_modification_time"), param_expected_modification_time,
                        "<value of type std::optional<::base::Time>>");
   });
#else
  TRACE_EVENT0("mojom", "FileSystemManager::RegisterBlob");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRegisterBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_RegisterBlob_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_content_type,
    content_type_fragment);

  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_type in FileSystemManager.RegisterBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FileSystemManager.RegisterBlob request");

  params->length = param_length;
  mojo::internal::MessageFragment<
      typename decltype(params->expected_modification_time)::BaseType> expected_modification_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    param_expected_modification_time,
    expected_modification_time_fragment);

  params->expected_modification_time.Set(
      expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("RegisterBlob");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_RegisterBlob_HandleSyncResponse(
          &result, out_param_blob));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileSystemManager::RegisterBlob", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), out_param_blob,
                        "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>");
   });
#endif
  return result;
}

void FileSystemManagerProxy::RegisterBlob(
    const ::blink::String& in_content_type, const ::blink::KURL& in_url, uint64_t in_length, std::optional<::base::Time> in_expected_modification_time, RegisterBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemManager::RegisterBlob", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_type"), in_content_type,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expected_modification_time"), in_expected_modification_time,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRegisterBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_RegisterBlob_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->content_type)::BaseType> content_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_content_type,
    content_type_fragment);

  params->content_type.Set(
      content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->content_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null content_type in FileSystemManager.RegisterBlob request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in FileSystemManager.RegisterBlob request");

  params->length = in_length;
  mojo::internal::MessageFragment<
      typename decltype(params->expected_modification_time)::BaseType> expected_modification_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_expected_modification_time,
    expected_modification_time_fragment);

  params->expected_modification_time.Set(
      expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("RegisterBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemManager_RegisterBlob_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemManager_Open_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::OpenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Open_ProxyToResponder> proxy(
        new FileSystemManager_Open_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Open_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Open_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::OpenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_name, const ::blink::KURL& in_root_url, ::base::File::Error in_error_code);
};

bool FileSystemManager_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Open_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.0
  bool success = true;
  ::blink::String p_name{};
  ::blink::KURL p_root_url{};
  ::base::File::Error p_error_code{};
  FileSystemManager_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadName(&p_name))
    success = false;
  if (success && !input_data_view.ReadRootUrl(&p_root_url))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_name), 
std::move(p_root_url), 
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Open_ProxyToResponder::Run(
    const ::blink::String& in_name, const ::blink::KURL& in_root_url, ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Open", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_url"), in_root_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kOpen), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Open_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in ");
  mojo::internal::MessageFragment<
      typename decltype(params->root_url)::BaseType> root_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_root_url,
    root_url_fragment);

  params->root_url.Set(
      root_url_fragment.is_null() ? nullptr : root_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_url in ");

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Open_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Open_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Open_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.0
  bool success = true;
  ::blink::String p_name{};
  ::blink::KURL p_root_url{};
  ::base::File::Error p_error_code{};
  FileSystemManager_Open_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadName(&p_name))
    success = false;
  if (success && !input_data_view.ReadRootUrl(&p_root_url))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 0, true);
    return false;
  }
  *out_name_ = std::move(p_name);
  *out_root_url_ = std::move(p_root_url);
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_ResolveURL_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::ResolveURLCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_ResolveURL_ProxyToResponder> proxy(
        new FileSystemManager_ResolveURL_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_ResolveURL_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_ResolveURL_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_ResolveURL_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::ResolveURLCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      FileSystemInfoPtr in_info, const ::base::FilePath& in_file_path, bool in_is_directory, ::base::File::Error in_error_code);
};

bool FileSystemManager_ResolveURL_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ResolveURL_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_ResolveURL_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.1
  bool success = true;
  FileSystemInfoPtr p_info{};
  ::base::FilePath p_file_path{};
  bool p_is_directory{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ResolveURL_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (success && !input_data_view.ReadFilePath(&p_file_path))
    success = false;
  if (success)
    p_is_directory = input_data_view.is_directory();
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info), 
std::move(p_file_path), 
std::move(p_is_directory), 
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_ResolveURL_ProxyToResponder::Run(
    FileSystemInfoPtr in_info, const ::base::FilePath& in_file_path, bool in_is_directory, ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::ResolveURL", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type FileSystemInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_path"), in_file_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_directory"), in_is_directory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kResolveURL), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ResolveURL_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->file_path)::BaseType> file_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_file_path,
    file_path_fragment);

  params->file_path.Set(
      file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_path in ");

  params->is_directory = in_is_directory;

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ResolveURL");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_ResolveURL_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ResolveURL_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_ResolveURL_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.1
  bool success = true;
  FileSystemInfoPtr p_info{};
  ::base::FilePath p_file_path{};
  bool p_is_directory{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ResolveURL_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (success && !input_data_view.ReadFilePath(&p_file_path))
    success = false;
  if (success)
    p_is_directory = input_data_view.is_directory();
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 1, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *out_file_path_ = std::move(p_file_path);
  *out_is_directory_ = std::move(p_is_directory);
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Move_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::MoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Move_ProxyToResponder> proxy(
        new FileSystemManager_Move_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Move_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Move_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Move_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::MoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Move_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Move_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Move_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.2
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Move_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Move_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Move", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kMove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Move_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Move");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Move_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Move_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Move_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.2
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Move_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 2, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Copy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::CopyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Copy_ProxyToResponder> proxy(
        new FileSystemManager_Copy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Copy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Copy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Copy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::CopyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Copy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Copy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Copy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.3
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Copy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Copy_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Copy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCopy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Copy_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Copy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Copy_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Copy_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Copy_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.3
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Copy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 3, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Remove_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::RemoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Remove_ProxyToResponder> proxy(
        new FileSystemManager_Remove_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Remove_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Remove_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Remove_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::RemoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Remove_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Remove_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Remove_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.4
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Remove_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Remove", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Remove_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Remove");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Remove_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Remove_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Remove_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.4
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 4, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_ReadMetadata_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::ReadMetadataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_ReadMetadata_ProxyToResponder> proxy(
        new FileSystemManager_ReadMetadata_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_ReadMetadata_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_ReadMetadata_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_ReadMetadata_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::ReadMetadataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::File::Info& in_file_info, ::base::File::Error in_error_code);
};

bool FileSystemManager_ReadMetadata_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ReadMetadata_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_ReadMetadata_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.5
  bool success = true;
  ::base::File::Info p_file_info{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ReadMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFileInfo(&p_file_info))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file_info), 
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_ReadMetadata_ProxyToResponder::Run(
    const ::base::File::Info& in_file_info, ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::ReadMetadata", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), in_file_info,
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadMetadata), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadMetadata_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_info)::BaseType> file_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
    in_file_info,
    file_info_fragment);

  params->file_info.Set(
      file_info_fragment.is_null() ? nullptr : file_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_info in ");

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadMetadata");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_ReadMetadata_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ReadMetadata_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_ReadMetadata_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.5
  bool success = true;
  ::base::File::Info p_file_info{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ReadMetadata_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFileInfo(&p_file_info))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 5, true);
    return false;
  }
  *out_file_info_ = std::move(p_file_info);
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Create_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::CreateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Create_ProxyToResponder> proxy(
        new FileSystemManager_Create_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Create_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Create_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Create_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::CreateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Create_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Create_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Create_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.6
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Create_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Create_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Create", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Create_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Create");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Create_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Create_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Create_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.6
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Create_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 6, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Exists_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::ExistsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Exists_ProxyToResponder> proxy(
        new FileSystemManager_Exists_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Exists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Exists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Exists_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::ExistsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Exists_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Exists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Exists_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.7
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Exists_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Exists", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Exists_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Exists");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_Exists_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Exists_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_Exists_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.7
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Exists_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 7, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_ReadDirectorySync_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::ReadDirectorySyncCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_ReadDirectorySync_ProxyToResponder> proxy(
        new FileSystemManager_ReadDirectorySync_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_ReadDirectorySync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_ReadDirectorySync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_ReadDirectorySync_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::ReadDirectorySyncCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> in_entries, ::base::File::Error in_error_code);
};

bool FileSystemManager_ReadDirectorySync_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.9
  bool success = true;
  ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> p_entries{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ReadDirectorySync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_entries), 
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_ReadDirectorySync_ProxyToResponder::Run(
    ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> in_entries, ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::ReadDirectorySync", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kReadDirectorySync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::filesystem::mojom::DirectoryEntryDataView>>(
    in_entries,
    entries_fragment,
    &entries_validate_params);

  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->entries.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null entries in ");

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("ReadDirectorySync");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_ReadDirectorySync_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.9
  bool success = true;
  ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> p_entries{};
  ::base::File::Error p_error_code{};
  FileSystemManager_ReadDirectorySync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 9, true);
    return false;
  }
  *out_entries_ = std::move(p_entries);
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_WriteSync_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::WriteSyncCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_WriteSync_ProxyToResponder> proxy(
        new FileSystemManager_WriteSync_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_WriteSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_WriteSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_WriteSync_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::WriteSyncCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_byte_count, ::base::File::Error in_error_code);
};

bool FileSystemManager_WriteSync_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_WriteSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_WriteSync_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.11
  bool success = true;
  int64_t p_byte_count{};
  ::base::File::Error p_error_code{};
  FileSystemManager_WriteSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_byte_count = input_data_view.byte_count();
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_byte_count), 
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_WriteSync_ProxyToResponder::Run(
    int64_t in_byte_count, ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::WriteSync", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("byte_count"), in_byte_count,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kWriteSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_WriteSync_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->byte_count = in_byte_count;

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("WriteSync");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_WriteSync_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_WriteSync_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_WriteSync_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.11
  bool success = true;
  int64_t p_byte_count{};
  ::base::File::Error p_error_code{};
  FileSystemManager_WriteSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_byte_count = input_data_view.byte_count();
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 11, true);
    return false;
  }
  *out_byte_count_ = std::move(p_byte_count);
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_Truncate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::TruncateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_Truncate_ProxyToResponder> proxy(
        new FileSystemManager_Truncate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_Truncate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_Truncate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_Truncate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::TruncateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_Truncate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_Truncate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_Truncate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.12
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_Truncate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_Truncate_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::Truncate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kTruncate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_Truncate_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("Truncate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemManager_TruncateSync_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::TruncateSyncCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_TruncateSync_ProxyToResponder> proxy(
        new FileSystemManager_TruncateSync_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_TruncateSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_TruncateSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_TruncateSync_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::TruncateSyncCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error_code);
};

bool FileSystemManager_TruncateSync_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_TruncateSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_TruncateSync_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.13
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_TruncateSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_code));
  }
  return true;
}

void FileSystemManager_TruncateSync_ProxyToResponder::Run(
    ::base::File::Error in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::TruncateSync", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kTruncateSync), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_TruncateSync_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("TruncateSync");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_TruncateSync_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_TruncateSync_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_TruncateSync_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.13
  bool success = true;
  ::base::File::Error p_error_code{};
  FileSystemManager_TruncateSync_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 13, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  *result_ = true;
  return true;
}
class FileSystemManager_CreateSnapshotFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::CreateSnapshotFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_CreateSnapshotFile_ProxyToResponder> proxy(
        new FileSystemManager_CreateSnapshotFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_CreateSnapshotFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_CreateSnapshotFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_CreateSnapshotFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::CreateSnapshotFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::File::Info& in_file_info, const ::base::FilePath& in_platform_path, ::base::File::Error in_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener> in_snapshot_listener);
};

bool FileSystemManager_CreateSnapshotFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.14
  bool success = true;
  ::base::File::Info p_file_info{};
  ::base::FilePath p_platform_path{};
  ::base::File::Error p_error_code{};
  ::mojo::PendingRemote<ReceivedSnapshotListener> p_snapshot_listener{};
  FileSystemManager_CreateSnapshotFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFileInfo(&p_file_info))
    success = false;
  if (success && !input_data_view.ReadPlatformPath(&p_platform_path))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (success) {
    p_snapshot_listener =
        input_data_view.TakeSnapshotListener<decltype(p_snapshot_listener)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_file_info), 
std::move(p_platform_path), 
std::move(p_error_code), 
std::move(p_snapshot_listener));
  }
  return true;
}

void FileSystemManager_CreateSnapshotFile_ProxyToResponder::Run(
    const ::base::File::Info& in_file_info, const ::base::FilePath& in_platform_path, ::base::File::Error in_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener> in_snapshot_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::CreateSnapshotFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_info"), in_file_info,
                        "<value of type const ::base::File::Info&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_path"), in_platform_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("snapshot_listener"), in_snapshot_listener,
                        "<value of type ::mojo::PendingRemote<ReceivedSnapshotListener>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kCreateSnapshotFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file_info)::BaseType> file_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
    in_file_info,
    file_info_fragment);

  params->file_info.Set(
      file_info_fragment.is_null() ? nullptr : file_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->platform_path)::BaseType> platform_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_platform_path,
    platform_path_fragment);

  params->platform_path.Set(
      platform_path_fragment.is_null() ? nullptr : platform_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->platform_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null platform_path in ");

  
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
    in_error_code,
    &params->error_code);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::ReceivedSnapshotListenerInterfaceBase>>(
    in_snapshot_listener,
    &params->snapshot_listener,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("CreateSnapshotFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_CreateSnapshotFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.14
  bool success = true;
  ::base::File::Info p_file_info{};
  ::base::FilePath p_platform_path{};
  ::base::File::Error p_error_code{};
  ::mojo::PendingRemote<ReceivedSnapshotListener> p_snapshot_listener{};
  FileSystemManager_CreateSnapshotFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFileInfo(&p_file_info))
    success = false;
  if (success && !input_data_view.ReadPlatformPath(&p_platform_path))
    success = false;
  if (success && !input_data_view.ReadErrorCode(&p_error_code))
    success = false;
  if (success) {
    p_snapshot_listener =
        input_data_view.TakeSnapshotListener<decltype(p_snapshot_listener)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 14, true);
    return false;
  }
  *out_file_info_ = std::move(p_file_info);
  *out_platform_path_ = std::move(p_platform_path);
  *out_error_code_ = std::move(p_error_code);
  *out_snapshot_listener_ = std::move(p_snapshot_listener);
  *result_ = true;
  return true;
}
class FileSystemManager_GetPlatformPath_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::GetPlatformPathCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_GetPlatformPath_ProxyToResponder> proxy(
        new FileSystemManager_GetPlatformPath_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_GetPlatformPath_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_GetPlatformPath_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_GetPlatformPath_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::GetPlatformPathCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::FilePath& in_platform_path);
};

bool FileSystemManager_GetPlatformPath_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_GetPlatformPath_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_GetPlatformPath_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.15
  bool success = true;
  ::base::FilePath p_platform_path{};
  FileSystemManager_GetPlatformPath_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlatformPath(&p_platform_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_platform_path));
  }
  return true;
}

void FileSystemManager_GetPlatformPath_ProxyToResponder::Run(
    const ::base::FilePath& in_platform_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::GetPlatformPath", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("platform_path"), in_platform_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kGetPlatformPath), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_GetPlatformPath_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->platform_path)::BaseType> platform_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_platform_path,
    platform_path_fragment);

  params->platform_path.Set(
      platform_path_fragment.is_null() ? nullptr : platform_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->platform_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null platform_path in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("GetPlatformPath");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_GetPlatformPath_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_GetPlatformPath_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_GetPlatformPath_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.15
  bool success = true;
  ::base::FilePath p_platform_path{};
  FileSystemManager_GetPlatformPath_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPlatformPath(&p_platform_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 15, true);
    return false;
  }
  *out_platform_path_ = std::move(p_platform_path);
  *result_ = true;
  return true;
}
class FileSystemManager_RegisterBlob_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemManager::RegisterBlobCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemManager_RegisterBlob_ProxyToResponder> proxy(
        new FileSystemManager_RegisterBlob_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemManager_RegisterBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemManager_RegisterBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemManager_RegisterBlob_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemManager::RegisterBlobCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::scoped_refptr<::blink::BlobDataHandle>& in_blob);
};

bool FileSystemManager_RegisterBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_RegisterBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemManager_RegisterBlob_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemManager.16
  bool success = true;
  ::scoped_refptr<::blink::BlobDataHandle> p_blob{};
  FileSystemManager_RegisterBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_blob));
  }
  return true;
}

void FileSystemManager_RegisterBlob_ProxyToResponder::Run(
    const ::scoped_refptr<::blink::BlobDataHandle>& in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemManager::RegisterBlob", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemManager::kRegisterBlob), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemManager_RegisterBlob_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blob)::BaseType> blob_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
    in_blob,
    blob_fragment);

  params->blob.Set(
      blob_fragment.is_null() ? nullptr : blob_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->blob.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null blob in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemManager::Name_);
  message.set_method_name("RegisterBlob");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileSystemManager_RegisterBlob_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemManager_RegisterBlob_ResponseParams_Data* params =
      reinterpret_cast<internal::FileSystemManager_RegisterBlob_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for FileSystemManager.16
  bool success = true;
  ::scoped_refptr<::blink::BlobDataHandle> p_blob{};
  FileSystemManager_RegisterBlob_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemManager::Name_, 16, true);
    return false;
  }
  *out_blob_ = std::move(p_blob);
  *result_ = true;
  return true;
}

// static
bool FileSystemManagerStubDispatch::Accept(
    FileSystemManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemManager>(message->header()->name)) {
    case messages::FileSystemManager::kOpen: {
      break;
    }
    case messages::FileSystemManager::kResolveURL: {
      break;
    }
    case messages::FileSystemManager::kMove: {
      break;
    }
    case messages::FileSystemManager::kCopy: {
      break;
    }
    case messages::FileSystemManager::kRemove: {
      break;
    }
    case messages::FileSystemManager::kReadMetadata: {
      break;
    }
    case messages::FileSystemManager::kCreate: {
      break;
    }
    case messages::FileSystemManager::kExists: {
      break;
    }
    case messages::FileSystemManager::kReadDirectory: {
      DCHECK(message->is_serialized());
      internal::FileSystemManager_ReadDirectory_Params_Data* params =
          reinterpret_cast<internal::FileSystemManager_ReadDirectory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemManager.8
      bool success = true;
      ::blink::KURL p_path{};
      ::mojo::PendingRemote<FileSystemOperationListener> p_listener{};
      FileSystemManager_ReadDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadDirectory(        
        std::move(p_path), 
        std::move(p_listener));
      return true;
    }
    case messages::FileSystemManager::kReadDirectorySync: {
      break;
    }
    case messages::FileSystemManager::kWrite: {
      DCHECK(message->is_serialized());
      internal::FileSystemManager_Write_Params_Data* params =
          reinterpret_cast<internal::FileSystemManager_Write_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemManager.10
      bool success = true;
      ::blink::KURL p_file_path{};
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> p_blob{};
      int64_t p_position{};
      ::mojo::PendingReceiver<FileSystemCancellableOperation> p_op_receiver{};
      ::mojo::PendingRemote<FileSystemOperationListener> p_listener{};
      FileSystemManager_Write_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success)
        p_position = input_data_view.position();
      if (success) {
        p_op_receiver =
            input_data_view.TakeOpReceiver<decltype(p_op_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_file_path), 
        std::move(p_blob), 
        std::move(p_position), 
        std::move(p_op_receiver), 
        std::move(p_listener));
      return true;
    }
    case messages::FileSystemManager::kWriteSync: {
      break;
    }
    case messages::FileSystemManager::kTruncate: {
      break;
    }
    case messages::FileSystemManager::kTruncateSync: {
      break;
    }
    case messages::FileSystemManager::kCreateSnapshotFile: {
      break;
    }
    case messages::FileSystemManager::kGetPlatformPath: {
      break;
    }
    case messages::FileSystemManager::kRegisterBlob: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemManagerStubDispatch::AcceptWithResponder(
    FileSystemManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemManager>(message->header()->name)) {
    case messages::FileSystemManager::kOpen: {
      internal::FileSystemManager_Open_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Open_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.0
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      FileSystemType p_file_system_type{};
      FileSystemManager_Open_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadFileSystemType(&p_file_system_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemManager_Open_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(        
        std::move(p_origin), 
        std::move(p_file_system_type), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kResolveURL: {
      internal::FileSystemManager_ResolveURL_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_ResolveURL_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.1
      bool success = true;
      ::blink::KURL p_filesystem_url{};
      FileSystemManager_ResolveURL_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilesystemUrl(&p_filesystem_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemManager_ResolveURL_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveURL(        
        std::move(p_filesystem_url), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kMove: {
      internal::FileSystemManager_Move_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Move_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.2
      bool success = true;
      ::blink::KURL p_src_path{};
      ::blink::KURL p_dest_path{};
      FileSystemManager_Move_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSrcPath(&p_src_path))
        success = false;
      if (success && !input_data_view.ReadDestPath(&p_dest_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemManager_Move_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Move(        
        std::move(p_src_path), 
        std::move(p_dest_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kCopy: {
      internal::FileSystemManager_Copy_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Copy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.3
      bool success = true;
      ::blink::KURL p_src_path{};
      ::blink::KURL p_dest_path{};
      FileSystemManager_Copy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSrcPath(&p_src_path))
        success = false;
      if (success && !input_data_view.ReadDestPath(&p_dest_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 3, false);
        return false;
      }
      auto callback =
          FileSystemManager_Copy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Copy(        
        std::move(p_src_path), 
        std::move(p_dest_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kRemove: {
      internal::FileSystemManager_Remove_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Remove_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.4
      bool success = true;
      ::blink::KURL p_path{};
      bool p_recursive{};
      FileSystemManager_Remove_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_recursive = input_data_view.recursive();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 4, false);
        return false;
      }
      auto callback =
          FileSystemManager_Remove_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_path), 
        std::move(p_recursive), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kReadMetadata: {
      internal::FileSystemManager_ReadMetadata_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_ReadMetadata_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.5
      bool success = true;
      ::blink::KURL p_path{};
      FileSystemManager_ReadMetadata_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 5, false);
        return false;
      }
      auto callback =
          FileSystemManager_ReadMetadata_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadMetadata(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kCreate: {
      internal::FileSystemManager_Create_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Create_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.6
      bool success = true;
      ::blink::KURL p_path{};
      bool p_exclusive{};
      bool p_is_directory{};
      bool p_recursive{};
      FileSystemManager_Create_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_exclusive = input_data_view.exclusive();
      if (success)
        p_is_directory = input_data_view.is_directory();
      if (success)
        p_recursive = input_data_view.recursive();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 6, false);
        return false;
      }
      auto callback =
          FileSystemManager_Create_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Create(        
        std::move(p_path), 
        std::move(p_exclusive), 
        std::move(p_is_directory), 
        std::move(p_recursive), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kExists: {
      internal::FileSystemManager_Exists_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Exists_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.7
      bool success = true;
      ::blink::KURL p_path{};
      bool p_is_directory{};
      FileSystemManager_Exists_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success)
        p_is_directory = input_data_view.is_directory();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 7, false);
        return false;
      }
      auto callback =
          FileSystemManager_Exists_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Exists(        
        std::move(p_path), 
        std::move(p_is_directory), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kReadDirectory: {
      break;
    }
    case messages::FileSystemManager::kReadDirectorySync: {
      internal::FileSystemManager_ReadDirectorySync_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_ReadDirectorySync_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.9
      bool success = true;
      ::blink::KURL p_path{};
      FileSystemManager_ReadDirectorySync_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 9, false);
        return false;
      }
      auto callback =
          FileSystemManager_ReadDirectorySync_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadDirectorySync(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kWrite: {
      break;
    }
    case messages::FileSystemManager::kWriteSync: {
      internal::FileSystemManager_WriteSync_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_WriteSync_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.11
      bool success = true;
      ::blink::KURL p_file_path{};
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> p_blob{};
      int64_t p_position{};
      FileSystemManager_WriteSync_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success)
        p_position = input_data_view.position();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 11, false);
        return false;
      }
      auto callback =
          FileSystemManager_WriteSync_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteSync(        
        std::move(p_file_path), 
        std::move(p_blob), 
        std::move(p_position), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kTruncate: {
      internal::FileSystemManager_Truncate_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_Truncate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.12
      bool success = true;
      ::blink::KURL p_file_path{};
      int64_t p_length{};
      ::mojo::PendingReceiver<FileSystemCancellableOperation> p_op_receiver{};
      FileSystemManager_Truncate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success)
        p_length = input_data_view.length();
      if (success) {
        p_op_receiver =
            input_data_view.TakeOpReceiver<decltype(p_op_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 12, false);
        return false;
      }
      auto callback =
          FileSystemManager_Truncate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Truncate(        
        std::move(p_file_path), 
        std::move(p_length), 
        std::move(p_op_receiver), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kTruncateSync: {
      internal::FileSystemManager_TruncateSync_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_TruncateSync_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.13
      bool success = true;
      ::blink::KURL p_file_path{};
      int64_t p_length{};
      FileSystemManager_TruncateSync_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 13, false);
        return false;
      }
      auto callback =
          FileSystemManager_TruncateSync_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TruncateSync(        
        std::move(p_file_path), 
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kCreateSnapshotFile: {
      internal::FileSystemManager_CreateSnapshotFile_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_CreateSnapshotFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.14
      bool success = true;
      ::blink::KURL p_file_path{};
      FileSystemManager_CreateSnapshotFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 14, false);
        return false;
      }
      auto callback =
          FileSystemManager_CreateSnapshotFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSnapshotFile(        
        std::move(p_file_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kGetPlatformPath: {
      internal::FileSystemManager_GetPlatformPath_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_GetPlatformPath_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.15
      bool success = true;
      ::blink::KURL p_file_path{};
      FileSystemManager_GetPlatformPath_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilePath(&p_file_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 15, false);
        return false;
      }
      auto callback =
          FileSystemManager_GetPlatformPath_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPlatformPath(        
        std::move(p_file_path), std::move(callback));
      return true;
    }
    case messages::FileSystemManager::kRegisterBlob: {
      internal::FileSystemManager_RegisterBlob_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemManager_RegisterBlob_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemManager.16
      bool success = true;
      ::blink::String p_content_type{};
      ::blink::KURL p_url{};
      uint64_t p_length{};
      std::optional<::base::Time> p_expected_modification_time{};
      FileSystemManager_RegisterBlob_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContentType(&p_content_type))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_length = input_data_view.length();
      if (success && !input_data_view.ReadExpectedModificationTime(&p_expected_modification_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemManager::Name_, 16, false);
        return false;
      }
      auto callback =
          FileSystemManager_RegisterBlob_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterBlob(        
        std::move(p_content_type), 
        std::move(p_url), 
        std::move(p_length), 
        std::move(p_expected_modification_time), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemManagerValidationInfo[] = {
    { &internal::FileSystemManager_Open_Params_Data::Validate,
     &internal::FileSystemManager_Open_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_ResolveURL_Params_Data::Validate,
     &internal::FileSystemManager_ResolveURL_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Move_Params_Data::Validate,
     &internal::FileSystemManager_Move_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Copy_Params_Data::Validate,
     &internal::FileSystemManager_Copy_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Remove_Params_Data::Validate,
     &internal::FileSystemManager_Remove_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_ReadMetadata_Params_Data::Validate,
     &internal::FileSystemManager_ReadMetadata_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Create_Params_Data::Validate,
     &internal::FileSystemManager_Create_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Exists_Params_Data::Validate,
     &internal::FileSystemManager_Exists_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_ReadDirectory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemManager_ReadDirectorySync_Params_Data::Validate,
     &internal::FileSystemManager_ReadDirectorySync_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Write_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FileSystemManager_WriteSync_Params_Data::Validate,
     &internal::FileSystemManager_WriteSync_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_Truncate_Params_Data::Validate,
     &internal::FileSystemManager_Truncate_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_TruncateSync_Params_Data::Validate,
     &internal::FileSystemManager_TruncateSync_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_CreateSnapshotFile_Params_Data::Validate,
     &internal::FileSystemManager_CreateSnapshotFile_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_GetPlatformPath_Params_Data::Validate,
     &internal::FileSystemManager_GetPlatformPath_ResponseParams_Data::Validate},
    { &internal::FileSystemManager_RegisterBlob_Params_Data::Validate,
     &internal::FileSystemManager_RegisterBlob_ResponseParams_Data::Validate},
};

bool FileSystemManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemManager::Name_,
    kFileSystemManagerValidationInfo);
}

bool FileSystemManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemManager::Name_,
    kFileSystemManagerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::FileSystemInfo::DataView, ::blink::mojom::blink::FileSystemInfoPtr>::Read(
    ::blink::mojom::blink::FileSystemInfo::DataView input,
    ::blink::mojom::blink::FileSystemInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::FileSystemInfoPtr result(::blink::mojom::blink::FileSystemInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadRootUrl(&result->root_url))
        success = false;
      if (success && !input.ReadMountType(&result->mount_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileSystemCancellableOperationInterceptorForTesting::Cancel(CancelCallback callback) {
  GetForwardingInterface()->Cancel(std::move(callback));
}
FileSystemCancellableOperationAsyncWaiter::FileSystemCancellableOperationAsyncWaiter(
    FileSystemCancellableOperation* proxy) : proxy_(proxy) {}

FileSystemCancellableOperationAsyncWaiter::~FileSystemCancellableOperationAsyncWaiter() = default;


void FileSystemCancellableOperationAsyncWaiter::Cancel(
    ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Cancel(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemCancellableOperationAsyncWaiter::Cancel(
    ) {
  ::base::File::Error async_wait_result;
  Cancel(&async_wait_result);
  return async_wait_result;
}




void FileSystemOperationListenerInterceptorForTesting::ResultsRetrieved(::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> entries, bool has_more) {
  GetForwardingInterface()->ResultsRetrieved(
    std::move(entries)
    , 
    std::move(has_more)
    );
}
void FileSystemOperationListenerInterceptorForTesting::DidWrite(int64_t byte_count, bool complete) {
  GetForwardingInterface()->DidWrite(
    std::move(byte_count)
    , 
    std::move(complete)
    );
}
void FileSystemOperationListenerInterceptorForTesting::ErrorOccurred(::base::File::Error error_code) {
  GetForwardingInterface()->ErrorOccurred(
    std::move(error_code)
    );
}
FileSystemOperationListenerAsyncWaiter::FileSystemOperationListenerAsyncWaiter(
    FileSystemOperationListener* proxy) : proxy_(proxy) {}

FileSystemOperationListenerAsyncWaiter::~FileSystemOperationListenerAsyncWaiter() = default;





void ReceivedSnapshotListenerInterceptorForTesting::DidReceiveSnapshotFile() {
  GetForwardingInterface()->DidReceiveSnapshotFile();
}
ReceivedSnapshotListenerAsyncWaiter::ReceivedSnapshotListenerAsyncWaiter(
    ReceivedSnapshotListener* proxy) : proxy_(proxy) {}

ReceivedSnapshotListenerAsyncWaiter::~ReceivedSnapshotListenerAsyncWaiter() = default;





void FileSystemManagerInterceptorForTesting::Open(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, FileSystemType file_system_type, OpenCallback callback) {
  GetForwardingInterface()->Open(
    std::move(origin)
    , 
    std::move(file_system_type)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::ResolveURL(const ::blink::KURL& filesystem_url, ResolveURLCallback callback) {
  GetForwardingInterface()->ResolveURL(
    std::move(filesystem_url)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Move(const ::blink::KURL& src_path, const ::blink::KURL& dest_path, MoveCallback callback) {
  GetForwardingInterface()->Move(
    std::move(src_path)
    , 
    std::move(dest_path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Copy(const ::blink::KURL& src_path, const ::blink::KURL& dest_path, CopyCallback callback) {
  GetForwardingInterface()->Copy(
    std::move(src_path)
    , 
    std::move(dest_path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Remove(const ::blink::KURL& path, bool recursive, RemoveCallback callback) {
  GetForwardingInterface()->Remove(
    std::move(path)
    , 
    std::move(recursive)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::ReadMetadata(const ::blink::KURL& path, ReadMetadataCallback callback) {
  GetForwardingInterface()->ReadMetadata(
    std::move(path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Create(const ::blink::KURL& path, bool exclusive, bool is_directory, bool recursive, CreateCallback callback) {
  GetForwardingInterface()->Create(
    std::move(path)
    , 
    std::move(exclusive)
    , 
    std::move(is_directory)
    , 
    std::move(recursive)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Exists(const ::blink::KURL& path, bool is_directory, ExistsCallback callback) {
  GetForwardingInterface()->Exists(
    std::move(path)
    , 
    std::move(is_directory)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::ReadDirectory(const ::blink::KURL& path, ::mojo::PendingRemote<FileSystemOperationListener> listener) {
  GetForwardingInterface()->ReadDirectory(
    std::move(path)
    , 
    std::move(listener)
    );
}
void FileSystemManagerInterceptorForTesting::ReadDirectorySync(const ::blink::KURL& path, ReadDirectorySyncCallback callback) {
  GetForwardingInterface()->ReadDirectorySync(
    std::move(path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Write(const ::blink::KURL& file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob, int64_t position, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, ::mojo::PendingRemote<FileSystemOperationListener> listener) {
  GetForwardingInterface()->Write(
    std::move(file_path)
    , 
    std::move(blob)
    , 
    std::move(position)
    , 
    std::move(op_receiver)
    , 
    std::move(listener)
    );
}
void FileSystemManagerInterceptorForTesting::WriteSync(const ::blink::KURL& file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob, int64_t position, WriteSyncCallback callback) {
  GetForwardingInterface()->WriteSync(
    std::move(file_path)
    , 
    std::move(blob)
    , 
    std::move(position)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::Truncate(const ::blink::KURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, TruncateCallback callback) {
  GetForwardingInterface()->Truncate(
    std::move(file_path)
    , 
    std::move(length)
    , 
    std::move(op_receiver)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::TruncateSync(const ::blink::KURL& file_path, int64_t length, TruncateSyncCallback callback) {
  GetForwardingInterface()->TruncateSync(
    std::move(file_path)
    , 
    std::move(length)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::CreateSnapshotFile(const ::blink::KURL& file_path, CreateSnapshotFileCallback callback) {
  GetForwardingInterface()->CreateSnapshotFile(
    std::move(file_path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::GetPlatformPath(const ::blink::KURL& file_path, GetPlatformPathCallback callback) {
  GetForwardingInterface()->GetPlatformPath(
    std::move(file_path)
    , std::move(callback));
}
void FileSystemManagerInterceptorForTesting::RegisterBlob(const ::blink::String& content_type, const ::blink::KURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time, RegisterBlobCallback callback) {
  GetForwardingInterface()->RegisterBlob(
    std::move(content_type)
    , 
    std::move(url)
    , 
    std::move(length)
    , 
    std::move(expected_modification_time)
    , std::move(callback));
}
FileSystemManagerAsyncWaiter::FileSystemManagerAsyncWaiter(
    FileSystemManager* proxy) : proxy_(proxy) {}

FileSystemManagerAsyncWaiter::~FileSystemManagerAsyncWaiter() = default;


void FileSystemManagerAsyncWaiter::Open(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, FileSystemType file_system_type, ::blink::String* out_name, ::blink::KURL* out_root_url, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Open(
      std::move(origin),
      std::move(file_system_type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_name
,
             ::blink::KURL* out_root_url
,
             ::base::File::Error* out_error_code
,
             const ::blink::String& name,
             const ::blink::KURL& root_url,
             ::base::File::Error error_code) {*out_name = std::move(name);*out_root_url = std::move(root_url);*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_name,
          out_root_url,
          out_error_code));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::ResolveURL(
    const ::blink::KURL& filesystem_url, FileSystemInfoPtr* out_info, ::base::FilePath* out_file_path, bool* out_is_directory, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->ResolveURL(
      std::move(filesystem_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             FileSystemInfoPtr* out_info
,
             ::base::FilePath* out_file_path
,
             bool* out_is_directory
,
             ::base::File::Error* out_error_code
,
             FileSystemInfoPtr info,
             const ::base::FilePath& file_path,
             bool is_directory,
             ::base::File::Error error_code) {*out_info = std::move(info);*out_file_path = std::move(file_path);*out_is_directory = std::move(is_directory);*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_info,
          out_file_path,
          out_is_directory,
          out_error_code));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::Move(
    const ::blink::KURL& src_path, const ::blink::KURL& dest_path, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Move(
      std::move(src_path),
      std::move(dest_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Move(
    const ::blink::KURL& src_path, const ::blink::KURL& dest_path) {
  ::base::File::Error async_wait_result;
  Move(std::move(src_path),std::move(dest_path),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::Copy(
    const ::blink::KURL& src_path, const ::blink::KURL& dest_path, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Copy(
      std::move(src_path),
      std::move(dest_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Copy(
    const ::blink::KURL& src_path, const ::blink::KURL& dest_path) {
  ::base::File::Error async_wait_result;
  Copy(std::move(src_path),std::move(dest_path),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::Remove(
    const ::blink::KURL& path, bool recursive, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Remove(
      std::move(path),
      std::move(recursive),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Remove(
    const ::blink::KURL& path, bool recursive) {
  ::base::File::Error async_wait_result;
  Remove(std::move(path),std::move(recursive),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::ReadMetadata(
    const ::blink::KURL& path, ::base::File::Info* out_file_info, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->ReadMetadata(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Info* out_file_info
,
             ::base::File::Error* out_error_code
,
             const ::base::File::Info& file_info,
             ::base::File::Error error_code) {*out_file_info = std::move(file_info);*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_file_info,
          out_error_code));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::Create(
    const ::blink::KURL& path, bool exclusive, bool is_directory, bool recursive, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Create(
      std::move(path),
      std::move(exclusive),
      std::move(is_directory),
      std::move(recursive),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Create(
    const ::blink::KURL& path, bool exclusive, bool is_directory, bool recursive) {
  ::base::File::Error async_wait_result;
  Create(std::move(path),std::move(exclusive),std::move(is_directory),std::move(recursive),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::Exists(
    const ::blink::KURL& path, bool is_directory, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Exists(
      std::move(path),
      std::move(is_directory),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Exists(
    const ::blink::KURL& path, bool is_directory) {
  ::base::File::Error async_wait_result;
  Exists(std::move(path),std::move(is_directory),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::ReadDirectorySync(
    const ::blink::KURL& path, ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_entries, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->ReadDirectorySync(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr>* out_entries
,
             ::base::File::Error* out_error_code
,
             ::blink::Vector<::filesystem::mojom::blink::DirectoryEntryPtr> entries,
             ::base::File::Error error_code) {*out_entries = std::move(entries);*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_entries,
          out_error_code));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::WriteSync(
    const ::blink::KURL& file_path, ::mojo::PendingRemote<::blink::mojom::blink::Blob> blob, int64_t position, int64_t* out_byte_count, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->WriteSync(
      std::move(file_path),
      std::move(blob),
      std::move(position),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_byte_count
,
             ::base::File::Error* out_error_code
,
             int64_t byte_count,
             ::base::File::Error error_code) {*out_byte_count = std::move(byte_count);*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_byte_count,
          out_error_code));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::Truncate(
    const ::blink::KURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->Truncate(
      std::move(file_path),
      std::move(length),
      std::move(op_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::Truncate(
    const ::blink::KURL& file_path, int64_t length, ::mojo::PendingReceiver<FileSystemCancellableOperation> op_receiver) {
  ::base::File::Error async_wait_result;
  Truncate(std::move(file_path),std::move(length),std::move(op_receiver),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::TruncateSync(
    const ::blink::KURL& file_path, int64_t length, ::base::File::Error* out_error_code) {
  base::RunLoop loop;
  proxy_->TruncateSync(
      std::move(file_path),
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error_code
,
             ::base::File::Error error_code) {*out_error_code = std::move(error_code);
            loop->Quit();
          },
          &loop,
          out_error_code));
  loop.Run();
}

::base::File::Error FileSystemManagerAsyncWaiter::TruncateSync(
    const ::blink::KURL& file_path, int64_t length) {
  ::base::File::Error async_wait_result;
  TruncateSync(std::move(file_path),std::move(length),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::CreateSnapshotFile(
    const ::blink::KURL& file_path, ::base::File::Info* out_file_info, ::base::FilePath* out_platform_path, ::base::File::Error* out_error_code, ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener) {
  base::RunLoop loop;
  proxy_->CreateSnapshotFile(
      std::move(file_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Info* out_file_info
,
             ::base::FilePath* out_platform_path
,
             ::base::File::Error* out_error_code
,
             ::mojo::PendingRemote<ReceivedSnapshotListener>* out_snapshot_listener
,
             const ::base::File::Info& file_info,
             const ::base::FilePath& platform_path,
             ::base::File::Error error_code,
             ::mojo::PendingRemote<ReceivedSnapshotListener> snapshot_listener) {*out_file_info = std::move(file_info);*out_platform_path = std::move(platform_path);*out_error_code = std::move(error_code);*out_snapshot_listener = std::move(snapshot_listener);
            loop->Quit();
          },
          &loop,
          out_file_info,
          out_platform_path,
          out_error_code,
          out_snapshot_listener));
  loop.Run();
}



void FileSystemManagerAsyncWaiter::GetPlatformPath(
    const ::blink::KURL& file_path, ::base::FilePath* out_platform_path) {
  base::RunLoop loop;
  proxy_->GetPlatformPath(
      std::move(file_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::FilePath* out_platform_path
,
             const ::base::FilePath& platform_path) {*out_platform_path = std::move(platform_path);
            loop->Quit();
          },
          &loop,
          out_platform_path));
  loop.Run();
}

::base::FilePath FileSystemManagerAsyncWaiter::GetPlatformPath(
    const ::blink::KURL& file_path) {
  ::base::FilePath async_wait_result;
  GetPlatformPath(std::move(file_path),&async_wait_result);
  return async_wait_result;
}

void FileSystemManagerAsyncWaiter::RegisterBlob(
    const ::blink::String& content_type, const ::blink::KURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time, ::scoped_refptr<::blink::BlobDataHandle>* out_blob) {
  base::RunLoop loop;
  proxy_->RegisterBlob(
      std::move(content_type),
      std::move(url),
      std::move(length),
      std::move(expected_modification_time),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::scoped_refptr<::blink::BlobDataHandle>* out_blob
,
             const ::scoped_refptr<::blink::BlobDataHandle>& blob) {*out_blob = std::move(blob);
            loop->Quit();
          },
          &loop,
          out_blob));
  loop.Run();
}

::scoped_refptr<::blink::BlobDataHandle> FileSystemManagerAsyncWaiter::RegisterBlob(
    const ::blink::String& content_type, const ::blink::KURL& url, uint64_t length, std::optional<::base::Time> expected_modification_time) {
  ::scoped_refptr<::blink::BlobDataHandle> async_wait_result;
  RegisterBlob(std::move(content_type),std::move(url),std::move(length),std::move(expected_modification_time),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif