// third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  FileInfo as mojoBase_mojom_FileInfo,
  FileInfoSpec as mojoBase_mojom_FileInfoSpec
} from '../../../../../mojo/public/mojom/base/file_info.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from '../blob/serialized_blob.mojom.m.js';

import {
  PermissionStatus as blink_mojom_PermissionStatus,
  PermissionStatusSpec as blink_mojom_PermissionStatusSpec
} from '../permissions/permission_status.mojom.m.js';

import {
  FileSystemAccessAccessHandleHostRemote as blink_mojom_FileSystemAccessAccessHandleHostRemote,
  FileSystemAccessAccessHandleHostPendingReceiver as blink_mojom_FileSystemAccessAccessHandleHostPendingReceiver
} from './file_system_access_access_handle_host.mojom.m.js';

import {
  FileSystemAccessCloudIdentifier as blink_mojom_FileSystemAccessCloudIdentifier,
  FileSystemAccessCloudIdentifierSpec as blink_mojom_FileSystemAccessCloudIdentifierSpec
} from './file_system_access_cloud_identifier.mojom.m.js';

import {
  FileSystemAccessError as blink_mojom_FileSystemAccessError,
  FileSystemAccessErrorSpec as blink_mojom_FileSystemAccessErrorSpec
} from './file_system_access_error.mojom.m.js';

import {
  FileSystemAccessFileDelegateHostRemote as blink_mojom_FileSystemAccessFileDelegateHostRemote,
  FileSystemAccessFileDelegateHostPendingReceiver as blink_mojom_FileSystemAccessFileDelegateHostPendingReceiver
} from './file_system_access_file_delegate_host.mojom.m.js';

import {
  FileSystemAccessFileModificationHostRemote as blink_mojom_FileSystemAccessFileModificationHostRemote,
  FileSystemAccessFileModificationHostPendingReceiver as blink_mojom_FileSystemAccessFileModificationHostPendingReceiver
} from './file_system_access_file_modification_host.mojom.m.js';

import {
  FileSystemAccessFileWriterRemote as blink_mojom_FileSystemAccessFileWriterRemote,
  FileSystemAccessFileWriterPendingReceiver as blink_mojom_FileSystemAccessFileWriterPendingReceiver
} from './file_system_access_file_writer.mojom.m.js';

import {
  FileSystemAccessPermissionMode as blink_mojom_FileSystemAccessPermissionMode,
  FileSystemAccessPermissionModeSpec as blink_mojom_FileSystemAccessPermissionModeSpec
} from './file_system_access_permission_mode.mojom.m.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from './file_system_access_transfer_token.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FileSystemAccessAccessHandleLockModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FileSystemAccessAccessHandleLockMode = {
  
  kReadwrite: 0,
  kReadOnly: 1,
  kReadwriteUnsafe: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FileSystemAccessWritableFileStreamLockModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FileSystemAccessWritableFileStreamLockMode = {
  
  kExclusive: 0,
  kSiloed: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FileSystemAccessFileHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FileSystemAccessFileHandle', scope);
  }
}

/** @interface */
export class FileSystemAccessFileHandleInterface {
  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus(mode) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(mode) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        info: !mojoBase_mojom_FileInfo,
        blob: ?blink_mojom_SerializedBlob,
   *  }>}
   */

  asBlob() {}
  
  /**
   * @param { !boolean } keepExistingData
   * @param { !boolean } autoClose
   * @param { !FileSystemAccessWritableFileStreamLockMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        writer: ?blink_mojom_FileSystemAccessFileWriterRemote,
   *  }>}
   */

  createFileWriter(keepExistingData, autoClose, mode) {}
  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  rename(newEntryName) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  move(destinationDirectory, newEntryName) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  remove() {}
  
  /**
   * @param { !FileSystemAccessAccessHandleLockMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        file: ?FileSystemAccessAccessHandleFile,
        accessHandleHost: ?blink_mojom_FileSystemAccessAccessHandleHostRemote,
   *  }>}
   */

  openAccessHandle(mode) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } other
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        isSame: !boolean,
   *  }>}
   */

  isSameEntry(other) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(token) {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {}
  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        cloudIdentifiers: !Array<!blink_mojom_FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {}
}

/**
 * @implements { FileSystemAccessFileHandleInterface }
 */
export class FileSystemAccessFileHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FileSystemAccessFileHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FileSystemAccessFileHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FileSystemAccessFileHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  getPermissionStatus(
      mode) {
    return this.proxy.sendMessage(
        0,
        FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessPermissionMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        status: !blink_mojom_PermissionStatus,
   *  }>}
   */

  requestPermission(
      mode) {
    return this.proxy.sendMessage(
        1,
        FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        info: !mojoBase_mojom_FileInfo,
        blob: ?blink_mojom_SerializedBlob,
   *  }>}
   */

  asBlob() {
    return this.proxy.sendMessage(
        2,
        FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } keepExistingData
   * @param { !boolean } autoClose
   * @param { !FileSystemAccessWritableFileStreamLockMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        writer: ?blink_mojom_FileSystemAccessFileWriterRemote,
   *  }>}
   */

  createFileWriter(
      keepExistingData,
      autoClose,
      mode) {
    return this.proxy.sendMessage(
        3,
        FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        [
          keepExistingData,
          autoClose,
          mode
        ],
        false);
  }

  
  /**
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  rename(
      newEntryName) {
    return this.proxy.sendMessage(
        4,
        FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        [
          newEntryName
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } destinationDirectory
   * @param { !string } newEntryName
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  move(
      destinationDirectory,
      newEntryName) {
    return this.proxy.sendMessage(
        5,
        FileSystemAccessFileHandle_Move_ParamsSpec.$,
        FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        [
          destinationDirectory,
          newEntryName
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
   *  }>}
   */

  remove() {
    return this.proxy.sendMessage(
        6,
        FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !FileSystemAccessAccessHandleLockMode } mode
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        file: ?FileSystemAccessAccessHandleFile,
        accessHandleHost: ?blink_mojom_FileSystemAccessAccessHandleHostRemote,
   *  }>}
   */

  openAccessHandle(
      mode) {
    return this.proxy.sendMessage(
        7,
        FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } other
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        isSame: !boolean,
   *  }>}
   */

  isSameEntry(
      other) {
    return this.proxy.sendMessage(
        8,
        FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        [
          other
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } token
   */

  transfer(
      token) {
    this.proxy.sendMessage(
        9,
        FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        [
          token
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        id: !string,
   *  }>}
   */

  getUniqueId() {
    return this.proxy.sendMessage(
        10,
        FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !blink_mojom_FileSystemAccessError,
        cloudIdentifiers: !Array<!blink_mojom_FileSystemAccessCloudIdentifier>,
   *  }>}
   */

  getCloudIdentifiers() {
    return this.proxy.sendMessage(
        11,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FileSystemAccessFileHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FileSystemAccessFileHandleReceiver {
  /**
   * @param {!FileSystemAccessFileHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FileSystemAccessFileHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FileSystemAccessFileHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        impl.getPermissionStatus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        impl.requestPermission.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        impl.asBlob.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        impl.createFileWriter.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        impl.rename.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessFileHandle_Move_ParamsSpec.$,
        FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        impl.move.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        impl.remove.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        impl.openAccessHandle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        impl.isSameEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        impl.transfer.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        impl.getUniqueId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        impl.getCloudIdentifiers.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FileSystemAccessFileHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FileSystemAccessFileHandleRemote}
   */
  static getRemote() {
    let remote = new FileSystemAccessFileHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FileSystemAccessFileHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FileSystemAccessFileHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FileSystemAccessFileHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FileSystemAccessFileHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPermissionStatus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
        FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
        this.getPermissionStatus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPermission =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
        FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
        this.requestPermission.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.asBlob =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
        FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
        this.asBlob.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFileWriter =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
        FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
        this.createFileWriter.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.rename =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FileSystemAccessFileHandle_Rename_ParamsSpec.$,
        FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
        this.rename.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.move =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        FileSystemAccessFileHandle_Move_ParamsSpec.$,
        FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
        this.move.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.remove =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        FileSystemAccessFileHandle_Remove_ParamsSpec.$,
        FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
        this.remove.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openAccessHandle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
        FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
        this.openAccessHandle.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isSameEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
        FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
        this.isSameEntry.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transfer =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
        null,
        this.transfer.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUniqueId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
        FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
        this.getUniqueId.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCloudIdentifiers =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
        FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
        this.getCloudIdentifiers.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessRegularFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_RequestPermission_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_AsBlob_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Rename_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Rename_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Move_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Move_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Remove_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Remove_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_IsSameEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_Transfer_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetUniqueId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FileSystemAccessAccessHandleFileSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FileSystemAccessRegularFileSpec.$,
    'FileSystemAccessRegularFile',
    [
      mojo.internal.StructField(
        'osFile', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileSize', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fileModificationHost', 16,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessFileModificationHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessRegularFile {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.osFile;
    /** @type { !bigint } */
    this.fileSize;
    /** @type { !blink_mojom_FileSystemAccessFileModificationHostRemote } */
    this.fileModificationHost;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetPermissionStatus_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetPermissionStatus_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_FileSystemAccessPermissionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetPermissionStatus_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessPermissionMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetPermissionStatus_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetPermissionStatus_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_RequestPermission_ParamsSpec.$,
    'FileSystemAccessFileHandle_RequestPermission_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_FileSystemAccessPermissionModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_RequestPermission_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessPermissionMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_RequestPermission_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_RequestPermission_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        blink_mojom_PermissionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_RequestPermission_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !blink_mojom_PermissionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_AsBlob_ParamsSpec.$,
    'FileSystemAccessFileHandle_AsBlob_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_AsBlob_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_AsBlob_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_AsBlob_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'info', 8,
        0,
        mojoBase_mojom_FileInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blob', 16,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_AsBlob_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !mojoBase_mojom_FileInfo } */
    this.info;
    /** @type { (blink_mojom_SerializedBlob|undefined) } */
    this.blob;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_CreateFileWriter_ParamsSpec.$,
    'FileSystemAccessFileHandle_CreateFileWriter_Params',
    [
      mojo.internal.StructField(
        'keepExistingData', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'autoClose', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mode', 4,
        0,
        FileSystemAccessWritableFileStreamLockModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_CreateFileWriter_Params {
  constructor() {
    /** @type { !boolean } */
    this.keepExistingData;
    /** @type { !boolean } */
    this.autoClose;
    /** @type { !FileSystemAccessWritableFileStreamLockMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_CreateFileWriter_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_CreateFileWriter_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writer', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessFileWriterRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_CreateFileWriter_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (blink_mojom_FileSystemAccessFileWriterRemote|undefined) } */
    this.writer;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Rename_ParamsSpec.$,
    'FileSystemAccessFileHandle_Rename_Params',
    [
      mojo.internal.StructField(
        'newEntryName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Rename_Params {
  constructor() {
    /** @type { !string } */
    this.newEntryName;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Rename_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Rename_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Rename_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Move_ParamsSpec.$,
    'FileSystemAccessFileHandle_Move_Params',
    [
      mojo.internal.StructField(
        'destinationDirectory', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newEntryName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Move_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.destinationDirectory;
    /** @type { !string } */
    this.newEntryName;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Move_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Move_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Move_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Remove_ParamsSpec.$,
    'FileSystemAccessFileHandle_Remove_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Remove_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Remove_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_Remove_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Remove_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_OpenAccessHandle_ParamsSpec.$,
    'FileSystemAccessFileHandle_OpenAccessHandle_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        FileSystemAccessAccessHandleLockModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_OpenAccessHandle_Params {
  constructor() {
    /** @type { !FileSystemAccessAccessHandleLockMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_OpenAccessHandle_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'file', 8,
        0,
        FileSystemAccessAccessHandleFileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessHandleHost', 24,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessAccessHandleHostRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_OpenAccessHandle_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { (FileSystemAccessAccessHandleFile|undefined) } */
    this.file;
    /** @type { (blink_mojom_FileSystemAccessAccessHandleHostRemote|undefined) } */
    this.accessHandleHost;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_IsSameEntry_ParamsSpec.$,
    'FileSystemAccessFileHandle_IsSameEntry_Params',
    [
      mojo.internal.StructField(
        'other', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_IsSameEntry_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.other;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_IsSameEntry_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_IsSameEntry_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSame', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_IsSameEntry_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !boolean } */
    this.isSame;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_Transfer_ParamsSpec.$,
    'FileSystemAccessFileHandle_Transfer_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_FileSystemAccessTransferTokenPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_Transfer_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenPendingReceiver } */
    this.token;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetUniqueId_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetUniqueId_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetUniqueId_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetUniqueId_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetUniqueId_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetUniqueId_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetCloudIdentifiers_ParamsSpec.$,
    'FileSystemAccessFileHandle_GetCloudIdentifiers_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetCloudIdentifiers_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParamsSpec.$,
    'FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        blink_mojom_FileSystemAccessErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cloudIdentifiers', 8,
        0,
        mojo.internal.Array(blink_mojom_FileSystemAccessCloudIdentifierSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FileSystemAccessFileHandle_GetCloudIdentifiers_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessError } */
    this.result;
    /** @type { !Array<!blink_mojom_FileSystemAccessCloudIdentifier> } */
    this.cloudIdentifiers;
  }
}

mojo.internal.Union(
    FileSystemAccessAccessHandleFileSpec.$, 'FileSystemAccessAccessHandleFile',
    {
      'regularFile': {
        'ordinal': 0,
        'type': FileSystemAccessRegularFileSpec.$,
      },
      'incognitoFileDelegate': {
        'ordinal': 1,
        'type': mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessFileDelegateHostRemote),
      },
    });

/**
 * @typedef { {
 *   regularFile: (!FileSystemAccessRegularFile|undefined),
 *   incognitoFileDelegate: (!blink_mojom_FileSystemAccessFileDelegateHostRemote|undefined),
 * } }
 */
export const FileSystemAccessAccessHandleFile = {};
